/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.Tool;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.action.builder.ActionBuilder;
import docking.action.builder.MultiStateActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import docking.widgets.filechooser.GhidraFileChooser;
import generic.theme.GIcon;
import ghidra.app.plugin.core.debug.gui.DebuggerBlockChooserDialog;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerLegacyModulesPanel;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerLegacySectionsPanel;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModuleActionContext;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModuleMapProposalDialog;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModulesPanel;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModulesPlugin;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerSectionActionContext;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerSectionMapProposalDialog;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerSectionsPanel;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerStaticMappingPlugin;
import ghidra.app.plugin.core.debug.service.modules.MapModulesBackgroundCommand;
import ghidra.app.plugin.core.debug.service.modules.MapSectionsBackgroundCommand;
import ghidra.app.services.DebuggerAutoMappingService;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.FileImporterService;
import ghidra.app.services.GoToService;
import ghidra.app.services.ProgramManager;
import ghidra.debug.api.action.AutoMapSpec;
import ghidra.debug.api.model.DebuggerObjectActionContext;
import ghidra.debug.api.modules.DebuggerMissingModuleActionContext;
import ghidra.debug.api.modules.DebuggerMissingProgramActionContext;
import ghidra.debug.api.modules.DebuggerStaticMappingChangeListener;
import ghidra.debug.api.modules.MapProposal;
import ghidra.debug.api.modules.ModuleMapProposal;
import ghidra.debug.api.modules.SectionMapProposal;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.main.DataTreeDialogType;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.framework.model.Project;
import ghidra.framework.model.TransactionInfo;
import ghidra.framework.model.TransactionListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoConfigStateField;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceClosedException;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.modules.TraceConflictedMappingException;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceModuleManager;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import org.apache.commons.lang3.ArrayUtils;

public class DebuggerModulesProvider
extends ComponentProviderAdapter
implements DebuggerAutoMappingService {
    protected static final AutoConfigState.ClassHandler<DebuggerModulesProvider> CONFIG_STATE_HANDLER = AutoConfigState.wireHandler(DebuggerModulesProvider.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected static final String NO_MODULES_PROPOSAL_SEL = "Could not formulate a proposal for any selected module. You may need to import and/or open the destination images first.";
    protected static final String FMT_NO_MODULES_PROPOSAL_RETRY = "Could not formulate a proposal for program '%s' to trace '%s'. The module may not be loaded yet, or the chosen image could be wrong.";
    protected static final String FMT_NO_MODULES_PROPOSAL_CURRENT = "Could not formulate a proposal from module '%s' to program '%s'.";
    final DebuggerModulesPlugin plugin;
    private DebuggerStaticMappingService staticMappingService;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    DebuggerListingService listingService;
    @AutoServiceConsumed
    private DebuggerConsoleService consoleService;
    @AutoServiceConsumed
    ProgramManager programManager;
    @AutoServiceConsumed
    private GoToService goToService;
    @AutoServiceConsumed
    private FileImporterService importerService;
    private final AutoService.Wiring autoServiceWiring;
    private final JSplitPane mainPanel = new JSplitPane(0);
    private final int defaultDividerSize = this.mainPanel.getDividerSize();
    DebuggerModulesPanel modulesPanel;
    DebuggerLegacyModulesPanel legacyModulesPanel;
    DebuggerSectionsPanel sectionsPanel;
    DebuggerLegacySectionsPanel legacySectionsPanel;
    private final DebuggerBlockChooserDialog blockChooserDialog;
    private final DebuggerModuleMapProposalDialog moduleProposalDialog;
    private final DebuggerSectionMapProposalDialog sectionProposalDialog;
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    private Program currentProgram;
    private ProgramLocation currentLocation;
    private ActionContext myActionContext;
    DockingAction actionMapIdentically;
    DockingAction actionMapManually;
    DockingAction actionMapModules;
    DockingAction actionMapModuleTo;
    DockingAction actionMapSections;
    DockingAction actionMapSectionTo;
    DockingAction actionMapSectionsTo;
    MultiStateDockingAction<AutoMapSpec> actionAutoMap;
    private final AutoMapSpec defaultAutoMapSpec;
    @AutoConfigStateField(codec=AutoMapSpec.AutoMapSpecConfigFieldCodec.class)
    AutoMapSpec autoMapSpec = this.defaultAutoMapSpec = AutoMapSpec.fromConfigName((String)"1_MAP_BY_MODULE");
    @AutoConfigStateField
    boolean showSectionsTable = true;
    @AutoConfigStateField
    boolean filterSectionsByModules = false;
    private final Map<Trace, AutoMapState> autoMapStateByTrace = new WeakHashMap<Trace, AutoMapState>();
    private AutoMapState forMappingListener;
    DockingAction actionImportMissingModule;
    DockingAction actionMapMissingModule;
    DockingAction actionMapMissingProgramRetry;
    DockingAction actionMapMissingProgramToCurrent;
    DockingAction actionMapMissingProgramIdentically;
    protected final ForCleanupMappingChangeListener mappingChangeListener = new ForCleanupMappingChangeListener();
    SelectAddressesAction actionSelectAddresses;
    ImportFromFileSystemAction actionImportFromFileSystem;
    ToggleDockingAction actionShowSectionsTable;
    ToggleDockingAction actionFilterSectionsByModules;
    DockingAction actionSelectCurrent;

    protected static boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getTrace(), b.getTrace())) {
            return false;
        }
        if (a.getSnap() != b.getSnap()) {
            return false;
        }
        return Objects.equals(a.getObject(), b.getObject());
    }

    protected static Set<TraceModule> getSelectedModules(ActionContext context) {
        if (context instanceof DebuggerModuleActionContext) {
            DebuggerModuleActionContext ctx = (DebuggerModuleActionContext)context;
            return DebuggerLegacyModulesPanel.getSelectedModulesFromContext(ctx);
        }
        if (context instanceof DebuggerSectionActionContext) {
            DebuggerSectionActionContext ctx = (DebuggerSectionActionContext)context;
            return DebuggerLegacySectionsPanel.getSelectedModulesFromContext(ctx);
        }
        if (context instanceof DebuggerObjectActionContext) {
            DebuggerObjectActionContext ctx = (DebuggerObjectActionContext)context;
            return DebuggerModulesPanel.getSelectedModulesFromContext(ctx);
        }
        return Set.of();
    }

    protected static Set<TraceSection> getSelectedSections(ActionContext context, boolean allowExpansion) {
        if (context instanceof DebuggerModuleActionContext) {
            DebuggerModuleActionContext ctx = (DebuggerModuleActionContext)context;
            return DebuggerLegacyModulesPanel.getSelectedSectionsFromContext(ctx);
        }
        if (context instanceof DebuggerSectionActionContext) {
            DebuggerSectionActionContext ctx = (DebuggerSectionActionContext)context;
            return DebuggerLegacySectionsPanel.getSelectedSectionsFromContext(ctx, allowExpansion);
        }
        if (context instanceof DebuggerObjectActionContext) {
            DebuggerObjectActionContext ctx = (DebuggerObjectActionContext)context;
            return DebuggerModulesPanel.getSelectedSectionsFromContext(ctx);
        }
        return Set.of();
    }

    protected static AddressSetView getSelectedAddresses(ActionContext context) {
        if (context instanceof DebuggerModuleActionContext) {
            DebuggerModuleActionContext ctx = (DebuggerModuleActionContext)context;
            return DebuggerLegacyModulesPanel.getSelectedAddressesFromContext(ctx);
        }
        if (context instanceof DebuggerSectionActionContext) {
            DebuggerSectionActionContext ctx = (DebuggerSectionActionContext)context;
            return DebuggerLegacySectionsPanel.getSelectedAddressesFromContext(ctx);
        }
        if (context instanceof DebuggerObjectActionContext) {
            DebuggerObjectActionContext ctx = (DebuggerObjectActionContext)context;
            return DebuggerModulesPanel.getSelectedAddressesFromContext(ctx);
        }
        return null;
    }

    public DebuggerModulesProvider(DebuggerModulesPlugin plugin) {
        super(plugin.getTool(), "Modules", plugin.getName(), null);
        this.plugin = plugin;
        this.setIcon(DebuggerResources.ICON_PROVIDER_MODULES);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_MODULES);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.blockChooserDialog = new DebuggerBlockChooserDialog(this.tool);
        this.moduleProposalDialog = new DebuggerModuleMapProposalDialog(this);
        this.sectionProposalDialog = new DebuggerSectionMapProposalDialog(this);
        this.setDefaultWindowPosition(WindowPosition.LEFT);
        this.setVisible(true);
        this.createActions();
    }

    private void importModuleFromFileSystem(TraceModule module) {
        GhidraFileChooser chooser = new GhidraFileChooser((Component)this.getComponent());
        chooser.setSelectedFile(new File(module.getName()));
        File file = chooser.getSelectedFile();
        chooser.dispose();
        if (file == null) {
            return;
        }
        Project activeProject = Objects.requireNonNull(AppInfo.getActiveProject());
        DomainFolder root = activeProject.getProjectData().getRootFolder();
        this.importerService.importFile(root, file);
    }

    void addResolutionActionMaybe(DebuggerConsoleService consoleService, DockingActionIf action) {
        if (action != null) {
            consoleService.addResolutionAction(action);
        }
    }

    void removeResolutionActionMaybe(DebuggerConsoleService consoleService, DockingActionIf action) {
        if (action != null) {
            consoleService.removeResolutionAction(action);
        }
    }

    @AutoServiceConsumed
    private void setConsoleService(DebuggerConsoleService consoleService) {
        if (consoleService != null) {
            this.addResolutionActionMaybe(consoleService, (DockingActionIf)this.actionImportMissingModule);
            this.addResolutionActionMaybe(consoleService, (DockingActionIf)this.actionMapMissingModule);
            this.addResolutionActionMaybe(consoleService, (DockingActionIf)this.actionMapMissingProgramRetry);
            this.addResolutionActionMaybe(consoleService, (DockingActionIf)this.actionMapMissingProgramToCurrent);
            this.addResolutionActionMaybe(consoleService, (DockingActionIf)this.actionMapMissingProgramIdentically);
        }
    }

    protected void dispose() {
        for (AutoMapState state : this.autoMapStateByTrace.values()) {
            state.dispose();
        }
        if (this.consoleService != null) {
            this.removeResolutionActionMaybe(this.consoleService, (DockingActionIf)this.actionImportMissingModule);
            this.removeResolutionActionMaybe(this.consoleService, (DockingActionIf)this.actionMapMissingModule);
            this.removeResolutionActionMaybe(this.consoleService, (DockingActionIf)this.actionMapMissingProgramRetry);
            this.removeResolutionActionMaybe(this.consoleService, (DockingActionIf)this.actionMapMissingProgramToCurrent);
            this.removeResolutionActionMaybe(this.consoleService, (DockingActionIf)this.actionMapMissingProgramIdentically);
        }
        this.blockChooserDialog.dispose();
        this.moduleProposalDialog.dispose();
        this.sectionProposalDialog.dispose();
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.myActionContext == null) {
            return super.getActionContext(event);
        }
        return this.myActionContext;
    }

    protected boolean isFilterSectionsByModules() {
        return this.filterSectionsByModules;
    }

    void modulesPanelContextChanged() {
        this.myActionContext = this.modulesPanel.getActionContext();
        if (this.isFilterSectionsByModules()) {
            this.sectionsPanel.reload();
        }
        this.contextChanged();
    }

    void legacyModulesPanelContextChanged() {
        this.myActionContext = this.legacyModulesPanel.getActionContext();
        if (this.isFilterSectionsByModules()) {
            this.legacySectionsPanel.loadSections();
        }
        this.contextChanged();
    }

    void sectionsPanelContextChanged() {
        this.myActionContext = this.sectionsPanel.getActionContext();
        this.contextChanged();
    }

    void legacySectionsPanelContextChanged() {
        this.myActionContext = this.legacySectionsPanel.getActionContext();
        this.contextChanged();
    }

    protected void buildMainPanel() {
        this.mainPanel.setContinuousLayout(true);
        this.modulesPanel = new DebuggerModulesPanel(this);
        this.mainPanel.setLeftComponent(this.modulesPanel);
        this.legacyModulesPanel = new DebuggerLegacyModulesPanel(this);
        this.sectionsPanel = new DebuggerSectionsPanel(this);
        this.mainPanel.setRightComponent(this.sectionsPanel);
        this.legacySectionsPanel = new DebuggerLegacySectionsPanel(this);
        this.mainPanel.setResizeWeight(0.5);
    }

    protected void createActions() {
        this.actionMapIdentically = (DockingAction)((ActionBuilder)((ActionBuilder)MapIdenticallyAction.builder(this.plugin).enabledWhen(ctx -> this.currentProgram != null && this.current.getTrace() != null)).onAction(this::activatedMapIdentically)).buildAndInstallLocal((ComponentProvider)this);
        this.actionMapManually = (DockingAction)((ActionBuilder)((ActionBuilder)MapManuallyAction.builder(this.plugin).enabled(true)).onAction(this::activatedMapManually)).buildAndInstallLocal((ComponentProvider)this);
        this.actionMapModules = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)MapModulesAction.builder(this.plugin).enabledWhen(ctx -> this.isContextHasModules((ActionContext)ctx) && this.isContextNotForcedSingle((ActionContext)ctx))).popupWhen(ctx -> this.isContextHasModules((ActionContext)ctx) && this.isContextNotForcedSingle((ActionContext)ctx))).onAction(this::activatedMapModules)).buildAndInstall((Tool)this.tool);
        this.actionMapModuleTo = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)MapModuleToAction.builder(this.plugin).enabledWhen(ctx -> this.currentProgram != null && DebuggerModulesProvider.getSelectedModules(ctx).size() == 1)).popupWhen(ctx -> this.currentProgram != null && DebuggerModulesProvider.getSelectedModules(ctx).size() == 1)).onAction(this::activatedMapModuleTo)).buildAndInstall((Tool)this.tool);
        this.actionMapSections = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)MapSectionsAction.builder(this.plugin).enabledWhen(ctx -> this.isContextHasSections((ActionContext)ctx) && this.isContextNotForcedSingle((ActionContext)ctx))).popupWhen(ctx -> this.isContextHasSections((ActionContext)ctx) && this.isContextNotForcedSingle((ActionContext)ctx))).onAction(this::activatedMapSections)).buildAndInstall((Tool)this.tool);
        this.actionMapSectionTo = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)MapSectionToAction.builder(this.plugin).enabledWhen(ctx -> this.currentProgram != null && DebuggerModulesProvider.getSelectedSections(ctx, false).size() == 1)).popupWhen(ctx -> this.currentProgram != null && DebuggerModulesProvider.getSelectedSections(ctx, false).size() == 1)).onAction(this::activatedMapSectionTo)).buildAndInstall((Tool)this.tool);
        this.actionMapSectionsTo = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)MapSectionsToAction.builder(this.plugin).enabledWhen(ctx -> this.currentProgram != null && this.isContextSectionsOfOneModule((ActionContext)ctx))).popupWhen(ctx -> this.currentProgram != null && this.isContextSectionsOfOneModule((ActionContext)ctx))).onAction(this::activatedMapSectionsTo)).buildAndInstall((Tool)this.tool);
        this.actionAutoMap = (MultiStateDockingAction)AutoMapAction.builder(this.plugin).onActionStateChanged(this::changedAutoMapSpec).buildAndInstallLocal((ComponentProvider)this);
        this.actionAutoMap.setCurrentActionStateByUserData((Object)this.defaultAutoMapSpec);
        this.actionImportMissingModule = (DockingAction)ImportMissingModuleAction.builder(this.plugin).withContext(DebuggerMissingModuleActionContext.class).onAction(this::activatedImportMissingModule).build();
        this.actionMapMissingModule = (DockingAction)MapMissingModuleAction.builder(this.plugin).withContext(DebuggerMissingModuleActionContext.class).onAction(this::activatedMapMissingModule).build();
        this.actionMapMissingProgramRetry = (DockingAction)MapMissingProgramRetryAction.builder(this.plugin).withContext(DebuggerMissingProgramActionContext.class).onAction(this::activatedMapMissingProgramRetry).build();
        this.actionMapMissingProgramToCurrent = (DockingAction)MapMissingProgramToCurrentAction.builder(this.plugin).withContext(DebuggerMissingProgramActionContext.class).enabledWhen(this::isEnabledMapMissingProgramToCurrent).onAction(this::activatedMapMissingProgramToCurrent).build();
        this.actionMapMissingProgramIdentically = (DockingAction)MapMissingProgramIdenticallyAction.builder(this.plugin).withContext(DebuggerMissingProgramActionContext.class).onAction(this::activatedMapMissingProgramIdentically).build();
        this.actionSelectAddresses = new SelectAddressesAction();
        this.actionImportFromFileSystem = new ImportFromFileSystemAction();
        this.actionShowSectionsTable = (ToggleDockingAction)((ToggleActionBuilder)ShowSectionsTableAction.builder(this.plugin).onAction(this::toggledShowSectionsTable)).selected(this.showSectionsTable).buildAndInstallLocal((ComponentProvider)this);
        this.actionFilterSectionsByModules = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)DebuggerResources.FilterAction.builder(this.plugin).description("Filter sections to those in selected modules")).helpLocation(new HelpLocation(this.plugin.getName(), "filter_by_module"))).onAction(this::toggledFilter)).buildAndInstallLocal((ComponentProvider)this);
        this.actionSelectCurrent = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)DebuggerResources.SelectRowsAction.builder(this.plugin).enabledWhen(ctx -> this.current.getTrace() != null)).description("Select modules and sections by dynamic selection")).onAction(this::activatedSelectCurrent)).buildAndInstallLocal((ComponentProvider)this);
        this.contextChanged();
    }

    private boolean isContextHasModules(ActionContext context) {
        return !DebuggerModulesProvider.getSelectedModules(context).isEmpty();
    }

    private boolean isContextHasSections(ActionContext context) {
        return !DebuggerModulesProvider.getSelectedSections(context, false).isEmpty();
    }

    private boolean isContextNonEmpty(ActionContext context) {
        if (context instanceof DebuggerModuleActionContext) {
            DebuggerModuleActionContext ctx = (DebuggerModuleActionContext)context;
            return !ctx.getSelectedModules().isEmpty();
        }
        if (context instanceof DebuggerSectionActionContext) {
            DebuggerSectionActionContext ctx = (DebuggerSectionActionContext)context;
            return !ctx.getSelectedSections(false).isEmpty();
        }
        if (context instanceof DebuggerObjectActionContext) {
            DebuggerObjectActionContext ctx = (DebuggerObjectActionContext)context;
            return !ctx.getObjectValues().isEmpty();
        }
        return false;
    }

    private boolean isContextNotForcedSingle(ActionContext context) {
        if (context instanceof DebuggerModuleActionContext) {
            DebuggerModuleActionContext ctx = (DebuggerModuleActionContext)context;
            return !ctx.isForcedSingle();
        }
        if (context instanceof DebuggerSectionActionContext) {
            DebuggerSectionActionContext ctx = (DebuggerSectionActionContext)context;
            return !ctx.isForcedSingle();
        }
        return true;
    }

    private boolean isContextSectionsOfOneModule(ActionContext context) {
        Set<TraceSection> sel = DebuggerModulesProvider.getSelectedSections(context, false);
        if (sel == null || sel.isEmpty()) {
            return false;
        }
        try {
            return sel.stream().map(TraceSection::getModule).distinct().count() == 1L;
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)("Could not check section selection context: " + String.valueOf(e)));
            return false;
        }
    }

    private void activatedMapIdentically(ActionContext ignored) {
        if (this.currentProgram == null || this.current.getTrace() == null) {
            return;
        }
        try {
            this.staticMappingService.addIdentityMapping(this.current.getTrace(), this.currentProgram, Lifespan.nowOn((long)this.traceManager.getCurrentSnap()), true);
        }
        catch (TraceConflictedMappingException e) {
            Msg.showError((Object)((Object)this), null, (String)"Map Identically", (Object)e.getMessage());
        }
    }

    private void activatedMapManually(ActionContext ignored) {
        ComponentProvider provider = this.tool.getComponentProvider("Static Mappings");
        if (provider != null) {
            this.tool.showComponentProvider(provider, true);
            return;
        }
        try {
            this.tool.addPlugin(DebuggerStaticMappingPlugin.class.getName());
        }
        catch (PluginException e) {
            Msg.showError((Object)((Object)this), (Component)this.mainPanel, (String)"Map Manually", (Object)"DebuggerStaticMappingPlugin could not be enabled", (Throwable)e);
            return;
        }
        provider = this.tool.getComponentProvider("Static Mappings");
        assert (provider != null);
        this.tool.showComponentProvider(provider, true);
    }

    private void activatedMapModules(ActionContext context) {
        Set<TraceModule> sel = DebuggerModulesProvider.getSelectedModules(context);
        if (sel == null || sel.isEmpty()) {
            return;
        }
        this.mapModules(sel);
    }

    private void activatedMapModuleTo(ActionContext context) {
        Set<TraceModule> sel = DebuggerModulesProvider.getSelectedModules(context);
        if (sel == null || sel.size() != 1) {
            return;
        }
        this.mapModuleTo(sel.iterator().next());
    }

    private void activatedMapSections(ActionContext context) {
        Set<TraceSection> sel = DebuggerModulesProvider.getSelectedSections(context, true);
        if (sel == null || sel.isEmpty()) {
            return;
        }
        this.mapSections(sel);
    }

    private void activatedMapSectionsTo(ActionContext context) {
        Set<TraceSection> sel = DebuggerModulesProvider.getSelectedSections(context, true);
        if (sel == null || sel.isEmpty()) {
            return;
        }
        this.mapSectionsTo(sel);
    }

    private void activatedMapSectionTo(ActionContext context) {
        Set<TraceSection> sel = DebuggerModulesProvider.getSelectedSections(context, false);
        if (sel == null || sel.size() != 1) {
            return;
        }
        this.mapSectionTo(sel.iterator().next());
    }

    private void changedAutoMapSpec(ActionState<AutoMapSpec> newState, EventTrigger trigger) {
        this.doSetAutoMapSpec((AutoMapSpec)newState.getUserData());
    }

    private void doSetAutoMapSpec(AutoMapSpec autoMapSpec) {
        this.autoMapSpec = autoMapSpec;
        Trace trace = this.current.getTrace();
        if (trace == null) {
            return;
        }
        AutoMapState state = this.autoMapStateByTrace.remove(trace);
        if (state != null && state.spec.equals((Object)autoMapSpec)) {
            this.autoMapStateByTrace.put(trace, state);
        } else {
            state.dispose();
            this.autoMapStateByTrace.put(trace, new AutoMapState(this.tool, trace, autoMapSpec));
        }
    }

    private void activatedImportMissingModule(DebuggerMissingModuleActionContext context) {
        if (this.importerService == null) {
            Msg.error((Object)((Object)this), (Object)"Import service is not present");
        }
        this.importModuleFromFileSystem(context.getModule());
    }

    private void activatedMapMissingModule(DebuggerMissingModuleActionContext context) {
        this.mapModuleTo(context.getModule());
    }

    private void activatedMapMissingProgramRetry(DebuggerMissingProgramActionContext context) {
        if (this.staticMappingService == null) {
            return;
        }
        Program program = context.getProgram();
        Trace trace = context.getTrace();
        Map map = this.staticMappingService.proposeModuleMaps(trace.getModuleManager().getAllModules(), List.of(program));
        Collection proposal = MapProposal.flatten(map.values());
        this.promptModuleProposal(proposal, FMT_NO_MODULES_PROPOSAL_RETRY.formatted(trace.getDomainFile().getName(), program.getDomainFile().getName()));
    }

    private boolean isEnabledMapMissingProgramToCurrent(DebuggerMissingProgramActionContext context) {
        if (this.staticMappingService == null || this.traceManager == null || this.listingService == null) {
            return false;
        }
        ProgramLocation loc = this.listingService.getCurrentLocation();
        if (loc == null) {
            return false;
        }
        Program program = loc.getProgram();
        if (!(program instanceof TraceProgramView)) {
            return false;
        }
        TraceProgramView view = (TraceProgramView)program;
        Trace trace = context.getTrace();
        if (view.getTrace() != trace) {
            return false;
        }
        long snap = this.traceManager.getCurrentFor(trace).getSnap();
        Address address = loc.getAddress();
        return !trace.getModuleManager().getModulesAt(snap, address).isEmpty();
    }

    private void activatedMapMissingProgramToCurrent(DebuggerMissingProgramActionContext context) {
        if (this.staticMappingService == null || this.traceManager == null || this.listingService == null) {
            return;
        }
        Trace trace = context.getTrace();
        long snap = this.traceManager.getCurrentFor(trace).getSnap();
        Address address = this.listingService.getCurrentLocation().getAddress();
        TraceModule module = (TraceModule)trace.getModuleManager().getModulesAt(snap, address).iterator().next();
        Program program = context.getProgram();
        ModuleMapProposal proposal = this.staticMappingService.proposeModuleMap(module, program);
        Map map = proposal.computeMap();
        this.promptModuleProposal(map.values(), FMT_NO_MODULES_PROPOSAL_CURRENT.formatted(module.getName(), program.getDomainFile().getName()));
    }

    private void activatedMapMissingProgramIdentically(DebuggerMissingProgramActionContext context) {
        if (this.staticMappingService == null) {
            return;
        }
        Trace trace = context.getTrace();
        long snap = this.traceManager == null ? 0L : this.traceManager.getCurrentFor(trace).getSnap();
        try {
            this.staticMappingService.addIdentityMapping(trace, context.getProgram(), Lifespan.nowOn((long)snap), true);
        }
        catch (TraceConflictedMappingException e) {
            Msg.showError((Object)((Object)this), null, (String)"Map Identically", (Object)e.getMessage());
        }
    }

    private void toggledShowSectionsTable(ActionContext ignored) {
        this.setShowSectionsTable(this.actionShowSectionsTable.isSelected());
    }

    public void setShowSectionsTable(boolean showSectionsTable) {
        if (this.showSectionsTable == showSectionsTable) {
            return;
        }
        this.doSetShowSectionsTable(showSectionsTable);
    }

    protected void doSetShowSectionsTable(boolean showSectionsTable) {
        this.showSectionsTable = showSectionsTable;
        this.actionShowSectionsTable.setSelected(showSectionsTable);
        this.mainPanel.setDividerSize(showSectionsTable ? this.defaultDividerSize : 0);
        this.sectionsPanel.setVisible(showSectionsTable);
        this.legacySectionsPanel.setVisible(showSectionsTable);
        this.mainPanel.resetToPreferredSizes();
    }

    private void toggledFilter(ActionContext ignored) {
        this.setFilterSectionsByModules(this.actionFilterSectionsByModules.isSelected());
    }

    public void setFilterSectionsByModules(boolean filterSectionsByModules) {
        if (this.filterSectionsByModules == filterSectionsByModules) {
            return;
        }
        this.doSetFilterSectionsByModules(filterSectionsByModules);
    }

    protected void doSetFilterSectionsByModules(boolean filterSectionsByModules) {
        this.filterSectionsByModules = filterSectionsByModules;
        this.actionFilterSectionsByModules.setSelected(filterSectionsByModules);
        this.sectionsPanel.setFilteredBySelectedModules(filterSectionsByModules);
        this.legacySectionsPanel.setFilteredBySelectedModules(filterSectionsByModules);
    }

    private void activatedSelectCurrent(ActionContext ignored) {
        if (this.listingService == null || this.traceManager == null || this.current.getTrace() == null) {
            return;
        }
        ProgramSelection progSel = this.listingService.getCurrentSelection();
        TraceModuleManager moduleManager = this.current.getTrace().getModuleManager();
        if (progSel != null && !progSel.isEmpty()) {
            long snap = this.traceManager.getCurrentSnap();
            HashSet<TraceModule> modSel = new HashSet<TraceModule>();
            HashSet<TraceSection> sectionSel = new HashSet<TraceSection>();
            for (AddressRange range : progSel) {
                for (TraceModule module : moduleManager.getModulesIntersecting(Lifespan.at((long)snap), range)) {
                    if (!module.getSections().isEmpty()) continue;
                    modSel.add(module);
                }
                for (TraceSection section : moduleManager.getSectionsIntersecting(Lifespan.at((long)snap), range)) {
                    sectionSel.add(section);
                    modSel.add(section.getModule());
                }
            }
            this.setSelectedModules(modSel);
            this.setSelectedSections(sectionSel);
            return;
        }
        ProgramLocation progLoc = this.listingService.getCurrentLocation();
        if (progLoc != null) {
            Address address = progLoc.getAddress();
            Set<TraceSection> sectionsAt = Set.copyOf(moduleManager.getSectionsAt(this.traceManager.getCurrentSnap(), address));
            if (!sectionsAt.isEmpty()) {
                Set<TraceModule> modulesAt = sectionsAt.stream().map(TraceSection::getModule).collect(Collectors.toSet());
                this.setSelectedModules(modulesAt);
                this.setSelectedSections(sectionsAt);
                return;
            }
            TraceModule bestModule = null;
            for (TraceModule module : moduleManager.getLoadedModules(this.traceManager.getCurrentSnap())) {
                Address base = module.getBase();
                if (base == null || base.getAddressSpace() != address.getAddressSpace()) continue;
                if (bestModule == null) {
                    bestModule = module;
                    continue;
                }
                if (base.compareTo((Object)address) > 0 || base.compareTo((Object)bestModule.getBase()) <= 0) continue;
                bestModule = module;
            }
            if (bestModule.getSections().isEmpty()) {
                this.setSelectedModules(Set.of(bestModule));
                return;
            }
        }
    }

    protected void promptModuleProposal(Collection<ModuleMapProposal.ModuleMapEntry> proposal, String emptyMsg) {
        if (proposal.isEmpty()) {
            Msg.showInfo((Object)((Object)this), (Component)this.getComponent(), (String)"Map Modules", (Object)emptyMsg);
            return;
        }
        Collection<ModuleMapProposal.ModuleMapEntry> adjusted = this.moduleProposalDialog.adjustCollection(this.getTool(), proposal);
        if (adjusted == null || this.staticMappingService == null) {
            return;
        }
        this.tool.executeBackgroundCommand((BackgroundCommand)new MapModulesBackgroundCommand(this.staticMappingService, adjusted), (DomainObject)this.current.getTrace());
    }

    protected void mapModules(Set<TraceModule> modules) {
        if (this.staticMappingService == null) {
            return;
        }
        Map map = this.staticMappingService.proposeModuleMaps(modules, List.of(this.programManager.getAllOpenPrograms()));
        Collection proposal = MapProposal.flatten(map.values());
        this.promptModuleProposal(proposal, NO_MODULES_PROPOSAL_SEL);
    }

    protected void mapModuleTo(TraceModule module) {
        if (this.staticMappingService == null) {
            return;
        }
        Program program = this.currentProgram;
        if (program == null) {
            return;
        }
        ModuleMapProposal proposal = this.staticMappingService.proposeModuleMap(module, program);
        Map map = proposal.computeMap();
        this.promptModuleProposal(map.values(), NO_MODULES_PROPOSAL_SEL);
    }

    protected void promptSectionProposal(Collection<SectionMapProposal.SectionMapEntry> proposal) {
        if (proposal.isEmpty()) {
            Msg.showInfo((Object)((Object)this), (Component)this.getComponent(), (String)"Map Sections", (Object)"Could not formulate a proposal for any selected section. You may need to import and/or open the destination images first.");
            return;
        }
        Collection<SectionMapProposal.SectionMapEntry> adjusted = this.sectionProposalDialog.adjustCollection(this.getTool(), proposal);
        if (adjusted == null || this.staticMappingService == null) {
            return;
        }
        this.tool.executeBackgroundCommand((BackgroundCommand)new MapSectionsBackgroundCommand(this.staticMappingService, adjusted), (DomainObject)this.current.getTrace());
    }

    protected void mapSections(Set<TraceSection> sections) {
        if (this.staticMappingService == null) {
            return;
        }
        Set modules = sections.stream().map(TraceSection::getModule).collect(Collectors.toSet());
        Map map = this.staticMappingService.proposeSectionMaps(modules, List.of(this.programManager.getAllOpenPrograms()));
        Collection proposal = MapProposal.flatten(map.values());
        Collection filtered = proposal.stream().filter(e -> sections.contains(e.getSection())).collect(Collectors.toSet());
        this.promptSectionProposal(filtered);
    }

    protected void mapSectionsTo(Set<TraceSection> sections) {
        if (this.staticMappingService == null) {
            return;
        }
        Program program = this.currentProgram;
        if (program == null) {
            return;
        }
        Set modules = sections.stream().map(TraceSection::getModule).collect(Collectors.toSet());
        if (modules.size() != 1) {
            return;
        }
        TraceModule module = (TraceModule)modules.iterator().next();
        SectionMapProposal map = this.staticMappingService.proposeSectionMap(module, program);
        Collection proposal = map.computeMap().values();
        Collection filtered = proposal.stream().filter(e -> sections.contains(e.getSection())).collect(Collectors.toSet());
        this.promptSectionProposal(filtered);
    }

    protected void mapSectionTo(TraceSection section) {
        if (this.staticMappingService == null) {
            return;
        }
        ProgramLocation location = this.currentLocation;
        MemoryBlock block = DebuggerModulesProvider.computeBlock(location);
        if (block == null) {
            return;
        }
        SectionMapProposal map = this.staticMappingService.proposeSectionMap(section, location.getProgram(), block);
        this.promptSectionProposal(map.computeMap().values());
    }

    protected Set<MemoryBlock> collectBlocksInOpenPrograms() {
        HashSet<MemoryBlock> result = new HashSet<MemoryBlock>();
        for (Program p : this.programManager.getAllOpenPrograms()) {
            if (p instanceof Trace) continue;
            result.addAll(List.of(p.getMemory().getBlocks()));
        }
        return result;
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public void setProgram(Program program) {
        DomainFile df;
        this.currentProgram = program;
        String name = program != null ? ((df = program.getDomainFile()) != null ? df.getName() : program.getName()) : "...";
        this.actionMapModuleTo.getPopupMenuData().setMenuItemName("Map Module to " + name);
        this.actionMapSectionsTo.getPopupMenuData().setMenuItemName("Map Sections to " + name);
    }

    public static MemoryBlock computeBlock(ProgramLocation location) {
        if (location == null) {
            return null;
        }
        Program program = location.getProgram();
        if (program == null) {
            return null;
        }
        Address addr = location.getAddress();
        if (addr == null) {
            return null;
        }
        return program.getMemory().getBlock(addr);
    }

    public static String computeBlockName(ProgramLocation location) {
        MemoryBlock block = DebuggerModulesProvider.computeBlock(location);
        if (block == null) {
            return "...";
        }
        Program program = location.getProgram();
        String name = program.getName();
        DomainFile df = program.getDomainFile();
        if (df != null) {
            name = df.getName();
        }
        return name + ":" + block.getName();
    }

    public void setLocation(ProgramLocation location) {
        this.currentLocation = location;
        String name = "Map Section to " + DebuggerModulesProvider.computeBlockName(location);
        this.actionMapSectionTo.getPopupMenuData().setMenuItemName(name);
    }

    public void programOpened(Program program) {
        AutoMapState mapState = this.autoMapStateByTrace.get(this.current.getTrace());
        if (mapState == null) {
            return;
        }
        mapState.forceMap();
    }

    public void programClosed(Program program) {
        if (this.currentProgram == program) {
            this.currentProgram = null;
        }
        this.cleanMissingProgramMessages(null, program);
    }

    public void traceOpened(Trace trace) {
        this.autoMapStateByTrace.computeIfAbsent(trace, t -> new AutoMapState(this.tool, trace, this.autoMapSpec));
    }

    public void traceClosed(Trace trace) {
        AutoMapState state = this.autoMapStateByTrace.remove(trace);
        if (state != null) {
            state.dispose();
        }
        this.cleanMissingProgramMessages(trace, null);
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        boolean changeTrace;
        if (DebuggerModulesProvider.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return;
        }
        Trace newTrace = coordinates.getTrace();
        boolean bl = changeTrace = this.current.getTrace() != newTrace;
        if (changeTrace) {
            this.myActionContext = null;
        }
        this.current = coordinates;
        AutoMapState amState = this.autoMapStateByTrace.get(newTrace);
        if (amState != null) {
            this.setAutoMapSpec(amState.spec);
        }
        if (Trace.isLegacy((Trace)newTrace)) {
            this.modulesPanel.coordinatesActivated(DebuggerCoordinates.NOWHERE);
            this.sectionsPanel.coordinatesActivated(DebuggerCoordinates.NOWHERE);
            this.legacyModulesPanel.coordinatesActivated(coordinates);
            this.legacySectionsPanel.coordinatesActivated(coordinates);
            if (ArrayUtils.indexOf((Object[])this.mainPanel.getComponents(), (Object)this.legacyModulesPanel) == -1) {
                this.mainPanel.remove(this.modulesPanel);
                this.mainPanel.remove(this.sectionsPanel);
                this.mainPanel.setLeftComponent(this.legacyModulesPanel);
                this.mainPanel.setRightComponent(this.legacySectionsPanel);
                this.mainPanel.validate();
            }
        } else {
            this.legacyModulesPanel.coordinatesActivated(DebuggerCoordinates.NOWHERE);
            this.legacySectionsPanel.coordinatesActivated(DebuggerCoordinates.NOWHERE);
            this.modulesPanel.coordinatesActivated(coordinates);
            this.sectionsPanel.coordinatesActivated(coordinates);
            if (ArrayUtils.indexOf((Object[])this.mainPanel.getComponents(), (Object)this.modulesPanel) == -1) {
                this.mainPanel.remove(this.legacyModulesPanel);
                this.mainPanel.remove(this.legacySectionsPanel);
                this.mainPanel.setLeftComponent(this.modulesPanel);
                this.mainPanel.setRightComponent(this.sectionsPanel);
                this.mainPanel.validate();
            }
        }
        this.contextChanged();
    }

    public void setSelectedModules(Set<TraceModule> sel) {
        if (Trace.isLegacy((Trace)this.current.getTrace())) {
            this.legacyModulesPanel.setSelectedModules(sel);
        } else {
            this.modulesPanel.setSelectedModules(sel);
        }
    }

    public void setSelectedSections(Set<TraceSection> sel) {
        if (Trace.isLegacy((Trace)this.current.getTrace())) {
            this.legacySectionsPanel.setSelectedSections(sel);
        } else {
            this.sectionsPanel.setSelectedSections(sel);
        }
    }

    private DataTreeDialog getProgramChooserDialog() {
        DomainFileFilter filter = df -> Program.class.isAssignableFrom(df.getDomainObjectClass());
        return new DataTreeDialog(null, "Map Module to Program", DataTreeDialogType.OPEN, filter);
    }

    public DomainFile askProgram(Program program) {
        DataTreeDialog dialog = this.getProgramChooserDialog();
        if (program != null) {
            dialog.selectDomainFile(program.getDomainFile());
        }
        this.tool.showDialog((DialogComponentProvider)dialog);
        return dialog.getDomainFile();
    }

    public Map.Entry<Program, MemoryBlock> askBlock(TraceSection section, Program program, MemoryBlock block) {
        if (this.programManager == null) {
            Msg.warn((Object)((Object)this), (Object)"No program manager!");
            return null;
        }
        return this.blockChooserDialog.chooseBlock(this.getTool(), section, List.of(this.programManager.getAllOpenPrograms()));
    }

    public void setAutoMapSpec(AutoMapSpec spec) {
        this.actionAutoMap.setCurrentActionStateByUserData((Object)spec);
    }

    public AutoMapSpec getAutoMapSpec() {
        return this.autoMapSpec;
    }

    public AutoMapSpec getAutoMapSpec(Trace trace) {
        AutoMapState state = this.autoMapStateByTrace.get(trace);
        return state == null ? this.autoMapSpec : state.spec;
    }

    public void writeConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.writeConfigState((Object)this, saveState);
    }

    public void readConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.readConfigState((Object)this, saveState);
        this.actionAutoMap.setCurrentActionStateByUserData((Object)this.autoMapSpec);
        this.doSetFilterSectionsByModules(this.filterSectionsByModules);
        this.doSetShowSectionsTable(this.showSectionsTable);
    }

    protected boolean shouldKeepMessage(DebuggerMissingProgramActionContext ctx, Trace closedTrace, Program closedProgram) {
        Address probe;
        Trace trace = ctx.getTrace();
        if (trace == closedTrace) {
            return false;
        }
        if (!this.traceManager.getOpenTraces().contains(trace)) {
            return false;
        }
        Program program = ctx.getProgram();
        if (program == closedProgram) {
            return false;
        }
        if (this.programManager != null && !Arrays.asList(this.programManager.getAllOpenPrograms()).contains(program)) {
            return false;
        }
        if (closedTrace != null || closedProgram != null) {
            return true;
        }
        TraceProgramView view = this.traceManager.getCurrentFor(trace).getView();
        ProgramLocation dyn = this.staticMappingService.getDynamicLocationFromStatic(view, new ProgramLocation(program, probe = ctx.getMappingProbeAddress()));
        return dyn == null;
    }

    protected void cleanMissingProgramMessages(Trace closedTrace, Program closedProgram) {
        if (this.traceManager == null || this.consoleService == null) {
            return;
        }
        for (ActionContext ctx : this.consoleService.getActionContexts()) {
            DebuggerMissingProgramActionContext mpCtx;
            if (!(ctx instanceof DebuggerMissingProgramActionContext) || this.shouldKeepMessage(mpCtx = (DebuggerMissingProgramActionContext)ctx, closedTrace, closedProgram)) continue;
            this.consoleService.removeFromLog((ActionContext)mpCtx);
        }
    }

    @AutoServiceConsumed
    private void setStaticMappingService(DebuggerStaticMappingService staticMappingService) {
        if (this.staticMappingService != null) {
            this.staticMappingService.removeChangeListener((DebuggerStaticMappingChangeListener)this.mappingChangeListener);
        }
        this.staticMappingService = staticMappingService;
        if (this.staticMappingService != null) {
            this.staticMappingService.addChangeListener((DebuggerStaticMappingChangeListener)this.mappingChangeListener);
        }
    }

    protected class ForCleanupMappingChangeListener
    implements DebuggerStaticMappingChangeListener {
        protected ForCleanupMappingChangeListener() {
        }

        public void mappingsChanged(Set<Trace> affectedTraces, Set<Program> affectedPrograms) {
            Swing.runIfSwingOrRunLater(() -> DebuggerModulesProvider.this.cleanMissingProgramMessages(null, null));
        }
    }

    protected static class AutoMapState
    extends TraceDomainObjectListener
    implements TransactionListener {
        private final PluginTool tool;
        private final Trace trace;
        private final AutoMapSpec spec;
        private volatile boolean couldHaveChanged = true;
        private volatile String infosLastTime = "";

        public AutoMapState(PluginTool tool, Trace trace, AutoMapSpec spec) {
            this.tool = tool;
            this.trace = trace;
            this.spec = spec;
            for (TraceEvent type : spec.getChangeTypes()) {
                this.listenFor(type, this::changed);
            }
            this.listenFor((TraceEvent)TraceEvents.VALUE_CREATED, this::valueCreated);
            this.listenForUntyped((EventType)DomainObjectEvent.RESTORED, this::objectRestored);
            trace.addListener((DomainObjectListener)this);
            trace.addTransactionListener((TransactionListener)this);
        }

        public void dispose() {
            this.trace.removeListener((DomainObjectListener)this);
            this.trace.removeTransactionListener((TransactionListener)this);
        }

        private void changed() {
            this.couldHaveChanged = true;
        }

        private void valueCreated(TraceObjectValue value) {
            this.couldHaveChanged = true;
        }

        private void objectRestored(DomainObjectChangeRecord rec) {
            this.couldHaveChanged = true;
        }

        public void transactionStarted(DomainObjectAdapterDB domainObj, TransactionInfo tx) {
        }

        public void transactionEnded(DomainObjectAdapterDB domainObj) {
            this.checkAutoMap();
        }

        public void undoStackChanged(DomainObjectAdapterDB domainObj) {
        }

        public void undoRedoOccurred(DomainObjectAdapterDB domainObj) {
        }

        private void checkAutoMap() {
            if (!this.couldHaveChanged) {
                return;
            }
            this.couldHaveChanged = false;
            String infosThisTime = this.spec.getInfoForObjects(this.trace);
            if (Objects.equals(infosThisTime, this.infosLastTime)) {
                return;
            }
            this.infosLastTime = infosThisTime;
            this.spec.runTask(this.tool, this.trace);
        }

        public void forceMap() {
            this.couldHaveChanged = true;
            this.infosLastTime = "";
            this.checkAutoMap();
        }
    }

    static interface MapIdenticallyAction {
        public static final String NAME = "Map Identically";
        public static final String DESCRIPTION = "Map the current trace to the current program using identical addresses";
        public static final Icon ICON = DebuggerResources.ICON_MAP_IDENTICALLY;
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_identically";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface MapManuallyAction {
        public static final String NAME = "Map Manually";
        public static final String DESCRIPTION = "Map the current trace to various programs manually";
        public static final Icon ICON = DebuggerResources.ICON_MAP_MANUALLY;
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_manually";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface MapModulesAction {
        public static final String NAME = "Map Modules";
        public static final String DESCRIPTION = "Map selected modules to program images";
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_modules";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{NAME})).popupMenuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface MapModuleToAction {
        public static final String NAME_PREFIX = "Map Module to ";
        public static final String DESCRIPTION = "Map the selected module to the current program";
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_module_to";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME_PREFIX, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{"Map Module to ..."})).popupMenuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface MapSectionsAction {
        public static final String NAME = "Map Sections";
        public static final String DESCRIPTION = "Map selected sections to program memory blocks";
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_sections";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{NAME})).popupMenuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface MapSectionToAction {
        public static final String NAME_PREFIX = "Map Section to ";
        public static final String DESCRIPTION = "Map the selected section to the current program";
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_section_to";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME_PREFIX, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{"Map Section to ..."})).popupMenuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface MapSectionsToAction {
        public static final String NAME_PREFIX = "Map Sections to ";
        public static final String DESCRIPTION = "Map the selected module sections to the current program";
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_sections_to";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME_PREFIX, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{"Map Sections to ..."})).popupMenuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface AutoMapAction {
        public static final String NAME = "Auto-Map Target Memory";
        public static final Icon ICON = DebuggerResources.ICON_MAP_AUTO;
        public static final String DESCRIPTION = "Automatically map dynamic memory to static counterparts";
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "auto_map";

        public static MultiStateActionBuilder<AutoMapSpec> builder(Plugin owner) {
            String ownerName = owner.getName();
            MultiStateActionBuilder builder = (MultiStateActionBuilder)((MultiStateActionBuilder)((MultiStateActionBuilder)((MultiStateActionBuilder)new MultiStateActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup(GROUP)).toolBarIcon(ICON)).useCheckboxForIcons(true).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
            for (AutoMapSpec spec : AutoMapSpec.allSpecs().values()) {
                builder.addState(spec.getMenuName(), spec.getMenuIcon(), (Object)spec);
            }
            return builder;
        }
    }

    static interface ImportMissingModuleAction {
        public static final String NAME = "Import Missing Module";
        public static final String DESCRIPTION = "Import the missing module from disk";
        public static final Icon ICON = DebuggerResources.ICON_IMPORT;
        public static final String HELP_ANCHOR = "import_missing_module";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).popupMenuIcon(ICON)).popupMenuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface MapMissingModuleAction {
        public static final String NAME = "Map Missing Module";
        public static final String DESCRIPTION = "Map the missing module to an existing import";
        public static final Icon ICON = DebuggerResources.ICON_MAP_MODULES;
        public static final String HELP_ANCHOR = "map_missing_module";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).popupMenuIcon(ICON)).popupMenuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface MapMissingProgramRetryAction {
        public static final String NAME = "Retry Map Missing Program";
        public static final String DESCRIPTION = "Retry mapping the missing program by finding its module";
        public static final Icon ICON = DebuggerResources.ICON_MAP_AUTO;
        public static final String HELP_ANCHOR = "map_missing_program_retry";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).popupMenuIcon(ICON)).popupMenuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface MapMissingProgramToCurrentAction {
        public static final String NAME = "Map Missing Program to Current Module";
        public static final String DESCRIPTION = "Map the missing program to the current module";
        public static final Icon ICON = DebuggerResources.ICON_MAP_MODULES;
        public static final String HELP_ANCHOR = "map_missing_program_current";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).popupMenuIcon(ICON)).popupMenuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface MapMissingProgramIdenticallyAction {
        public static final String NAME = "Map Missing Program Identically";
        public static final String DESCRIPTION = "Map the missing program to its trace identically";
        public static final Icon ICON = DebuggerResources.ICON_MAP_IDENTICALLY;
        public static final String HELP_ANCHOR = "map_missing_program_identically";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).popupMenuIcon(ICON)).popupMenuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    protected class SelectAddressesAction
    extends DebuggerResources.AbstractSelectAddressesAction {
        public static final String GROUP = "Dbg1. General";

        public SelectAddressesAction() {
            super(DebuggerModulesProvider.this.plugin);
            this.setDescription("Select addresses contained in modules or sections");
            this.setToolBarData(new ToolBarData(ICON, GROUP));
            this.setPopupMenuData(new MenuData(new String[]{"Select Addresses"}, GROUP));
            DebuggerModulesProvider.this.addLocalAction((DockingActionIf)this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionContext context) {
            if (DebuggerModulesProvider.this.listingService == null) {
                return;
            }
            AddressSetView sel = DebuggerModulesProvider.getSelectedAddresses(context);
            if (sel == null || sel.isEmpty()) {
                return;
            }
            sel = sel.intersect((AddressSetView)DebuggerModulesProvider.this.traceManager.getCurrentView().getMemory());
            ProgramSelection ps = new ProgramSelection(sel);
            DebuggerModulesProvider.this.listingService.setCurrentSelection(ps);
        }

        public boolean isEnabledForContext(ActionContext context) {
            return DebuggerModulesProvider.this.isContextNonEmpty(context);
        }
    }

    protected class ImportFromFileSystemAction
    extends DebuggerResources.AbstractImportFromFileSystemAction {
        public static final String GROUP = "Dbg1. General";

        public ImportFromFileSystemAction() {
            super(DebuggerModulesProvider.this.plugin);
            this.setPopupMenuData(new MenuData(new String[]{"Import From File System"}, GROUP));
            DebuggerModulesProvider.this.tool.addAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            if (DebuggerModulesProvider.this.importerService == null) {
                return;
            }
            Set<TraceModule> modules = DebuggerModulesProvider.getSelectedModules(context);
            if (modules == null || modules.size() != 1) {
                return;
            }
            TraceModule mod = modules.iterator().next();
            DebuggerModulesProvider.this.importModuleFromFileSystem(mod);
        }

        public boolean isEnabledForContext(ActionContext context) {
            try {
                Set<TraceModule> sel = DebuggerModulesProvider.getSelectedModules(context);
                return DebuggerModulesProvider.this.importerService != null && sel != null && sel.size() == 1;
            }
            catch (TraceClosedException e) {
                return false;
            }
        }
    }

    static interface ShowSectionsTableAction {
        public static final String NAME = "Show Sections Table";
        public static final Icon ICON = new GIcon("icon.debugger.modules.table.sections");
        public static final String DESCRIPTION = "Toggle display fo the Sections Table pane";
        public static final String GROUP = "yyyy";
        public static final String ORDER = "1";
        public static final String HELP_ANCHOR = "show_sections_table";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup(GROUP, ORDER)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }
}

