/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import docking.ComponentProvider;
import docking.DefaultActionContext;
import docking.widgets.table.GTable;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModulesProvider;
import ghidra.app.plugin.core.debug.gui.modules.SectionRow;
import ghidra.trace.model.modules.TraceSection;
import java.awt.Component;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class DebuggerSectionActionContext
extends DefaultActionContext {
    private final Set<TraceSection> selectedSections;
    private final boolean forcedSingle;

    private static Set<TraceSection> toSections(Collection<SectionRow> rows) {
        return rows.stream().map(SectionRow::getSection).collect(Collectors.toUnmodifiableSet());
    }

    public DebuggerSectionActionContext(DebuggerModulesProvider provider, Collection<SectionRow> rows, GTable table) {
        this((ComponentProvider)provider, DebuggerSectionActionContext.toSections(rows), (Component)table, false);
    }

    public DebuggerSectionActionContext(ComponentProvider provider, Set<TraceSection> selected, Component sourceComponent, boolean forcedSingle) {
        super(provider, selected, sourceComponent);
        this.selectedSections = selected;
        this.forcedSingle = forcedSingle;
    }

    public Set<TraceSection> getSelectedSections(boolean allowExpansion) {
        if (this.forcedSingle && allowExpansion) {
            return this.selectedSections.stream().flatMap(s -> s.getModule().getSections().stream()).collect(Collectors.toUnmodifiableSet());
        }
        return this.selectedSections;
    }

    public boolean isForcedSingle() {
        return this.forcedSingle;
    }
}

