/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import db.Transaction;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModulesProvider;
import ghidra.app.plugin.core.debug.service.modules.DebuggerStaticMappingUtils;
import ghidra.program.model.address.Address;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.modules.TraceModule;

public class ModuleRow {
    private final DebuggerModulesProvider provider;
    private final TraceModule module;

    public ModuleRow(DebuggerModulesProvider provider, TraceModule module) {
        this.provider = provider;
        this.module = module;
    }

    public TraceModule getModule() {
        return this.module;
    }

    public void setName(String name) {
        try (Transaction tx = this.module.getTrace().openTransaction("Renamed module");){
            this.module.setName(name);
        }
    }

    public String getShortName() {
        return DebuggerStaticMappingUtils.computeModuleShortName(this.module.getName());
    }

    public String getName() {
        return this.module.getName();
    }

    public String getMapping() {
        return DebuggerStaticMappingUtils.computeMappedFiles(this.module.getTrace(), this.provider.current.getSnap(), this.module.getRange());
    }

    public Address getBase() {
        return this.module.getBase();
    }

    public Address getMaxAddress() {
        return this.module.getMaxAddress();
    }

    public long getLoadedSnap() {
        return this.module.getLoadedSnap();
    }

    public Long getUnloadedSnap() {
        long snap = this.module.getUnloadedSnap();
        return snap == Long.MAX_VALUE ? null : Long.valueOf(snap);
    }

    public Lifespan getLifespan() {
        return this.module.getLifespan();
    }

    public long getLength() {
        return this.module.getLength();
    }
}

