/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.script.AskDialog;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;

public class SetTimeoutAction
extends DockingAction {
    DebuggerObjectsProvider provider;
    int timeout = 0;

    public SetTimeoutAction(PluginTool tool, String owner, DebuggerObjectsProvider provider) {
        super("SetTimeout", owner);
        this.setMenuBarData(new MenuData(new String[]{"Maintenance", "&Set Node Timeout"}, null, "M100"));
        this.setHelpLocation(new HelpLocation(owner, "set_node_timeout"));
        this.provider = provider;
        provider.addLocalAction((DockingActionIf)this);
        this.timeout = provider.getNodeTimeout();
    }

    public boolean isEnabledForContext(ActionContext context) {
        return true;
    }

    public void actionPerformed(ActionContext context) {
        AskDialog dialog = new AskDialog("Set Node Timeout", "Seconds", 1, (Object)this.timeout);
        if (dialog.isCanceled()) {
            return;
        }
        this.timeout = Integer.parseInt(dialog.getValueAsString());
        this.provider.setNodeTimeout(this.timeout);
    }

    public void setNodeTimeout(int timeout) {
        this.timeout = timeout;
    }
}

