/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.target;

import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.target.DebuggerTargetsProvider;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModel;
import java.util.Objects;

public class DebuggerModelNode
extends DebuggerResources.AbstractDebuggerModelNode
implements DebuggerModelListener {
    private final DebuggerObjectModel model;
    private final DebuggerTargetsProvider provider;
    private String name;

    public DebuggerModelNode(DebuggerObjectModel model, DebuggerTargetsProvider provider) {
        this.model = Objects.requireNonNull(model);
        this.provider = Objects.requireNonNull(provider);
        this.name = String.valueOf(model.getClass()) + "@" + Integer.toHexString(System.identityHashCode(model));
        model.addModelListener((DebuggerModelListener)this);
    }

    public String getDisplayText() {
        return this.model.getBrief();
    }

    public String getName() {
        return this.name;
    }

    public boolean isLeaf() {
        return true;
    }

    public DebuggerObjectModel getDebuggerModel() {
        return this.model;
    }

    public void modelStateChanged() {
        this.provider.updateTree(false, null);
    }
}

