/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.target;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.action.builder.ActionBuilder;
import docking.widgets.tree.AnyChangeTreeModelListener;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeSelectionEvent;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.target.DebuggerConnectionsNode;
import ghidra.app.plugin.core.debug.gui.target.DebuggerModelActionContext;
import ghidra.app.plugin.core.debug.gui.target.DebuggerTargetsPlugin;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.ProgramManager;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.listing.Program;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class DebuggerTargetsProvider
extends ComponentProviderAdapter {
    final DebuggerTargetsPlugin plugin;
    @AutoServiceConsumed
    DebuggerModelService modelService;
    private final AutoService.Wiring autoServiceWiring;
    private JPanel mainPanel;
    protected GTree tree;
    protected DebuggerConnectionsNode rootNode;
    ConnectAction actionConnect;
    DisconnectAction actionDisconnect;
    DockingAction actionDisconnectAll;
    FlushCachesAction actionFlushCaches;
    DebuggerModelActionContext myActionContext;

    protected static DebuggerModelService getModelServiceFromContext(ActionContext context) {
        if (!(context instanceof DebuggerModelActionContext)) {
            return null;
        }
        DebuggerModelActionContext ctx = (DebuggerModelActionContext)context;
        return ctx.getIfModelService();
    }

    protected static DebuggerObjectModel getModelFromContext(ActionContext context) {
        if (!(context instanceof DebuggerModelActionContext)) {
            return null;
        }
        DebuggerModelActionContext ctx = (DebuggerModelActionContext)context;
        return ctx.getIfDebuggerModel();
    }

    public DebuggerTargetsProvider(DebuggerTargetsPlugin plugin) {
        super(plugin.getTool(), "Debugger Targets", plugin.getName());
        this.plugin = plugin;
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.setTitle("Debugger Targets");
        this.setIcon(DebuggerResources.ICON_PROVIDER_TARGETS);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_TARGETS);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.setDefaultWindowPosition(WindowPosition.LEFT);
        this.setVisible(true);
        this.createActions();
        this.myActionContext = new DebuggerModelActionContext((ComponentProvider)this, null, this.tree);
    }

    public void addLocalAction(DockingActionIf action) {
        super.addLocalAction(action);
    }

    private void createActions() {
        this.actionConnect = new ConnectAction();
        this.actionDisconnect = new DisconnectAction();
        this.actionDisconnectAll = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.DisconnectAllAction.builder(this.plugin, this.plugin).menuPath(new String[]{"Disconnect All"})).onAction(this::activatedDisconnectAll)).buildAndInstallLocal((ComponentProvider)this);
        this.actionFlushCaches = new FlushCachesAction();
    }

    private void activatedDisconnectAll(ActionContext context) {
        if (this.modelService == null) {
            return;
        }
        this.modelService.closeAllModels();
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.myActionContext == null) {
            return super.getActionContext(event);
        }
        return this.myActionContext;
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    private void setContext() {
        this.myActionContext = new DebuggerModelActionContext((ComponentProvider)this, this.tree.getSelectionPath(), this.tree);
        this.contextChanged();
    }

    private void emitEvents() {
        DebuggerObjectModel model = this.myActionContext.getIfDebuggerModel();
        if (model != null) {
            this.modelService.activateModel(model);
        }
    }

    private void buildMainPanel() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.rootNode = new DebuggerConnectionsNode(this.modelService, this);
        this.tree = new GTree((GTreeNode)this.rootNode);
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.mainPanel.add((Component)this.tree);
        this.tree.setAccessibleNamePrefix("Debugger Targets");
        this.tree.getGTSelectionModel().addGTreeSelectionListener(evt -> {
            this.setContext();
            if (evt.getEventOrigin() != GTreeSelectionEvent.EventOrigin.API_GENERATED) {
                this.emitEvents();
            }
        });
        this.tree.addGTModelListener((TreeModelListener)((AnyChangeTreeModelListener)e -> {
            this.setContext();
            this.emitEvents();
        }));
    }

    @AutoServiceConsumed
    private void setModelService(DebuggerModelService modelService) {
        if (this.tree != null) {
            this.rootNode = new DebuggerConnectionsNode(modelService, this);
            this.tree.setRootNode((GTreeNode)this.rootNode);
        }
    }

    protected void updateTree(boolean select, Object obj) {
        if (this.tree == null) {
            return;
        }
        this.tree.repaint();
        if (!select) {
            return;
        }
        GTreeNode node = this.rootNode.findNodeForObject(obj);
        if (node != null) {
            this.tree.setSelectedNode(node);
            this.myActionContext = new DebuggerModelActionContext((ComponentProvider)this, node.getTreePath(), this.tree);
            this.contextChanged();
        }
    }

    public void modelActivated(DebuggerObjectModel model) {
        if (this.rootNode == null || this.tree == null) {
            return;
        }
        GTreeNode node = this.rootNode.findNodeForObject(model);
        if (node == null) {
            return;
        }
        this.tree.setSelectionPaths(new TreePath[]{node.getTreePath()}, GTreeSelectionEvent.EventOrigin.API_GENERATED);
    }

    protected void clearServiceCaches(DebuggerModelService service) {
        for (DebuggerObjectModel model : service.getModels()) {
            model.invalidateAllLocalCaches();
        }
    }

    protected class ConnectAction
    extends DebuggerResources.AbstractConnectAction {
        public static final String GROUP = "Dbg2. Connection";

        public ConnectAction() {
            super(DebuggerTargetsProvider.this.plugin);
            this.setToolBarData(new ToolBarData(ICON, GROUP));
            this.setPopupMenuData(new MenuData(new String[]{"Connect"}, ICON, GROUP));
            DebuggerTargetsProvider.this.addLocalAction((DockingActionIf)this);
        }

        public void actionPerformed(ActionContext context) {
            ProgramManager programManager = (ProgramManager)DebuggerTargetsProvider.this.tool.getService(ProgramManager.class);
            Program program = programManager == null ? null : programManager.getCurrentProgram();
            DebuggerTargetsProvider.this.modelService.showConnectDialog(program);
        }

        public boolean isAddToPopup(ActionContext context) {
            return DebuggerTargetsProvider.getModelServiceFromContext((ActionContext)DebuggerTargetsProvider.this.myActionContext) != null;
        }

        public boolean isEnabledForContext(ActionContext context) {
            return DebuggerTargetsProvider.this.modelService != null;
        }
    }

    protected class DisconnectAction
    extends DebuggerResources.AbstractDisconnectAction {
        public static final String GROUP = "Dbg2. Connection";

        public DisconnectAction() {
            super(DebuggerTargetsProvider.this.plugin);
            this.setMenuBarData(new MenuData(new String[]{"Disconnect"}, ICON, GROUP));
            this.setPopupMenuData(new MenuData(new String[]{"Disconnect"}, ICON, GROUP));
            DebuggerTargetsProvider.this.addLocalAction((DockingActionIf)this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionContext context) {
            DebuggerObjectModel model = DebuggerTargetsProvider.getModelFromContext((ActionContext)DebuggerTargetsProvider.this.myActionContext);
            if (model == null) {
                return;
            }
            model.close().exceptionally(DebuggerResources.showError(DebuggerTargetsProvider.this.getComponent(), "Problem disconnecting"));
        }

        public boolean isAddToPopup(ActionContext context) {
            return DebuggerTargetsProvider.getModelFromContext((ActionContext)DebuggerTargetsProvider.this.myActionContext) != null;
        }

        public boolean isEnabledForContext(ActionContext context) {
            return DebuggerTargetsProvider.getModelFromContext((ActionContext)DebuggerTargetsProvider.this.myActionContext) != null;
        }
    }

    protected class FlushCachesAction
    extends DebuggerResources.AbstractFlushCachesAction {
        public static final String GROUP = "Dbg8. Maintenance";

        public FlushCachesAction() {
            super(DebuggerTargetsProvider.this.plugin);
            this.setPopupMenuData(new MenuData(new String[]{"Flush Caches"}, GROUP));
            DebuggerTargetsProvider.this.addLocalAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            DebuggerModelService service = DebuggerTargetsProvider.this.myActionContext.getIfModelService();
            if (service != null) {
                DebuggerTargetsProvider.this.clearServiceCaches(service);
                return;
            }
            DebuggerObjectModel model = DebuggerTargetsProvider.this.myActionContext.getIfDebuggerModel();
            if (model != null) {
                model.invalidateAllLocalCaches();
                return;
            }
        }

        public boolean isAddToPopup(ActionContext context) {
            if (DebuggerTargetsProvider.this.myActionContext.getIfModelService() != null) {
                return true;
            }
            return DebuggerTargetsProvider.this.myActionContext.getIfDebuggerModel() != null;
        }
    }
}

