/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.thread;

import docking.ComponentProvider;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.RangeCursorTableHeaderRenderer;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.threaded.ThreadedTableModelListener;
import ghidra.app.plugin.core.debug.gui.action.PCLocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.action.SPLocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.model.AbstractObjectsTableBasedPanel;
import ghidra.app.plugin.core.debug.gui.model.ModelQuery;
import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueKeyColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueLifePlotColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueObjectAttributeColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueObjectEditableAttributeColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueObjectPropertyColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueValColumn;
import ghidra.app.plugin.core.debug.gui.thread.DebuggerThreadsProvider;
import ghidra.app.plugin.core.debug.service.modules.DebuggerStaticMappingUtils;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathPredicates;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.thread.TraceObjectThread;
import java.util.List;
import java.util.Objects;
import javax.swing.event.ListSelectionEvent;

public class DebuggerThreadsPanel
extends AbstractObjectsTableBasedPanel<TraceObjectThread> {
    @AutoServiceConsumed
    protected DebuggerTraceManagerService traceManager;
    private final DebuggerThreadsProvider provider;
    private final RangeCursorTableHeaderRenderer.SeekListener seekListener = pos -> {
        long max;
        long snap = Math.round(pos);
        if (snap < 0L) {
            snap = 0L;
        }
        long l = max = this.current.getTrace() == null ? 0L : this.current.getTrace().getTimeManager().getMaxSnap();
        if (snap > max) {
            snap = max;
        }
        this.traceManager.activateSnap(snap);
    };

    protected static ModelQuery successorThreads(TargetObjectSchema rootSchema, List<String> path) {
        TargetObjectSchema schema = rootSchema.getSuccessorSchema(path);
        return new ModelQuery((PathPredicates)schema.searchFor(TargetThread.class, path, true));
    }

    DebuggerCoordinates coordsForObject(TraceObject object) {
        if (this.provider.current.getTrace() != object.getTrace()) {
            return DebuggerCoordinates.NOWHERE.object(object).frame(0);
        }
        return this.provider.current.object(object).frame(0);
    }

    DebuggerCoordinates diffCoordsForObject(TraceObject object) {
        if (((ObjectTableModel)this.tableModel).getDiffTrace() == null) {
            return DebuggerCoordinates.NOWHERE;
        }
        return DebuggerCoordinates.NOWHERE.trace(((ObjectTableModel)this.tableModel).getDiffTrace()).path(object.getCanonicalPath()).frame(0).snap(((ObjectTableModel)this.tableModel).getDiffSnap());
    }

    private Address computeProgramCounter(DebuggerCoordinates coords) {
        return PCLocationTrackingSpec.INSTANCE.computeTraceAddress((ServiceProvider)this.provider.getTool(), coords);
    }

    private Function computeFunction(DebuggerCoordinates coords, ServiceProvider serviceProvider) {
        Address pc = this.computeProgramCounter(coords);
        if (pc == null) {
            return null;
        }
        return DebuggerStaticMappingUtils.getFunction(pc, coords, serviceProvider);
    }

    private String computeModuleName(DebuggerCoordinates coords) {
        Address pc = this.computeProgramCounter(coords);
        if (pc == null) {
            return null;
        }
        return DebuggerStaticMappingUtils.getModuleName(pc, coords);
    }

    private Address computeStackPointer(DebuggerCoordinates coords) {
        return SPLocationTrackingSpec.INSTANCE.computeTraceAddress((ServiceProvider)this.provider.getTool(), coords);
    }

    public DebuggerThreadsPanel(DebuggerThreadsProvider provider) {
        super(provider.plugin, (ComponentProvider)provider, TraceObjectThread.class);
        this.provider = provider;
        this.setLimitToSnap(false);
        this.addSeekListener(this.seekListener);
        ((ObjectTableModel)this.tableModel).addThreadedTableModelListener(new ThreadedTableModelListener(){

            public void loadingStarted() {
            }

            public void loadingFinished(boolean wasCancelled) {
                DebuggerThreadsPanel.this.trySelectCurrentThread();
            }

            public void loadPending() {
            }
        });
    }

    @Override
    protected ObjectTableModel createModel() {
        return new ThreadTableModel(this.plugin);
    }

    @Override
    protected ModelQuery computeQuery(TraceObject object) {
        List seedPath;
        TargetObjectSchema rootSchema = object.getRoot().getTargetSchema();
        List processPath = rootSchema.searchForAncestor(TargetProcess.class, seedPath = object.getCanonicalPath().getKeyList());
        if (processPath != null) {
            return DebuggerThreadsPanel.successorThreads(rootSchema, processPath);
        }
        List containerPath = rootSchema.searchForSuitableContainer(TargetThread.class, seedPath);
        if (containerPath != null) {
            return DebuggerThreadsPanel.successorThreads(rootSchema, containerPath);
        }
        return DebuggerThreadsPanel.successorThreads(rootSchema, List.of());
    }

    private void trySelectCurrentThread() {
        TraceObject object = this.current.getObject();
        if (object == null) {
            return;
        }
        this.trySelectAncestor(object);
    }

    @Override
    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        super.coordinatesActivated(coordinates);
        this.trySelectCurrentThread();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.provider.threadsPanelContextChanged();
    }

    private class ThreadTableModel
    extends ObjectTableModel {
        protected ThreadTableModel(Plugin plugin) {
            super(plugin);
        }

        @Override
        protected TraceValueLifePlotColumn newPlotColumn() {
            return new ThreadPlotColumn();
        }

        @Override
        protected TableColumnDescriptor<ObjectTableModel.ValueRow> createTableColumnDescriptor() {
            TableColumnDescriptor descriptor = new TableColumnDescriptor();
            descriptor.addHiddenColumn((DynamicTableColumn)new ThreadPathColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new ThreadNameColumn(), 1, true);
            descriptor.addVisibleColumn((DynamicTableColumn)new ThreadPcColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new ThreadFunctionColumn());
            descriptor.addHiddenColumn((DynamicTableColumn)new ThreadModuleColumn());
            descriptor.addHiddenColumn((DynamicTableColumn)new ThreadSpColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new ThreadStateColumn());
            descriptor.addHiddenColumn((DynamicTableColumn)new ThreadCommentColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)this.getPlotColumn());
            return descriptor;
        }
    }

    private static class ThreadPlotColumn
    extends TraceValueLifePlotColumn {
        private ThreadPlotColumn() {
        }
    }

    private static class ThreadCommentColumn
    extends TraceValueObjectEditableAttributeColumn<String> {
        public ThreadCommentColumn() {
            super("_comment", String.class);
        }

        @Override
        public String getColumnName() {
            return "Comment";
        }
    }

    private static class ThreadStateColumn
    extends TraceValueObjectAttributeColumn<String> {
        public ThreadStateColumn() {
            super("_state", String.class);
        }

        @Override
        public String getColumnName() {
            return "State";
        }
    }

    private class ThreadSpColumn
    extends TraceValueObjectPropertyColumn<Address> {
        public ThreadSpColumn() {
            super(Address.class);
        }

        @Override
        public ObjectTableModel.ValueProperty<Address> getProperty(ObjectTableModel.ValueRow row) {
            TraceObject obj = row.getValue().getChild();
            final DebuggerCoordinates coords = DebuggerThreadsPanel.this.coordsForObject(obj);
            final DebuggerCoordinates diffCoords = DebuggerThreadsPanel.this.diffCoordsForObject(obj);
            return new ObjectTableModel.ValueAddressProperty(row){

                @Override
                public Address getValue() {
                    return DebuggerThreadsPanel.this.computeStackPointer(coords);
                }

                @Override
                public boolean isModified() {
                    return !Objects.equals(DebuggerThreadsPanel.this.computeStackPointer(coords), DebuggerThreadsPanel.this.computeStackPointer(diffCoords));
                }
            };
        }

        public String getColumnName() {
            return "SP";
        }
    }

    private class ThreadModuleColumn
    extends TraceValueObjectPropertyColumn<String> {
        public ThreadModuleColumn() {
            super(String.class);
        }

        @Override
        public ObjectTableModel.ValueProperty<String> getProperty(ObjectTableModel.ValueRow row) {
            TraceObject obj = row.getValue().getChild();
            final DebuggerCoordinates coords = DebuggerThreadsPanel.this.coordsForObject(obj);
            final DebuggerCoordinates diffCoords = DebuggerThreadsPanel.this.diffCoordsForObject(obj);
            return new ObjectTableModel.ValueDerivedProperty<String>(row, String.class){

                @Override
                public String getValue() {
                    return DebuggerThreadsPanel.this.computeModuleName(coords);
                }

                @Override
                public boolean isModified() {
                    return !Objects.equals(DebuggerThreadsPanel.this.computeModuleName(coords), DebuggerThreadsPanel.this.computeModuleName(diffCoords));
                }
            };
        }

        public String getColumnName() {
            return "Module";
        }
    }

    private class ThreadFunctionColumn
    extends TraceValueObjectPropertyColumn<Function> {
        public ThreadFunctionColumn() {
            super(Function.class);
        }

        @Override
        public ObjectTableModel.ValueProperty<Function> getProperty(ObjectTableModel.ValueRow row) {
            throw new AssertionError();
        }

        @Override
        public ObjectTableModel.ValueProperty<Function> getValue(ObjectTableModel.ValueRow row, Settings settings, Trace data, final ServiceProvider serviceProvider) {
            TraceObject obj = row.getValue().getChild();
            final DebuggerCoordinates coords = DebuggerThreadsPanel.this.coordsForObject(obj);
            final DebuggerCoordinates diffCoords = DebuggerThreadsPanel.this.diffCoordsForObject(obj);
            return new ObjectTableModel.ValueDerivedProperty<Function>(row, Function.class){

                @Override
                public Function getValue() {
                    return DebuggerThreadsPanel.this.computeFunction(coords, serviceProvider);
                }

                @Override
                public boolean isModified() {
                    return !Objects.equals(DebuggerThreadsPanel.this.computeFunction(coords, serviceProvider), DebuggerThreadsPanel.this.computeFunction(diffCoords, serviceProvider));
                }
            };
        }

        public String getColumnName() {
            return "Function";
        }
    }

    private class ThreadPcColumn
    extends TraceValueObjectPropertyColumn<Address> {
        public ThreadPcColumn() {
            super(Address.class);
        }

        @Override
        public ObjectTableModel.ValueProperty<Address> getProperty(ObjectTableModel.ValueRow row) {
            TraceObject obj = row.getValue().getChild();
            final DebuggerCoordinates coords = DebuggerThreadsPanel.this.coordsForObject(obj);
            final DebuggerCoordinates diffCoords = DebuggerThreadsPanel.this.diffCoordsForObject(obj);
            return new ObjectTableModel.ValueAddressProperty(row){

                @Override
                public Address getValue() {
                    return DebuggerThreadsPanel.this.computeProgramCounter(coords);
                }

                @Override
                public boolean isModified() {
                    return !Objects.equals(DebuggerThreadsPanel.this.computeProgramCounter(coords), DebuggerThreadsPanel.this.computeProgramCounter(diffCoords));
                }
            };
        }

        public String getColumnName() {
            return "PC";
        }
    }

    private static class ThreadNameColumn
    extends TraceValueValColumn {
        private ThreadNameColumn() {
        }

        @Override
        public String getColumnName() {
            return "Name";
        }
    }

    private static class ThreadPathColumn
    extends TraceValueKeyColumn {
        private ThreadPathColumn() {
        }

        @Override
        public String getColumnName() {
            return "Path";
        }

        @Override
        public String getValue(ObjectTableModel.ValueRow rowObject, Settings settings, Trace data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getValue().getCanonicalPath().toString();
        }
    }
}

