/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.thread;

import db.Transaction;
import ghidra.app.plugin.core.debug.gui.action.PCLocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.action.SPLocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.thread.DebuggerThreadsProvider;
import ghidra.app.plugin.core.debug.gui.thread.ThreadState;
import ghidra.app.plugin.core.debug.service.modules.DebuggerStaticMappingUtils;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;

public class ThreadRow {
    private final DebuggerThreadsProvider provider;
    private final TraceThread thread;

    public ThreadRow(DebuggerThreadsProvider provider, TraceThread thread) {
        this.provider = provider;
        this.thread = thread;
    }

    public TraceThread getThread() {
        return this.thread;
    }

    public Trace getTrace() {
        return this.thread.getTrace();
    }

    public void setName(String name) {
        try (Transaction tx = this.thread.getTrace().openTransaction("Rename thread");){
            this.thread.setName(name);
        }
    }

    public String getName() {
        return this.thread.getName();
    }

    private Address computeProgramCounter(DebuggerCoordinates coords) {
        return PCLocationTrackingSpec.INSTANCE.computeTraceAddress((ServiceProvider)this.provider.getTool(), coords);
    }

    public Address getProgramCounter() {
        DebuggerCoordinates coords = this.provider.current.thread(this.thread);
        return this.computeProgramCounter(coords);
    }

    public Function getFunction() {
        DebuggerCoordinates coords = this.provider.current.thread(this.thread);
        Address pc = this.computeProgramCounter(coords);
        return DebuggerStaticMappingUtils.getFunction(pc, coords, (ServiceProvider)this.provider.getTool());
    }

    public String getModule() {
        DebuggerCoordinates coords = this.provider.current.thread(this.thread);
        Address pc = this.computeProgramCounter(coords);
        return DebuggerStaticMappingUtils.getModuleName(pc, coords);
    }

    public Address getStackPointer() {
        DebuggerCoordinates coords = this.provider.current.thread(this.thread);
        return SPLocationTrackingSpec.INSTANCE.computeTraceAddress((ServiceProvider)this.provider.getTool(), coords);
    }

    public long getCreationSnap() {
        return this.thread.getCreationSnap();
    }

    public String getDestructionSnap() {
        long snap = this.thread.getDestructionSnap();
        return snap == Long.MAX_VALUE ? "" : Long.toString(snap);
    }

    public Lifespan getLifespan() {
        return this.thread.getLifespan();
    }

    public void setComment(String comment) {
        try (Transaction tx = this.thread.getTrace().openTransaction("Set thread comment");){
            this.thread.setComment(comment);
        }
    }

    public String getComment() {
        return this.thread.getComment();
    }

    public ThreadState getState() {
        if (!this.thread.isAlive()) {
            return ThreadState.TERMINATED;
        }
        if (this.provider.targetService == null) {
            return ThreadState.ALIVE;
        }
        Target target = this.provider.targetService.getTarget(this.thread.getTrace());
        if (target == null) {
            return ThreadState.ALIVE;
        }
        TargetExecutionStateful.TargetExecutionState state = target.getThreadExecutionState(this.thread);
        if (state == null) {
            return ThreadState.UNKNOWN;
        }
        switch (state) {
            case ALIVE: {
                return ThreadState.ALIVE;
            }
            case INACTIVE: {
                return ThreadState.UNKNOWN;
            }
            case RUNNING: {
                return ThreadState.RUNNING;
            }
            case STOPPED: {
                return ThreadState.STOPPED;
            }
            case TERMINATED: {
                return ThreadState.TERMINATED;
            }
        }
        throw new AssertionError();
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Error rendering as string: " + String.valueOf(e)));
            return "<ERROR>";
        }
    }
}

