/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.mapping;

import ghidra.app.plugin.core.debug.mapping.AbstractDebuggerPlatformMapper;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformOffer;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformOpinion;
import ghidra.debug.api.platform.DebuggerPlatformMapper;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import java.util.Set;

public class HostDebuggerPlatformOpinion
implements DebuggerPlatformOpinion {
    @Override
    public Set<DebuggerPlatformOffer> getOffers(Trace trace, TraceObject focus, long snap, boolean includeOverrides) {
        return Set.of(Offers.HOST);
    }

    static enum Offers implements DebuggerPlatformOffer
    {
        HOST{

            @Override
            public String getDescription() {
                return "Host/base (Language already chosen by target)";
            }

            @Override
            public int getConfidence() {
                return 1;
            }

            @Override
            public CompilerSpec getCompilerSpec() {
                return null;
            }

            @Override
            public DebuggerPlatformMapper take(PluginTool tool, Trace trace) {
                return new HostDebuggerPlatformMapper(tool, trace);
            }

            @Override
            public boolean isCreatorOf(DebuggerPlatformMapper mapper) {
                return mapper.getClass() == HostDebuggerPlatformMapper.class;
            }
        };

    }

    protected static class HostDebuggerPlatformMapper
    extends AbstractDebuggerPlatformMapper {
        public HostDebuggerPlatformMapper(PluginTool tool, Trace trace) {
            super(tool, trace);
        }

        public CompilerSpec getCompilerSpec(TraceObject object) {
            return this.trace.getBaseCompilerSpec();
        }

        public void addToTrace(long snap) {
        }

        @Override
        public boolean canInterpret(TraceObject newFocus, long snap) {
            return true;
        }
    }
}

