/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.mapping;

import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerRegisterMapper;
import ghidra.dbg.target.TargetRegister;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.dbg.util.ConversionUtils;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class LargestSubDebuggerRegisterMapper
extends DefaultDebuggerRegisterMapper {
    protected static final Comparator<Register> LENGTH_COMPARATOR = Comparator.comparing(Register::getBitLength);
    protected Map<String, Register> allLanguageRegs = new LinkedHashMap<String, Register>();
    protected Map<Register, TreeSet<Register>> present = new HashMap<Register, TreeSet<Register>>();

    public LargestSubDebuggerRegisterMapper(CompilerSpec cSpec, TargetRegisterContainer targetRegContainer, boolean caseSensitive) {
        super(cSpec, targetRegContainer, caseSensitive);
        for (Register lReg : cSpec.getLanguage().getRegisters()) {
            this.allLanguageRegs.put(this.normalizeName(lReg.getName()), lReg);
        }
    }

    @Override
    protected boolean includeTraceRegister(Register lReg) {
        return true;
    }

    @Override
    protected synchronized Register considerRegister(String index) {
        Register lReg = super.considerRegister(index);
        if (lReg == null) {
            return null;
        }
        this.present.computeIfAbsent(lReg.getBaseRegister(), r -> new TreeSet<Register>(LENGTH_COMPARATOR)).add(lReg);
        return lReg;
    }

    @Override
    protected synchronized Register considerRegister(TargetRegister tReg) {
        Register lReg = super.considerRegister(tReg);
        if (lReg == null) {
            return null;
        }
        this.present.computeIfAbsent(lReg.getBaseRegister(), r -> new TreeSet<Register>(LENGTH_COMPARATOR)).add(lReg);
        return lReg;
    }

    @Override
    protected synchronized Register removeRegister(TargetRegister tReg) {
        Register lReg = super.removeRegister(tReg);
        if (lReg == null) {
            return null;
        }
        Register lbReg = lReg.getBaseRegister();
        TreeSet<Register> set = this.present.get(lbReg);
        set.remove(lReg);
        if (set.isEmpty()) {
            this.present.remove(lbReg);
        }
        return lReg;
    }

    @Override
    public synchronized Register getTraceRegister(String name) {
        Register lReg = this.allLanguageRegs.get(this.normalizeName(name));
        if (lReg == null || !this.present.containsKey(lReg)) {
            return null;
        }
        return lReg;
    }

    public synchronized Map.Entry<String, byte[]> traceToTarget(RegisterValue registerValue) {
        Register lbReg = registerValue.getRegister();
        if (!lbReg.isBaseRegister()) {
            throw new IllegalArgumentException();
        }
        TreeSet<Register> subs = this.present.get(lbReg);
        if (subs == null) {
            return null;
        }
        Register lReg = subs.last();
        RegisterValue subValue = registerValue.getRegisterValue(lReg);
        TargetRegister tReg = (TargetRegister)this.targetRegs.get(this.normalizeName(lReg.getName()));
        if (tReg == null) {
            return null;
        }
        return Map.entry(tReg.getIndex(), ConversionUtils.bigIntegerToBytes((int)lReg.getMinimumByteSize(), (BigInteger)subValue.getUnsignedValue()));
    }

    @Override
    public synchronized TargetRegister traceToTarget(Register lbReg) {
        TreeSet<Register> subs = this.present.get(lbReg);
        if (subs == null) {
            return null;
        }
        Register lReg = subs.last();
        return super.traceToTarget(lReg);
    }

    public synchronized RegisterValue targetToTrace(String tRegName, byte[] value) {
        if (value == null) {
            return null;
        }
        Register lReg = (Register)this.languageRegs.get(this.normalizeName(tRegName));
        if (lReg == null && (lReg = this.considerRegister(tRegName)) == null) {
            return null;
        }
        Register lbReg = lReg.getBaseRegister();
        TreeSet<Register> subs = this.present.get(lbReg);
        if (subs == null) {
            return null;
        }
        if (lReg != subs.last()) {
            Msg.warn((Object)this, (Object)("Potential register cache aliasing: " + String.valueOf(lReg) + " vs " + String.valueOf(subs.last())));
            return null;
        }
        RegisterValue lbVal = new RegisterValue(lbReg, BigInteger.ZERO);
        return lbVal.assign(lReg, new BigInteger(1, value));
    }

    public RegisterValue targetToTrace(TargetRegister tReg, byte[] value) {
        return this.targetToTrace(tReg.getIndex(), value);
    }

    @Override
    public synchronized Register targetToTrace(TargetRegister tReg) {
        Register lReg = (Register)this.languageRegs.get(this.normalizeName(tReg.getIndex()));
        if (lReg == null) {
            return null;
        }
        Register lbReg = lReg.getBaseRegister();
        TreeSet<Register> subs = this.present.get(lbReg);
        if (subs == null) {
            return null;
        }
        if (lReg != subs.last()) {
            return null;
        }
        return lbReg;
    }

    @Override
    public synchronized Set<Register> getRegistersOnTarget() {
        return Set.copyOf(this.present.keySet());
    }
}

