/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.dbgeng;

import ghidra.app.plugin.core.debug.disassemble.DisassemblyInject;
import ghidra.app.plugin.core.debug.disassemble.DisassemblyInjectInfo;
import ghidra.app.plugin.core.debug.disassemble.TraceDisassembleCommand;
import ghidra.app.services.DebuggerTargetService;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemBufferByteProvider;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.OptionalHeader;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.debug.api.target.Target;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.DefaultProgramContext;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.util.ProgramContextImpl;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

@DisassemblyInjectInfo(platforms={@DisassemblyInjectInfo.PlatformInfo(langID="x86:LE:64:default", compilerID="windows"), @DisassemblyInjectInfo.PlatformInfo(langID="x86:LE:64:default", compilerID="clangwindows")})
public class DbgengX64DisassemblyInject
implements DisassemblyInject {
    @Override
    public void pre(PluginTool tool, TraceDisassembleCommand command, TracePlatform platform, long snap, TraceThread thread, AddressSetView startSet, AddressSetView restricted) {
        AddressRange first = startSet.getFirstRange();
        if (first == null) {
            return;
        }
        Trace trace = platform.getTrace();
        DebuggerTargetService targetService = (DebuggerTargetService)tool.getService(DebuggerTargetService.class);
        Target target = targetService == null ? null : targetService.getTarget(trace);
        Collection modules = trace.getModuleManager().getModulesAt(snap, first.getMinAddress());
        Msg.debug((Object)this, (Object)("Disassembling in modules: " + modules.stream().map(TraceModule::getName).collect(Collectors.joining(","))));
        Set modes = modules.stream().map(m -> this.modeForModule(target, trace, snap, (TraceModule)m)).filter(m -> m != Mode.UNK).collect(Collectors.toSet());
        Msg.debug((Object)this, (Object)("Disassembling in mode(s): " + String.valueOf(modes)));
        if (modes.size() != 1) {
            return;
        }
        Mode mode = (Mode)((Object)modes.iterator().next());
        Language language = platform.getLanguage();
        Register longModeReg = language.getRegister("longMode");
        Register addrsizeReg = language.getRegister("addrsize");
        Register opsizeReg = language.getRegister("opsize");
        ProgramContextImpl context = new ProgramContextImpl(language);
        language.applyContextSettings((DefaultProgramContext)context);
        RegisterValue ctxVal = context.getDisassemblyContext(first.getMinAddress());
        command.setInitialContext(switch (mode.ordinal()) {
            case 0 -> ctxVal.assign(longModeReg, BigInteger.ONE).assign(addrsizeReg, BigInteger.TWO).assign(opsizeReg, BigInteger.ONE);
            case 1 -> ctxVal.assign(longModeReg, BigInteger.ZERO).assign(addrsizeReg, BigInteger.ONE).assign(opsizeReg, BigInteger.ONE);
            default -> throw new AssertionError();
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Mode modeForModule(Target target, Trace trace, long snap, TraceModule module) {
        if (target != null && target.getSnap() == snap) {
            AddressSet set = new AddressSet();
            set.add(module.getBase(), module.getBase());
            try {
                target.readMemory((AddressSetView)set, TaskMonitor.DUMMY);
                trace.flushEvents();
            }
            catch (CancelledException e) {
                throw new AssertionError((Object)e);
            }
        }
        MemBuffer bufferAt = trace.getMemoryManager().getBufferAt(snap, module.getBase());
        try (MemBufferByteProvider bp = new MemBufferByteProvider(bufferAt);){
            PortableExecutable pe = new PortableExecutable((ByteProvider)bp, PortableExecutable.SectionLayout.MEMORY, false, false);
            NTHeader ntHeader = pe.getNTHeader();
            if (ntHeader == null) {
                Mode mode = Mode.UNK;
                return mode;
            }
            OptionalHeader optionalHeader = ntHeader.getOptionalHeader();
            if (optionalHeader == null) {
                Mode mode = Mode.UNK;
                return mode;
            }
            Mode mode = optionalHeader.is64bit() ? Mode.X64 : Mode.X86;
            return mode;
        }
        catch (IOException e) {
            Msg.warn((Object)this, (Object)("Could not parse PE from trace: " + String.valueOf(e)));
            return Mode.UNK;
        }
    }

    static enum Mode {
        X64,
        X86,
        UNK;

    }
}

