/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.control;

import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceOpenedPluginEvent;
import ghidra.app.services.DebuggerControlService;
import ghidra.app.services.DebuggerEmulationService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.debug.api.control.ControlMode;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.mem.LiveMemoryHandler;
import ghidra.program.model.mem.LiveMemoryListener;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.trace.model.Trace;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.program.TraceProgramViewMemory;
import ghidra.util.datastruct.ListenerSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@PluginInfo(shortDescription="Debugger control and machine-state editing service plugin", description="Centralizes control and machine-state editing across the tool", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceOpenedPluginEvent.class, TraceActivatedPluginEvent.class, TraceClosedPluginEvent.class}, servicesRequired={DebuggerTraceManagerService.class, DebuggerEmulationService.class}, servicesProvided={DebuggerControlService.class})
public class DebuggerControlServicePlugin
extends AbstractDebuggerPlugin
implements DebuggerControlService {
    private DebuggerTraceManagerService traceManager;
    protected final ListenerForEditorInstallation listenerForEditorInstallation = new ListenerForEditorInstallation();
    private final Map<Trace, ControlMode> currentModes = new HashMap<Trace, ControlMode>();
    private final ListenerSet<DebuggerControlService.ControlModeChangeListener> listeners = new ListenerSet(DebuggerControlService.ControlModeChangeListener.class, true);

    public DebuggerControlServicePlugin(PluginTool tool) {
        super(tool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControlMode getCurrentMode(Trace trace) {
        Map<Trace, ControlMode> map = this.currentModes;
        synchronized (map) {
            return this.currentModes.getOrDefault(Objects.requireNonNull(trace), ControlMode.DEFAULT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentMode(Trace trace, ControlMode newMode) {
        ControlMode oldMode;
        Map<Trace, ControlMode> map = this.currentModes;
        synchronized (map) {
            oldMode = this.currentModes.getOrDefault(Objects.requireNonNull(trace), ControlMode.DEFAULT);
            if (newMode != oldMode) {
                this.currentModes.put(trace, newMode);
            }
        }
        if (newMode != oldMode) {
            ((DebuggerControlService.ControlModeChangeListener)this.listeners.invoke()).modeChanged(trace, newMode);
            this.tool.contextChanged(null);
        }
    }

    public void addModeChangeListener(DebuggerControlService.ControlModeChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeModeChangeListener(DebuggerControlService.ControlModeChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public DebuggerControlService.StateEditor createStateEditor(DebuggerCoordinates coordinates) {
        return new DefaultStateEditor(coordinates);
    }

    public DebuggerControlService.StateEditor createStateEditor(Trace trace) {
        return new FollowsManagerStateEditor(trace);
    }

    public DebuggerControlService.StateEditingMemoryHandler createStateEditor(TraceProgramView view) {
        return new FollowsViewStateEditor(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void coordinatesActivated(DebuggerCoordinates coordinates, DebuggerTraceManagerService.ActivationCause cause) {
        ControlMode newMode;
        ControlMode oldMode;
        if (cause != DebuggerTraceManagerService.ActivationCause.USER) {
            return;
        }
        Trace trace = coordinates.getTrace();
        if (trace == null) {
            return;
        }
        Map<Trace, ControlMode> map = this.currentModes;
        synchronized (map) {
            oldMode = this.currentModes.getOrDefault(trace, ControlMode.DEFAULT);
            newMode = oldMode.modeOnChange(coordinates);
            if (newMode != oldMode) {
                this.currentModes.put(trace, newMode);
            }
        }
        if (newMode != oldMode) {
            ((DebuggerControlService.ControlModeChangeListener)this.listeners.invoke()).modeChanged(trace, newMode);
            this.tool.contextChanged(null);
        }
    }

    protected void installMemoryEditor(TraceProgramView view) {
        TraceProgramViewMemory memory = view.getMemory();
        if (memory.getLiveMemoryHandler() != null) {
            return;
        }
        memory.setLiveMemoryHandler((LiveMemoryHandler)this.createStateEditor(view));
    }

    protected void uninstallMemoryEditor(TraceProgramView view) {
        TraceProgramViewMemory memory = view.getMemory();
        LiveMemoryHandler handler = memory.getLiveMemoryHandler();
        if (!(handler instanceof DebuggerControlService.StateEditingMemoryHandler)) {
            return;
        }
        DebuggerControlService.StateEditingMemoryHandler editor = (DebuggerControlService.StateEditingMemoryHandler)handler;
        if (editor.getService() != this) {
            return;
        }
        memory.setLiveMemoryHandler(null);
    }

    protected void installAllMemoryEditors(Trace trace) {
        trace.addProgramViewListener((Trace.TraceProgramViewListener)this.listenerForEditorInstallation);
        for (TraceProgramView view : trace.getAllProgramViews()) {
            this.installMemoryEditor(view);
        }
    }

    protected void installAllMemoryEditors() {
        if (this.traceManager == null) {
            return;
        }
        for (Trace trace : this.traceManager.getOpenTraces()) {
            this.installAllMemoryEditors(trace);
        }
    }

    protected void uninstallAllMemoryEditors(Trace trace) {
        trace.removeProgramViewListener((Trace.TraceProgramViewListener)this.listenerForEditorInstallation);
        for (TraceProgramView view : trace.getAllProgramViews()) {
            this.uninstallMemoryEditor(view);
        }
    }

    protected void uninstallAllMemoryEditors() {
        if (this.traceManager == null) {
            return;
        }
        for (Trace trace : this.traceManager.getOpenTraces()) {
            this.uninstallAllMemoryEditors(trace);
        }
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof TraceOpenedPluginEvent) {
            TraceOpenedPluginEvent ev = (TraceOpenedPluginEvent)event;
            this.installAllMemoryEditors(ev.getTrace());
        } else if (event instanceof TraceActivatedPluginEvent) {
            TraceActivatedPluginEvent ev = (TraceActivatedPluginEvent)event;
            this.coordinatesActivated(ev.getActiveCoordinates(), ev.getCause());
        } else if (event instanceof TraceClosedPluginEvent) {
            TraceClosedPluginEvent ev = (TraceClosedPluginEvent)event;
            this.uninstallAllMemoryEditors(ev.getTrace());
        }
    }

    @AutoServiceConsumed
    private void setTraceManager(DebuggerTraceManagerService traceManager) {
        this.uninstallAllMemoryEditors();
        this.traceManager = traceManager;
        this.installAllMemoryEditors();
    }

    protected class ListenerForEditorInstallation
    implements Trace.TraceProgramViewListener {
        protected ListenerForEditorInstallation() {
        }

        public void viewCreated(TraceProgramView view) {
            DebuggerControlServicePlugin.this.installMemoryEditor(view);
        }
    }

    protected class DefaultStateEditor
    extends AbstractStateEditor {
        private final DebuggerCoordinates coordinates;

        public DefaultStateEditor(DebuggerCoordinates coordinates) {
            this.coordinates = Objects.requireNonNull(coordinates);
        }

        public DebuggerControlService getService() {
            return DebuggerControlServicePlugin.this;
        }

        public DebuggerCoordinates getCoordinates() {
            return this.coordinates;
        }
    }

    protected class FollowsManagerStateEditor
    extends AbstractStateEditor {
        private final Trace trace;

        public FollowsManagerStateEditor(Trace trace) {
            this.trace = trace;
        }

        public DebuggerControlService getService() {
            return DebuggerControlServicePlugin.this;
        }

        public DebuggerCoordinates getCoordinates() {
            if (!DebuggerControlServicePlugin.this.traceManager.getOpenTraces().contains(this.trace)) {
                throw new IllegalStateException("Trace " + String.valueOf(this.trace) + " is not opened in the trace manager.");
            }
            return DebuggerControlServicePlugin.this.traceManager.resolveTrace(this.trace);
        }
    }

    public class FollowsViewStateEditor
    extends AbstractStateEditor
    implements DebuggerControlService.StateEditingMemoryHandler {
        private final TraceProgramView view;

        public FollowsViewStateEditor(TraceProgramView view) {
            this.view = view;
        }

        public DebuggerControlService getService() {
            return DebuggerControlServicePlugin.this;
        }

        public DebuggerCoordinates getCoordinates() {
            return DebuggerControlServicePlugin.this.traceManager.resolveView(this.view);
        }

        public void clearCache() {
        }

        public byte getByte(Address addr) throws MemoryAccessException {
            ByteBuffer buf = ByteBuffer.allocate(1);
            this.view.getTrace().getMemoryManager().getViewBytes(this.view.getSnap(), addr, buf);
            return buf.get(0);
        }

        public int getBytes(Address address, byte[] buffer, int startIndex, int size) throws MemoryAccessException {
            return this.view.getTrace().getMemoryManager().getViewBytes(this.view.getSnap(), address, ByteBuffer.wrap(buffer, startIndex, size));
        }

        public void putByte(Address address, byte value) throws MemoryAccessException {
            try {
                this.setVariable(address, new byte[]{value}).get(1L, TimeUnit.SECONDS);
            }
            catch (ExecutionException e) {
                throw new MemoryAccessException("Failed to write " + String.valueOf(address) + ": " + String.valueOf(e.getCause()));
            }
            catch (InterruptedException | TimeoutException e) {
                throw new MemoryAccessException("Failed to write " + String.valueOf(address) + ": " + String.valueOf(e));
            }
        }

        public int putBytes(Address address, byte[] source, int startIndex, int size) throws MemoryAccessException {
            try {
                this.setVariable(address, Arrays.copyOfRange(source, startIndex, startIndex + size)).get(1L, TimeUnit.SECONDS);
            }
            catch (ExecutionException e) {
                throw new MemoryAccessException("Failed to write " + String.valueOf(address) + ": " + String.valueOf(e.getCause()));
            }
            catch (InterruptedException | TimeoutException e) {
                throw new MemoryAccessException("Failed to write " + String.valueOf(address) + ": " + String.valueOf(e));
            }
            return size;
        }

        public void addLiveMemoryListener(LiveMemoryListener listener) {
            throw new UnsupportedOperationException();
        }

        public void removeLiveMemoryListener(LiveMemoryListener listener) {
            throw new UnsupportedOperationException();
        }
    }

    protected abstract class AbstractStateEditor
    implements DebuggerControlService.StateEditor {
        protected AbstractStateEditor() {
        }

        public boolean isVariableEditable(Address address, int length) {
            DebuggerCoordinates coordinates = this.getCoordinates();
            Trace trace = coordinates.getTrace();
            return DebuggerControlServicePlugin.this.getCurrentMode(trace).isVariableEditable(coordinates, address, length);
        }

        public CompletableFuture<Void> setVariable(Address address, byte[] data) {
            DebuggerCoordinates coordinates = this.getCoordinates();
            Trace trace = coordinates.getTrace();
            return DebuggerControlServicePlugin.this.getCurrentMode(trace).setVariable(DebuggerControlServicePlugin.this.tool, coordinates, address, data);
        }
    }
}

