/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.service.model.DebuggerConnectDialog;
import ghidra.app.plugin.core.debug.service.model.DebuggerModelServiceInternal;
import ghidra.app.plugin.core.debug.service.model.DebuggerModelServiceProxyPlugin;
import ghidra.app.plugin.core.debug.service.model.DebuggerSelectMappingOfferDialog;
import ghidra.app.plugin.core.debug.service.model.launch.DebuggerProgramLaunchOpinion;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.async.AsyncFence;
import ghidra.dbg.AnnotatedDebuggerAttributeListener;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.util.PathUtils;
import ghidra.debug.api.action.ActionSource;
import ghidra.debug.api.model.DebuggerMappingOffer;
import ghidra.debug.api.model.DebuggerMappingOpinion;
import ghidra.debug.api.model.DebuggerProgramLaunchOffer;
import ghidra.debug.api.model.DebuggerTargetTraceMapper;
import ghidra.debug.api.model.TraceRecorder;
import ghidra.debug.api.model.TraceRecorderListener;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.ApplicationLevelOnlyPlugin;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.lifecycle.Internal;
import ghidra.program.model.listing.Program;
import ghidra.trace.database.DBTrace;
import ghidra.trace.model.Trace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;
import ghidra.util.TimedMsg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.datastruct.CollectionChangeListener;
import ghidra.util.datastruct.ListenerSet;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.CharBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdom.Element;

@PluginInfo(shortDescription="Debugger models manager service", description="Manage debug sessions, connections, and trace recording", category="Debugger", packageName="Debugger", status=PluginStatus.HIDDEN, servicesRequired={}, servicesProvided={DebuggerModelService.class})
public class DebuggerModelServicePlugin
extends Plugin
implements DebuggerModelServiceInternal,
ApplicationLevelOnlyPlugin {
    private static final String PREFIX_FACTORY = "Factory_";
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd-HH.mm.ss-z");
    protected final Set<DebuggerModelServiceProxyPlugin> proxies = new HashSet<DebuggerModelServiceProxyPlugin>();
    protected final Set<DebuggerModelFactory> factories = new HashSet<DebuggerModelFactory>();
    protected final Set<DebuggerObjectModel> models = new LinkedHashSet<DebuggerObjectModel>();
    protected final ForRemovalAndFocusListener forRemovalAndFocusListener = new ForRemovalAndFocusListener();
    protected final Map<TargetObject, TraceRecorder> recordersByTarget = new WeakHashMap<TargetObject, TraceRecorder>();
    protected final ListenerSet<CollectionChangeListener<DebuggerModelFactory>> factoryListeners = new ListenerSet(CollectionChangeListener.of(DebuggerModelFactory.class), true);
    protected final ListenerSet<CollectionChangeListener<DebuggerObjectModel>> modelListeners = new ListenerSet(CollectionChangeListener.of(DebuggerObjectModel.class), true);
    protected final ListenerSet<CollectionChangeListener<TraceRecorder>> recorderListeners = new ListenerSet(CollectionChangeListener.of(TraceRecorder.class), true);
    protected final ChangeListener classChangeListener = new ChangeListenerForFactoryInstances();
    protected final ListenerOnRecorders listenerOnRecorders = new ListenerOnRecorders();
    protected final DebuggerSelectMappingOfferDialog offerDialog;
    protected final DebuggerConnectDialog connectDialog = new DebuggerConnectDialog();
    DockingAction actionDisconnectAll;
    protected DebuggerObjectModel currentModel;

    public DebuggerModelServicePlugin(PluginTool tool) {
        super(tool);
        this.offerDialog = new DebuggerSelectMappingOfferDialog(tool);
        ClassSearcher.addChangeListener((ChangeListener)this.classChangeListener);
        this.refreshFactoryInstances();
        this.connectDialog.setModelService(this);
    }

    protected void init() {
        super.init();
        this.createActions();
    }

    protected void dispose() {
        super.dispose();
        this.connectDialog.dispose();
        this.offerDialog.dispose();
    }

    protected void createActions() {
        this.actionDisconnectAll = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)DebuggerResources.DisconnectAllAction.builder(this, this).menuPath(new String[]{"Debugger", "Disconnect All"})).menuIcon(null)).onAction(this::activatedDisconnectAll)).buildAndInstall((Tool)this.tool);
    }

    private void activatedDisconnectAll(ActionContext context) {
        this.closeAllModels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addProxy(DebuggerModelServiceProxyPlugin proxy) {
        Set<DebuggerModelServiceProxyPlugin> set = this.proxies;
        synchronized (set) {
            this.proxies.add(proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeProxy(DebuggerModelServiceProxyPlugin proxy) {
        Set<DebuggerModelServiceProxyPlugin> set = this.proxies;
        synchronized (set) {
            this.proxies.remove(proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DebuggerModelFactory> getModelFactories() {
        Set<DebuggerModelFactory> set = this.factories;
        synchronized (set) {
            return Set.copyOf(this.factories);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DebuggerObjectModel> getModels() {
        Set<DebuggerObjectModel> set = this.models;
        synchronized (set) {
            return Set.copyOf(this.models);
        }
    }

    public CompletableFuture<Void> closeAllModels() {
        AsyncFence fence = new AsyncFence();
        for (DebuggerObjectModel model : this.getModels()) {
            fence.include((CompletableFuture)model.close().exceptionally(DebuggerResources.showError(null, "Problem disconnecting")));
        }
        return fence.ready();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TraceRecorder> getTraceRecorders() {
        Map<TargetObject, TraceRecorder> map = this.recordersByTarget;
        synchronized (map) {
            return List.copyOf(this.recordersByTarget.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addModel(DebuggerObjectModel model) {
        Objects.requireNonNull(model);
        Set<DebuggerObjectModel> set = this.models;
        synchronized (set) {
            if (!this.models.add(model)) {
                return false;
            }
            model.addModelListener((DebuggerModelListener)this.forRemovalAndFocusListener);
            TargetObject root = model.getModelRoot();
            if (root != null && !root.isValid()) {
                this.forRemovalAndFocusListener.invalidated(root, root, "Invalidated before or during add to service");
            }
        }
        ((CollectionChangeListener)this.modelListeners.invoke()).elementAdded((Object)model);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeModel(DebuggerObjectModel model) {
        model.removeModelListener((DebuggerModelListener)this.forRemovalAndFocusListener);
        Set<DebuggerObjectModel> set = this.models;
        synchronized (set) {
            if (!this.models.remove(model)) {
                return false;
            }
        }
        ((CollectionChangeListener)this.modelListeners.invoke()).elementRemoved((Object)model);
        return true;
    }

    @Override
    public void fireFocusEvent(TargetObject focused) {
    }

    @Override
    public void fireSnapEvent(TraceRecorder recorder, long snap) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraceRecorder recordTarget(TargetObject target, DebuggerTargetTraceMapper mapper, ActionSource source) throws IOException {
        TraceRecorder recorder;
        Map<TargetObject, TraceRecorder> map = this.recordersByTarget;
        synchronized (map) {
            recorder = this.recordersByTarget.get(target);
            if (recorder != null) {
                Msg.warn((Object)this, (Object)("Target is already being recorded: " + String.valueOf(target)));
                return recorder;
            }
            recorder = this.doBeginRecording(target, mapper);
            recorder.addListener((TraceRecorderListener)this.listenerOnRecorders);
            recorder.init().exceptionally(e -> {
                if (source == ActionSource.MANUAL) {
                    Msg.showError((Object)this, null, (String)"Record Trace", (Object)"Error initializing recorder", (Throwable)e);
                } else {
                    Msg.error((Object)this, (Object)"Error initializing recorder", (Throwable)e);
                }
                return null;
            });
            this.recordersByTarget.put(target, recorder);
        }
        ((CollectionChangeListener)this.recorderListeners.invoke()).elementAdded((Object)recorder);
        if (!recorder.isRecording()) {
            this.doRemoveRecorder(recorder);
        }
        return recorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraceRecorder recordTargetBestOffer(TargetObject target) {
        Map<TargetObject, TraceRecorder> map = this.recordersByTarget;
        synchronized (map) {
            TraceRecorder recorder = this.recordersByTarget.get(target);
            if (recorder != null) {
                Msg.warn((Object)this, (Object)("Target is already being recorded: " + String.valueOf(target)));
                return recorder;
            }
        }
        DebuggerTargetTraceMapper mapper = DebuggerMappingOffer.first((Collection)DebuggerMappingOpinion.queryOpinions((TargetObject)target, (boolean)false));
        if (mapper == null) {
            throw new NoSuchElementException("No mapper for target: " + String.valueOf(target));
        }
        try {
            return this.recordTarget(target, mapper, ActionSource.AUTOMATIC);
        }
        catch (IOException e) {
            throw new AssertionError("Could not record target: " + String.valueOf(target), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    protected TraceRecorder doRecordTargetPromptOffers(PluginTool t, TargetObject target) {
        Map<TargetObject, TraceRecorder> map = this.recordersByTarget;
        synchronized (map) {
            TraceRecorder recorder = this.recordersByTarget.get(target);
            if (recorder != null) {
                Msg.warn((Object)this, (Object)("Target is already being recorded: " + String.valueOf(target)));
                return recorder;
            }
        }
        List offers = DebuggerMappingOpinion.queryOpinions((TargetObject)target, (boolean)true);
        this.offerDialog.setOffers(offers);
        t.showDialog((DialogComponentProvider)this.offerDialog);
        if (this.offerDialog.isCancelled()) {
            return null;
        }
        DebuggerMappingOffer selected = this.offerDialog.getSelectedOffer();
        assert (selected != null);
        DebuggerTargetTraceMapper mapper = selected.take();
        try {
            return this.recordTarget(target, mapper, ActionSource.MANUAL);
        }
        catch (IOException e) {
            throw new AssertionError("Could not record target: " + String.valueOf(target), e);
        }
    }

    public TraceRecorder recordTargetPromptOffers(TargetObject target) {
        return this.doRecordTargetPromptOffers(this.tool, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRecorder(TraceRecorder recorder) {
        Map<TargetObject, TraceRecorder> map = this.recordersByTarget;
        synchronized (map) {
            TraceRecorder old = this.recordersByTarget.remove(recorder.getTarget());
            if (old != null) {
                if (old != recorder) {
                    throw new AssertionError((Object)"Container-recorder mix up");
                }
                old.removeListener((TraceRecorderListener)this.listenerOnRecorders);
            }
        }
        ((CollectionChangeListener)this.recorderListeners.invoke()).elementRemoved((Object)recorder);
    }

    public synchronized DebuggerObjectModel getCurrentModel() {
        if (!this.currentModel.isAlive()) {
            this.currentModel = null;
        }
        return this.currentModel;
    }

    @Override
    public synchronized boolean doActivateModel(DebuggerObjectModel model) {
        if (model == this.currentModel) {
            return false;
        }
        this.currentModel = model;
        return true;
    }

    @Override
    @Internal
    public void refreshFactoryInstances() {
        List newFactories = ClassSearcher.getInstances(DebuggerModelFactory.class);
        this.setModelFactories(newFactories);
    }

    @Override
    @Internal
    public synchronized void setModelFactories(Collection<DebuggerModelFactory> newFactories) {
        HashSet<DebuggerModelFactory> diff = new HashSet<DebuggerModelFactory>();
        diff.addAll(this.factories);
        diff.removeAll(newFactories);
        for (DebuggerModelFactory factory : diff) {
            this.factories.remove(factory);
            ((CollectionChangeListener)this.factoryListeners.invoke()).elementRemoved((Object)factory);
        }
        diff.clear();
        diff.addAll(newFactories);
        diff.removeAll(this.factories);
        for (DebuggerModelFactory factory : diff) {
            this.factories.add(factory);
            ((CollectionChangeListener)this.factoryListeners.invoke()).elementAdded((Object)factory);
        }
    }

    public void addFactoriesChangedListener(CollectionChangeListener<DebuggerModelFactory> listener) {
        this.factoryListeners.add(listener);
    }

    public void removeFactoriesChangedListener(CollectionChangeListener<DebuggerModelFactory> listener) {
        this.factoryListeners.remove(listener);
    }

    public synchronized void addModelsChangedListener(CollectionChangeListener<DebuggerObjectModel> listener) {
        this.modelListeners.add(listener);
    }

    public synchronized void removeModelsChangedListener(CollectionChangeListener<DebuggerObjectModel> listener) {
        this.modelListeners.remove(listener);
    }

    public synchronized void addTraceRecordersChangedListener(CollectionChangeListener<TraceRecorder> listener) {
        this.recorderListeners.add(listener);
    }

    public synchronized void removeTraceRecordersChangedListener(CollectionChangeListener<TraceRecorder> listener) {
        this.recorderListeners.remove(listener);
    }

    @Override
    public TraceRecorder recordTargetAndActivateTrace(TargetObject target, DebuggerTargetTraceMapper mapper, DebuggerTraceManagerService traceManager) throws IOException {
        TraceRecorder recorder = this.recordTarget(target, mapper, ActionSource.AUTOMATIC);
        if (traceManager != null) {
            Trace trace = recorder.getTrace();
            traceManager.openTrace(trace);
            traceManager.activate(traceManager.resolveTrace(trace), DebuggerTraceManagerService.ActivationCause.ACTIVATE_DEFAULT);
        }
        return recorder;
    }

    public TraceRecorder recordTargetAndActivateTrace(TargetObject target, DebuggerTargetTraceMapper mapper) throws IOException {
        return this.recordTargetAndActivateTrace(target, mapper, null);
    }

    protected TraceRecorder doBeginRecording(TargetObject target, DebuggerTargetTraceMapper mapper) throws IOException {
        String traceName = DebuggerModelServicePlugin.nameTrace(target);
        DBTrace trace = new DBTrace(traceName, mapper.getTraceCompilerSpec(), (Object)this);
        TraceRecorder recorder = mapper.startRecording(this.tool, (Trace)trace);
        trace.release((Object)this);
        return recorder;
    }

    protected static String nameTrace(TargetObject target) {
        String name = target.getDisplay();
        if (name == null) {
            name = PathUtils.toString((List)target.getPath());
        }
        CharBuffer buf = CharBuffer.wrap(name.toCharArray());
        for (int i = 0; i < buf.length(); ++i) {
            if (LocalFileSystem.isValidNameCharacter((char)buf.get(i))) continue;
            buf.put(i, '_');
        }
        return AppInfo.getActiveProject().getProjectData().makeValidName(String.valueOf(buf) + " " + DATE_FORMAT.format(new Date()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemoveRecorder(TraceRecorder recorder) {
        boolean removed;
        Map<TargetObject, TraceRecorder> map = this.recordersByTarget;
        synchronized (map) {
            removed = this.recordersByTarget.remove(recorder.getTarget()) != null;
        }
        if (removed) {
            ((CollectionChangeListener)this.recorderListeners.invoke()).elementRemoved((Object)recorder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraceRecorder getRecorder(TargetObject target) {
        Map<TargetObject, TraceRecorder> map = this.recordersByTarget;
        synchronized (map) {
            return this.recordersByTarget.get(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraceRecorder getRecorderForSuccessor(TargetObject successor) {
        Map<TargetObject, TraceRecorder> map = this.recordersByTarget;
        synchronized (map) {
            while (successor != null) {
                TraceRecorder recorder = this.recordersByTarget.get(successor);
                if (recorder != null) {
                    return recorder;
                }
                successor = successor.getParent();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraceRecorder getRecorder(Trace trace) {
        Map<TargetObject, TraceRecorder> map = this.recordersByTarget;
        synchronized (map) {
            for (TraceRecorder recorder : this.recordersByTarget.values()) {
                if (recorder.getTrace() != trace) continue;
                return recorder;
            }
            return null;
        }
    }

    public TargetThread getTargetThread(TraceThread thread) {
        TraceRecorder recorder = this.getRecorder(thread.getTrace());
        if (recorder == null) {
            return null;
        }
        return recorder.getTargetThread(thread);
    }

    public TargetObject getTarget(Trace trace) {
        TraceRecorder recorder = this.getRecorder(trace);
        if (recorder == null) {
            return null;
        }
        return recorder.getTarget();
    }

    public Trace getTrace(TargetObject target) {
        TraceRecorder recorder = this.getRecorder(target);
        if (recorder == null) {
            return null;
        }
        return recorder.getTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraceThread getTraceThread(TargetThread thread) {
        Map<TargetObject, TraceRecorder> map = this.recordersByTarget;
        synchronized (map) {
            for (TraceRecorder recorder : this.recordersByTarget.values()) {
                if (!PathUtils.isAncestor((List)recorder.getTarget().getPath(), (List)thread.getPath())) continue;
                return recorder.getTraceThread(thread);
            }
        }
        return null;
    }

    public TraceThread getTraceThread(TargetObject target, TargetThread thread) {
        TraceRecorder recorder = this.getRecorder(target);
        if (recorder == null) {
            return null;
        }
        return recorder.getTraceThread(thread);
    }

    public TargetObject getTargetFocus(TargetObject target) {
        TraceRecorder recorder = this.getRecorder(target);
        if (recorder == null) {
            return null;
        }
        return recorder.getFocus();
    }

    public void writeConfigState(SaveState saveState) {
        for (DebuggerModelFactory factory : this.getModelFactories()) {
            String stateName = PREFIX_FACTORY + factory.getClass().getName();
            SaveState factoryState = new SaveState();
            factory.writeConfigState(factoryState);
            saveState.putXmlElement(stateName, factoryState.saveToXml());
        }
        this.connectDialog.writeConfigState(saveState);
    }

    public void readConfigState(SaveState saveState) {
        for (DebuggerModelFactory factory : this.getModelFactories()) {
            String stateName = PREFIX_FACTORY + factory.getClass().getName();
            Element factoryElement = saveState.getXmlElement(stateName);
            if (factoryElement == null) continue;
            SaveState factoryState = new SaveState(factoryElement);
            factory.readConfigState(factoryState);
        }
        this.connectDialog.readConfigState(saveState);
    }

    protected Stream<DebuggerProgramLaunchOffer> doGetProgramLaunchOffers(PluginTool tool, Program program) {
        return ClassSearcher.getInstances(DebuggerProgramLaunchOpinion.class).stream().flatMap(opinion -> opinion.getOffers(program, tool, this).stream());
    }

    public Stream<DebuggerProgramLaunchOffer> getProgramLaunchOffers(Program program) {
        return this.doGetProgramLaunchOffers(this.tool, program);
    }

    protected CompletableFuture<DebuggerObjectModel> doShowConnectDialog(PluginTool tool, DebuggerModelFactory factory, Program program) {
        CompletableFuture<DebuggerObjectModel> future = this.connectDialog.reset(factory, program);
        tool.showDialog((DialogComponentProvider)this.connectDialog);
        return future;
    }

    public CompletableFuture<DebuggerObjectModel> showConnectDialog() {
        return this.doShowConnectDialog(this.tool, null, null);
    }

    public CompletableFuture<DebuggerObjectModel> showConnectDialog(Program program) {
        return this.doShowConnectDialog(this.tool, null, program);
    }

    public CompletableFuture<DebuggerObjectModel> showConnectDialog(DebuggerModelFactory factory) {
        return this.doShowConnectDialog(this.tool, factory, null);
    }

    protected class ForRemovalAndFocusListener
    extends AnnotatedDebuggerAttributeListener {
        public ForRemovalAndFocusListener() {
            super(MethodHandles.lookup());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidated(TargetObject object, TargetObject branch, String reason) {
            if (!object.isRoot()) {
                return;
            }
            DebuggerObjectModel model = object.getModel();
            Set<DebuggerObjectModel> set = DebuggerModelServicePlugin.this.models;
            synchronized (set) {
                DebuggerModelServicePlugin.this.models.remove(model);
            }
            model.removeModelListener((DebuggerModelListener)this);
            ((CollectionChangeListener)DebuggerModelServicePlugin.this.modelListeners.invoke()).elementRemoved((Object)model);
            if (DebuggerModelServicePlugin.this.currentModel == model) {
                DebuggerModelServicePlugin.this.activateModel(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_focus")
        public void focusChanged(TargetObject object, TargetObject focused) {
            List<DebuggerModelServiceProxyPlugin> copy;
            DebuggerModelServicePlugin.this.fireFocusEvent(focused);
            Set<DebuggerModelServiceProxyPlugin> set = DebuggerModelServicePlugin.this.proxies;
            synchronized (set) {
                copy = List.copyOf(DebuggerModelServicePlugin.this.proxies);
            }
            for (DebuggerModelServiceProxyPlugin proxy : copy) {
                proxy.fireFocusEvent(focused);
            }
        }
    }

    protected class ChangeListenerForFactoryInstances
    implements ChangeListener {
        protected ChangeListenerForFactoryInstances() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            DebuggerModelServicePlugin.this.refreshFactoryInstances();
        }
    }

    protected class ListenerOnRecorders
    implements TraceRecorderListener {
        protected ListenerOnRecorders() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void snapAdvanced(TraceRecorder recorder, long snap) {
            List<DebuggerModelServiceProxyPlugin> copy;
            TimedMsg.debug((Object)this, (String)"Got snapAdvanced callback");
            DebuggerModelServicePlugin.this.fireSnapEvent(recorder, snap);
            Set<DebuggerModelServiceProxyPlugin> set = DebuggerModelServicePlugin.this.proxies;
            synchronized (set) {
                copy = List.copyOf(DebuggerModelServicePlugin.this.proxies);
            }
            for (DebuggerModelServiceProxyPlugin proxy : copy) {
                TimedMsg.debug((Object)this, (String)("Firing SnapEvent on " + String.valueOf(proxy)));
                proxy.fireSnapEvent(recorder, snap);
            }
        }

        public void recordingStopped(TraceRecorder recorder) {
            DebuggerModelServicePlugin.this.removeRecorder(recorder);
        }
    }
}

