/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import docking.ReusableDialogComponentProvider;
import docking.widgets.table.ColumnSortState;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.RowObjectFilterModel;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.TableFilter;
import ghidra.debug.api.model.DebuggerMappingOffer;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.Processor;
import ghidra.program.util.DefaultLanguageService;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class DebuggerSelectMappingOfferDialog
extends ReusableDialogComponentProvider {
    private final OfferPanel offerPanel;
    private boolean isCancelled = false;

    protected DebuggerSelectMappingOfferDialog(PluginTool tool) {
        super("Record", true, false, true, false);
        this.offerPanel = new OfferPanel(tool);
        this.populateComponents();
    }

    protected void populateComponents() {
        this.offerPanel.setBorder(BorderFactory.createTitledBorder(" Select Target Recorder Mapper "));
        this.addWorkPanel(this.offerPanel);
        this.addOKButton();
        this.addCancelButton();
        this.setDefaultButton(this.okButton);
        this.setOkEnabled(false);
        this.offerPanel.offerTable.getSelectionModel().addListSelectionListener(e -> this.setOkEnabled(this.getSelectedOffer() != null));
    }

    public void setPreferredIDs(LanguageID langID, CompilerSpecID csID) {
        this.offerPanel.setPreferredIDs(langID, csID);
    }

    public void setOffers(Collection<DebuggerMappingOffer> offers) {
        this.offerPanel.setOffers(offers);
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setSelectedOffer(DebuggerMappingOffer offer) {
        this.offerPanel.setSelectedOffer(offer);
    }

    public DebuggerMappingOffer getSelectedOffer() {
        return this.offerPanel.getSelectedOffer();
    }

    protected List<DebuggerMappingOffer> getDisplayedOffers() {
        return this.offerPanel.getDisplayedOffers();
    }

    protected void setFilterRecommended(boolean recommendedOnly) {
        this.offerPanel.setFilterRecommended(recommendedOnly);
    }

    protected void cancelCallback() {
        this.isCancelled = true;
        super.cancelCallback();
    }

    protected void okCallback() {
        if (this.getSelectedOffer() != null) {
            this.isCancelled = false;
            this.close();
        }
    }

    public static class OfferPanel
    extends JPanel {
        private final OfferTableModel offerTableModel;
        private final GhidraTable offerTable;
        private final GhidraTableFilterPanel<DebuggerMappingOffer> offerTableFilterPanel;
        private final JLabel descLabel = new JLabel();
        private final JCheckBox overrideCheckBox = new JCheckBox("Show Only Recommended Offers");
        private final JScrollPane scrollPane = new JScrollPane(){

            @Override
            public Dimension getPreferredSize() {
                Dimension pref = super.getPreferredSize();
                if (pref.width != 0) {
                    pref.height = 150;
                }
                return pref;
            }
        };
        private final TableFilter<DebuggerMappingOffer> filterRecommended = new TableFilter<DebuggerMappingOffer>(this){

            public boolean acceptsRow(DebuggerMappingOffer offer) {
                return !offer.isOverride();
            }

            public boolean isSubFilterOf(TableFilter<?> tableFilter) {
                return false;
            }
        };
        private LanguageID preferredLangID;
        private CompilerSpecID preferredCsID;

        protected OfferPanel(PluginTool tool) {
            this.offerTableModel = new OfferTableModel(tool);
            this.offerTable = new GhidraTable((TableModel)((Object)this.offerTableModel));
            this.offerTableFilterPanel = new GhidraTableFilterPanel((JTable)this.offerTable, (RowObjectTableModel)this.offerTableModel);
            this.scrollPane.setViewportView((Component)this.offerTable);
            JPanel descPanel = new JPanel(new BorderLayout());
            descPanel.setBorder(BorderFactory.createTitledBorder("Description"));
            descPanel.add((Component)this.descLabel, "Center");
            JPanel nested1 = new JPanel(new BorderLayout());
            nested1.add((Component)this.scrollPane, "Center");
            nested1.add((Component)this.offerTableFilterPanel, "South");
            JPanel nested2 = new JPanel(new BorderLayout());
            nested2.add((Component)nested1, "Center");
            nested2.add((Component)descPanel, "South");
            this.setLayout(new BorderLayout());
            this.add((Component)nested2, "Center");
            this.add((Component)this.overrideCheckBox, "South");
            this.setFilterRecommended(true);
            this.offerTable.getSelectionModel().addListSelectionListener(e -> {
                DebuggerMappingOffer offer = this.getSelectedOffer();
                this.descLabel.setText(offer == null ? "" : offer.getDescription());
            });
            this.overrideCheckBox.addActionListener(evt -> this.setFilterRecommended(this.overrideCheckBox.isSelected()));
        }

        public void setPreferredIDs(LanguageID langID, CompilerSpecID csID) {
            this.preferredLangID = langID;
            this.preferredCsID = csID;
        }

        public void setOffers(Collection<DebuggerMappingOffer> offers) {
            this.offerTableModel.clear();
            this.offerTableModel.addAll(offers);
            this.selectPreferred();
        }

        private void selectPreferred() {
            RowObjectFilterModel model = this.offerTableFilterPanel.getTableFilterModel();
            int count = model.getRowCount();
            if (this.preferredLangID != null && this.preferredCsID != null) {
                for (int i = 0; i < count; ++i) {
                    DebuggerMappingOffer offer = (DebuggerMappingOffer)model.getRowObject(i);
                    if (!offer.getTraceLanguageID().equals((Object)this.preferredLangID) || !offer.getTraceCompilerSpecID().equals((Object)this.preferredCsID)) continue;
                    this.offerTable.getSelectionModel().setSelectionInterval(i, i);
                    return;
                }
            }
            if (model.getRowCount() > 0) {
                this.offerTable.getSelectionModel().setSelectionInterval(0, 0);
            }
        }

        public void setFilterRecommended(boolean recommendedOnly) {
            boolean hasSelection = this.offerTableFilterPanel.getSelectedItem() != null;
            this.overrideCheckBox.setSelected(recommendedOnly);
            this.offerTableFilterPanel.setSecondaryFilter(recommendedOnly ? this.filterRecommended : null);
            if (!hasSelection) {
                this.selectPreferred();
            }
        }

        public void setSelectedOffer(DebuggerMappingOffer offer) {
            this.offerTableFilterPanel.setSelectedItem((Object)offer);
        }

        public DebuggerMappingOffer getSelectedOffer() {
            return (DebuggerMappingOffer)this.offerTableFilterPanel.getSelectedItem();
        }

        public List<DebuggerMappingOffer> getDisplayedOffers() {
            return List.copyOf(this.offerTableFilterPanel.getTableFilterModel().getModelData());
        }
    }

    public static class OfferTableModel
    extends DefaultEnumeratedColumnTableModel<OfferTableColumns, DebuggerMappingOffer> {
        public OfferTableModel(PluginTool tool) {
            super(tool, "Offers", OfferTableColumns.class);
        }

        public List<OfferTableColumns> defaultSortOrder() {
            return List.of(OfferTableColumns.CONFIDENCE, OfferTableColumns.PROCESSOR, OfferTableColumns.VARIANT, OfferTableColumns.COMPILER);
        }
    }

    protected static enum OfferTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<OfferTableColumns, DebuggerMappingOffer>
    {
        CONFIDENCE("Confidence", Integer.class, DebuggerMappingOffer::getConfidence, ColumnSortState.SortDirection.DESCENDING),
        PROCESSOR("Processor", Processor.class, OfferTableColumns::getProcessor),
        VARIANT("Variant", String.class, OfferTableColumns::getVariant),
        SIZE("Size", Integer.class, OfferTableColumns::getSize),
        ENDIAN("Endian", Endian.class, OfferTableColumns::getEndian),
        COMPILER("Compiler", CompilerSpecID.class, DebuggerMappingOffer::getTraceCompilerSpecID);

        private static final LanguageService LANG_SERV;
        private final String header;
        private final Class<?> cls;
        private final Function<DebuggerMappingOffer, ?> getter;
        private final ColumnSortState.SortDirection sortDir;

        private static Processor getProcessor(DebuggerMappingOffer offer) {
            try {
                return LANG_SERV.getLanguageDescription(offer.getTraceLanguageID()).getProcessor();
            }
            catch (LanguageNotFoundException e) {
                return Processor.findOrPossiblyCreateProcessor((String)"Not Found");
            }
        }

        private static String getVariant(DebuggerMappingOffer offer) {
            try {
                return LANG_SERV.getLanguageDescription(offer.getTraceLanguageID()).getVariant();
            }
            catch (LanguageNotFoundException e) {
                return "???";
            }
        }

        private static int getSize(DebuggerMappingOffer offer) {
            try {
                return LANG_SERV.getLanguageDescription(offer.getTraceLanguageID()).getSize();
            }
            catch (LanguageNotFoundException e) {
                return 0;
            }
        }

        private static Endian getEndian(DebuggerMappingOffer offer) {
            try {
                return LANG_SERV.getLanguageDescription(offer.getTraceLanguageID()).getEndian();
            }
            catch (LanguageNotFoundException e) {
                return null;
            }
        }

        private <T> OfferTableColumns(String header, Class<T> cls, Function<DebuggerMappingOffer, T> getter, ColumnSortState.SortDirection sortDir) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.sortDir = sortDir;
        }

        private <T> OfferTableColumns(String header, Class<T> cls, Function<DebuggerMappingOffer, T> getter) {
            this(header, cls, getter, ColumnSortState.SortDirection.ASCENDING);
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(DebuggerMappingOffer row) {
            return this.getter.apply(row);
        }

        public String getHeader() {
            return this.header;
        }

        public ColumnSortState.SortDirection defaultSortDirection() {
            return this.sortDir;
        }

        static {
            LANG_SERV = DefaultLanguageService.getLanguageService();
        }
    }
}

