/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import ghidra.app.plugin.core.debug.service.model.DefaultTraceRecorder;
import ghidra.app.plugin.core.debug.service.model.interfaces.ManagedMemoryRecorder;
import ghidra.app.plugin.core.debug.service.model.record.RecorderUtils;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetMemoryRegion;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceOverlappedRegionException;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;

public class DefaultMemoryRecorder
implements ManagedMemoryRecorder {
    private static final int BLOCK_BITS = 12;
    private final DefaultTraceRecorder recorder;
    private final Trace trace;
    private final TraceMemoryManager memoryManager;

    public DefaultMemoryRecorder(DefaultTraceRecorder recorder) {
        this.recorder = recorder;
        this.trace = recorder.getTrace();
        this.memoryManager = this.trace.getMemoryManager();
    }

    public CompletableFuture<Void> captureProcessMemory(AddressSetView set, TaskMonitor monitor) {
        return RecorderUtils.INSTANCE.readMemoryBlocks(this.recorder, 12, set, monitor);
    }

    @Override
    public void offerProcessMemory(TargetMemory memory) {
        this.recorder.getProcessMemory().addMemory(memory);
    }

    @Override
    public void offerProcessRegion(TargetMemoryRegion region) {
        TargetMemory mem = region.getMemory();
        this.recorder.getProcessMemory().addRegion(region, mem);
        String path = region.getJoinedPath(".");
        long snap = this.recorder.getSnap();
        this.recorder.parTx.execute("Memory region " + path + " added", () -> {
            try {
                TraceMemoryRegion traceRegion = this.memoryManager.getLiveRegionByPath(snap, path);
                if (traceRegion != null) {
                    Msg.warn((Object)this, (Object)("Region " + path + " already recorded"));
                    return;
                }
                AddressRange traceRange = this.recorder.getMemoryMapper().targetToTraceTruncated(region.getRange());
                if (traceRange == null) {
                    Msg.warn((Object)this, (Object)("Dropped unmappable region: " + String.valueOf(region)));
                    return;
                }
                if (region.getRange().getLength() != traceRange.getLength()) {
                    Msg.warn((Object)this, (Object)("Truncated region: " + String.valueOf(region)));
                }
                traceRegion = this.memoryManager.addRegion(path, Lifespan.nowOn((long)snap), traceRange, this.getTraceFlags(region));
                traceRegion.setName(region.getDisplay());
            }
            catch (TraceOverlappedRegionException e) {
                Msg.error((Object)this, (Object)("Failed to create region due to overlap: " + String.valueOf((Object)e)));
            }
            catch (DuplicateNameException e) {
                Msg.error((Object)this, (Object)("Failed to create region due to duplicate: " + String.valueOf((Object)e)));
            }
        }, path);
    }

    @Override
    public void removeProcessMemory(TargetMemory memory) {
        this.recorder.getProcessMemory().removeMemory(memory);
    }

    @Override
    public void removeProcessRegion(TargetMemoryRegion region) {
        String path = region.getJoinedPath(".");
        long snap = this.recorder.getSnap();
        this.recorder.parTx.execute("Memory region " + path + " removed", () -> {
            try {
                TraceMemoryRegion traceRegion = this.memoryManager.getLiveRegionByPath(snap, path);
                if (traceRegion == null) {
                    Msg.warn((Object)this, (Object)("Could not find region " + path + " in trace to remove"));
                    return;
                }
                if (traceRegion.getCreationSnap() >= snap) {
                    traceRegion.delete();
                } else {
                    traceRegion.setDestructionSnap(snap - 1L);
                }
            }
            catch (TraceOverlappedRegionException | DuplicateNameException e) {
                Msg.error((Object)this, (Object)("Failed to record region removal: " + String.valueOf(e)));
            }
        }, path);
    }

    @Override
    public TraceMemoryRegion getTraceMemoryRegion(TargetMemoryRegion region) {
        String path = region.getJoinedPath(".");
        return this.memoryManager.getLiveRegionByPath(this.recorder.getSnap(), path);
    }

    public Collection<TraceMemoryFlag> getTraceFlags(TargetMemoryRegion region) {
        HashSet<TraceMemoryFlag> flags = new HashSet<TraceMemoryFlag>();
        if (region.isReadable()) {
            flags.add(TraceMemoryFlag.READ);
        }
        if (region.isWritable()) {
            flags.add(TraceMemoryFlag.WRITE);
        }
        if (region.isExecutable()) {
            flags.add(TraceMemoryFlag.EXECUTE);
        }
        return flags;
    }

    public void regionChanged(TargetMemoryRegion region, String display) {
        String path = region.getJoinedPath(".");
        long snap = this.recorder.getSnap();
        this.recorder.parTx.execute("Memory region " + path + " changed display", () -> {
            TraceMemoryRegion traceRegion = this.memoryManager.getLiveRegionByPath(snap, path);
            if (traceRegion == null) {
                Msg.warn((Object)this, (Object)("Could not find region " + path + " in trace to rename"));
                return;
            }
            traceRegion.setName(display);
        }, path);
    }
}

