/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import ghidra.app.plugin.core.debug.service.model.DefaultTraceRecorder;
import ghidra.app.plugin.core.debug.service.model.interfaces.ManagedModuleRecorder;
import ghidra.dbg.target.TargetModule;
import ghidra.dbg.target.TargetSection;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceModuleManager;
import ghidra.trace.model.modules.TraceSection;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;

public class DefaultModuleRecorder
implements ManagedModuleRecorder {
    private final DefaultTraceRecorder recorder;
    private final Trace trace;
    private final TraceModuleManager moduleManager;

    public DefaultModuleRecorder(DefaultTraceRecorder recorder) {
        this.recorder = recorder;
        this.trace = recorder.getTrace();
        this.moduleManager = this.trace.getModuleManager();
    }

    protected TraceModule doRecordProcessModule(long snap, TargetModule module) {
        String path = module.getJoinedPath(".");
        if (this.recorder.getMemoryMapper() == null) {
            Msg.error((Object)this, (Object)("Got module before memory mapper: " + path));
            return null;
        }
        TraceModule exists = this.moduleManager.getLoadedModuleByPath(snap, path);
        if (exists != null) {
            return exists;
        }
        try {
            AddressRange targetRange = module.getRange();
            if (targetRange == null) {
                Msg.error((Object)this, (Object)("Range not found for " + String.valueOf(module)));
                return null;
            }
            AddressRange traceRange = this.recorder.getMemoryMapper().targetToTrace(targetRange);
            return this.moduleManager.addLoadedModule(path, module.getModuleName(), traceRange, snap);
        }
        catch (DuplicateNameException e) {
            return this.moduleManager.getLoadedModuleByPath(snap, path);
        }
    }

    @Override
    public void offerProcessModule(TargetModule module) {
        long snap = this.recorder.getSnap();
        String path = module.getJoinedPath(".");
        this.recorder.parTx.execute("Module " + path + " loaded", () -> this.doRecordProcessModule(snap, module), path);
    }

    protected TraceSection doRecordProcessModuleSection(long snap, TargetSection section) {
        String path = section.getJoinedPath(".");
        if (this.recorder.getMemoryMapper() == null) {
            Msg.error((Object)this, (Object)("Got module section before memory mapper: " + path));
            return null;
        }
        TraceModule traceModule = this.doRecordProcessModule(snap, section.getModule());
        if (traceModule == null) {
            return null;
        }
        try {
            AddressRange targetRange = section.getRange();
            AddressRange traceRange = this.recorder.getMemoryMapper().targetToTrace(targetRange);
            return traceModule.addSection(path, section.getIndex(), traceRange);
        }
        catch (DuplicateNameException e) {
            return this.moduleManager.getLoadedSectionByPath(snap, path);
        }
    }

    @Override
    public void offerProcessModuleSection(TargetSection section) {
        long snap = this.recorder.getSnap();
        String path = section.getJoinedPath(".");
        this.recorder.parTx.execute("Section " + path + " added", () -> this.doRecordProcessModuleSection(snap, section), section.getModule().getJoinedPath("."));
    }

    protected void doRemoveProcessModule(long snap, TargetModule module) {
        String path = module.getJoinedPath(".");
        TraceModule traceModule = this.moduleManager.getLoadedModuleByPath(snap, path);
        if (traceModule == null) {
            Msg.warn((Object)this, (Object)("unloaded " + path + " is not in the trace"));
            return;
        }
        try {
            if (traceModule.getLoadedSnap() == snap) {
                Msg.warn((Object)this, (Object)"Observed module unload in the same snap as its load");
            }
            traceModule.setUnloadedSnap(snap);
        }
        catch (DuplicateNameException e) {
            Msg.error((Object)this, (Object)("Could not record process module removed: " + String.valueOf((Object)e)));
        }
    }

    public void moduleChanged(TargetModule module, AddressRange traceRng) {
        long snap = this.recorder.getSnap();
        String path = module.getJoinedPath(".");
        this.recorder.parTx.execute("Module " + path + " range updated", () -> this.doModuleChanged(snap, path, traceRng), path);
    }

    protected void doModuleChanged(long snap, String path, AddressRange traceRng) {
        TraceModule traceModule = this.moduleManager.getLoadedModuleByPath(snap, path);
        if (traceModule == null) {
            Msg.warn((Object)this, (Object)("changed " + path + " is not in the trace"));
            return;
        }
        traceModule.setRange(traceRng);
    }

    @Override
    public void removeProcessModule(TargetModule module) {
        long snap = this.recorder.getSnap();
        String path = module.getJoinedPath(".");
        this.recorder.parTx.execute("Module " + path + " unloaded", () -> this.doRemoveProcessModule(snap, module), path);
    }

    @Override
    public TraceModule getTraceModule(TargetModule module) {
        String path = module.getJoinedPath(".");
        return this.moduleManager.getLoadedModuleByPath(this.recorder.getSnap(), path);
    }

    @Override
    public TraceSection getTraceSection(TargetSection section) {
        String path = section.getJoinedPath(".");
        return this.moduleManager.getLoadedSectionByPath(this.recorder.getSnap(), path);
    }
}

