/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import ghidra.app.plugin.core.debug.service.model.DefaultTraceRecorder;
import ghidra.app.plugin.core.debug.service.model.interfaces.ManagedStackRecorder;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.util.PathUtils;
import ghidra.debug.api.model.DebuggerMemoryMapper;
import ghidra.program.model.address.Address;
import ghidra.trace.model.Trace;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.stack.TraceStackManager;
import ghidra.trace.model.thread.TraceThread;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class DefaultStackRecorder
implements ManagedStackRecorder {
    private NavigableMap<Integer, TargetStackFrame> stack = Collections.synchronizedNavigableMap(new TreeMap());
    private final TraceThread thread;
    private final DefaultTraceRecorder recorder;
    private final Trace trace;
    private final TraceStackManager stackManager;

    protected static int getFrameLevel(TargetStackFrame frame) {
        return Integer.decode(frame.getIndex());
    }

    public DefaultStackRecorder(TraceThread thread, DefaultTraceRecorder recorder) {
        this.thread = thread;
        this.recorder = recorder;
        this.trace = recorder.getTrace();
        this.stackManager = this.trace.getStackManager();
    }

    @Override
    public void offerStackFrame(TargetStackFrame frame) {
        this.recordFrame(frame);
    }

    @Override
    public void recordStack() {
        this.doRecordStack(this.recorder.getSnap(), this.getPcsByLevel());
    }

    public void popStack() {
        long snap = this.recorder.getSnap();
        this.recorder.parTx.execute("Stack popped", () -> {
            TraceStack traceStack = this.stackManager.getStack(this.thread, snap, true);
            traceStack.setDepth(this.stackDepth(), false);
        }, this.thread.getPath());
    }

    public void doRecordFrame(TraceStack traceStack, int frameLevel, Address pc) {
        TraceStackFrame traceFrame = traceStack.getFrame(frameLevel, true);
        traceFrame.setProgramCounter(null, pc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Integer, Address> getPcsByLevel() {
        DebuggerMemoryMapper mm = this.recorder.getMemoryMapper();
        NavigableMap<Integer, TargetStackFrame> navigableMap = this.stack;
        synchronized (navigableMap) {
            return this.stack.entrySet().stream().collect(Collectors.toMap(e -> (Integer)e.getKey(), e -> mm.targetToTrace(((TargetStackFrame)e.getValue()).getProgramCounter())));
        }
    }

    protected void doRecordStack(long snap, Map<Integer, Address> pcsByLevel) {
        this.recorder.parTx.execute("Stack changed", () -> {
            TraceStack traceStack = this.stackManager.getStack(this.thread, snap, true);
            traceStack.setDepth(this.stackDepth(), false);
            for (Map.Entry ent : pcsByLevel.entrySet()) {
                this.doRecordFrame(traceStack, (Integer)ent.getKey(), (Address)ent.getValue());
            }
        }, this.thread.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordFrame(TargetStackFrame frame) {
        Map<Integer, Address> pcsByLevel;
        long snap = this.recorder.getSnap();
        NavigableMap<Integer, TargetStackFrame> navigableMap = this.stack;
        synchronized (navigableMap) {
            this.stack.put(DefaultStackRecorder.getFrameLevel(frame), frame);
            pcsByLevel = this.getPcsByLevel();
        }
        this.doRecordStack(snap, pcsByLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int stackDepth() {
        NavigableMap<Integer, TargetStackFrame> navigableMap = this.stack;
        synchronized (navigableMap) {
            return this.stack.isEmpty() ? 0 : (Integer)this.stack.lastKey() + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSuccessorFrameLevel(TargetObject successor) {
        for (TargetObject p = successor; p != null; p = p.getParent()) {
            TargetStackFrame frame;
            if (!(p instanceof TargetStackFrame)) continue;
            if (!PathUtils.isIndex((List)p.getPath())) {
                throw new AssertionError((Object)("Invalid path index " + String.valueOf(p.getPath())));
            }
            int index = Integer.decode(p.getIndex());
            NavigableMap<Integer, TargetStackFrame> navigableMap = this.stack;
            synchronized (navigableMap) {
                frame = (TargetStackFrame)this.stack.get(index);
            }
            if (!Objects.equals(p, frame)) {
                return -1;
            }
            return index;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkStackFrameRemoved(TargetObject invalid) {
        boolean removed;
        NavigableMap<Integer, TargetStackFrame> navigableMap = this.stack;
        synchronized (navigableMap) {
            removed = this.stack.values().remove(invalid);
        }
        if (removed) {
            this.popStack();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address pcFromStack() {
        TargetStackFrame frame;
        NavigableMap<Integer, TargetStackFrame> navigableMap = this.stack;
        synchronized (navigableMap) {
            frame = (TargetStackFrame)this.stack.get(0);
        }
        if (frame == null) {
            return null;
        }
        return frame.getProgramCounter();
    }

    @Override
    public TraceStackFrame getTraceStackFrame(TraceThread thread, int level) {
        TraceStack latest = this.stackManager.getLatestStack(thread, this.recorder.getSnap());
        if (latest == null) {
            return null;
        }
        return latest.getFrame(level, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TargetStackFrame getTargetStackFrame(int frameLevel) {
        NavigableMap<Integer, TargetStackFrame> navigableMap = this.stack;
        synchronized (navigableMap) {
            return (TargetStackFrame)this.stack.get(frameLevel);
        }
    }
}

