/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model.launch;

import ghidra.app.plugin.core.debug.service.model.launch.DebuggerProgramLaunchOpinion;
import ghidra.app.services.DebuggerModelService;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.debug.api.model.DebuggerProgramLaunchOffer;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public abstract class AbstractDebuggerProgramLaunchOpinion
implements DebuggerProgramLaunchOpinion {
    protected static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    protected static final MethodType CON_SIG = MethodType.methodType(Void.TYPE, Program.class, PluginTool.class, DebuggerModelFactory.class);

    protected static DebuggerModelFactory getFactory(Class<? extends DebuggerProgramLaunchOffer> offerClass, DebuggerModelService service) {
        FactoryClass annotation = offerClass.getAnnotation(FactoryClass.class);
        if (annotation == null) {
            Msg.error(AbstractDebuggerProgramLaunchOpinion.class, (Object)("Missing @" + FactoryClass.class.getSimpleName() + " annotation on " + String.valueOf(offerClass)));
            return null;
        }
        Optional<DebuggerModelFactory> found = service.getModelFactories().stream().filter(f -> f.getClass().getName().equals(annotation.value())).findAny();
        if (found.isEmpty()) {
            Msg.error(AbstractDebuggerProgramLaunchOpinion.class, (Object)("No factory with name " + annotation.value() + " required by " + String.valueOf(offerClass)));
            return null;
        }
        return found.get();
    }

    protected abstract Collection<Class<? extends DebuggerProgramLaunchOffer>> getOfferClasses();

    @Override
    public Collection<DebuggerProgramLaunchOffer> getOffers(Program program, PluginTool tool, DebuggerModelService service) {
        String exe = program.getExecutablePath();
        if (exe == null || exe.isBlank()) {
            return List.of();
        }
        ArrayList<DebuggerProgramLaunchOffer> offers = new ArrayList<DebuggerProgramLaunchOffer>();
        for (Class<? extends DebuggerProgramLaunchOffer> cls : this.getOfferClasses()) {
            DebuggerModelFactory factory = AbstractDebuggerProgramLaunchOpinion.getFactory(cls, service);
            if (factory == null || !factory.isCompatible(program)) continue;
            try {
                MethodHandle constructor = LOOKUP.findConstructor(cls, CON_SIG);
                offers.add(constructor.invoke(program, tool, factory));
            }
            catch (Throwable e) {
                throw new AssertionError((Object)e);
            }
        }
        return offers;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface FactoryClass {
        public String value();
    }
}

