/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model.record;

import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.loop.AsyncLoopHandlerForSecond;
import ghidra.debug.api.model.TraceRecorder;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeChunker;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;

public enum RecorderUtils {
    INSTANCE;


    public AddressSetView quantize(int blockBits, AddressSetView set) {
        if (blockBits == 1) {
            return set;
        }
        long blockMask = -1L << blockBits;
        AddressSet result = new AddressSet();
        for (AddressRange range : set) {
            AddressSpace space = range.getAddressSpace();
            Address min = space.getAddress(range.getMinAddress().getOffset() & blockMask);
            Address max = space.getAddress(range.getMaxAddress().getOffset() | blockMask ^ 0xFFFFFFFFFFFFFFFFL);
            result.add((AddressRange)new AddressRangeImpl(min, max));
        }
        return result;
    }

    public CompletableFuture<Void> readMemoryBlocks(TraceRecorder recorder, int blockBits, AddressSetView set, TaskMonitor monitor) {
        int blockSize = 1 << blockBits;
        int total = 0;
        AddressSetView expSet = this.quantize(blockBits, set);
        for (AddressRange r2 : expSet) {
            total = (int)((long)total + Long.divideUnsigned(r2.getLength() + (long)blockSize - 1L, blockSize));
        }
        monitor.initialize((long)total);
        monitor.setMessage("Reading memory");
        return AsyncUtils.each((TypeSpec)TypeSpec.VOID, (Iterator)expSet.iterator(), (r, loop) -> {
            AddressRangeChunker blocks = new AddressRangeChunker(r, blockSize);
            ((CompletableFuture)AsyncUtils.each((TypeSpec)TypeSpec.VOID, (Iterator)blocks.iterator(), (blk, inner) -> {
                monitor.incrementProgress(1L);
                CompletableFuture future = recorder.readMemory(blk.getMinAddress(), (int)blk.getLength());
                ((CompletableFuture)((CompletableFuture)future.exceptionally(e -> {
                    Msg.error((Object)((Object)this), (Object)("Could not read " + String.valueOf(blk) + ": " + String.valueOf(e)));
                    return null;
                })).thenApply(__ -> !monitor.isCancelled())).handle((arg_0, arg_1) -> ((AsyncLoopHandlerForSecond)inner).repeatWhile(arg_0, arg_1));
            }).thenApply(v -> !monitor.isCancelled())).handle((arg_0, arg_1) -> ((AsyncLoopHandlerForSecond)loop).repeatWhile(arg_0, arg_1));
        });
    }
}

