/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import db.Transaction;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceOpenedPluginEvent;
import ghidra.app.plugin.core.debug.service.modules.DebuggerStaticMappingProposals;
import ghidra.app.plugin.core.debug.service.modules.DebuggerStaticMappingUtils;
import ghidra.app.plugin.core.debug.service.modules.DefaultRegionMapProposal;
import ghidra.app.plugin.core.debug.service.modules.DefaultSectionMapProposal;
import ghidra.app.plugin.core.debug.service.modules.InfoPerProgram;
import ghidra.app.plugin.core.debug.service.modules.InfoPerTrace;
import ghidra.app.plugin.core.debug.service.modules.MappingEntry;
import ghidra.app.plugin.core.debug.service.modules.ProgramModuleIndexer;
import ghidra.app.plugin.core.debug.utils.ProgramLocationUtils;
import ghidra.app.plugin.core.debug.utils.ProgramURLUtils;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.ProgramManager;
import ghidra.debug.api.modules.DebuggerStaticMappingChangeListener;
import ghidra.debug.api.modules.MapEntry;
import ghidra.debug.api.modules.ModuleMapProposal;
import ghidra.debug.api.modules.RegionMapProposal;
import ghidra.debug.api.modules.SectionMapProposal;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.TraceSpan;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.modules.TraceConflictedMappingException;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.util.Msg;
import ghidra.util.datastruct.ListenerSet;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@PluginInfo(shortDescription="Debugger static mapping manager", description="Track and manage static mappings (program-trace relocations)", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={ProgramOpenedPluginEvent.class, ProgramClosedPluginEvent.class, TraceOpenedPluginEvent.class, TraceClosedPluginEvent.class}, servicesRequired={ProgramManager.class, DebuggerTraceManagerService.class}, servicesProvided={DebuggerStaticMappingService.class})
public class DebuggerStaticMappingServicePlugin
extends Plugin
implements DebuggerStaticMappingService,
DomainFolderChangeListener {
    final Map<Trace, InfoPerTrace> traceInfoByTrace = new HashMap<Trace, InfoPerTrace>();
    final Map<Program, InfoPerProgram> programInfoByProgram = new HashMap<Program, InfoPerProgram>();
    final Map<URL, InfoPerProgram> programInfoByUrl = new HashMap<URL, InfoPerProgram>();
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private ProgramManager programManager;
    private final AutoService.Wiring autoWiring;
    final Object lock = new Object();
    final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final ListenerSet<DebuggerStaticMappingChangeListener> changeListeners = new ListenerSet(DebuggerStaticMappingChangeListener.class, true);
    private final ProgramModuleIndexer programModuleIndexer;
    private final DebuggerStaticMappingProposals.ModuleMapProposalGenerator moduleMapProposalGenerator;

    public DebuggerStaticMappingServicePlugin(PluginTool tool) {
        super(tool);
        this.autoWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);
        this.programModuleIndexer = new ProgramModuleIndexer(tool);
        this.moduleMapProposalGenerator = new DebuggerStaticMappingProposals.ModuleMapProposalGenerator(this.programModuleIndexer);
    }

    protected void dispose() {
        this.tool.getProject().getProjectData().removeDomainFolderChangeListener((DomainFolderChangeListener)this);
        this.executor.close();
        super.dispose();
    }

    public void addChangeListener(DebuggerStaticMappingChangeListener l) {
        this.changeListeners.add((Object)l);
    }

    public void removeChangeListener(DebuggerStaticMappingChangeListener l) {
        this.changeListeners.remove((Object)l);
    }

    void checkAndClearProgram(ChangeCollector cc, MappingEntry me) {
        InfoPerProgram info = this.programInfoByUrl.get(me.getStaticProgramUrl());
        if (info == null) {
            return;
        }
        info.clearProgram(cc, me);
    }

    void checkAndFillProgram(ChangeCollector cc, MappingEntry me) {
        InfoPerProgram info = this.programInfoByUrl.get(me.getStaticProgramUrl());
        if (info == null) {
            return;
        }
        info.fillProgram(cc, me);
    }

    public CompletableFuture<Void> changesSettled() {
        return CompletableFuture.runAsync(() -> {}, this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void programsChanged() {
        try (ChangeCollector cc = new ChangeCollector(this);){
            Object object = this.lock;
            synchronized (object) {
                this.programsChanged(cc);
            }
        }
    }

    void programsChanged(ChangeCollector cc) {
        Set curProgs = Stream.of(this.programManager.getAllOpenPrograms()).filter(p -> !p.isClosed()).collect(Collectors.toSet());
        Set<InfoPerProgram> removed = this.programInfoByProgram.values().stream().filter(i -> !curProgs.contains(i.program) || !i.urlMatches()).collect(Collectors.toSet());
        this.processRemovedProgramInfos(cc, removed);
        Set<Program> added = ChangeCollector.subtract(curProgs, this.programInfoByProgram.keySet());
        this.processAddedPrograms(cc, added);
    }

    void processRemovedProgramInfos(ChangeCollector cc, Set<InfoPerProgram> removed) {
        for (InfoPerProgram info : removed) {
            this.processRemovedProgramInfo(cc, info);
        }
    }

    void processRemovedProgramInfo(ChangeCollector cc, InfoPerProgram info) {
        this.programInfoByProgram.remove(info.program);
        this.programInfoByUrl.remove(info.url);
        info.clearEntries(cc);
    }

    void processAddedPrograms(ChangeCollector cc, Set<Program> added) {
        for (Program program : added) {
            this.processAddedProgram(cc, program);
        }
    }

    void processAddedProgram(ChangeCollector cc, Program program) {
        InfoPerProgram info = new InfoPerProgram(this, program);
        this.programInfoByProgram.put(program, info);
        this.programInfoByUrl.put(info.url, info);
        info.fillEntries(cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tracesChanged() {
        try (ChangeCollector cc = new ChangeCollector(this);){
            Object object = this.lock;
            synchronized (object) {
                this.tracesChanged(cc);
            }
        }
    }

    void tracesChanged(ChangeCollector cc) {
        Set curTraces = this.traceManager.getOpenTraces().stream().filter(t -> !t.isClosed()).collect(Collectors.toSet());
        Set<Trace> oldTraces = this.traceInfoByTrace.keySet();
        Set<Trace> removed = ChangeCollector.subtract(oldTraces, curTraces);
        Set<Trace> added = ChangeCollector.subtract(curTraces, oldTraces);
        this.processRemovedTraces(cc, removed);
        this.processAddedTraces(cc, added);
    }

    void processRemovedTraces(ChangeCollector cc, Set<Trace> removed) {
        for (Trace trace : removed) {
            this.processRemovedTrace(cc, trace);
        }
    }

    void processRemovedTrace(ChangeCollector cc, Trace trace) {
        InfoPerTrace info = this.traceInfoByTrace.remove(trace);
        info.removeEntries(cc);
    }

    void processAddedTraces(ChangeCollector cc, Set<Trace> added) {
        for (Trace trace : added) {
            this.processAddedTrace(cc, trace);
        }
    }

    void processAddedTrace(ChangeCollector cc, Trace trace) {
        InfoPerTrace info = new InfoPerTrace(this, trace);
        this.traceInfoByTrace.put(trace, info);
        info.resyncEntries(cc);
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramOpenedPluginEvent) {
            CompletableFuture.runAsync(this::programsChanged, this.executor);
        } else if (event instanceof ProgramClosedPluginEvent) {
            CompletableFuture.runAsync(this::programsChanged, this.executor);
        } else if (event instanceof TraceOpenedPluginEvent) {
            CompletableFuture.runAsync(this::tracesChanged, this.executor);
        } else if (event instanceof TraceClosedPluginEvent) {
            CompletableFuture.runAsync(this::tracesChanged, this.executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void domainFileObjectOpenedForUpdate(DomainFile file, DomainObject object) {
        if (object instanceof Program) {
            Program program = (Program)object;
            Object object2 = this.lock;
            synchronized (object2) {
                if (this.programInfoByProgram.containsKey(program)) {
                    CompletableFuture.runAsync(this::programsChanged, this.executor);
                }
            }
        }
    }

    public void addMapping(TraceLocation from, ProgramLocation to, long length, boolean truncateExisting) throws TraceConflictedMappingException {
        try (Transaction tx = from.getTrace().openTransaction("Add mapping");){
            DebuggerStaticMappingUtils.addMapping(from, to, length, truncateExisting);
        }
    }

    public void addMapping(MapEntry<?, ?> entry, boolean truncateExisting) throws TraceConflictedMappingException {
        try (Transaction tx = entry.getFromTrace().openTransaction("Add mapping");){
            DebuggerStaticMappingUtils.addMapping(entry, truncateExisting);
        }
    }

    public void addMappings(Collection<? extends MapEntry<?, ?>> entries, TaskMonitor monitor, boolean truncateExisting, String description) throws CancelledException {
        Map<Trace, List<MapEntry>> byTrace = entries.stream().collect(Collectors.groupingBy(ent -> ent.getFromTrace()));
        for (Map.Entry<Trace, List<MapEntry>> ent2 : byTrace.entrySet()) {
            Trace trace = ent2.getKey();
            Transaction tx = trace.openTransaction(description);
            try {
                DebuggerStaticMappingServicePlugin.doAddMappings(trace, (Collection)ent2.getValue(), monitor, truncateExisting);
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
    }

    protected static void doAddMappings(Trace trace, Collection<MapEntry<?, ?>> entries, TaskMonitor monitor, boolean truncateExisting) throws CancelledException {
        for (MapEntry<?, ?> ent : entries) {
            monitor.checkCancelled();
            try {
                DebuggerStaticMappingUtils.addMapping(ent, truncateExisting);
            }
            catch (Exception e) {
                Msg.error(DebuggerStaticMappingService.class, (Object)("Could not add mapping " + String.valueOf(ent) + ": " + e.getMessage()));
            }
        }
    }

    public void addIdentityMapping(Trace from, Program toProgram, Lifespan lifespan, boolean truncateExisting) {
        try (Transaction tx = from.openTransaction("Add identity mappings");){
            DebuggerStaticMappingUtils.addIdentityMapping(from, toProgram, lifespan, truncateExisting);
        }
    }

    public void addModuleMappings(Collection<ModuleMapProposal.ModuleMapEntry> entries, TaskMonitor monitor, boolean truncateExisting) throws CancelledException {
        this.addMappings(entries, monitor, truncateExisting, "Add module mappings");
        HashMap<Program, List> entriesByProgram = new HashMap<Program, List>();
        for (ModuleMapProposal.ModuleMapEntry moduleMapEntry : entries) {
            if (!moduleMapEntry.isMemorize()) continue;
            entriesByProgram.computeIfAbsent(moduleMapEntry.getToProgram(), p -> new ArrayList()).add(moduleMapEntry);
        }
        for (Map.Entry entry : entriesByProgram.entrySet()) {
            Transaction tx = ((Program)entry.getKey()).openTransaction("Memorize module mapping");
            try {
                for (ModuleMapProposal.ModuleMapEntry entry2 : (List)entry.getValue()) {
                    ProgramModuleIndexer.addModulePaths(entry2.getToProgram(), List.of(entry2.getModule().getName()));
                }
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
    }

    public void addSectionMappings(Collection<SectionMapProposal.SectionMapEntry> entries, TaskMonitor monitor, boolean truncateExisting) throws CancelledException {
        this.addMappings(entries, monitor, truncateExisting, "Add sections mappings");
    }

    public void addRegionMappings(Collection<RegionMapProposal.RegionMapEntry> entries, TaskMonitor monitor, boolean truncateExisting) throws CancelledException {
        this.addMappings(entries, monitor, truncateExisting, "Add regions mappings");
    }

    protected <T> T noTraceInfo() {
        Msg.debug((Object)((Object)this), (Object)"The given trace is not open in this tool (or the service hasn't received and processed the open-trace event, yet)");
        return null;
    }

    protected <T> T noProgramInfo() {
        Msg.debug((Object)((Object)this), (Object)"The given program is not open in this tool (or the service hasn't received and processed the open-program event, yet)");
        return null;
    }

    protected <T> T noProject() {
        return DebuggerStaticMappingUtils.noProject((Object)this);
    }

    protected InfoPerTrace requireTrackedInfo(Trace trace) {
        InfoPerTrace info = this.traceInfoByTrace.get(trace);
        if (info == null) {
            return (InfoPerTrace)((Object)this.noTraceInfo());
        }
        return info;
    }

    protected InfoPerProgram requireTrackedInfo(Program program) {
        InfoPerProgram info = this.programInfoByProgram.get(program);
        if (info == null) {
            return (InfoPerProgram)this.noProgramInfo();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Program> getOpenMappedProgramsAtSnap(Trace trace, long snap) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace info = this.requireTrackedInfo(trace);
            if (info == null) {
                return null;
            }
            return info.getOpenMappedProgramsAtSnap(snap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramLocation getOpenMappedLocation(TraceLocation loc) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace info = this.requireTrackedInfo(loc.getTrace());
            if (info == null) {
                return null;
            }
            return info.getOpenMappedProgramLocation(loc.getAddress(), loc.getLifespan());
        }
    }

    protected long getNonScratchSnap(TraceProgramView view) {
        return (Long)view.getViewport().getTop(s -> s >= 0L ? s : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramLocation getStaticLocationFromDynamic(ProgramLocation loc) {
        Object object = this.lock;
        synchronized (object) {
            loc = ProgramLocationUtils.fixLocation(loc, true);
            TraceProgramView view = (TraceProgramView)loc.getProgram();
            Trace trace = view.getTrace();
            DefaultTraceLocation tloc = new DefaultTraceLocation(trace, null, Lifespan.at((long)this.getNonScratchSnap(view)), loc.getByteAddress());
            ProgramLocation mapped = this.getOpenMappedLocation((TraceLocation)tloc);
            if (mapped == null) {
                return null;
            }
            return ProgramLocationUtils.replaceAddress(loc, mapped.getProgram(), mapped.getByteAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TraceLocation> getOpenMappedLocations(ProgramLocation loc) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerProgram info = this.requireTrackedInfo(loc.getProgram());
            if (info == null) {
                return null;
            }
            return info.getOpenMappedTraceLocations(loc.getByteAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraceLocation getOpenMappedLocation(Trace trace, ProgramLocation loc, long snap) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerProgram info = this.requireTrackedInfo(loc.getProgram());
            if (info == null) {
                return null;
            }
            return info.getOpenMappedTraceLocation(trace, loc.getByteAddress(), snap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramLocation getDynamicLocationFromStatic(TraceProgramView view, ProgramLocation loc) {
        Object object = this.lock;
        synchronized (object) {
            TraceLocation tloc = this.getOpenMappedLocation(view.getTrace(), loc, this.getNonScratchSnap(view));
            if (tloc == null) {
                return null;
            }
            return ProgramLocationUtils.replaceAddress(loc, (Program)view, tloc.getAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Program, Collection<DebuggerStaticMappingService.MappedAddressRange>> getOpenMappedViews(Trace trace, AddressSetView set, long snap) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace info = this.requireTrackedInfo(trace);
            if (info == null) {
                return null;
            }
            return info.getOpenMappedViews(set, Lifespan.at((long)snap));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TraceSpan, Collection<DebuggerStaticMappingService.MappedAddressRange>> getOpenMappedViews(Program program, AddressSetView set) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerProgram info = this.requireTrackedInfo(program);
            if (info == null) {
                return Map.of();
            }
            return info.getOpenMappedViews(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Program> openMappedProgramsInView(Trace trace, AddressSetView set, long snap, Set<Exception> failures) {
        Set<URL> urls;
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace info = this.requireTrackedInfo(trace);
            if (info == null) {
                return null;
            }
            urls = info.getMappedProgramUrlsInView(set, Lifespan.at((long)snap));
        }
        HashSet<Program> result = new HashSet<Program>();
        for (URL url : urls) {
            try {
                Program program = ProgramURLUtils.openDomainFileFromOpenProject(this.programManager, this.tool.getProject(), url, 2);
                if (program == null) {
                    failures.add(new FileNotFoundException(url.toString()));
                }
                result.add(program);
            }
            catch (Exception e) {
                if (failures == null) {
                    throw e;
                }
                failures.add(e);
            }
        }
        return result;
    }

    protected Collection<? extends Program> orderCurrentFirst(Collection<? extends Program> programs) {
        if (this.programManager == null) {
            return programs;
        }
        Program currentProgram = this.programManager.getCurrentProgram();
        if (!programs.contains(currentProgram)) {
            return programs;
        }
        LinkedHashSet<Object> reordered = new LinkedHashSet<Object>(programs.size());
        reordered.add(currentProgram);
        reordered.addAll(programs);
        return reordered;
    }

    public DomainFile findBestModuleProgram(AddressSpace space, TraceModule module) {
        return this.programModuleIndexer.getBestMatch(space, module, this.programManager.getCurrentProgram());
    }

    public ModuleMapProposal proposeModuleMap(TraceModule module, Program program) {
        return this.moduleMapProposalGenerator.proposeMap(module, program);
    }

    public ModuleMapProposal proposeModuleMap(TraceModule module, Collection<? extends Program> programs) {
        return this.moduleMapProposalGenerator.proposeBestMap(module, this.orderCurrentFirst(programs));
    }

    public Map<TraceModule, ModuleMapProposal> proposeModuleMaps(Collection<? extends TraceModule> modules, Collection<? extends Program> programs) {
        return this.moduleMapProposalGenerator.proposeBestMaps(modules, this.orderCurrentFirst(programs));
    }

    public SectionMapProposal proposeSectionMap(TraceSection section, Program program, MemoryBlock block) {
        return new DefaultSectionMapProposal(section, program, block);
    }

    public SectionMapProposal proposeSectionMap(TraceModule module, Program program) {
        return DebuggerStaticMappingProposals.SECTIONS.proposeMap(module, program);
    }

    public SectionMapProposal proposeSectionMap(TraceModule module, Collection<? extends Program> programs) {
        return (SectionMapProposal)DebuggerStaticMappingProposals.SECTIONS.proposeBestMap(module, this.orderCurrentFirst(programs));
    }

    public Map<TraceModule, SectionMapProposal> proposeSectionMaps(Collection<? extends TraceModule> modules, Collection<? extends Program> programs) {
        return DebuggerStaticMappingProposals.SECTIONS.proposeBestMaps(modules, this.orderCurrentFirst(programs));
    }

    public RegionMapProposal proposeRegionMap(TraceMemoryRegion region, Program program, MemoryBlock block) {
        return new DefaultRegionMapProposal(region, program, block);
    }

    public RegionMapProposal proposeRegionMap(Collection<? extends TraceMemoryRegion> regions, Program program) {
        return DebuggerStaticMappingProposals.REGIONS.proposeMap(Collections.unmodifiableCollection(regions), program);
    }

    public Map<Collection<TraceMemoryRegion>, RegionMapProposal> proposeRegionMaps(Collection<? extends TraceMemoryRegion> regions, Collection<? extends Program> programs) {
        Set<Set<TraceMemoryRegion>> groups = DebuggerStaticMappingProposals.groupRegionsByLikelyModule(regions);
        return DebuggerStaticMappingProposals.REGIONS.proposeBestMaps(groups, programs);
    }

    record ChangeCollector(DebuggerStaticMappingServicePlugin plugin, Set<Trace> traces, Set<Program> programs) implements AutoCloseable
    {
        public ChangeCollector(DebuggerStaticMappingServicePlugin plugin) {
            this(plugin, new HashSet<Trace>(), new HashSet<Program>());
        }

        static <T> Set<T> subtract(Set<T> a, Set<T> b) {
            HashSet<T> result = new HashSet<T>(a);
            result.removeAll(b);
            return result;
        }

        public void traceAffected(Trace trace) {
            this.traces.add(trace);
        }

        public void programAffected(Program program) {
            if (program != null) {
                this.programs.add(program);
            }
        }

        @Override
        public void close() {
            ((DebuggerStaticMappingChangeListener)this.plugin.changeListeners.getProxy()).mappingsChanged(this.traces, this.programs);
        }
    }
}

