/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import ghidra.app.plugin.core.debug.service.modules.AbstractMapEntry;
import ghidra.app.plugin.core.debug.service.modules.AbstractMapProposal;
import ghidra.app.plugin.core.debug.service.modules.DebuggerStaticMappingUtils;
import ghidra.app.plugin.core.debug.service.modules.ModuleRegionMatcher;
import ghidra.debug.api.modules.ModuleMapProposal;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceObjectMemoryRegion;
import ghidra.trace.model.modules.TraceModule;
import ghidra.util.MathUtilities;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class DefaultModuleMapProposal
extends AbstractMapProposal<TraceModule, Program, ModuleMapProposal.ModuleMapEntry>
implements ModuleMapProposal {
    protected static final int BLOCK_BITS = 12;
    protected static final int BLOCK_SIZE = 4096;
    protected static final long BLOCK_MASK = -4096L;
    protected final TraceModule module;
    protected final NavigableMap<Long, ModuleRegionMatcher> matchers = new TreeMap<Long, ModuleRegionMatcher>();
    protected AddressRange imageRange;
    protected AddressRange moduleRange;

    protected static AddressRange quantize(AddressRange range) {
        AddressSpace space = range.getAddressSpace();
        Address min = space.getAddress(range.getMinAddress().getOffset() & 0xFFFFFFFFFFFFF000L);
        Address max = space.getAddress(range.getMaxAddress().getOffset() | 0xFFFL);
        return new AddressRangeImpl(min, max);
    }

    protected DefaultModuleMapProposal(TraceModule module, Program program) {
        super(module.getTrace(), program);
        this.module = module;
        this.processProgram();
        this.processModule();
    }

    public TraceModule getModule() {
        return this.module;
    }

    private ModuleRegionMatcher getMatcher(long baseOffset) {
        return this.matchers.computeIfAbsent(baseOffset, ModuleRegionMatcher::new);
    }

    private void processProgram() {
        this.imageRange = DefaultModuleMapProposal.quantize(DefaultModuleMapEntry.computeImageRange(this.program));
        Address imageBase = this.imageRange.getMinAddress();
        for (MemoryBlock block : this.program.getMemory().getBlocks()) {
            if (!DefaultModuleMapEntry.includeBlock(this.program, block)) continue;
            this.getMatcher((long)block.getStart().subtract((Address)imageBase)).block = block;
        }
    }

    private void processModule() {
        this.moduleRange = DefaultModuleMapProposal.quantize(this.module.getRange());
        Address moduleBase = this.moduleRange.getMinAddress();
        Lifespan lifespan = this.module.getLifespan();
        for (TraceMemoryRegion region : this.module.getTrace().getMemoryManager().getRegionsIntersecting(lifespan, this.moduleRange)) {
            Address address;
            if (region instanceof TraceObjectMemoryRegion) {
                TraceObjectMemoryRegion objReg = (TraceObjectMemoryRegion)region;
                address = objReg.getMinAddress(lifespan.lmin());
            } else {
                address = region.getMinAddress();
            }
            Address min = address;
            this.getMatcher((long)min.subtract((Address)moduleBase)).region = region;
        }
    }

    public double computeScore() {
        return (double)this.matchers.values().stream().reduce(0, (s, m) -> s + m.score(), Integer::sum).intValue() / (double)this.matchers.size();
    }

    public Map<TraceModule, ModuleMapProposal.ModuleMapEntry> computeMap() {
        return Map.of(this.module, new DefaultModuleMapEntry(this.module, this.program, this.moduleRange));
    }

    public Program getToObject(TraceModule from) {
        if (from != this.module) {
            return null;
        }
        return this.program;
    }

    public static class DefaultModuleMapEntry
    extends AbstractMapEntry<TraceModule, Program>
    implements ModuleMapProposal.ModuleMapEntry {
        protected AddressRange moduleRange;
        protected AddressRange imageRange;
        protected boolean memorize = false;

        public static boolean includeBlock(Program program, MemoryBlock block) {
            if (program.getImageBase().getAddressSpace() != block.getStart().getAddressSpace()) {
                return false;
            }
            if (!block.isLoaded()) {
                return false;
            }
            if (block.isMapped()) {
                return false;
            }
            return !block.isArtificial();
        }

        public static AddressRange computeImageRange(Program program) {
            DebuggerStaticMappingUtils.Extrema extrema = new DebuggerStaticMappingUtils.Extrema();
            for (MemoryBlock block : program.getMemory().getBlocks()) {
                if (!DefaultModuleMapEntry.includeBlock(program, block)) continue;
                extrema.consider(block.getAddressRange());
            }
            if (program.getImageBase().getOffset() != 0L) {
                extrema.consider(program.getImageBase());
            }
            return extrema.getRange();
        }

        protected DefaultModuleMapEntry(TraceModule module, Program program, AddressRange moduleRange) {
            super(module.getTrace(), module, program, program);
            this.moduleRange = moduleRange;
            this.imageRange = DefaultModuleMapProposal.quantize(DefaultModuleMapEntry.computeImageRange(program));
        }

        public TraceModule getModule() {
            return (TraceModule)this.getFromObject();
        }

        public Lifespan getFromLifespan() {
            return this.getModule().getLifespan();
        }

        private long getLength() {
            return MathUtilities.unsignedMin((long)this.moduleRange.getLength(), (long)this.imageRange.getLength());
        }

        public AddressRange getFromRange() {
            try {
                return new AddressRangeImpl(this.moduleRange.getMinAddress(), this.getLength());
            }
            catch (AddressOverflowException e) {
                throw new AssertionError((Object)e);
            }
        }

        public AddressRange getModuleRange() {
            return this.moduleRange;
        }

        public void setProgram(Program program) {
            this.setToObject(program, program);
            this.imageRange = DefaultModuleMapProposal.quantize(DefaultModuleMapEntry.computeImageRange(program));
        }

        public AddressRange getToRange() {
            try {
                return new AddressRangeImpl(this.imageRange.getMinAddress(), this.getLength());
            }
            catch (AddressOverflowException e) {
                throw new AssertionError((Object)e);
            }
        }

        public boolean isMemorize() {
            return this.memorize;
        }

        public void setMemorize(boolean memorize) {
            this.memorize = memorize;
        }
    }
}

