/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.tracemgr;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.widgets.OptionDialog;
import ghidra.app.plugin.core.debug.event.DebuggerPlatformPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceInactiveCoordinatesPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceOpenedPluginEvent;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.control.DisconnectTask;
import ghidra.app.plugin.core.debug.gui.control.TargetActionTask;
import ghidra.app.services.DebuggerControlService;
import ghidra.app.services.DebuggerEmulationService;
import ghidra.app.services.DebuggerPlatformService;
import ghidra.app.services.DebuggerTargetService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.NavigationHistoryService;
import ghidra.async.AsyncConfigFieldCodec;
import ghidra.async.AsyncReference;
import ghidra.async.AsyncTimer;
import ghidra.async.AsyncUtils;
import ghidra.async.SwingExecutorService;
import ghidra.dbg.target.TargetObject;
import ghidra.debug.api.control.ControlMode;
import ghidra.debug.api.platform.DebuggerPlatformMapper;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.target.TargetPublicationListener;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.main.DataTreeDialogType;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.TransactionInfo;
import ghidra.framework.model.TransactionListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoConfigStateField;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.lifecycle.Internal;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceClosedException;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.program.TraceVariableSnapProgramView;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.HTMLUtilities;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.TriConsumer;
import ghidra.util.VersionExceptionHandler;
import ghidra.util.database.DomainObjectLockHold;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@PluginInfo(shortDescription="Debugger Trace Management Plugin", description="Manages the set of open traces, current views, etc.", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsProduced={TraceOpenedPluginEvent.class, TraceActivatedPluginEvent.class, TraceInactiveCoordinatesPluginEvent.class, TraceClosedPluginEvent.class}, eventsConsumed={TraceActivatedPluginEvent.class, TraceClosedPluginEvent.class, DebuggerPlatformPluginEvent.class}, servicesRequired={}, servicesProvided={DebuggerTraceManagerService.class})
public class DebuggerTraceManagerServicePlugin
extends Plugin
implements DebuggerTraceManagerService {
    private static final AutoConfigState.ClassHandler<DebuggerTraceManagerServicePlugin> CONFIG_STATE_HANDLER = AutoConfigState.wireHandler(DebuggerTraceManagerServicePlugin.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String KEY_TRACE_COUNT = "NUM_TRACES";
    private static final String PREFIX_OPEN_TRACE = "OPEN_TRACE_";
    private static final String KEY_CURRENT_COORDS = "CURRENT_COORDS";
    public static final String NEW_TRACES_FOLDER_NAME = "New Traces";
    protected final Map<Trace, LastCoords> lastCoordsByTrace = new WeakHashMap<Trace, LastCoords>();
    protected final Map<Trace, ListenerForTraceChanges> listenersByTrace = new WeakHashMap<Trace, ListenerForTraceChanges>();
    protected final Set<Trace> tracesView = Collections.unmodifiableSet(this.listenersByTrace.keySet());
    private final ForTargetsListener forTargetsListener = new ForTargetsListener();
    private final ForFollowPresentListener forFollowPresentListener = new ForFollowPresentListener();
    protected DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    protected TargetObject curObj;
    @AutoConfigStateField(codec=AsyncConfigFieldCodec.BooleanAsyncConfigFieldCodec.class)
    protected final AsyncReference<Boolean, Void> saveTracesByDefault = new AsyncReference((Object)true);
    @AutoConfigStateField(codec=AsyncConfigFieldCodec.BooleanAsyncConfigFieldCodec.class)
    protected final AsyncReference<Boolean, Void> autoCloseOnTerminate = new AsyncReference((Object)true);
    protected boolean ensureActiveTrace = true;
    private DebuggerTargetService targetService;
    @AutoServiceConsumed
    private DebuggerEmulationService emulationService;
    @AutoServiceConsumed
    private DebuggerPlatformService platformService;
    private DebuggerControlService controlService;
    @AutoServiceConsumed
    private NavigationHistoryService navigationHistoryService;
    private final AutoService.Wiring autoServiceWiring;
    DockingAction actionCloseTrace;
    DockingAction actionCloseAllTraces;
    DockingAction actionCloseOtherTraces;
    DockingAction actionCloseDeadTraces;
    DockingAction actionSaveTrace;
    DockingAction actionOpenTrace;
    ToggleDockingAction actionSaveByDefault;
    ToggleDockingAction actionCloseOnTerminate;
    Set<Object> strongRefs = new HashSet<Object>();
    protected static final String MSGPAT_TERMINATE = "<html>\n  <body width=\"300px\">\n    <p>This will terminate the following targets:</p>\n    <ul>\n      %s\n    </ul>\n    <p>Proceed?</p>\n  </body>\n</html>\n";

    public DebuggerTraceManagerServicePlugin(PluginTool plugintool) {
        super(plugintool);
        this.autoServiceWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);
    }

    private <T> T strongRef(T t) {
        this.strongRefs.add(t);
        return t;
    }

    protected void init() {
        super.init();
        this.createActions();
    }

    protected void createActions() {
        this.actionSaveTrace = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.SaveTraceAction.builder(this).enabledWhen(c -> this.current.getTrace() != null)).onAction(this::activatedSaveTrace)).buildAndInstall((Tool)this.tool);
        this.actionOpenTrace = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.OpenTraceAction.builder(this).enabledWhen(ctx -> true)).onAction(this::activatedOpenTrace)).buildAndInstall((Tool)this.tool);
        this.actionCloseTrace = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.CloseTraceAction.builder(this).enabledWhen(ctx -> this.current.getTrace() != null)).onAction(this::activatedCloseTrace)).buildAndInstall((Tool)this.tool);
        this.actionCloseAllTraces = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.CloseAllTracesAction.builder(this).enabledWhen(ctx -> !this.tracesView.isEmpty())).onAction(this::activatedCloseAllTraces)).buildAndInstall((Tool)this.tool);
        this.actionCloseOtherTraces = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.CloseOtherTracesAction.builder(this).enabledWhen(ctx -> this.tracesView.size() > 1 && this.current.getTrace() != null)).onAction(this::activatedCloseOtherTraces)).buildAndInstall((Tool)this.tool);
        this.actionCloseDeadTraces = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.CloseDeadTracesAction.builder(this).enabledWhen(ctx -> !this.tracesView.isEmpty() && this.targetService != null)).onAction(this::activatedCloseDeadTraces)).buildAndInstall((Tool)this.tool);
        this.actionSaveByDefault = (ToggleDockingAction)((ToggleActionBuilder)DebuggerResources.SaveByDefaultAction.builder(this).selected(this.isSaveTracesByDefault()).onAction(c -> this.setSaveTracesByDefault(this.actionSaveByDefault.isSelected()))).buildAndInstall((Tool)this.tool);
        this.addSaveTracesByDefaultChangeListener(this.strongRef(new DebuggerResources.ToToggleSelectionListener(this.actionSaveByDefault)));
        this.actionCloseOnTerminate = (ToggleDockingAction)((ToggleActionBuilder)DebuggerResources.CloseOnTerminateAction.builder(this).selected(this.isAutoCloseOnTerminate()).onAction(c -> this.setAutoCloseOnTerminate(this.actionCloseOnTerminate.isSelected()))).buildAndInstall((Tool)this.tool);
        this.addAutoCloseOnTerminateChangeListener(this.strongRef(new DebuggerResources.ToToggleSelectionListener(this.actionCloseOnTerminate)));
    }

    private void activatedSaveTrace(ActionContext ctx) {
        Trace trace = this.current.getTrace();
        if (trace == null) {
            return;
        }
        this.saveTrace(trace);
    }

    private void activatedOpenTrace(ActionContext ctx) {
        DomainFile df = this.askTrace(this.current.getTrace());
        if (df != null) {
            Trace trace = this.openTrace(df, -1);
            this.activateTrace(trace);
        }
    }

    private void activatedCloseTrace(ActionContext ctx) {
        Trace trace = this.current.getTrace();
        if (trace == null) {
            return;
        }
        this.closeTrace(trace);
    }

    private void activatedCloseAllTraces(ActionContext ctx) {
        this.closeAllTraces();
    }

    private void activatedCloseOtherTraces(ActionContext ctx) {
        Trace trace = this.current.getTrace();
        if (trace == null) {
            return;
        }
        this.closeOtherTraces(trace);
    }

    private void activatedCloseDeadTraces(ActionContext ctx) {
        this.closeDeadTraces();
    }

    protected DataTreeDialog getTraceChooserDialog() {
        DomainFileFilter filter = new DomainFileFilter(this){

            public boolean accept(DomainFile df) {
                return Trace.class.isAssignableFrom(df.getDomainObjectClass());
            }

            public boolean followLinkedFolders() {
                return false;
            }
        };
        return new DataTreeDialog(null, "Open Trace", DataTreeDialogType.OPEN, filter);
    }

    public DomainFile askTrace(Trace trace) {
        DataTreeDialog dialog = this.getTraceChooserDialog();
        if (trace != null) {
            dialog.selectDomainFile(trace.getDomainFile());
        }
        this.tool.showDialog((DialogComponentProvider)dialog);
        return dialog.getDomainFile();
    }

    public void closeAllTraces() {
        this.checkCloseTraces(this.getOpenTraces(), false);
    }

    public void closeOtherTraces(Trace keep) {
        this.checkCloseTraces(this.getOpenTraces().stream().filter(t -> t != keep).toList(), false);
    }

    public void closeDeadTraces() {
        this.checkCloseTraces(this.targetService == null ? this.getOpenTraces() : this.getOpenTraces().stream().filter(t -> this.targetService.getTarget(t) == null).toList(), false);
    }

    @AutoServiceConsumed
    private void setTargetService(DebuggerTargetService targetService) {
        if (this.targetService != null) {
            this.targetService.removeTargetPublicationListener((TargetPublicationListener)this.forTargetsListener);
        }
        this.targetService = targetService;
        if (this.targetService != null) {
            this.targetService.addTargetPublicationListener((TargetPublicationListener)this.forTargetsListener);
        }
    }

    @AutoServiceConsumed
    private void setControlService(DebuggerControlService editingService) {
        if (this.controlService != null) {
            this.controlService.removeModeChangeListener((DebuggerControlService.ControlModeChangeListener)this.forFollowPresentListener);
        }
        this.controlService = editingService;
        if (this.controlService != null) {
            this.controlService.addModeChangeListener((DebuggerControlService.ControlModeChangeListener)this.forFollowPresentListener);
        }
    }

    public Class<?>[] getSupportedDataTypes() {
        return new Class[]{Trace.class};
    }

    public boolean acceptData(DomainFile[] data) {
        if (data == null || data.length == 0) {
            return false;
        }
        List<DomainFile> toOpen = Stream.of(data).filter(f -> f != null && Trace.class.isAssignableFrom(f.getDomainObjectClass())).collect(Collectors.toList());
        Collection<Trace> openTraces = this.openTraces(toOpen);
        if (!openTraces.isEmpty()) {
            this.activateTrace(openTraces.iterator().next());
            return true;
        }
        return false;
    }

    protected boolean supportsFocus(Target target) {
        return target != null && target.isSupportsFocus();
    }

    protected DebuggerCoordinates fillInTarget(Trace trace, DebuggerCoordinates coordinates) {
        if (trace == null) {
            return DebuggerCoordinates.NOWHERE;
        }
        if (coordinates.getTarget() != null) {
            return coordinates;
        }
        Target target = this.computeTarget(trace);
        if (target == null) {
            return coordinates;
        }
        return coordinates.target(target);
    }

    protected DebuggerCoordinates fillInPlatform(DebuggerCoordinates coordinates) {
        if (this.platformService == null || coordinates.getTrace() == null) {
            return coordinates;
        }
        DebuggerPlatformMapper mapper = this.platformService.getMapper(coordinates.getTrace(), coordinates.getObject(), coordinates.getSnap());
        if (mapper == null) {
            return coordinates;
        }
        TracePlatform platform = this.getPlatformForMapper(coordinates.getTrace(), coordinates.getObject(), mapper);
        return coordinates.platform(platform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doSetCurrent(DebuggerCoordinates newCurrent) {
        Map<Trace, ListenerForTraceChanges> map = this.listenersByTrace;
        synchronized (map) {
            if (this.current.equals((Object)newCurrent)) {
                return false;
            }
            this.current = newCurrent;
            if (newCurrent.getTrace() != null) {
                this.lastCoordsByTrace.put(newCurrent.getTrace(), new LastCoords(newCurrent));
            }
        }
        this.contextChanged();
        return true;
    }

    protected DebuggerCoordinates fixAndSetCurrent(DebuggerCoordinates newCurrent, DebuggerTraceManagerService.ActivationCause cause) {
        Target target;
        newCurrent = newCurrent == null ? DebuggerCoordinates.NOWHERE : newCurrent;
        newCurrent = this.fillInTarget(newCurrent.getTrace(), newCurrent);
        newCurrent = this.fillInPlatform(newCurrent);
        if ((cause == DebuggerTraceManagerService.ActivationCause.START_RECORDING || cause == DebuggerTraceManagerService.ActivationCause.FOLLOW_PRESENT) && (target = newCurrent.getTarget()) != null) {
            newCurrent = newCurrent.snap(target.getSnap());
        }
        if ((newCurrent = this.validateCoordiantes(newCurrent, cause)) == null || !this.doSetCurrent(newCurrent)) {
            return null;
        }
        return newCurrent;
    }

    protected void contextChanged() {
        Trace trace = this.current.getTrace();
        String itemName = trace == null ? "..." : trace.getName();
        this.actionCloseTrace.getMenuBarData().setMenuItemName("Close " + itemName);
        this.actionSaveTrace.getMenuBarData().setMenuItemName("Save " + itemName);
        this.tool.contextChanged(null);
    }

    private ControlMode getEffectiveControlMode(Trace trace) {
        if (trace == null) {
            return ControlMode.RO_TRACE;
        }
        return this.controlService == null ? ControlMode.DEFAULT : this.controlService.getCurrentMode(trace);
    }

    private DebuggerCoordinates validateCoordiantes(DebuggerCoordinates coordinates, DebuggerTraceManagerService.ActivationCause cause) {
        ControlMode mode = this.getEffectiveControlMode(coordinates.getTrace());
        return mode.validateCoordinates(this.tool, coordinates, cause);
    }

    private boolean isFollowsPresent(Trace trace) {
        ControlMode mode = this.getEffectiveControlMode(trace);
        return mode.followsPresent();
    }

    protected TracePlatform getPlatformForMapper(Trace trace, TraceObject object, DebuggerPlatformMapper mapper) {
        return trace.getPlatformManager().getPlatform(mapper.getCompilerSpec(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPlatformMapperSelected(Trace trace, DebuggerPlatformMapper mapper) {
        Map<Trace, ListenerForTraceChanges> map = this.listenersByTrace;
        synchronized (map) {
            if (!this.listenersByTrace.containsKey(trace)) {
                return;
            }
            LastCoords cur = this.lastCoordsByTrace.getOrDefault(trace, LastCoords.NEVER);
            DebuggerCoordinates adj = cur.coords.platform(this.getPlatformForMapper(trace, cur.coords.getObject(), mapper));
            this.lastCoordsByTrace.put(trace, cur.keepTime(adj));
            if (trace == this.current.getTrace()) {
                this.current = adj;
                this.fireLocationEvent(adj, DebuggerTraceManagerService.ActivationCause.MAPPER_CHANGED);
            }
        }
    }

    protected Target computeTarget(Trace trace) {
        if (this.targetService == null) {
            return null;
        }
        if (trace == null) {
            return null;
        }
        return this.targetService.getTarget(trace);
    }

    protected void updateCurrentTarget() {
        Target target = this.computeTarget(this.current.getTrace());
        if (target == null) {
            return;
        }
        DebuggerCoordinates toActivate = this.current.target(target);
        this.activate(toActivate, DebuggerTraceManagerService.ActivationCause.FOLLOW_PRESENT);
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof TraceActivatedPluginEvent) {
            TraceActivatedPluginEvent ev = (TraceActivatedPluginEvent)event;
            this.fixAndSetCurrent(ev.getActiveCoordinates(), ev.getCause());
        } else if (event instanceof TraceClosedPluginEvent) {
            TraceClosedPluginEvent ev = (TraceClosedPluginEvent)event;
            this.doTraceClosed(ev.getTrace());
        } else if (event instanceof DebuggerPlatformPluginEvent) {
            DebuggerPlatformPluginEvent ev = (DebuggerPlatformPluginEvent)event;
            this.doPlatformMapperSelected(ev.getTrace(), ev.getMapper());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<Trace> getOpenTraces() {
        Map<Trace, ListenerForTraceChanges> map = this.listenersByTrace;
        synchronized (map) {
            return Set.copyOf(this.tracesView);
        }
    }

    public DebuggerCoordinates getCurrent() {
        return this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerCoordinates getCurrentFor(Trace trace) {
        Map<Trace, ListenerForTraceChanges> map = this.listenersByTrace;
        synchronized (map) {
            return this.fillInTarget(trace, this.lastCoordsByTrace.getOrDefault((Object)trace, (LastCoords)LastCoords.NEVER).coords);
        }
    }

    public Trace getCurrentTrace() {
        return this.current.getTrace();
    }

    public TracePlatform getCurrentPlatform() {
        return this.current.getPlatform();
    }

    public TraceProgramView getCurrentView() {
        return this.current.getView();
    }

    public TraceThread getCurrentThread() {
        return this.current.getThread();
    }

    public long getCurrentSnap() {
        return this.current.getSnap();
    }

    public int getCurrentFrame() {
        return this.current.getFrame();
    }

    public TraceObject getCurrentObject() {
        return this.current.getObject();
    }

    public Long findSnapshot(DebuggerCoordinates coordinates) {
        if (coordinates.getTime().isSnapOnly()) {
            return coordinates.getSnap();
        }
        Trace trace = coordinates.getTrace();
        long version = trace.getEmulatorCacheVersion();
        for (TraceSnapshot snapshot : trace.getTimeManager().getSnapshotsWithSchedule(coordinates.getTime())) {
            if (snapshot.getVersion() < version) continue;
            return snapshot.getKey();
        }
        return null;
    }

    public CompletableFuture<Long> materialize(DebuggerCoordinates coordinates) {
        Long found = this.findSnapshot(coordinates);
        if (found != null) {
            return CompletableFuture.completedFuture(found);
        }
        if (this.emulationService == null) {
            throw new IllegalStateException("Cannot navigate to coordinates with execution schedules, because the emulation service is not available.");
        }
        return this.emulationService.backgroundEmulate(coordinates.getPlatform(), coordinates.getTime());
    }

    protected CompletableFuture<Void> prepareViewAndFireEvent(DebuggerCoordinates coordinates, DebuggerTraceManagerService.ActivationCause cause) {
        TraceVariableSnapProgramView varView = (TraceVariableSnapProgramView)coordinates.getView();
        if (varView == null) {
            this.fireLocationEvent(coordinates, cause);
            return AsyncUtils.nil();
        }
        return this.materialize(coordinates).thenAcceptAsync(snap -> {
            if (!coordinates.equals((Object)this.current)) {
                return;
            }
            varView.setSnap(snap.longValue());
            this.fireLocationEvent(coordinates, cause);
        }, (Executor)(cause == DebuggerTraceManagerService.ActivationCause.EMU_STATE_EDIT ? SwingExecutorService.MAYBE_NOW : SwingExecutorService.LATER));
    }

    protected void fireLocationEvent(DebuggerCoordinates coordinates, DebuggerTraceManagerService.ActivationCause cause) {
        this.firePluginEvent(new TraceActivatedPluginEvent(this.getName(), coordinates, cause));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openTrace(Trace trace) {
        if (trace.getConsumerList().contains((Object)this)) {
            return;
        }
        trace.addConsumer((Object)this);
        Map<Trace, ListenerForTraceChanges> map = this.listenersByTrace;
        synchronized (map) {
            if (this.listenersByTrace.containsKey(trace)) {
                return;
            }
            ListenerForTraceChanges listener = new ListenerForTraceChanges(trace);
            this.listenersByTrace.put(trace, listener);
            trace.addListener((DomainObjectListener)listener);
        }
        this.contextChanged();
        this.firePluginEvent(new TraceOpenedPluginEvent(this.getName(), trace));
    }

    public Trace openTrace(DomainFile file, int version) {
        try {
            return this.doOpenTrace(file, version, new Object(), TaskMonitor.DUMMY);
        }
        catch (CancelledException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Trace doOpenTrace(DomainFile file, int version, Object consumer, TaskMonitor monitor) throws CancelledException {
        DomainObject obj = null;
        try {
            obj = version == -1 ? file.getDomainObject(consumer, true, true, monitor) : file.getReadOnlyDomainObject(consumer, version, monitor);
            Trace trace = (Trace)obj;
            this.openTrace(trace);
            Trace trace2 = trace;
            return trace2;
        }
        catch (VersionException e) {
            e = new VersionException(e.getVersionIndicator(), false).combine(e);
            VersionExceptionHandler.showVersionError(null, (String)file.getName(), (String)file.getContentType(), (String)"Open", (VersionException)e);
            Trace trace = null;
            return trace;
        }
        catch (IOException e) {
            if (file.isInWritableProject()) {
                ClientUtil.handleException((RepositoryAdapter)this.tool.getProject().getRepository(), (Exception)e, (String)"Open Trace", null);
            } else {
                Msg.showError((Object)((Object)this), null, (String)"Error Opening Trace", (Object)("Could not open " + file.getName()), (Throwable)e);
            }
            Trace trace = null;
            return trace;
        }
        finally {
            if (obj != null) {
                obj.release(consumer);
            }
        }
    }

    public Collection<Trace> openTraces(final Collection<DomainFile> files) {
        final ArrayList<Trace> result = new ArrayList<Trace>();
        new TaskLauncher(new Task("Open Traces", true, true, true){

            public void run(TaskMonitor monitor) throws CancelledException {
                for (DomainFile f : files) {
                    try {
                        result.add(DebuggerTraceManagerServicePlugin.this.doOpenTrace(f, -1, (Object)this, monitor));
                    }
                    catch (ClassCastException e) {
                        Msg.error((Object)((Object)this), (Object)("Attempted to open non-Trace domain file: " + String.valueOf(f)));
                    }
                }
            }
        });
        return result;
    }

    public static DomainFolder createOrGetFolder(PluginTool tool, String operation, DomainFolder parent, String name) throws InvalidNameException {
        try {
            return parent.createFolder(name);
        }
        catch (DuplicateFileException e) {
            return parent.getFolder(name);
        }
        catch (NotConnectedException | ConnectException e) {
            ClientUtil.promptForReconnect((RepositoryAdapter)tool.getProject().getRepository(), (Component)tool.getToolFrame());
            return null;
        }
        catch (IOException e) {
            ClientUtil.handleException((RepositoryAdapter)tool.getProject().getRepository(), (Exception)e, (String)operation, (Component)tool.getToolFrame());
            return null;
        }
    }

    protected static DomainObjectLockHold maybeLock(Trace trace, boolean lock) {
        if (!lock) {
            return null;
        }
        return DomainObjectLockHold.forceLock((DomainObject)trace, (boolean)false, (String)"Auto Save");
    }

    public static CompletableFuture<Void> saveTrace(final PluginTool tool, final Trace trace, final boolean force) {
        tool.prepareToSave((DomainObject)trace);
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (trace.getDomainFile().getParent() != null) {
            new TaskLauncher(new Task("Save Trace", true, true, true){

                public void run(TaskMonitor monitor) throws CancelledException {
                    try (DomainObjectLockHold hold = DebuggerTraceManagerServicePlugin.maybeLock(trace, force);){
                        trace.getDomainFile().save(monitor);
                        future.complete(null);
                    }
                    catch (CancelledException e) {
                        future.completeExceptionally(e);
                    }
                    catch (NotConnectedException | ConnectException e) {
                        ClientUtil.promptForReconnect((RepositoryAdapter)tool.getProject().getRepository(), (Component)tool.getToolFrame());
                        future.completeExceptionally(e);
                    }
                    catch (IOException e) {
                        ClientUtil.handleException((RepositoryAdapter)tool.getProject().getRepository(), (Exception)e, (String)"Save Trace", (Component)tool.getToolFrame());
                        future.completeExceptionally(e);
                    }
                    catch (Throwable e) {
                        future.completeExceptionally(e);
                    }
                }
            });
        } else {
            DomainFolder traces;
            DomainFolder root = tool.getProject().getProjectData().getRootFolder();
            try {
                traces = DebuggerTraceManagerServicePlugin.createOrGetFolder(tool, "Save New Trace", root, NEW_TRACES_FOLDER_NAME);
            }
            catch (InvalidNameException e) {
                throw new AssertionError((Object)e);
            }
            new TaskLauncher(new Task("Save New Trace", true, true, true){

                public void run(TaskMonitor monitor) throws CancelledException {
                    Object filename = trace.getName();
                    try (DomainObjectLockHold hold = DebuggerTraceManagerServicePlugin.maybeLock(trace, force);){
                        int i = 1;
                        while (true) {
                            try {
                                traces.createFile((String)filename, (DomainObject)trace, monitor);
                            }
                            catch (DuplicateFileException e) {
                                filename = trace.getName() + "." + i;
                                ++i;
                                continue;
                            }
                            break;
                        }
                        trace.save("Initial save", monitor);
                        future.complete(null);
                    }
                    catch (CancelledException e) {
                        future.completeExceptionally(e);
                    }
                    catch (NotConnectedException | ConnectException e) {
                        ClientUtil.promptForReconnect((RepositoryAdapter)tool.getProject().getRepository(), (Component)tool.getToolFrame());
                        future.completeExceptionally(e);
                    }
                    catch (IOException e) {
                        ClientUtil.handleException((RepositoryAdapter)tool.getProject().getRepository(), (Exception)e, (String)"Save New Trace", (Component)tool.getToolFrame());
                        future.completeExceptionally(e);
                    }
                    catch (InvalidNameException e) {
                        Msg.showError(DebuggerTraceManagerServicePlugin.class, null, (String)"Save New Trace Error", (Object)e.getMessage());
                        future.completeExceptionally(e);
                    }
                    catch (Throwable e) {
                        Msg.showError(DebuggerTraceManagerServicePlugin.class, null, (String)"Save New Trace Error", (Object)e.getMessage(), (Throwable)e);
                        future.completeExceptionally(e);
                    }
                }
            });
        }
        return future;
    }

    public CompletableFuture<Void> saveTrace(Trace trace, boolean force) {
        if (this.isDisposed()) {
            Msg.error((Object)((Object)this), (Object)"Cannot save trace after manager disposal! Data may have been lost.");
            return AsyncUtils.nil();
        }
        return DebuggerTraceManagerServicePlugin.saveTrace(this.tool, trace, force);
    }

    public CompletableFuture<Void> saveTrace(Trace trace) {
        return this.saveTrace(trace, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTraceClosed(Trace trace) {
        if (this.navigationHistoryService != null) {
            this.navigationHistoryService.clear((Program)trace.getProgramView());
        }
        Map<Trace, ListenerForTraceChanges> map = this.listenersByTrace;
        synchronized (map) {
            this.lastCoordsByTrace.remove(trace);
            trace.removeListener((DomainObjectListener)this.listenersByTrace.remove(trace));
        }
        try {
            if (this.current.getTrace() == trace) {
                this.activate(DebuggerCoordinates.NOWHERE, DebuggerTraceManagerService.ActivationCause.ACTIVATE_DEFAULT);
            } else {
                this.contextChanged();
            }
        }
        finally {
            trace.release((Object)this);
        }
    }

    protected void doCloseTraces(Collection<Trace> traces, Collection<Target> targets) {
        for (Trace t : traces) {
            if (!t.getConsumerList().contains((Object)this)) continue;
            this.doTraceClosed(t);
            this.firePluginEvent(new TraceClosedPluginEvent(this.getName(), t));
        }
        TargetActionTask.executeTask(this.tool, new DisconnectTask(this.tool, targets));
    }

    protected static String formatTargets(Collection<Target> targets) {
        return targets.stream().map(t -> "<li>%s</li>".formatted(HTMLUtilities.escapeHTML((String)t.describe()))).sorted().collect(Collectors.joining("\n"));
    }

    protected void checkCloseTraces(Collection<Trace> traces, boolean noConfirm) {
        List<Target> live = traces.stream().map(t -> this.targetService.getTarget(t)).filter(t -> t != null).toList();
        Swing.runIfSwingOrRunLater(() -> {
            if (live.isEmpty() || noConfirm) {
                this.doCloseTraces(traces, live);
                return;
            }
            String msg = MSGPAT_TERMINATE.formatted(DebuggerTraceManagerServicePlugin.formatTargets(live));
            int response = OptionDialog.showYesNoDialog(null, (String)"Terminate", (String)msg);
            switch (response) {
                case 1: {
                    this.doCloseTraces(traces, live);
                    break;
                }
                case 2: {
                    List.of();
                }
            }
        });
    }

    public void closeTrace(Trace trace) {
        this.checkCloseTraces(List.of(trace), false);
    }

    public void closeTraceNoConfirm(Trace trace) {
        this.checkCloseTraces(List.of(trace), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        super.dispose();
        this.activate(DebuggerCoordinates.NOWHERE, DebuggerTraceManagerService.ActivationCause.ACTIVATE_DEFAULT);
        Map<Trace, ListenerForTraceChanges> map = this.listenersByTrace;
        synchronized (map) {
            Iterator<Trace> it = this.listenersByTrace.keySet().iterator();
            while (it.hasNext()) {
                Trace trace = it.next();
                trace.release((Object)this);
                this.lastCoordsByTrace.remove(trace);
                trace.removeListener((DomainObjectListener)this.listenersByTrace.get(trace));
                it.remove();
            }
            this.lastCoordsByTrace.clear();
        }
        this.autoServiceWiring.dispose();
    }

    @Internal
    private String stackTraceUp(int levels) {
        StackTraceElement elem = new Throwable().getStackTrace()[levels += 2];
        return elem.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DebuggerCoordinates getMostRecentCoordinates() {
        Map<Trace, ListenerForTraceChanges> map = this.listenersByTrace;
        synchronized (map) {
            return this.lastCoordsByTrace.values().stream().sorted(Comparator.comparing(l -> -l.time.longValue())).findFirst().map(l -> l.coords).orElse(DebuggerCoordinates.NOWHERE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> activateAndNotify(DebuggerCoordinates coordinates, DebuggerTraceManagerService.ActivationCause cause) {
        Trace newTrace = coordinates.getTrace();
        Map<Trace, ListenerForTraceChanges> map = this.listenersByTrace;
        synchronized (map) {
            if (newTrace != null && !this.listenersByTrace.containsKey(newTrace)) {
                if (cause == DebuggerTraceManagerService.ActivationCause.FOLLOW_PRESENT) {
                    Msg.error((Object)((Object)this), (Object)"Ignoring activation because FOLLOW_PRESENT for non-opened trace");
                    return AsyncUtils.nil();
                }
                throw new IllegalStateException("Trace must be opened before activated: " + String.valueOf(newTrace));
            }
            if (newTrace == null && this.ensureActiveTrace) {
                coordinates = this.getMostRecentCoordinates();
            }
        }
        if (cause == DebuggerTraceManagerService.ActivationCause.FOLLOW_PRESENT) {
            if (!this.isFollowsPresent(newTrace)) {
                return AsyncUtils.nil();
            }
            if (this.current.getTrace() != newTrace) {
                try {
                    newTrace.getProgramView().setSnap(coordinates.getViewSnap());
                }
                catch (TraceClosedException e) {
                    Msg.warn((Object)((Object)this), (Object)("Ignoring time activation for closed trace: " + String.valueOf((Object)e)));
                }
                this.firePluginEvent(new TraceInactiveCoordinatesPluginEvent(this.getName(), coordinates));
                return AsyncUtils.nil();
            }
        }
        DebuggerCoordinates prev = this.current;
        DebuggerCoordinates resolved = this.fixAndSetCurrent(coordinates, cause);
        if (resolved == null) {
            return AsyncUtils.nil();
        }
        CompletionStage future = this.prepareViewAndFireEvent(resolved, cause).exceptionally(ex -> {
            this.doSetCurrent(prev);
            return null;
        });
        if (cause != DebuggerTraceManagerService.ActivationCause.USER) {
            return future;
        }
        Target target = resolved.getTarget();
        if (target == null) {
            return future;
        }
        return ((CompletableFuture)future).thenCompose(__ -> target.activateAsync(prev, resolved));
    }

    public void activate(DebuggerCoordinates coordinates, DebuggerTraceManagerService.ActivationCause cause) {
        this.activateAndNotify(coordinates, cause);
    }

    public DebuggerCoordinates resolveTrace(Trace trace) {
        return this.getCurrentFor(trace).trace(trace);
    }

    public DebuggerCoordinates resolveTarget(Target target) {
        Trace trace = target == null ? null : target.getTrace();
        return this.getCurrentFor(trace).target(target).snap(target.getSnap());
    }

    public DebuggerCoordinates resolvePlatform(TracePlatform platform) {
        Trace trace = platform == null ? null : platform.getTrace();
        return this.getCurrentFor(trace).platform(platform);
    }

    public DebuggerCoordinates resolveThread(TraceThread thread) {
        Trace trace = thread == null ? null : thread.getTrace();
        return this.getCurrentFor(trace).thread(thread);
    }

    public DebuggerCoordinates resolveSnap(long snap) {
        return this.current.snap(snap);
    }

    public DebuggerCoordinates resolveTime(TraceSchedule time) {
        return this.current.time(time);
    }

    public DebuggerCoordinates resolveView(TraceProgramView view) {
        Trace trace = view == null ? null : view.getTrace();
        return this.getCurrentFor(trace).view(view);
    }

    public DebuggerCoordinates resolveFrame(int frameLevel) {
        return this.current.frame(frameLevel);
    }

    public DebuggerCoordinates resolvePath(TraceObjectKeyPath path) {
        return this.current.path(path);
    }

    public DebuggerCoordinates resolveObject(TraceObject object) {
        return this.current.object(object);
    }

    public void setSaveTracesByDefault(boolean enabled) {
        this.saveTracesByDefault.set((Object)enabled, null);
    }

    public boolean isSaveTracesByDefault() {
        return (Boolean)this.saveTracesByDefault.get();
    }

    public void addSaveTracesByDefaultChangeListener(DebuggerTraceManagerService.BooleanChangeAdapter listener) {
        this.saveTracesByDefault.addChangeListener((TriConsumer)listener);
    }

    public void removeSaveTracesByDefaultChangeListener(DebuggerTraceManagerService.BooleanChangeAdapter listener) {
        this.saveTracesByDefault.removeChangeListener((TriConsumer)listener);
    }

    public void setAutoCloseOnTerminate(boolean enabled) {
        this.autoCloseOnTerminate.set((Object)enabled, null);
    }

    public boolean isAutoCloseOnTerminate() {
        return (Boolean)this.autoCloseOnTerminate.get();
    }

    public void addAutoCloseOnTerminateChangeListener(DebuggerTraceManagerService.BooleanChangeAdapter listener) {
        this.autoCloseOnTerminate.addChangeListener((TriConsumer)listener);
    }

    public void removeAutoCloseOnTerminateChangeListener(DebuggerTraceManagerService.BooleanChangeAdapter listener) {
        this.autoCloseOnTerminate.removeChangeListener((TriConsumer)listener);
    }

    public boolean canClose() {
        if (this.isSaveTracesByDefault()) {
            for (Trace trace : this.tracesView) {
                ProjectLocator loc = trace.getDomainFile().getProjectLocator();
                if (loc != null && !loc.isTransient()) continue;
                this.saveTrace(trace);
            }
        }
        return true;
    }

    public void writeConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.writeConfigState((Object)this, saveState);
    }

    public void readConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.readConfigState((Object)this, saveState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDataState(SaveState saveState) {
        Map<Trace, DebuggerCoordinates> coordsByTrace;
        List<Trace> traces;
        DebuggerCoordinates currentCoords;
        if (!this.isSaveTracesByDefault()) {
            return;
        }
        Map<Trace, ListenerForTraceChanges> map = this.listenersByTrace;
        synchronized (map) {
            currentCoords = this.current;
            traces = this.tracesView.stream().filter(t -> {
                ProjectLocator loc = t.getDomainFile().getProjectLocator();
                return loc != null && !loc.isTransient();
            }).sorted(Comparator.comparingLong(t -> {
                LastCoords last = this.lastCoordsByTrace.get(t);
                return last == null ? -1L : last.time;
            })).toList();
            coordsByTrace = this.lastCoordsByTrace.entrySet().stream().collect(Collectors.toMap(e -> (Trace)e.getKey(), e -> ((LastCoords)e.getValue()).coords));
        }
        saveState.putInt(KEY_TRACE_COUNT, traces.size());
        for (int index = 0; index < traces.size(); ++index) {
            Trace t2 = traces.get(index);
            DebuggerCoordinates coords = coordsByTrace.get(t2);
            String stateName = PREFIX_OPEN_TRACE + index;
            coords.writeDataState(this.tool, saveState, stateName);
        }
        currentCoords.writeDataState(this.tool, saveState, KEY_CURRENT_COORDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDataState(SaveState saveState) {
        Map<Trace, ListenerForTraceChanges> map = this.listenersByTrace;
        synchronized (map) {
            long baseTime = System.currentTimeMillis();
            int traceCount = saveState.getInt(KEY_TRACE_COUNT, 0);
            for (int index = 0; index < traceCount; ++index) {
                String stateName = PREFIX_OPEN_TRACE + index;
                DebuggerCoordinates coords = DebuggerCoordinates.readDataState((PluginTool)this.tool, (SaveState)saveState, (String)stateName);
                if (coords.getTrace() == null) continue;
                this.lastCoordsByTrace.put(coords.getTrace(), new LastCoords(baseTime + (long)index, coords));
            }
        }
        this.activate(DebuggerCoordinates.readDataState((PluginTool)this.tool, (SaveState)saveState, (String)KEY_CURRENT_COORDS), DebuggerTraceManagerService.ActivationCause.RESTORE_STATE);
    }

    class ForTargetsListener
    implements TargetPublicationListener {
        ForTargetsListener() {
        }

        public void targetPublished(Target target) {
            Swing.runLater(() -> DebuggerTraceManagerServicePlugin.this.updateCurrentTarget());
        }

        public CompletableFuture<Void> waitUnlockedDebounced(Target target) {
            Trace trace = target.getTrace();
            return ((CompletableFuture)new TransactionEndFuture(trace).thenCompose(__ -> AsyncTimer.DEFAULT_TIMER.mark().after(100L))).thenComposeAsync(__ -> {
                if (trace.isLocked()) {
                    return this.waitUnlockedDebounced(target);
                }
                return AsyncUtils.nil();
            });
        }

        public void targetWithdrawn(Target target) {
            boolean save = DebuggerTraceManagerServicePlugin.this.isSaveTracesByDefault();
            CompletableFuture<Void> flush = save ? this.waitUnlockedDebounced(target) : AsyncUtils.nil();
            flush.thenRunAsync(() -> {
                DebuggerTraceManagerServicePlugin.this.updateCurrentTarget();
                if (!DebuggerTraceManagerServicePlugin.this.isAutoCloseOnTerminate()) {
                    return;
                }
                Trace trace = target.getTrace();
                Map<Trace, ListenerForTraceChanges> map = DebuggerTraceManagerServicePlugin.this.listenersByTrace;
                synchronized (map) {
                    if (!DebuggerTraceManagerServicePlugin.this.listenersByTrace.containsKey(trace)) {
                        return;
                    }
                }
                if (save) {
                    DebuggerTraceManagerServicePlugin.this.saveTrace(trace);
                }
                DebuggerTraceManagerServicePlugin.this.closeTrace(trace);
            }, AsyncUtils.SWING_EXECUTOR);
        }
    }

    class ForFollowPresentListener
    implements DebuggerControlService.ControlModeChangeListener {
        ForFollowPresentListener() {
        }

        public void modeChanged(Trace trace, ControlMode mode) {
            if (trace != DebuggerTraceManagerServicePlugin.this.current.getTrace() || !mode.followsPresent()) {
                return;
            }
            Target curTarget = DebuggerTraceManagerServicePlugin.this.current.getTarget();
            if (curTarget == null) {
                return;
            }
            DebuggerCoordinates coords = DebuggerTraceManagerServicePlugin.this.current;
            TraceObjectKeyPath focus = curTarget.getFocus();
            if (focus != null) {
                coords = coords.path(focus);
            }
            coords = coords.snap(curTarget.getSnap());
            DebuggerTraceManagerServicePlugin.this.activateAndNotify(coords, DebuggerTraceManagerService.ActivationCause.FOLLOW_PRESENT);
        }
    }

    protected record LastCoords(Long time, DebuggerCoordinates coords) {
        public static final LastCoords NEVER = new LastCoords(null, DebuggerCoordinates.NOWHERE);

        public LastCoords(DebuggerCoordinates coords) {
            this(System.currentTimeMillis(), coords);
        }

        public LastCoords keepTime(DebuggerCoordinates adjusted) {
            return new LastCoords(this.time, adjusted);
        }
    }

    class ListenerForTraceChanges
    extends TraceDomainObjectListener {
        private final Trace trace;

        public ListenerForTraceChanges(Trace trace) {
            this.trace = trace;
            this.listenFor((TraceEvent)TraceEvents.THREAD_ADDED, this::threadAdded);
            this.listenFor((TraceEvent)TraceEvents.THREAD_DELETED, this::threadDeleted);
            this.listenFor((TraceEvent)TraceEvents.OBJECT_CREATED, this::objectCreated);
        }

        private void threadAdded(TraceThread thread) {
            Target target = DebuggerTraceManagerServicePlugin.this.current.getTarget();
            if (DebuggerTraceManagerServicePlugin.this.supportsFocus(target)) {
                TraceObjectKeyPath focus = target.getFocus();
                if (focus == null) {
                    return;
                }
                if (thread == target.getThreadForSuccessor(focus)) {
                    DebuggerTraceManagerServicePlugin.this.activate(DebuggerTraceManagerServicePlugin.this.current.thread(thread), DebuggerTraceManagerService.ActivationCause.SYNC_MODEL);
                }
                return;
            }
            if (DebuggerTraceManagerServicePlugin.this.current.getTrace() != this.trace) {
                return;
            }
            if (DebuggerTraceManagerServicePlugin.this.current.getThread() != null) {
                return;
            }
            DebuggerTraceManagerServicePlugin.this.activate(DebuggerTraceManagerServicePlugin.this.current.thread(thread), DebuggerTraceManagerService.ActivationCause.ACTIVATE_DEFAULT);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void threadDeleted(TraceThread thread) {
            Map<Trace, ListenerForTraceChanges> map = DebuggerTraceManagerServicePlugin.this.listenersByTrace;
            synchronized (map) {
                LastCoords last = DebuggerTraceManagerServicePlugin.this.lastCoordsByTrace.get(this.trace);
                if (last != null && last.coords.getThread() == thread) {
                    DebuggerTraceManagerServicePlugin.this.lastCoordsByTrace.remove(this.trace);
                }
            }
            if (DebuggerTraceManagerServicePlugin.this.current.getThread() == thread) {
                DebuggerTraceManagerServicePlugin.this.activate(DebuggerTraceManagerServicePlugin.this.current.thread(null), DebuggerTraceManagerService.ActivationCause.ACTIVATE_DEFAULT);
            }
        }

        private void objectCreated(TraceObject object) {
            Target target = DebuggerTraceManagerServicePlugin.this.current.getTarget();
            if (DebuggerTraceManagerServicePlugin.this.supportsFocus(target)) {
                return;
            }
            if (DebuggerTraceManagerServicePlugin.this.current.getTrace() != this.trace) {
                return;
            }
            if (!object.isRoot()) {
                return;
            }
            DebuggerTraceManagerServicePlugin.this.activate(DebuggerTraceManagerServicePlugin.this.current.object(object), DebuggerTraceManagerService.ActivationCause.SYNC_MODEL);
        }
    }

    static class TransactionEndFuture
    extends CompletableFuture<Void>
    implements TransactionListener {
        final Trace trace;

        public TransactionEndFuture(Trace trace) {
            this.trace = trace;
            this.trace.addTransactionListener((TransactionListener)this);
            if (this.trace.getCurrentTransactionInfo() == null) {
                this.complete(null);
            }
        }

        public void transactionStarted(DomainObjectAdapterDB domainObj, TransactionInfo tx) {
        }

        @Override
        public boolean complete(Void value) {
            this.trace.removeTransactionListener((TransactionListener)this);
            return super.complete(value);
        }

        public void transactionEnded(DomainObjectAdapterDB domainObj) {
            this.complete(null);
        }

        public void undoStackChanged(DomainObjectAdapterDB domainObj) {
        }

        public void undoRedoOccurred(DomainObjectAdapterDB domainObj) {
        }
    }
}

