/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.stack;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Register;

sealed interface Sym {
    public static Sym opaque() {
        return OpaqueSym.OPAQUE;
    }

    public Sym add(CompilerSpec var1, Sym var2);

    default public Sym sub(CompilerSpec cSpec, Sym in2) {
        return this.add(cSpec, in2.twosComp());
    }

    public Sym twosComp();

    public long sizeOf(CompilerSpec var1);

    public static Sym constant(long value) {
        return new ConstSym(value, 8);
    }

    public Address addressIn(AddressSpace var1, CompilerSpec var2);

    public static enum OpaqueSym implements Sym
    {
        OPAQUE;


        @Override
        public Sym add(CompilerSpec cSpec, Sym in2) {
            return this;
        }

        @Override
        public Sym twosComp() {
            return this;
        }

        @Override
        public long sizeOf(CompilerSpec cSpec) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address addressIn(AddressSpace space, CompilerSpec cSpec) {
            return Address.NO_ADDRESS;
        }
    }

    public record ConstSym(long value, int size) implements Sym
    {
        @Override
        public Sym add(CompilerSpec cSpec, Sym in2) {
            if (in2 instanceof ConstSym) {
                ConstSym const2 = (ConstSym)in2;
                return new ConstSym(this.value + const2.value, this.size);
            }
            if (in2 instanceof RegisterSym) {
                RegisterSym reg2 = (RegisterSym)in2;
                if (reg2.register() == cSpec.getStackPointer()) {
                    return new StackOffsetSym(this.value);
                }
                return Sym.opaque();
            }
            if (in2 instanceof StackOffsetSym) {
                StackOffsetSym off2 = (StackOffsetSym)in2;
                return new StackOffsetSym(this.value + off2.offset);
            }
            return Sym.opaque();
        }

        @Override
        public Sym twosComp() {
            return new ConstSym(-this.value, this.size);
        }

        @Override
        public long sizeOf(CompilerSpec cSpec) {
            return this.size;
        }

        @Override
        public Address addressIn(AddressSpace space, CompilerSpec cSpec) {
            if (space.isConstantSpace() || space.isRegisterSpace() || space.isUniqueSpace()) {
                return space.getAddress(this.value);
            }
            return Address.NO_ADDRESS;
        }
    }

    public record StackDerefSym(long offset, int size) implements Sym
    {
        @Override
        public Sym add(CompilerSpec cSpec, Sym in2) {
            return Sym.opaque();
        }

        @Override
        public Sym twosComp() {
            return Sym.opaque();
        }

        @Override
        public long sizeOf(CompilerSpec cSpec) {
            return this.size;
        }

        @Override
        public Address addressIn(AddressSpace space, CompilerSpec cSpec) {
            return Address.NO_ADDRESS;
        }
    }

    public record StackOffsetSym(long offset) implements Sym
    {
        @Override
        public Sym add(CompilerSpec cSpec, Sym in2) {
            if (in2 instanceof ConstSym) {
                ConstSym const2 = (ConstSym)in2;
                return new StackOffsetSym(this.offset + const2.value());
            }
            return Sym.opaque();
        }

        @Override
        public Sym twosComp() {
            return Sym.opaque();
        }

        @Override
        public long sizeOf(CompilerSpec cSpec) {
            return cSpec.getStackPointer().getMinimumByteSize();
        }

        @Override
        public Address addressIn(AddressSpace space, CompilerSpec cSpec) {
            if (space != cSpec.getStackBaseSpace()) {
                return Address.NO_ADDRESS;
            }
            return cSpec.getStackSpace().getAddress(this.offset);
        }
    }

    public record RegisterSym(Register register) implements Sym
    {
        @Override
        public Sym add(CompilerSpec cSpec, Sym in2) {
            if (in2 instanceof ConstSym) {
                ConstSym const2 = (ConstSym)in2;
                return const2.add(cSpec, this);
            }
            return Sym.opaque();
        }

        @Override
        public Sym twosComp() {
            return Sym.opaque();
        }

        @Override
        public long sizeOf(CompilerSpec cSpec) {
            return this.register.getMinimumByteSize();
        }

        @Override
        public Address addressIn(AddressSpace space, CompilerSpec cSpec) {
            if (this.register != cSpec.getStackPointer()) {
                return Address.NO_ADDRESS;
            }
            if (space != cSpec.getStackBaseSpace()) {
                return Address.NO_ADDRESS;
            }
            return cSpec.getStackSpace().getAddress(0L);
        }
    }
}

