/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.stack;

import ghidra.app.plugin.core.debug.stack.Sym;
import ghidra.app.plugin.core.debug.stack.SymPcodeArithmetic;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.trace.database.DBTraceUtils;
import ghidra.util.Msg;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class SymStateSpace {
    final NavigableMap<Address, SymEntry> map;
    private final ExprMapSetter setter = new ExprMapSetter();

    public SymStateSpace() {
        this.map = new TreeMap<Address, SymEntry>();
    }

    protected SymStateSpace(NavigableMap<Address, SymEntry> map) {
        this.map = map;
    }

    public String toString() {
        return this.toString("", null);
    }

    public String toString(String indent, Language language) {
        return this.map.values().stream().map(se -> se.toString(language)).collect(Collectors.joining("\n" + indent, indent + "{", "\n" + indent + "}"));
    }

    private NavigableMap<Address, SymEntry> subMap(Address lower, Address upper) {
        Map.Entry<Address, SymEntry> adjEnt = this.map.floorEntry(lower);
        if (adjEnt != null && adjEnt.getValue().contains(upper)) {
            lower = adjEnt.getKey();
        }
        return this.map.subMap(lower, true, upper, true);
    }

    public void set(Address address, int size, Sym sym) {
        SymEntry entry;
        try {
            entry = new SymEntry(address, size, sym);
        }
        catch (AddressOverflowException e) {
            throw new AssertionError((Object)e);
        }
        this.setter.set(entry.entRange, entry);
    }

    public Sym get(Address address, int size, SymPcodeArithmetic arithmetic, Language language) {
        AddressRangeImpl range = new AddressRangeImpl(address, address.add((long)(size - 1)));
        Sym result = null;
        Address expectedNext = null;
        for (SymEntry ent : this.subMap(range.getMinAddress(), range.getMaxAddress()).values()) {
            if (ent.entRange.equals((Object)range)) {
                return ent.extract((AddressRange)range, arithmetic);
            }
            AddressRange intersection = range.intersect(ent.entRange);
            if (expectedNext != null && !expectedNext.equals((Object)intersection.getMinAddress())) {
                return Sym.opaque();
            }
            expectedNext = intersection.getMaxAddress().next();
            Sym piece = ent.extract(intersection, arithmetic);
            piece = arithmetic.unaryOp(17, size, (int)intersection.getLength(), piece);
            if (result == null) {
                result = piece;
                continue;
            }
            result = arithmetic.binaryOp(28, size, size, piece, size, result);
        }
        if (result != null) {
            return result;
        }
        if (address.isRegisterAddress()) {
            Register register = language.getRegister(address, size);
            if (register == null) {
                Msg.warn((Object)this, (Object)("Could not figure register: address=" + String.valueOf(address) + ",size=" + size));
                return Sym.opaque();
            }
            return new Sym.RegisterSym(register);
        }
        if (address.isStackAddress()) {
            return new Sym.StackDerefSym(address.getOffset(), size);
        }
        return Sym.opaque();
    }

    public void clear() {
        this.map.clear();
    }

    public void dump(String prefix, Language language) {
        for (SymEntry ent : this.map.values()) {
            Register register = ent.getRegister(language);
            if (register != null) {
                System.err.println(prefix + String.valueOf(register) + " = " + String.valueOf(ent.sym));
                continue;
            }
            System.err.println(prefix + String.valueOf(ent));
        }
    }

    public SymStateSpace fork() {
        return new SymStateSpace(new TreeMap<Address, SymEntry>((SortedMap<Address, SymEntry>)this.map));
    }

    protected class ExprMapSetter
    extends DBTraceUtils.AddressRangeMapSetter<Map.Entry<Address, SymEntry>, SymEntry> {
        protected ExprMapSetter() {
        }

        protected AddressRange getRange(Map.Entry<Address, SymEntry> entry) {
            return entry.getValue().entRange;
        }

        protected SymEntry getValue(Map.Entry<Address, SymEntry> entry) {
            return entry.getValue();
        }

        protected void remove(Map.Entry<Address, SymEntry> entry) {
            SymStateSpace.this.map.remove(entry.getKey());
        }

        protected Iterable<Map.Entry<Address, SymEntry>> getIntersecting(Address lower, Address upper) {
            return SymStateSpace.this.subMap(lower, upper).entrySet();
        }

        protected Map.Entry<Address, SymEntry> put(AddressRange range, SymEntry value) {
            SymStateSpace.this.map.put(range.getMinAddress(), value.truncate(range));
            return null;
        }
    }

    record SymEntry(AddressRange entRange, AddressRange symRange, Sym sym) {
        SymEntry(AddressRange range, Sym sym) {
            this(range, range, sym);
        }

        SymEntry(Address start, int size, Sym sym) throws AddressOverflowException {
            this((AddressRange)new AddressRangeImpl(start, (long)size), sym);
        }

        public String toString(Language language) {
            Register reg = this.getRegister(language);
            if (reg == null) {
                return this.toString();
            }
            return String.format("%s[entRanage=%s,symRange=%s,sym=%s]", this.getClass().getSimpleName(), reg, this.symRange, this.sym);
        }

        boolean isTruncated() {
            return !this.entRange.equals((Object)this.symRange);
        }

        Register getRegister(Language language) {
            return language.getRegister(this.entRange.getMinAddress(), (int)this.entRange.getLength());
        }

        SymEntry truncate(AddressRange range) {
            if (this.entRange.getMinAddress().compareTo((Object)range.getMinAddress()) > 0) {
                throw new AssertionError();
            }
            if (this.entRange.getMaxAddress().compareTo((Object)range.getMaxAddress()) < 0) {
                throw new AssertionError();
            }
            return new SymEntry(range, this.symRange, this.sym);
        }

        boolean contains(Address address) {
            return this.entRange.contains(address);
        }

        Sym extract(AddressRange range, SymPcodeArithmetic arithmetic) {
            if (this.symRange.equals((Object)range)) {
                return this.sym;
            }
            return Sym.opaque();
        }
    }
}

