/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.local;

import ghidra.framework.store.CheckoutType;
import ghidra.framework.store.FileIDFactory;
import ghidra.framework.store.FolderItem;
import ghidra.framework.store.ItemCheckoutStatus;
import ghidra.framework.store.Version;
import ghidra.framework.store.local.CheckoutManager;
import ghidra.framework.store.local.DataDirectoryException;
import ghidra.framework.store.local.HistoryManager;
import ghidra.framework.store.local.LocalDataFile;
import ghidra.framework.store.local.LocalDatabaseItem;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.framework.store.local.UnknownFolderItem;
import ghidra.util.Msg;
import ghidra.util.PropertyFile;
import ghidra.util.ReadOnlyException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.exception.FileInUseException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.util.FileUtilities;

public abstract class LocalFolderItem
implements FolderItem {
    static final Logger log = LogManager.getLogger(LocalFolderItem.class);
    static final String FILE_TYPE = "FILE_TYPE";
    static final String READ_ONLY = "READ_ONLY";
    static final String CONTENT_TYPE = "CONTENT_TYPE";
    static final String CHECKOUT_ID = "CHECKOUT_ID";
    static final String EXCLUSIVE_CHECKOUT = "EXCLUSIVE";
    static final String CHECKOUT_VERSION = "CHECKOUT_VERSION";
    static final String LOCAL_CHECKOUT_VERSION = "LOCAL_CHECKOUT_VERSION";
    static final String CONTENT_TYPE_VERSION = "CONTENT_TYPE_VERSION";
    static final String DATA_DIR_EXTENSION = ".db";
    final PropertyFile propertyFile;
    final CheckoutManager checkoutMgr;
    final HistoryManager historyMgr;
    final LocalFileSystem fileSystem;
    final boolean isVersioned;
    final boolean useDataDir;
    String repositoryName;
    long lastModified;
    long checkinId = -1L;

    LocalFolderItem(LocalFileSystem fileSystem, PropertyFile propertyFile) {
        this.fileSystem = fileSystem;
        this.propertyFile = propertyFile;
        this.isVersioned = fileSystem.isVersioned();
        File dataDir = this.getDataDir();
        this.useDataDir = dataDir.exists();
        this.checkoutMgr = null;
        this.historyMgr = null;
        this.lastModified = propertyFile.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocalFolderItem(LocalFileSystem fileSystem, PropertyFile propertyFile, boolean useDataDir, boolean create) throws IOException {
        this.fileSystem = fileSystem;
        this.propertyFile = propertyFile;
        this.isVersioned = fileSystem.isVersioned();
        this.useDataDir = useDataDir || this.isVersioned;
        boolean success = false;
        try {
            if (create) {
                if (fileSystem.isReadOnly()) {
                    throw new ReadOnlyException();
                }
                if (propertyFile.exists()) {
                    throw new DuplicateFileException(this.getName() + " already exists.");
                }
                if (useDataDir) {
                    File dir = this.getDataDir();
                    if (dir.exists()) {
                        throw new DataDirectoryException("Data directory already exists", dir);
                    }
                    if (!dir.mkdir()) {
                        throw new IOException("Failed to create " + this.getName());
                    }
                }
                propertyFile.writeState();
            } else if (useDataDir && !this.getDataDir().exists() || !propertyFile.exists()) {
                throw new FileNotFoundException(this.getName() + " not found");
            }
            if (this.isVersioned) {
                this.checkoutMgr = new CheckoutManager(this, create);
                this.historyMgr = new HistoryManager(this, create);
            } else {
                this.checkoutMgr = null;
                this.historyMgr = null;
            }
            success = true;
        }
        finally {
            if (!success && create) {
                this.abortCreate();
            }
        }
        this.lastModified = propertyFile.lastModified();
    }

    void log(String msg, String user) {
        this.fileSystem.log(this, msg, user);
    }

    @Override
    public LocalFolderItem refresh() throws IOException {
        if (this.useDataDir && !this.getDataDir().exists() || !this.propertyFile.exists()) {
            return null;
        }
        this.propertyFile.readState();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File getDataDir() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            return new File(this.propertyFile.getFolder(), LocalFileSystem.HIDDEN_DIR_PREFIX + LocalFileSystem.escapeHiddenDirPrefixChars(this.propertyFile.getStorageName()) + DATA_DIR_EXTENSION);
        }
    }

    abstract int getMinimumVersion() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkInUse(int version) throws FileInUseException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.checkoutMgr != null) {
                boolean isCheckedOut;
                try {
                    isCheckedOut = this.checkoutMgr.isCheckedOut(version);
                }
                catch (IOException e) {
                    throw new FileInUseException(this.getName() + " versioning error", (Throwable)e);
                }
                if (isCheckedOut) {
                    throw new FileInUseException(this.getName() + " version " + version + " is checked out");
                }
            } else if (!this.isVersioned && this.getCheckoutId() != -1L) {
                throw new FileInUseException(this.getName() + " is checked out");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkInUse() throws FileInUseException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.fileSystem.migrationInProgress()) {
                return;
            }
            if (this.checkoutMgr != null) {
                boolean isCheckedOut;
                try {
                    isCheckedOut = this.checkoutMgr.isCheckedOut();
                }
                catch (IOException e) {
                    throw new FileInUseException(this.getName() + " versioning error", (Throwable)e);
                }
                if (isCheckedOut) {
                    throw new FileInUseException(this.getName() + " is checked out");
                }
            } else if (!this.isVersioned && this.getCheckoutId() != -1L) {
                throw new FileInUseException(this.getName() + " is checked out");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void beginCheckin(long checkoutId) throws FileInUseException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.checkinId != -1L) {
                ItemCheckoutStatus status;
                try {
                    status = this.checkoutMgr.getCheckout(this.checkinId);
                }
                catch (IOException e) {
                    throw new FileInUseException(this.getName() + " versioning error", (Throwable)e);
                }
                String byMsg = status != null ? " by: " + status.getUser() : "";
                throw new FileInUseException("Another checkin is in progress" + byMsg);
            }
            this.checkinId = checkoutId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endCheckin(long itemCheckinId) {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.checkinId == itemCheckinId) {
                this.checkinId = -1L;
            }
        }
    }

    void fireItemCreated() {
        this.fileSystem.getListener().itemCreated(this.getParentPath(), this.getName());
    }

    void fireItemChanged() {
        this.fileSystem.getListener().itemChanged(this.getParentPath(), this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abortCreate() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            this.propertyFile.delete();
            if (this.useDataDir) {
                FileUtilities.deleteDir((File)this.getDataDir());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(int version, String user) throws IOException {
        if (this.fileSystem.isReadOnly()) {
            throw new ReadOnlyException();
        }
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            String parentPath = this.getParentPath();
            String name = this.getName();
            boolean deleted = false;
            int currentVersion = this.getCurrentVersion();
            if (version == -1) {
                if (this.isVersioned) {
                    this.checkInUse();
                }
                this.deleteContent(user);
                deleted = true;
            } else {
                if (!this.isVersioned) {
                    throw new IllegalArgumentException("delete version must be -1 for non-versioned items");
                }
                int minVersion = this.getMinimumVersion();
                if (version == minVersion) {
                    this.checkInUse(version);
                    if (minVersion == currentVersion) {
                        this.deleteContent(user);
                        deleted = true;
                    } else {
                        this.deleteMinimumVersion(user);
                    }
                } else if (version == currentVersion) {
                    this.checkInUse(version);
                    this.deleteCurrentVersion(user);
                } else {
                    throw new IOException("Only the oldest or latest version may be deleted");
                }
            }
            if (deleted) {
                this.fileSystem.itemDeleted(parentPath, name);
                if (currentVersion > 0) {
                    this.fileSystem.getListener().itemDeleted(parentPath, name);
                }
                this.fileSystem.deleteEmptyVersionedFolders(this.getParentPath());
            } else {
                this.fireItemChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteContent(String user) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            File dataDir = this.getDataDir();
            File chkDir = new File(dataDir.getParentFile(), dataDir.getName() + ".delete");
            FileUtilities.deleteDir((File)chkDir);
            if (this.useDataDir && dataDir.exists() && !dataDir.renameTo(chkDir)) {
                throw new FileInUseException(this.getName() + " is in use");
            }
            boolean success = false;
            try {
                this.propertyFile.delete();
                if (this.propertyFile.exists()) {
                    throw new FileInUseException(this.getName() + " is in use");
                }
                success = true;
            }
            finally {
                if (!success) {
                    if (this.useDataDir && !dataDir.exists() && chkDir.exists() && this.propertyFile.exists()) {
                        chkDir.renameTo(dataDir);
                    }
                } else {
                    if (this.useDataDir) {
                        FileUtilities.deleteDir((File)chkDir);
                    }
                    this.log("file deleted", user);
                }
            }
        }
    }

    abstract void deleteMinimumVersion(String var1) throws IOException;

    abstract void deleteCurrentVersion(String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveTo(File newFolder, String newStorageName, String newFolderPath, String newName) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            this.checkInUse();
            File oldFolder = this.propertyFile.getFolder();
            String oldStorageName = this.propertyFile.getStorageName();
            String oldPath = this.propertyFile.getParentPath();
            File oldDbDir = this.getDataDir();
            String oldName = this.getName();
            this.propertyFile.moveTo(newFolder, newStorageName, newFolderPath, newName);
            boolean success = false;
            try {
                File newDbDir = this.getDataDir();
                if (this.useDataDir && !newDbDir.equals(oldDbDir)) {
                    if (newDbDir.exists()) {
                        throw new DuplicateFileException(this.getName() + " already exists");
                    }
                    if (!oldDbDir.renameTo(newDbDir)) {
                        throw new FileInUseException(this.getName() + " is in use");
                    }
                }
                success = true;
            }
            finally {
                if (!success) {
                    this.propertyFile.moveTo(oldFolder, oldStorageName, oldPath, oldName);
                }
            }
        }
    }

    @Override
    public String getContentType() {
        return this.propertyFile.getString(CONTENT_TYPE, null);
    }

    @Override
    public String getFileID() {
        return this.propertyFile.getFileID();
    }

    @Override
    public String resetFileID() throws IOException {
        String fileId = FileIDFactory.createFileID();
        String oldFileId = this.propertyFile.getFileID();
        this.propertyFile.setFileID(fileId);
        this.propertyFile.writeState();
        this.fileSystem.fileIdChanged(this.propertyFile, oldFileId);
        return fileId;
    }

    @Override
    public String getName() {
        return this.propertyFile.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getParentPath() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            return this.propertyFile.getParentPath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPathName() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            return this.propertyFile.getPath();
        }
    }

    @Override
    public boolean isCheckedOut() {
        if (this.isVersioned) {
            throw new UnsupportedOperationException("isCheckedOut is not applicable to versioned item");
        }
        return this.getCheckoutId() != -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCheckedOutExclusive() {
        if (this.isVersioned) {
            throw new UnsupportedOperationException("isCheckedOutExclusive is not applicable to versioned item");
        }
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.propertyFile.getLong(CHECKOUT_ID, -1L) != -1L) {
                return this.propertyFile.getBoolean(EXCLUSIVE_CHECKOUT, false);
            }
        }
        return false;
    }

    @Override
    public boolean isVersioned() throws IOException {
        return this.fileSystem.isVersioned();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Version[] getVersions() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (!this.isVersioned) {
                throw new UnsupportedOperationException("Non-versioned item does not support getVersions");
            }
            return this.historyMgr.getVersions();
        }
    }

    @Override
    public long lastModified() {
        return this.lastModified;
    }

    @Override
    public boolean isReadOnly() {
        return this.propertyFile.getBoolean(READ_ONLY, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadOnly(boolean state) throws IOException {
        if (this.isVersioned) {
            throw new IOException("Versioned item does not support read-only property");
        }
        if (this.fileSystem.isReadOnly()) {
            throw new ReadOnlyException();
        }
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            LocalFolderItem localFolderItem = this;
            synchronized (localFolderItem) {
                this.propertyFile.putBoolean(READ_ONLY, state);
                this.propertyFile.writeState();
            }
            this.fireItemChanged();
        }
    }

    @Override
    public int getContentTypeVersion() {
        return this.propertyFile.getInt(CONTENT_TYPE_VERSION, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContentTypeVersion(int version) throws IOException {
        if (this.fileSystem.isReadOnly()) {
            throw new ReadOnlyException();
        }
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            LocalFolderItem localFolderItem = this;
            synchronized (localFolderItem) {
                this.propertyFile.putInt(CONTENT_TYPE_VERSION, version);
                this.propertyFile.writeState();
            }
            this.fireItemChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemCheckoutStatus checkout(CheckoutType checkoutType, String user, String projectPath) throws IOException {
        if (!this.isVersioned) {
            throw new UnsupportedOperationException("Non-versioned item does not support checkout");
        }
        if (this.fileSystem.isReadOnly()) {
            throw new ReadOnlyException();
        }
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            ItemCheckoutStatus coStatus = this.checkoutMgr.newCheckout(checkoutType, user, this.getCurrentVersion(), projectPath);
            if (checkoutType != CheckoutType.NORMAL && coStatus != null && this.getFileID() == null) {
                this.resetFileID();
            }
            return coStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateCheckout(long checkoutId, boolean notify) throws IOException {
        if (!this.isVersioned) {
            throw new UnsupportedOperationException("Non-versioned item does not support checkout");
        }
        if (this.fileSystem.isReadOnly()) {
            throw new ReadOnlyException();
        }
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            ItemCheckoutStatus coStatus = this.checkoutMgr.getCheckout(checkoutId);
            if (coStatus == null) {
                throw new IOException("Invalid checkout ID");
            }
            if (checkoutId == this.checkinId) {
                throw new IOException("Checkin is in-progress");
            }
            this.checkoutMgr.endCheckout(checkoutId);
        }
        if (notify) {
            this.fireItemChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemCheckoutStatus getCheckout(long checkoutId) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (!this.isVersioned) {
                throw new UnsupportedOperationException("Non-versioned item does not support checkout");
            }
            return this.checkoutMgr.getCheckout(checkoutId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemCheckoutStatus[] getCheckouts() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (!this.isVersioned) {
                throw new UnsupportedOperationException("Non-versioned item does not support checkout");
            }
            return this.checkoutMgr.getAllCheckouts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCheckoutId() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.isVersioned) {
                throw new UnsupportedOperationException("getCheckoutId is not applicable to versioned item");
            }
            return this.propertyFile.getLong(CHECKOUT_ID, -1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCheckoutVersion() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.isVersioned) {
                throw new UnsupportedOperationException("getCheckoutVersion is not applicable to versioned item");
            }
            return this.propertyFile.getInt(CHECKOUT_VERSION, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLocalCheckoutVersion() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.isVersioned) {
                throw new UnsupportedOperationException("getLocalCheckoutVersion is not applicable to versioned item");
            }
            return this.propertyFile.getInt(LOCAL_CHECKOUT_VERSION, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCheckout(long checkoutId, boolean exclusive, int checkoutVersion, int localVersion) throws IOException {
        if (this.isVersioned) {
            throw new UnsupportedOperationException("setCheckout is not applicable to versioned item");
        }
        if (this.fileSystem.isReadOnly()) {
            throw new ReadOnlyException();
        }
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (checkoutId <= 0L || checkoutVersion <= 0 || localVersion < 0) {
                throw new IllegalArgumentException("Bad checkout data: " + checkoutId + "," + checkoutVersion + "," + localVersion);
            }
            this.propertyFile.putLong(CHECKOUT_ID, checkoutId);
            this.propertyFile.putBoolean(EXCLUSIVE_CHECKOUT, exclusive);
            this.propertyFile.putInt(CHECKOUT_VERSION, checkoutVersion);
            this.propertyFile.putInt(LOCAL_CHECKOUT_VERSION, localVersion);
            this.propertyFile.writeState();
            this.fireItemChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCheckout() throws IOException {
        if (this.isVersioned) {
            throw new UnsupportedOperationException("clearCheckout is not applicable to versioned item");
        }
        if (this.fileSystem.isReadOnly()) {
            throw new ReadOnlyException();
        }
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            this.propertyFile.putLong(CHECKOUT_ID, -1L);
            this.propertyFile.putBoolean(EXCLUSIVE_CHECKOUT, false);
            this.propertyFile.putInt(CHECKOUT_VERSION, -1);
            this.propertyFile.putInt(LOCAL_CHECKOUT_VERSION, -1);
            this.propertyFile.writeState();
            this.fireItemChanged();
        }
    }

    static LocalFolderItem getFolderItem(LocalFileSystem fileSystem, PropertyFile propertyFile) {
        int fileType = propertyFile.getInt(FILE_TYPE, -1);
        try {
            if (fileType == 1) {
                return new LocalDataFile(fileSystem, propertyFile);
            }
            if (fileType == 0) {
                return new LocalDatabaseItem(fileSystem, propertyFile);
            }
            log.error("Item has unknown content type: " + String.valueOf(new File(propertyFile.getFolder(), propertyFile.getStorageName())));
        }
        catch (FileNotFoundException e) {
            log.error("Item may be corrupt due to missing file: " + String.valueOf(new File(propertyFile.getFolder(), propertyFile.getStorageName())), (Throwable)e);
        }
        catch (IOException e) {
            log.error("Item may be corrupt: " + String.valueOf(new File(propertyFile.getFolder(), propertyFile.getStorageName())), (Throwable)e);
        }
        return new UnknownFolderItem(fileSystem, propertyFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasCheckouts() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.isVersioned) {
                try {
                    return this.checkoutMgr.isCheckedOut();
                }
                catch (IOException e) {
                    Msg.error((Object)(this.getName() + " versioning error"), (Object)e);
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCheckinActive() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.isVersioned) {
                return this.checkinId != -1L;
            }
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocalFolderItem) {
            return this.propertyFile.equals(((LocalFolderItem)obj).propertyFile);
        }
        return false;
    }

    public abstract void updateCheckout(FolderItem var1, boolean var2, TaskMonitor var3) throws IOException, CancelledException;

    public abstract void updateCheckout(FolderItem var1, int var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCheckoutVersion(long checkoutId, int checkoutVersion, String user) throws IOException {
        if (!this.isVersioned) {
            throw new UnsupportedOperationException("updateCheckoutVersion is not applicable to non-versioned item");
        }
        if (this.fileSystem.isReadOnly()) {
            throw new ReadOnlyException();
        }
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            ItemCheckoutStatus checkout = this.getCheckout(checkoutId);
            if (checkout == null || !checkout.getUser().equals(user)) {
                throw new IOException("Checkout not found");
            }
            this.checkoutMgr.updateCheckout(checkoutId, checkoutVersion);
        }
    }
}

