/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.remote;

import db.buffers.BufferFile;
import db.buffers.LocalBufferFile;
import db.buffers.ManagedBufferFile;
import db.buffers.ManagedBufferFileAdapter;
import ghidra.framework.client.RemoteAdapterListener;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.remote.RepositoryItem;
import ghidra.framework.store.DataFileItem;
import ghidra.framework.store.DatabaseItem;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.FileSystemEventManager;
import ghidra.framework.store.FileSystemListener;
import ghidra.framework.store.FolderItem;
import ghidra.framework.store.remote.RemoteDatabaseItem;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class RemoteFileSystem
implements FileSystem,
RemoteAdapterListener {
    private RepositoryAdapter repository;
    private FileSystemEventManager eventManager = new FileSystemEventManager(true);

    public RemoteFileSystem(RepositoryAdapter repository) {
        this.repository = repository;
        repository.setFileSystemListener(this.eventManager);
        repository.addListener(this);
    }

    @Override
    public String getUserName() {
        try {
            return this.repository.getUser().getName();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void addFileSystemListener(FileSystemListener listener) {
        this.eventManager.add(listener);
    }

    @Override
    public void removeFileSystemListener(FileSystemListener listener) {
        this.eventManager.remove(listener);
    }

    @Override
    public boolean isVersioned() {
        return true;
    }

    @Override
    public boolean isOnline() {
        return this.repository.isConnected();
    }

    @Override
    public boolean isReadOnly() throws IOException {
        return this.repository.getUser().isReadOnly();
    }

    @Override
    public boolean isShared() {
        return true;
    }

    @Override
    public int getItemCount() throws IOException, UnsupportedOperationException {
        return this.repository.getItemCount();
    }

    @Override
    public synchronized String[] getItemNames(String folderPath) throws IOException {
        RepositoryItem[] items = this.repository.getItemList(folderPath);
        String[] names = new String[items.length];
        for (int i = 0; i < items.length; ++i) {
            names[i] = items[i].getName();
        }
        return names;
    }

    @Override
    public FolderItem[] getItems(String folderPath) throws IOException {
        RepositoryItem[] items = this.repository.getItemList(folderPath);
        FolderItem[] folderItems = new FolderItem[items.length];
        for (int i = 0; i < items.length; ++i) {
            if (items[i].getItemType() != 2) {
                throw new IOException("Unsupported file type");
            }
            folderItems[i] = new RemoteDatabaseItem(this.repository, items[i]);
        }
        return folderItems;
    }

    @Override
    public synchronized FolderItem getItem(String folderPath, String name) throws IOException {
        RepositoryItem item = this.repository.getItem(folderPath, name);
        if (item == null) {
            return null;
        }
        if (item.getItemType() == 2) {
            return new RemoteDatabaseItem(this.repository, item);
        }
        throw new IOException("Unsupported file type");
    }

    @Override
    public FolderItem getItem(String fileID) throws IOException, UnsupportedOperationException {
        RepositoryItem item = this.repository.getItem(fileID);
        if (item == null) {
            return null;
        }
        if (item.getItemType() == 2) {
            return new RemoteDatabaseItem(this.repository, item);
        }
        throw new IOException("Unsupported file type");
    }

    @Override
    public String[] getFolderNames(String parentPath) throws IOException {
        return this.repository.getSubfolderList(parentPath);
    }

    @Override
    public void createFolder(String parentPath, String folderName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ManagedBufferFile createDatabase(String parentPath, String name, String fileID, String contentType, int bufferSize, String user, String projectPath) throws InvalidNameException, IOException {
        return this.repository.createDatabase(parentPath, name, bufferSize, contentType, fileID, projectPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseItem createDatabase(String parentPath, String name, String fileID, BufferFile bufferFile, String comment, String contentType, boolean resetDatabaseId, TaskMonitor monitor, String user) throws InvalidNameException, IOException, CancelledException {
        ManagedBufferFileAdapter newFile = this.repository.createDatabase(parentPath, name, bufferFile.getBufferSize(), contentType, fileID, null);
        boolean success = false;
        try {
            newFile.setVersionComment(comment);
            LocalBufferFile.copyFile((BufferFile)bufferFile, (BufferFile)newFile, null, (TaskMonitor)monitor);
            long checkinId = newFile.getCheckinID();
            newFile.close();
            this.repository.terminateCheckout(parentPath, name, checkinId, false);
            success = true;
        }
        finally {
            if (!success) {
                newFile.delete();
            }
            newFile.dispose();
        }
        return (DatabaseItem)this.getItem(parentPath, name);
    }

    @Override
    public DataFileItem createDataFile(String parentPath, String name, InputStream istream, String comment, String contentType, TaskMonitor monitor) throws InvalidNameException, IOException, CancelledException {
        this.repository.createDataFile(parentPath, name);
        return (DataFileItem)this.getItem(parentPath, name);
    }

    @Override
    public FolderItem createFile(String parentPath, String name, File packedFile, TaskMonitor monitor, String user) throws InvalidNameException, IOException, CancelledException {
        throw new UnsupportedOperationException("Versioned filesystem does not support createFile");
    }

    @Override
    public void deleteFolder(String folderPath) throws IOException {
        throw new UnsupportedOperationException("Versioned filesystem does not support deleteFolder");
    }

    @Override
    public void moveFolder(String parentPath, String folderName, String newParentPath) throws InvalidNameException, IOException {
        this.repository.moveFolder(parentPath, newParentPath, folderName, folderName);
    }

    @Override
    public void renameFolder(String parentPath, String folderName, String newFolderName) throws InvalidNameException, IOException {
        this.repository.moveFolder(parentPath, parentPath, folderName, newFolderName);
    }

    @Override
    public void moveItem(String parentPath, String name, String newParentPath, String newName) throws InvalidNameException, IOException {
        this.repository.moveItem(parentPath, newParentPath, name, newName);
    }

    @Override
    public boolean folderExists(String folderPath) throws IOException {
        return this.repository.folderExists(folderPath);
    }

    @Override
    public boolean fileExists(String folderPath, String itemName) throws IOException {
        return this.repository.fileExists(folderPath, itemName);
    }

    @Override
    public void connectionStateChanged(Object adapter) {
        if (adapter == this.repository) {
            this.eventManager.syncronize();
        }
    }

    @Override
    public void dispose() {
        this.eventManager.dispose();
    }
}

