/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.AbstractElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.SH_ElfRelocationType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;

public class SH_ElfRelocationHandler
extends AbstractElfRelocationHandler<SH_ElfRelocationType, ElfRelocationContext<?>> {
    public SH_ElfRelocationHandler() {
        super(SH_ElfRelocationType.class);
    }

    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 42 && elf.is32Bit();
    }

    protected RelocationResult relocate(ElfRelocationContext<?> elfRelocationContext, ElfRelocation relocation, SH_ElfRelocationType type, Address relocationAddress, ElfSymbol sym, Address symbolAddr, long symbolValue, String symbolName) throws MemoryAccessException {
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        int addend = (int)relocation.getAddend();
        int offset = (int)relocationAddress.getOffset();
        int symbolIndex = relocation.getSymbolIndex();
        int newValue = 0;
        int byteLength = 4;
        switch (type) {
            case R_SH_RELATIVE: {
                if (elfRelocationContext.extractAddend()) {
                    addend = memory.getInt(relocationAddress);
                }
                newValue = (int)elfRelocationContext.getImageBaseWordAdjustmentOffset() + addend;
                memory.setInt(relocationAddress, newValue);
                return new RelocationResult(Relocation.Status.APPLIED, byteLength);
            }
            case R_SH_COPY: {
                this.markAsUnsupportedCopy(program, relocationAddress, type, symbolName, symbolIndex, sym.getSize(), elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        if (this.handleUnresolvedSymbol(elfRelocationContext, relocation, relocationAddress)) {
            return RelocationResult.FAILURE;
        }
        switch (type) {
            case R_SH_DIR32: {
                if (elfRelocationContext.extractAddend()) {
                    addend = memory.getInt(relocationAddress);
                }
                newValue = (int)symbolValue + addend;
                memory.setInt(relocationAddress, newValue);
                if (symbolIndex == 0 || addend == 0 || sym.isSection()) break;
                SH_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                SH_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case R_SH_GLOB_DAT: 
            case R_SH_JMP_SLOT: {
                memory.setInt(relocationAddress, (int)symbolValue);
                break;
            }
            case R_SH_REL32: {
                if (elfRelocationContext.extractAddend()) {
                    addend = memory.getInt(relocationAddress);
                }
                newValue = (int)symbolValue + addend - offset;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case R_SH_DIR8WPN: 
            case R_SH_DIR8WPZ: {
                short oldValue = memory.getShort(relocationAddress);
                if (elfRelocationContext.extractAddend()) {
                    addend = oldValue & 0xFF;
                    if (type == SH_ElfRelocationType.R_SH_DIR8WPN && (addend & 0x80) != 0) {
                        addend -= 256;
                    }
                }
                newValue = (int)symbolValue + addend - offset >> 1;
                newValue = oldValue & 0xFF00 | newValue & 0xFF;
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case R_SH_IND12W: {
                short oldValue = memory.getShort(relocationAddress);
                if (elfRelocationContext.extractAddend() && ((addend = oldValue & 0xFFF) & 0x800) != 0) {
                    addend -= 4096;
                }
                newValue = (int)symbolValue + addend - offset >> 1;
                newValue = oldValue & 0xF000 | newValue & 0xFFF;
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case R_SH_DIR8WPL: {
                short oldValue = memory.getShort(relocationAddress);
                if (elfRelocationContext.extractAddend()) {
                    addend = oldValue & 0xFF;
                }
                newValue = (int)symbolValue + addend - offset >> 2;
                newValue = oldValue & 0xFF00 | newValue & 0xFF;
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            default: {
                this.markAsUnhandled(program, relocationAddress, type, symbolIndex, symbolName, elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

