/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data;

import ghidra.app.cmd.data.AbstractCreateDataBackgroundCmd;
import ghidra.app.cmd.data.EHDataTypeUtilities;
import ghidra.app.cmd.data.TypeDescriptorModel;
import ghidra.app.cmd.data.rtti.RttiUtil;
import ghidra.app.util.datatype.microsoft.DataApplyOptions;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;

public class CreateTypeDescriptorBackgroundCmd
extends AbstractCreateDataBackgroundCmd<TypeDescriptorModel> {
    private static final String RTTI_0_NAME = "RTTI Type Descriptor";

    public CreateTypeDescriptorBackgroundCmd(Address address) {
        super("TypeDescriptor", address, 1);
    }

    public CreateTypeDescriptorBackgroundCmd(Address address, DataValidationOptions validationOptions, DataApplyOptions applyOptions) {
        super("TypeDescriptor", address, 1, validationOptions, applyOptions);
    }

    public CreateTypeDescriptorBackgroundCmd(TypeDescriptorModel model, DataApplyOptions applyOptions) {
        super(model, applyOptions);
    }

    private void loadModel(Program program) {
        if (this.model == null || program != ((TypeDescriptorModel)this.model).getProgram()) {
            this.model = new TypeDescriptorModel(program, this.getDataAddress(), this.validationOptions);
        }
    }

    @Override
    protected TypeDescriptorModel createModel(Program program) {
        if (this.model == null) {
            this.loadModel(program);
        }
        return (TypeDescriptorModel)this.model;
    }

    @Override
    protected boolean createData() throws CodeUnitInsertionException, CancelledException {
        if (!super.createData()) {
            return false;
        }
        DataType dataType = ((TypeDescriptorModel)this.model).getDataType();
        int structLen = dataType.getLength();
        Address arrayAddr = ((TypeDescriptorModel)this.model).getAddress().add((long)structLen);
        ArrayDataType charArray = new ArrayDataType((DataType)CharDataType.dataType, ((TypeDescriptorModel)this.model).getDataTypeLength() - structLen, 1);
        Program program = ((TypeDescriptorModel)this.model).getProgram();
        Data nameData = DataUtilities.createData((Program)program, (Address)arrayAddr, (DataType)charArray, (int)charArray.getLength(), (DataUtilities.ClearDataMode)this.getClearDataMode());
        nameData.setComment(0, "TypeDescriptor.name");
        return true;
    }

    @Override
    protected boolean createAssociatedData() throws CancelledException {
        return true;
    }

    @Override
    protected boolean createMarkup() throws CancelledException, InvalidInputException {
        this.monitor.checkCancelled();
        Program program = ((TypeDescriptorModel)this.model).getProgram();
        String demangledName = ((TypeDescriptorModel)this.model).getDemangledTypeDescriptor();
        if (demangledName == null) {
            return false;
        }
        String prefix = demangledName + " ";
        EHDataTypeUtilities.createPlateCommentIfNeeded(program, prefix, RTTI_0_NAME, null, this.getDataAddress(), this.applyOptions);
        this.monitor.checkCancelled();
        Namespace classNamespace = ((TypeDescriptorModel)this.model).getDescriptorAsNamespace();
        if (classNamespace == null) {
            Msg.error(RttiUtil.class, (Object)("Cannot get namespace from model " + String.valueOf(((TypeDescriptorModel)this.model).getAddress())));
            return false;
        }
        if (!(classNamespace instanceof GhidraClass)) {
            classNamespace = RttiUtil.promoteToClassNamespace(program, classNamespace);
        }
        EHDataTypeUtilities.createSymbolIfNeeded(program, classNamespace, RTTI_0_NAME, this.getDataAddress(), this.applyOptions);
        return true;
    }
}

