/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.rtti;

import ghidra.app.cmd.data.TypeDescriptorModel;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.ProgramMemoryUtil;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import utility.function.TerminatingConsumer;

public class RttiUtil {
    private static final String TYPE_INFO_NAMESPACE = "type_info";
    private static final int MIN_MATCHING_VFTABLE_PTRS = 5;
    static final String CONST_PREFIX = "const ";
    public static final String TYPE_INFO_LABEL = "class_type_info_RTTI_Type_Descriptor";
    public static final String TYPE_INFO_STRING = ".?AVtype_info@@";
    private static final String CLASS_PREFIX_CHARS = ".?A";
    private static Map<Program, Address> vftableMap = new WeakHashMap<Program, Address>();

    private RttiUtil() {
    }

    static boolean createSymbolFromDemangledType(Program program, Address rttiAddress, TypeDescriptorModel typeDescriptorModel, String rttiSuffix) {
        rttiSuffix = SymbolUtilities.replaceInvalidChars((String)rttiSuffix, (boolean)true);
        Namespace classNamespace = typeDescriptorModel.getDescriptorAsNamespace();
        SymbolTable symbolTable = program.getSymbolTable();
        Symbol matchingSymbol = symbolTable.getSymbol(rttiSuffix, rttiAddress, classNamespace);
        if (matchingSymbol != null) {
            return false;
        }
        try {
            Symbol symbol = symbolTable.createLabel(rttiAddress, rttiSuffix, classNamespace, SourceType.IMPORTED);
            symbol.setPrimary();
            return true;
        }
        catch (InvalidInputException e) {
            Msg.error(RttiUtil.class, (Object)("Unable to create label for " + rttiSuffix + " at " + String.valueOf(rttiAddress) + "."), (Throwable)e);
            return false;
        }
    }

    public static Namespace promoteToClassNamespace(Program program, Namespace namespace) {
        if (!(namespace instanceof GhidraClass)) {
            try {
                namespace = NamespaceUtils.convertNamespaceToClass((Namespace)namespace);
            }
            catch (InvalidInputException iie) {
                Msg.error(RttiUtil.class, (Object)("Unable to convert namespace to class for namespace " + String.valueOf(namespace) + "."), (Throwable)iie);
            }
        }
        return namespace;
    }

    public static int getVfTableCount(Program program, Address vfTableBaseAddress) {
        Address referencedAddress;
        Memory memory = program.getMemory();
        ReferenceManager referenceManager = program.getReferenceManager();
        FunctionManager functionManager = program.getFunctionManager();
        MemoryBlock textBlock = memory.getBlock(".text");
        MemoryBlock nepBlock = memory.getBlock(".nep");
        AddressSetView initializedAddresses = memory.getLoadedAndInitializedAddressSet();
        PseudoDisassembler pseudoDisassembler = new PseudoDisassembler(program);
        int tableSize = 0;
        Address currentVfPointerAddress = vfTableBaseAddress;
        int defaultPointerSize = program.getDefaultPointerSize();
        while ((referencedAddress = MSDataTypeUtils.getAbsoluteAddress((Program)program, (Address)currentVfPointerAddress)) != null && referencedAddress.getOffset() != 0L && initializedAddresses.contains(referencedAddress)) {
            Function function;
            if (textBlock != null || nepBlock != null) {
                boolean inNepBlock;
                MemoryBlock refedBlock = memory.getBlock(referencedAddress);
                boolean inTextBlock = textBlock != null && textBlock.equals((Object)refedBlock);
                boolean bl = inNepBlock = nepBlock != null && nepBlock.equals((Object)refedBlock);
                if (!inTextBlock && !inNepBlock) break;
            }
            if (tableSize > 0 && RttiUtil.referenceIndicatesEndOfTable(referenceManager, currentVfPointerAddress) || (function = functionManager.getFunctionAt(referencedAddress)) == null && !pseudoDisassembler.isValidSubroutine(referencedAddress, true, false)) break;
            ++tableSize;
            currentVfPointerAddress = currentVfPointerAddress.add((long)defaultPointerSize);
        }
        return tableSize;
    }

    private static boolean referenceIndicatesEndOfTable(ReferenceManager referenceManager, Address address) {
        boolean hasReferencesTo = referenceManager.hasReferencesTo(address);
        if (!hasReferencesTo) {
            return false;
        }
        ReferenceIterator referenceIter = referenceManager.getReferencesTo(address);
        while (referenceIter.hasNext()) {
            Reference ref = referenceIter.next();
            if (ref.getSource() != SourceType.ANALYSIS) {
                return true;
            }
            if (!ref.getReferenceType().isData() || ref.getReferenceType().isRead()) continue;
            return true;
        }
        return false;
    }

    public static String getDescriptorTypeNamespace(TypeDescriptorModel rtti0Model) {
        String descriptorTypeNamespace = rtti0Model.getDescriptorTypeNamespace();
        if (descriptorTypeNamespace == null) {
            descriptorTypeNamespace = "";
        }
        return descriptorTypeNamespace;
    }

    public static Address findTypeInfoVftableAddress(Program program, TaskMonitor monitor) throws CancelledException {
        if (vftableMap.containsKey(program)) {
            return vftableMap.get(program);
        }
        Address infoVftableAddress = RttiUtil.findTypeInfoVftableLabel(program);
        if (infoVftableAddress == null) {
            AddressSetView set = program.getMemory().getLoadedAndInitializedAddressSet();
            List dataBlocks = ProgramMemoryUtil.getMemoryBlocksStartingWithName((Program)program, (AddressSetView)set, (String)".data", (TaskMonitor)monitor);
            CommonRTTIMatchCounter vfTableAddrChecker = new CommonRTTIMatchCounter(program);
            ProgramMemoryUtil.locateString((String)CLASS_PREFIX_CHARS, (TerminatingConsumer)vfTableAddrChecker, (Program)program, (List)dataBlocks, (AddressSetView)set, (TaskMonitor)monitor);
            infoVftableAddress = vfTableAddrChecker.getinfoVfTable();
        }
        vftableMap.put(program, infoVftableAddress);
        return infoVftableAddress;
    }

    private static Address findTypeInfoVftableLabel(Program program) {
        Namespace typeinfoNamespace;
        SymbolTable symbolTable = program.getSymbolTable();
        Symbol vftableSymbol = symbolTable.getLocalVariableSymbol("vftable", typeinfoNamespace = symbolTable.getNamespace(TYPE_INFO_NAMESPACE, program.getGlobalNamespace()));
        if (vftableSymbol != null) {
            return vftableSymbol.getAddress();
        }
        vftableSymbol = symbolTable.getLocalVariableSymbol("`vftable'", typeinfoNamespace);
        if (vftableSymbol != null) {
            return vftableSymbol.getAddress();
        }
        vftableSymbol = symbolTable.getLocalVariableSymbol(TYPE_INFO_NAMESPACE, typeinfoNamespace);
        if (vftableSymbol != null) {
            return vftableSymbol.getAddress();
        }
        return null;
    }

    public static void createTypeInfoVftableSymbol(Program program, Address address) {
        Symbol vftableSymbol;
        SymbolTable symbolTable = program.getSymbolTable();
        Namespace typeinfoNamespace = symbolTable.getNamespace(TYPE_INFO_NAMESPACE, program.getGlobalNamespace());
        if (typeinfoNamespace == null) {
            try {
                typeinfoNamespace = symbolTable.createClass(program.getGlobalNamespace(), TYPE_INFO_NAMESPACE, SourceType.IMPORTED);
            }
            catch (DuplicateNameException e) {
                Msg.error(RttiUtil.class, (Object)("Duplicate type_info class namespace at " + program.getName() + " " + String.valueOf(address) + ". " + e.getMessage()));
                return;
            }
            catch (InvalidInputException e) {
                Msg.error(RttiUtil.class, (Object)("Invalid input creating type_info class namespace " + program.getName() + " " + String.valueOf(address) + ". " + e.getMessage()));
                return;
            }
        }
        if ((vftableSymbol = symbolTable.getSymbol(TYPE_INFO_NAMESPACE, address, typeinfoNamespace)) != null) {
            return;
        }
        vftableSymbol = symbolTable.getSymbol("`vftable'", address, typeinfoNamespace);
        if (vftableSymbol != null) {
            return;
        }
        try {
            vftableSymbol = symbolTable.createLabel(address, "vftable", typeinfoNamespace, SourceType.IMPORTED);
            if (vftableSymbol == null) {
                Msg.error(RttiUtil.class, (Object)(program.getName() + " Couldn't create type_info vftable symbol. "));
                return;
            }
            vftableSymbol.setPrimary();
        }
        catch (InvalidInputException e) {
            Msg.error(RttiUtil.class, (Object)(program.getName() + " Couldn't create type_info vftable symbol. " + e.getMessage()));
            return;
        }
    }

    private static class CommonRTTIMatchCounter
    implements TerminatingConsumer<Address> {
        int matchingAddrCount = 0;
        int defaultPointerSize = 4;
        boolean terminationRequest = false;
        Address commonVftableAddress = null;
        Program program;

        public CommonRTTIMatchCounter(Program program) {
            this.program = program;
            this.defaultPointerSize = program.getDefaultPointerSize();
        }

        public Address getinfoVfTable() {
            return this.commonVftableAddress;
        }

        public boolean terminationRequested() {
            return this.terminationRequest;
        }

        public void accept(Address foundAddress) {
            Address mangledClassNameAddress = foundAddress;
            Address pointerToTypeInfoVftable = mangledClassNameAddress.subtract((long)(2 * this.defaultPointerSize));
            Address possibleVftableAddress = MSDataTypeUtils.getAbsoluteAddress((Program)this.program, (Address)pointerToTypeInfoVftable);
            if (possibleVftableAddress == null) {
                return;
            }
            if (possibleVftableAddress.getOffset() == 0L) {
                return;
            }
            if (!possibleVftableAddress.equals((Object)this.commonVftableAddress)) {
                if (this.matchingAddrCount > 2) {
                    return;
                }
                this.matchingAddrCount = 0;
            }
            this.commonVftableAddress = possibleVftableAddress;
            ++this.matchingAddrCount;
            if (this.matchingAddrCount > 5) {
                this.terminationRequest = true;
                return;
            }
        }
    }
}

