/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.prototype.MicrosoftCodeAnalyzerPlugin;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.app.plugin.prototype.MicrosoftCodeAnalyzerPlugin.PEUtil;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public class PropagateExternalParametersAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "WindowsPE x86 Propagate External Parameters";
    private static final String DESCRIPTION = "This analyzer uses external Windows function call parameter information to populate comments next to pushed parameters. In some cases, data is labeled and commented as well";
    private List<PushedParamInfo> results = new ArrayList<PushedParamInfo>();
    private Program currentProgram;

    public PropagateExternalParametersAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setSupportsOneTimeAnalysis();
        this.setPriority(AnalysisPriority.DATA_TYPE_PROPOGATION.after().after().after().after().after());
    }

    private void processExternalFunction(Listing listing, ReferenceManager refMan, Reference[] extRefs, Function externalFunction, Parameter[] params) {
        String externalFunctionName = externalFunction.getName();
        for (Reference extRef : extRefs) {
            CodeUnitIterator it;
            Address fromAddr = extRef.getFromAddress();
            Function callingFunction = listing.getFunctionContaining(fromAddr);
            if (callingFunction == null) continue;
            String mnemonic = listing.getCodeUnitAt(fromAddr).getMnemonicString();
            if (mnemonic.equals("JMP") && callingFunction.isThunk()) {
                this.processThunkReference(listing, refMan, externalFunction, params, callingFunction);
                continue;
            }
            if (!mnemonic.equals("CALL") || !this.hasEnoughPushes(it = this.getCodeUnitsFromFunctionStartToRef(callingFunction, fromAddr), params.length)) continue;
            CodeUnitIterator codeUnitsToRef = this.getCodeUnitsFromFunctionStartToRef(callingFunction, fromAddr);
            this.propogateParams(params, codeUnitsToRef, externalFunctionName);
        }
    }

    private void processThunkReference(Listing listing, ReferenceManager refMan, Function externalFunction, Parameter[] params, Function callingFunction) {
        ReferenceIterator iterator = refMan.getReferencesTo(callingFunction.getEntryPoint());
        for (Reference thunkRef : iterator) {
            CodeUnitIterator cuIt;
            String thunkMnemonic;
            Address thunkAddr = thunkRef.getFromAddress();
            Function thunk = listing.getFunctionContaining(thunkAddr);
            if (thunk == null || !(thunkMnemonic = listing.getCodeUnitAt(thunkAddr).getMnemonicString()).equals("CALL") || !this.hasEnoughPushes(cuIt = this.getCodeUnitsFromFunctionStartToRef(thunk, thunkAddr), params.length)) continue;
            CodeUnitIterator codeUnitsToRef = this.getCodeUnitsFromFunctionStartToRef(thunk, thunkAddr);
            this.propogateParams(params, codeUnitsToRef, externalFunction.getName());
        }
    }

    private int numParams(CodeUnit cu) {
        Reference[] references = cu.getReferencesFrom();
        if (references.length != 0) {
            Address toAddr = references[0].getToAddress();
            FunctionManager functionManager = this.currentProgram.getFunctionManager();
            Function f = functionManager.getReferencedFunction(toAddr);
            if (f != null) {
                Parameter[] params = f.getParameters();
                return params.length;
            }
        }
        return 0;
    }

    private CodeUnitIterator getCodeUnitsFromFunctionStartToRef(Function function, Address referenceAddress) {
        if (function == null) {
            return null;
        }
        Listing listing = this.currentProgram.getListing();
        AddressSetView functionBody = function.getBody();
        CodeUnit referenceCodeUnit = listing.getCodeUnitAt(referenceAddress);
        Address referenceMinAddress = referenceCodeUnit.getMinAddress();
        CodeUnit previousCodeUnit = listing.getCodeUnitBefore(referenceMinAddress);
        Address previousMinAddress = previousCodeUnit.getMinAddress();
        AddressIterator it = functionBody.getAddresses(previousMinAddress, false);
        AddressSet addrSet = new AddressSet();
        while (it.hasNext()) {
            Address addr = it.next();
            addrSet.addRange(addr, addr);
        }
        return listing.getCodeUnits((AddressSetView)addrSet, false);
    }

    private boolean hasEnoughPushes(CodeUnitIterator iterator, int numParams) {
        if (iterator == null) {
            return false;
        }
        int numPushes = 0;
        int numSkips = 0;
        while (iterator.hasNext() && numPushes < numParams) {
            CodeUnit cu = iterator.next();
            if (numSkips > 0) {
                --numSkips;
                continue;
            }
            if (cu.getMnemonicString().equals("CALL")) {
                numParams += this.numParams(cu);
                continue;
            }
            if (!cu.getMnemonicString().equals("PUSH")) continue;
            ++numPushes;
        }
        return numPushes >= numParams;
    }

    private void propogateParams(Parameter[] params, CodeUnitIterator iterator, String externalFunctionName) {
        int index = 0;
        int numSkips = 0;
        while (iterator.hasNext() && index < params.length) {
            boolean isBranch;
            CodeUnit cu = iterator.next();
            boolean bl = isBranch = cu.getLabel() != null;
            if (cu.getMnemonicString().equals("CALL")) {
                numSkips += this.numParams(cu);
            } else if (cu.getMnemonicString().equals("PUSH")) {
                if (numSkips > 0) {
                    --numSkips;
                } else {
                    Parameter param = params[index];
                    DataType dt = param.getDataType();
                    String name = param.getName();
                    SetCommentCmd cmd = new SetCommentCmd(cu.getAddress(), 0, dt.getDisplayName() + " " + name + " for " + externalFunctionName);
                    cmd.applyTo(this.currentProgram);
                    this.addResult(name, dt, cu.getMinAddress(), externalFunctionName);
                    ++index;
                }
            }
            if (!isBranch) continue;
            break;
        }
    }

    private void addResult(String name, DataType dataType, Address addr, String calledFuncName) {
        PushedParamInfo param = new PushedParamInfo(this, name, dataType, addr, calledFuncName);
        this.results.add(param);
    }

    public boolean canAnalyze(Program program) {
        return PEUtil.canAnalyze(program);
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        this.currentProgram = program;
        Listing listing = program.getListing();
        FunctionManager functionManager = program.getFunctionManager();
        ReferenceManager referenceManager = program.getReferenceManager();
        SymbolTable symbolTable = program.getSymbolTable();
        SymbolIterator externalSymbols = symbolTable.getExternalSymbols();
        for (Symbol externalSymbol : externalSymbols) {
            Function externalFunction;
            Parameter[] params;
            if (externalSymbol.getSymbolType() != SymbolType.FUNCTION || (params = (externalFunction = functionManager.getFunctionAt(externalSymbol.getAddress())).getParameters()).length == 0) continue;
            Reference[] references = externalSymbol.getReferences();
            this.processExternalFunction(listing, referenceManager, references, externalFunction, params);
        }
        Msg.trace((Object)((Object)this), (Object)("Processing propagation results - count: " + this.results.size()));
        for (int i = 0; i < this.results.size(); ++i) {
            Address referencedAddress;
            int opType;
            PushedParamInfo paramInfo = this.results.get(i);
            Address paramAddress = paramInfo.getAddress();
            Instruction instruction = listing.getInstructionAt(paramAddress);
            if (!instruction.getOperandRefType(0).isData() || !this.isAddressReferenceOperand(opType = instruction.getOperandType(0)) || (referencedAddress = this.getReferencedAddress(paramAddress)) == null) continue;
            String paramName = paramInfo.getName();
            String symbolName = paramName + "_" + referencedAddress.toString();
            this.addSymbol(symbolTable, referencedAddress, symbolName);
            String paramText = paramName + " parameter of " + paramInfo.getCalledFunctionName();
            String newComment = paramText + "\n";
            Msg.trace((Object)((Object)this), (Object)("External Function Call at " + String.valueOf(paramAddress) + " : " + paramText + " at " + referencedAddress.toString()));
            this.createComment(referencedAddress, newComment, paramInfo);
            this.clearUndefinedDataType(referencedAddress, monitor);
            this.createData(paramInfo, referencedAddress);
        }
        return true;
    }

    private void createComment(Address dataAddress, String newComment, PushedParamInfo info) {
        Listing listing = this.currentProgram.getListing();
        String plateComment = listing.getComment(3, dataAddress);
        if (plateComment == null) {
            SetCommentCmd cmd = new SetCommentCmd(dataAddress, 3, newComment);
            cmd.applyTo(this.currentProgram);
        } else if (!plateComment.contains(info.getCalledFunctionName())) {
            String updatedComment = plateComment + "\n" + newComment;
            SetCommentCmd cmd = new SetCommentCmd(dataAddress, 3, updatedComment);
            cmd.applyTo(this.currentProgram);
        }
    }

    private void createData(PushedParamInfo paramInfo, Address address) {
        DataType dt;
        Listing listing = this.currentProgram.getListing();
        if (!listing.isUndefined(address, address.add((long)((dt = paramInfo.getDataType()).getLength() - 1)))) {
            return;
        }
        CreateDataCmd cmd = new CreateDataCmd(address, dt);
        if (!cmd.applyTo(this.currentProgram)) {
            Msg.error((Object)((Object)this), (Object)("Error making data: " + cmd.getStatusMsg()));
        }
    }

    private void clearUndefinedDataType(Address address, TaskMonitor monitor) throws CancelledException {
        Listing listing = this.currentProgram.getListing();
        Data data = listing.getDefinedDataAt(address);
        if (data == null) {
            return;
        }
        DataType dt = data.getDataType();
        if (Undefined.isUndefined((DataType)dt)) {
            listing.clearCodeUnits(address, address, false, monitor);
        }
    }

    private void addSymbol(SymbolTable symbolTable, Address address, String symbolName) {
        Listing listing = this.currentProgram.getListing();
        Data data = listing.getDefinedDataAt(address);
        if (data != null && data.hasStringValue()) {
            return;
        }
        try {
            Symbol newSymbol = symbolTable.createLabel(address, symbolName, SourceType.USER_DEFINED);
            newSymbol.setPrimary();
        }
        catch (InvalidInputException e) {
            Msg.trace((Object)((Object)this), (Object)"Unexpected exception", (Throwable)e);
        }
    }

    private Address getReferencedAddress(Address address) {
        Listing listing = this.currentProgram.getListing();
        Reference[] refs = listing.getCodeUnitAt(address).getOperandReferences(0);
        if (refs.length > 0 && refs[0].isMemoryReference()) {
            return refs[0].getToAddress();
        }
        return null;
    }

    private boolean isAddressReferenceOperand(int opType) {
        if ((opType & 0x2000) == 0) {
            return false;
        }
        return (opType & 0x80) != 0 || (opType & 0x4000) != 0 || (opType & 0x400000) != 0;
    }

    private class PushedParamInfo {
        private String name;
        private DataType dataType;
        private Address addr;
        private String calledFunctionName;

        PushedParamInfo(PropagateExternalParametersAnalyzer propagateExternalParametersAnalyzer, String name, DataType dataType, Address addr, String calledFunctionName) {
            this.name = name;
            this.dataType = dataType;
            this.addr = addr;
            this.calledFunctionName = calledFunctionName;
        }

        String getName() {
            return this.name;
        }

        DataType getDataType() {
            return this.dataType;
        }

        Address getAddress() {
            return this.addr;
        }

        String getCalledFunctionName() {
            return this.calledFunctionName;
        }
    }
}

