/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.gadp.client;

import com.google.protobuf.Message;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.AbstractTargetObject;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.gadp.GadpRegistry;
import ghidra.dbg.gadp.client.GadpClient;
import ghidra.dbg.gadp.client.GadpClientTargetMemory;
import ghidra.dbg.gadp.client.GadpClientTargetObject;
import ghidra.dbg.gadp.client.GadpValueUtils;
import ghidra.dbg.gadp.client.annot.GadpEventHandler;
import ghidra.dbg.gadp.protocol.Gadp;
import ghidra.dbg.memory.CachedMemory;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.program.model.address.AddressSpace;
import ghidra.util.Msg;
import ghidra.util.datastruct.ListenerSet;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import utilities.util.ProxyUtilities;

public class DelegateGadpClientTargetObject
extends DefaultTargetObject<GadpClientTargetObject, GadpClientTargetObject>
implements GadpClientTargetObject {
    protected static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    protected static final Map<Set<Class<? extends TargetObject>>, GadpEventHandlerMap> EVENT_HANDLER_MAPS_BY_COMPOSITION = new HashMap<Set<Class<? extends TargetObject>>, GadpEventHandlerMap>();
    private final GadpClient client;
    private final List<String> ifaceNames;
    private final List<Class<? extends TargetObject>> ifaces;
    private final GadpEventHandlerMap eventHandlers;
    protected Map<AddressSpace, CachedMemory> memCache = null;
    protected Map<String, byte[]> regCache = null;
    protected ListenerSet<TargetBreakpointSpec.TargetBreakpointAction> actions = null;

    protected static GadpClientTargetObject makeModelProxy(GadpClient client, GadpClientTargetObject parent, String key, String typeHint, List<String> ifaceNames) {
        List ifaces = TargetObject.getInterfacesByName(ifaceNames);
        List<Class<? extends TargetObject>> mixins = GadpRegistry.getMixins(ifaces);
        TargetObjectSchema schema = parent == null ? client.getRootSchema() : parent.getSchema().getChildSchema(key);
        return new DelegateGadpClientTargetObject(client, parent, key, typeHint, schema, ifaceNames, ifaces, mixins).getProxy();
    }

    public DelegateGadpClientTargetObject(GadpClient client, GadpClientTargetObject parent, String key, String typeHint, TargetObjectSchema schema, List<String> ifaceNames, List<Class<? extends TargetObject>> ifaces, List<Class<? extends TargetObject>> mixins) {
        super((AbstractTargetObject.ProxyFactory)client, mixins, (AbstractDebuggerObjectModel)client, (TargetObject)parent, key, typeHint, schema);
        this.client = client;
        this.ifaceNames = ifaceNames;
        this.ifaces = ifaces;
        HashSet<Class<? extends TargetObject>> allMixins = new HashSet<Class<? extends TargetObject>>(mixins);
        allMixins.add(GadpClientTargetObject.class);
        this.eventHandlers = EVENT_HANDLER_MAPS_BY_COMPOSITION.computeIfAbsent(allMixins, GadpEventHandlerMap::new);
    }

    @Override
    public GadpClient getModel() {
        return this.client;
    }

    public GadpClientTargetObject getProxy() {
        return (GadpClientTargetObject)super.getProxy();
    }

    public Collection<String> getInterfaceNames() {
        return this.ifaceNames;
    }

    public Collection<? extends Class<? extends TargetObject>> getInterfaces() {
        return this.ifaces;
    }

    public CompletableFuture<Void> resync(DebuggerObjectModel.RefreshBehavior attributes, DebuggerObjectModel.RefreshBehavior elements) {
        return this.client.sendChecked((Message.Builder)Gadp.ResyncRequest.newBuilder().setPath(GadpValueUtils.makePath(this.path)).setAttributes(attributes.equals((Object)DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS)).setElements(elements.equals((Object)DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS)), Gadp.ResyncReply.getDefaultInstance()).thenApply(rep -> null);
    }

    protected CompletableFuture<Void> requestAttributes(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.resync(refresh, DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
    }

    protected CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.resync(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER, refresh);
    }

    @Override
    public DelegateGadpClientTargetObject getDelegate() {
        return this;
    }

    public void updateWithDeltas(Gadp.ModelObjectDelta deltaE, Gadp.ModelObjectDelta deltaA) {
        Map<String, GadpClientTargetObject> elementsAdded = GadpValueUtils.getElementMap(this, deltaE.getAddedList());
        Map<String, Object> attributesAdded = GadpValueUtils.getAttributeMap(this, deltaA.getAddedList());
        this.changeElements((Collection)deltaE.getRemovedList(), List.of(), elementsAdded, "Updated");
        this.changeAttributes((List)deltaA.getRemovedList(), attributesAdded, "Updated");
    }

    protected void handleEvent(Gadp.EventNotification notify) {
        this.eventHandlers.handle(this.getProxy(), notify.getEvtCase(), notify);
    }

    protected void assertValid() {
        if (!this.valid) {
            throw new IllegalStateException("Object is no longer valid: " + this.toString());
        }
    }

    protected void doClearCaches() {
        this.clearMemCacheEntries();
        this.clearRegisterCacheEntries();
    }

    public synchronized CompletableFuture<Void> invalidateCaches() {
        this.assertValid();
        this.doClearCaches();
        return this.client.sendChecked((Message.Builder)Gadp.CacheInvalidateRequest.newBuilder().setPath(GadpValueUtils.makePath(this.path)), Gadp.CacheInvalidateReply.getDefaultInstance()).thenApply(rep -> null);
    }

    protected synchronized CachedMemory getMemoryCache(AddressSpace space) {
        GadpClientTargetMemory memory = (GadpClientTargetMemory)this.getProxy();
        if (this.memCache == null) {
            this.memCache = new HashMap<AddressSpace, CachedMemory>();
        }
        return this.memCache.computeIfAbsent(space, s -> new CachedMemory(memory.getRawReader((AddressSpace)s), memory.getRawWriter((AddressSpace)s)));
    }

    protected synchronized void clearMemCacheEntries() {
        if (this.memCache == null) {
            return;
        }
        for (CachedMemory mem : this.memCache.values()) {
            mem.clear();
        }
    }

    protected synchronized Map<String, byte[]> getRegisterCache() {
        if (this.regCache == null) {
            this.regCache = Collections.synchronizedMap(new HashMap());
        }
        return this.regCache;
    }

    protected synchronized void clearRegisterCacheEntries() {
        if (this.regCache != null) {
            this.regCache.clear();
        }
    }

    protected synchronized ListenerSet<TargetBreakpointSpec.TargetBreakpointAction> getActions(boolean createIfAbsent) {
        if (this.actions == null && createIfAbsent) {
            this.actions = new ListenerSet(TargetBreakpointSpec.TargetBreakpointAction.class, false);
        }
        return this.actions;
    }

    public void doInvalidate(TargetObject branch, String reason) {
        this.client.removeProxy(this.path, reason);
        super.doInvalidate(branch, reason);
    }

    protected static class GadpEventHandlerMap
    extends GadpHandlerMap<GadpEventHandler, Gadp.EventNotification.EvtCase> {
        protected static final Class<?>[] PARAMETER_CLASSES = new Class[]{Gadp.EventNotification.class};

        public GadpEventHandlerMap(Set<Class<? extends TargetObject>> ifaces) {
            super(GadpEventHandler.class, PARAMETER_CLASSES);
            for (Class<? extends TargetObject> iface : ifaces) {
                this.registerInterface(iface);
            }
        }

        @Override
        protected Gadp.EventNotification.EvtCase getKey(GadpEventHandler annot) {
            return annot.value();
        }
    }

    protected static abstract class GadpHandlerMap<A extends Annotation, K> {
        protected final Class<A> annotationType;
        protected final Class<?>[] paramClasses;
        protected final Map<K, MethodHandle> handles = new HashMap<K, MethodHandle>();

        public GadpHandlerMap(Class<A> annotationType, Class<?>[] paramClasses) {
            this.annotationType = annotationType;
            this.paramClasses = paramClasses;
        }

        protected abstract K getKey(A var1);

        protected void compose(GadpHandlerMap<A, K> that) {
            for (Map.Entry<K, MethodHandle> ent : that.handles.entrySet()) {
                MethodHandle old = this.handles.put(ent.getKey(), ent.getValue());
                if (old != null) {
                    throw new AssertionError((Object)("Conflict over handler for " + String.valueOf(ent.getKey()) + ": " + String.valueOf(old) + " and " + String.valueOf(ent.getValue())));
                }
            }
        }

        protected void register(K key, MethodHandle handle) {
            MethodHandle old = this.handles.put(key, handle);
            if (old != null) {
                throw new AssertionError((Object)("Conflict over handler for " + String.valueOf(key) + ": " + String.valueOf(old) + " and " + String.valueOf(handle)));
            }
        }

        protected void registerInterface(Class<? extends TargetObject> iface) {
            for (Method method : iface.getDeclaredMethods()) {
                MethodHandle handle;
                A annot = method.getDeclaredAnnotation(this.annotationType);
                if (annot == null) continue;
                if (!Arrays.equals(this.paramClasses, method.getParameterTypes())) {
                    throw new AssertionError((Object)("@" + this.annotationType.getSimpleName() + " methods must have typed parameters: " + Arrays.toString(this.paramClasses)));
                }
                try {
                    handle = ProxyUtilities.getSuperMethodHandle((Method)method, (MethodHandles.Lookup)LOOKUP);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
                this.register(this.getKey(annot), handle);
            }
        }

        protected void handle(GadpClientTargetObject proxy, K key, Object ... params) {
            MethodHandle handle = this.handles.get(key);
            if (handle == null) {
                return;
            }
            try {
                handle.bindTo(proxy).invokeWithArguments(params);
            }
            catch (Throwable e) {
                Msg.error((Object)this, (Object)("Problem processing key: " + String.valueOf(key)), (Throwable)e);
            }
        }
    }
}

