/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.gadp.server;

import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.loop.AsyncLoopHandlerForFirst;
import ghidra.comm.service.AbstractAsyncClientHandler;
import ghidra.comm.service.AbstractAsyncServer;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.error.DebuggerMemoryAccessException;
import ghidra.dbg.error.DebuggerModelAccessException;
import ghidra.dbg.error.DebuggerModelNoSuchPathException;
import ghidra.dbg.error.DebuggerModelTypeException;
import ghidra.dbg.error.DebuggerRegisterAccessException;
import ghidra.dbg.error.DebuggerUserException;
import ghidra.dbg.gadp.GadpVersion;
import ghidra.dbg.gadp.client.GadpValueUtils;
import ghidra.dbg.gadp.error.GadpErrorException;
import ghidra.dbg.gadp.protocol.Gadp;
import ghidra.dbg.gadp.server.AbstractGadpServer;
import ghidra.dbg.gadp.util.AsyncProtobufMessageChannel;
import ghidra.dbg.target.TargetActiveScope;
import ghidra.dbg.target.TargetAttachable;
import ghidra.dbg.target.TargetAttacher;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetConfigurable;
import ghidra.dbg.target.TargetConsole;
import ghidra.dbg.target.TargetDeletable;
import ghidra.dbg.target.TargetDetachable;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetInterpreter;
import ghidra.dbg.target.TargetInterruptible;
import ghidra.dbg.target.TargetKillable;
import ghidra.dbg.target.TargetLauncher;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetRegisterBank;
import ghidra.dbg.target.TargetResumable;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.TargetSteppable;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.schema.EnumerableTargetObjectSchema;
import ghidra.dbg.target.schema.SchemaContext;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.XmlSchemaContext;
import ghidra.dbg.util.CollectionUtils;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.util.Msg;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class GadpClientHandler
extends AbstractAsyncClientHandler<AbstractGadpServer, GadpClientHandler> {
    protected static final boolean LOG_ERROR_REPLY_STACKS = false;
    protected final DebuggerObjectModel model;
    protected final AsyncProtobufMessageChannel<Gadp.RootMessage, Gadp.RootMessage> channel;
    protected final ListenerForEvents listenerForEvents = new ListenerForEvents();

    protected static <T> T errorSendNotify(Throwable e) {
        Msg.error(GadpClientHandler.class, (Object)("Could not send notification: " + String.valueOf(e)));
        return null;
    }

    public GadpClientHandler(AbstractGadpServer server, AsynchronousSocketChannel sock) {
        super((AbstractAsyncServer)server, sock);
        this.model = server.model;
        this.channel = this.createMessageChannel(sock);
    }

    protected AsyncProtobufMessageChannel<Gadp.RootMessage, Gadp.RootMessage> createMessageChannel(AsynchronousByteChannel byteChannel) {
        return new AsyncProtobufMessageChannel<Gadp.RootMessage, Gadp.RootMessage>(byteChannel);
    }

    protected CompletableFuture<Void> launchAsync() {
        return AsyncUtils.loop((TypeSpec)TypeSpec.VOID, loop -> {
            if (this.sock.isOpen()) {
                this.channel.read(Gadp.RootMessage::parseFrom).handle((arg_0, arg_1) -> ((AsyncLoopHandlerForFirst)loop).consume(arg_0, arg_1));
            } else {
                loop.exit();
            }
        }, (TypeSpec)TypeSpec.cls(Gadp.RootMessage.class), (msg, loop) -> {
            loop.repeat();
            try {
                this.processMessage((Gadp.RootMessage)msg).exceptionally(e -> {
                    e.printStackTrace();
                    this.replyError((Gadp.RootMessage)msg, (Throwable)e).exceptionally(ee -> {
                        Msg.error((Object)((Object)this), (Object)("Could not send error reply: " + String.valueOf(ee)));
                        return null;
                    });
                    return null;
                });
            }
            catch (Throwable e2) {
                this.replyError((Gadp.RootMessage)msg, e2).exceptionally(ee -> {
                    Msg.error((Object)((Object)this), (Object)("Could not send error reply: " + String.valueOf(ee)));
                    return null;
                });
            }
        });
    }

    protected Gadp.RootMessage buildError(Gadp.RootMessage req, Gadp.ErrorCode code, String message) {
        return Gadp.RootMessage.newBuilder().setSequence(req.getSequence()).setErrorReply(Gadp.ErrorReply.newBuilder().setCode(code).setMessage(message)).build();
    }

    protected CompletableFuture<?> replyError(Gadp.RootMessage req, Throwable e) {
        Throwable t = AsyncUtils.unwrapThrowable((Throwable)e);
        Msg.debug((Object)((Object)this), (Object)("Error caused by request " + String.valueOf(req) + ": " + String.valueOf(e)));
        if (t instanceof GadpErrorException) {
            GadpErrorException error = (GadpErrorException)t;
            return this.channel.write(this.buildError(req, error.getCode(), error.getMessage()));
        }
        if (t instanceof UnsupportedOperationException) {
            return this.channel.write(this.buildError(req, Gadp.ErrorCode.EC_NOT_SUPPORTED, t.getMessage()));
        }
        if (t instanceof DebuggerModelNoSuchPathException) {
            return this.channel.write(this.buildError(req, Gadp.ErrorCode.EC_NO_OBJECT, t.getMessage()));
        }
        if (t instanceof DebuggerModelTypeException) {
            return this.channel.write(this.buildError(req, Gadp.ErrorCode.EC_NO_INTERFACE, t.getMessage()));
        }
        if (t instanceof DebuggerIllegalArgumentException) {
            return this.channel.write(this.buildError(req, Gadp.ErrorCode.EC_BAD_ARGUMENT, t.getMessage()));
        }
        if (t instanceof DebuggerMemoryAccessException) {
            return this.channel.write(this.buildError(req, Gadp.ErrorCode.EC_MEMORY_ACCESS, t.getMessage()));
        }
        if (t instanceof DebuggerRegisterAccessException) {
            return this.channel.write(this.buildError(req, Gadp.ErrorCode.EC_REGISTER_ACCESS, t.getMessage()));
        }
        if (t instanceof DebuggerUserException) {
            return this.channel.write(this.buildError(req, Gadp.ErrorCode.EC_USER_ERROR, t.getMessage()));
        }
        if (t instanceof DebuggerModelAccessException) {
            return this.channel.write(this.buildError(req, Gadp.ErrorCode.EC_MODEL_ACCESS, t.getMessage()));
        }
        return this.channel.write(this.buildError(req, Gadp.ErrorCode.EC_UNKNOWN, "Unknown server-side error"));
    }

    protected GadpVersion getVersion() {
        return GadpVersion.VER1;
    }

    protected CompletableFuture<?> processMessage(Gadp.RootMessage msg) {
        switch (msg.getMsgCase()) {
            case CONNECT_REQUEST: {
                return this.processConnect(msg.getSequence(), msg.getConnectRequest());
            }
            case PING_REQUEST: {
                return this.processPing(msg.getSequence(), msg.getPingRequest());
            }
            case ATTACH_REQUEST: {
                return this.processAttach(msg.getSequence(), msg.getAttachRequest());
            }
            case BREAK_CREATE_REQUEST: {
                return this.processBreakCreate(msg.getSequence(), msg.getBreakCreateRequest());
            }
            case BREAK_TOGGLE_REQUEST: {
                return this.processBreakToggle(msg.getSequence(), msg.getBreakToggleRequest());
            }
            case CACHE_INVALIDATE_REQUEST: {
                return this.processCacheInvalidate(msg.getSequence(), msg.getCacheInvalidateRequest());
            }
            case CONFIGURE_REQUEST: {
                return this.processConfigure(msg.getSequence(), msg.getConfigureRequest());
            }
            case DELETE_REQUEST: {
                return this.processDelete(msg.getSequence(), msg.getDeleteRequest());
            }
            case DETACH_REQUEST: {
                return this.processDetach(msg.getSequence(), msg.getDetachRequest());
            }
            case EXECUTE_REQUEST: {
                return this.processExecute(msg.getSequence(), msg.getExecuteRequest());
            }
            case FOCUS_REQUEST: {
                return this.processFocus(msg.getSequence(), msg.getFocusRequest());
            }
            case INTERRUPT_REQUEST: {
                return this.processInterrupt(msg.getSequence(), msg.getInterruptRequest());
            }
            case INVOKE_REQUEST: {
                return this.processInvoke(msg.getSequence(), msg.getInvokeRequest());
            }
            case KILL_REQUEST: {
                return this.processKill(msg.getSequence(), msg.getKillRequest());
            }
            case LAUNCH_REQUEST: {
                return this.processLaunch(msg.getSequence(), msg.getLaunchRequest());
            }
            case MEMORY_READ_REQUEST: {
                return this.processMemoryRead(msg.getSequence(), msg.getMemoryReadRequest());
            }
            case MEMORY_WRITE_REQUEST: {
                return this.processMemoryWrite(msg.getSequence(), msg.getMemoryWriteRequest());
            }
            case REGISTER_READ_REQUEST: {
                return this.processRegisterRead(msg.getSequence(), msg.getRegisterReadRequest());
            }
            case REGISTER_WRITE_REQUEST: {
                return this.processRegisterWrite(msg.getSequence(), msg.getRegisterWriteRequest());
            }
            case RESYNC_REQUEST: {
                return this.processResync(msg.getSequence(), msg.getResyncRequest());
            }
            case RESUME_REQUEST: {
                return this.processResume(msg.getSequence(), msg.getResumeRequest());
            }
            case STEP_REQUEST: {
                return this.processStep(msg.getSequence(), msg.getStepRequest());
            }
            case ACTIVATION_REQUEST: {
                return this.processActivation(msg.getSequence(), msg.getActivationRequest());
            }
        }
        throw new GadpErrorException(Gadp.ErrorCode.EC_BAD_REQUEST, "Unrecognized request: " + String.valueOf((Object)msg.getMsgCase()));
    }

    protected CompletableFuture<?> processConnect(int seqno, Gadp.ConnectRequest req) {
        String ver = this.getVersion().getName();
        if (!req.getVersionList().contains((Object)ver)) {
            throw new GadpErrorException(Gadp.ErrorCode.EC_NO_VERSION, "No listed version is supported");
        }
        TargetObjectSchema rootSchema = this.model.getRootSchema();
        if (rootSchema == null) {
            Msg.error((Object)((Object)this), (Object)"Served model has no schema! Using OBJECT");
            rootSchema = EnumerableTargetObjectSchema.OBJECT;
        }
        CompletableFuture<Integer> send = this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setConnectReply(Gadp.ConnectReply.newBuilder().setVersion(ver).setSchemaContext(XmlSchemaContext.serialize((SchemaContext)rootSchema.getContext())).setRootSchema(rootSchema.getName().toString())).build());
        return send.thenAccept(__ -> this.model.addModelListener((DebuggerModelListener)this.listenerForEvents, true));
    }

    protected CompletableFuture<?> processPing(int seqno, Gadp.PingRequest req) {
        return this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setPingReply(Gadp.PingReply.newBuilder().setContent(req.getContent())).build());
    }

    protected <T extends TargetObject> T isObjectValuedAttribute(TargetObject parent, Map.Entry<String, ?> ent, Class<T> cls) {
        Object val = ent.getValue();
        if (!cls.isAssignableFrom(val.getClass())) {
            return null;
        }
        TargetObject ref = (TargetObject)cls.cast(val);
        if (!ref.getPath().equals(PathUtils.extend((List)parent.getPath(), (String)ent.getKey()))) {
            return null;
        }
        return (T)ref;
    }

    protected <T extends TargetObject> CompletableFuture<Integer> sendDelta(List<String> parentPath, CollectionUtils.Delta<TargetObject, T> deltaE, CollectionUtils.Delta<?, ?> deltaA) {
        return this.channel.write(Gadp.RootMessage.newBuilder().setEventNotification(Gadp.EventNotification.newBuilder().setPath(GadpValueUtils.makePath(parentPath)).setModelObjectEvent(Gadp.ModelObjectEvent.newBuilder().setElementDelta(GadpValueUtils.makeElementDelta(parentPath, deltaE)).setAttributeDelta(GadpValueUtils.makeElementDelta(parentPath, deltaA)))).build());
    }

    protected TargetObject getObjectChecked(List<String> path) {
        return (TargetObject)DebuggerObjectModel.requireNonNull((Object)this.model.getModelObject(path), path);
    }

    protected TargetObject getObjectChecked(Gadp.Path path) {
        return this.getObjectChecked((List<String>)path.getEList());
    }

    protected CompletableFuture<?> processInvoke(int seqno, Gadp.InvokeRequest req) {
        TargetMethod method = (TargetMethod)this.getObjectChecked(req.getPath()).as(TargetMethod.class);
        Map<String, ?> arguments = GadpValueUtils.getArguments(this.model, req.getArgumentList());
        return ((CompletableFuture)method.invoke(arguments).thenCompose(result -> this.model.flushEvents().thenApply(__ -> result))).thenCompose(result -> this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setInvokeReply(Gadp.InvokeReply.newBuilder().setResult(GadpValueUtils.makeValue(null, result))).build()));
    }

    protected CompletableFuture<?> processResync(int seqno, Gadp.ResyncRequest req) {
        ProtocolStringList path = req.getPath().getEList();
        return ((CompletableFuture)((CompletableFuture)this.model.fetchModelObject((List)path).thenCompose(arg_0 -> GadpClientHandler.lambda$processResync$9((List)path, req, arg_0))).thenCompose(__ -> this.model.flushEvents())).thenCompose(__ -> this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setResyncReply(Gadp.ResyncReply.getDefaultInstance()).build()));
    }

    protected CompletableFuture<Void> performAttach(Gadp.AttachRequest req, TargetAttacher attacher) {
        switch (req.getSpecCase()) {
            case TARGET: {
                TargetAttachable attachable = (TargetAttachable)this.getObjectChecked(req.getTarget()).as(TargetAttachable.class);
                return attacher.attach(attachable);
            }
            case PID: {
                return attacher.attach(req.getPid());
            }
        }
        throw new GadpErrorException(Gadp.ErrorCode.EC_BAD_REQUEST, "Unrecognized attach specification:" + String.valueOf(req));
    }

    protected CompletableFuture<?> processAttach(int seqno, Gadp.AttachRequest req) {
        TargetAttacher attacher = (TargetAttacher)this.getObjectChecked(req.getPath()).as(TargetAttacher.class);
        return ((CompletableFuture)this.performAttach(req, attacher).thenCompose(__ -> this.model.flushEvents())).thenCompose(__ -> this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setAttachReply(Gadp.AttachReply.getDefaultInstance()).build()));
    }

    protected CompletableFuture<Void> performBreakCreate(Gadp.BreakCreateRequest req, TargetBreakpointSpecContainer breaks) {
        TargetBreakpointSpecContainer.TargetBreakpointKindSet kinds = GadpValueUtils.getBreakKindSet(req.getKinds());
        switch (req.getSpecCase()) {
            case EXPRESSION: {
                return breaks.placeBreakpoint(req.getExpression(), (Set)kinds);
            }
            case ADDRESS: {
                AddressRange range = ((AbstractGadpServer)this.server).getAddressRange(req.getAddress());
                return breaks.placeBreakpoint(range, (Set)kinds);
            }
        }
        throw new GadpErrorException(Gadp.ErrorCode.EC_BAD_REQUEST, "Unrecognized breakpoint specification: " + String.valueOf(req));
    }

    protected CompletableFuture<?> processBreakCreate(int seqno, Gadp.BreakCreateRequest req) {
        TargetBreakpointSpecContainer breaks = (TargetBreakpointSpecContainer)this.getObjectChecked(req.getPath()).as(TargetBreakpointSpecContainer.class);
        return ((CompletableFuture)this.performBreakCreate(req, breaks).thenCompose(__ -> this.model.flushEvents())).thenCompose(__ -> this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setBreakCreateReply(Gadp.BreakCreateReply.getDefaultInstance()).build()));
    }

    protected CompletableFuture<?> processBreakToggle(int seqno, Gadp.BreakToggleRequest req) {
        TargetBreakpointSpec spec = (TargetBreakpointSpec)this.getObjectChecked(req.getPath()).as(TargetBreakpointSpec.class);
        return ((CompletableFuture)spec.toggle(req.getEnabled()).thenCompose(__ -> this.model.flushEvents())).thenCompose(__ -> this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setBreakToggleReply(Gadp.BreakToggleReply.getDefaultInstance()).build()));
    }

    protected CompletableFuture<?> processDelete(int seqno, Gadp.DeleteRequest req) {
        TargetDeletable del = (TargetDeletable)this.getObjectChecked(req.getPath()).as(TargetDeletable.class);
        return ((CompletableFuture)del.delete().thenCompose(__ -> this.model.flushEvents())).thenCompose(__ -> this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setDeleteReply(Gadp.DeleteReply.getDefaultInstance()).build()));
    }

    protected CompletableFuture<?> processDetach(int seqno, Gadp.DetachRequest req) {
        TargetDetachable det = (TargetDetachable)this.getObjectChecked(req.getPath()).as(TargetDetachable.class);
        return ((CompletableFuture)det.detach().thenCompose(__ -> this.model.flushEvents())).thenCompose(__ -> this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setDetachReply(Gadp.DetachReply.getDefaultInstance()).build()));
    }

    protected CompletableFuture<String> performExecute(Gadp.ExecuteRequest req, TargetInterpreter interpreter) {
        if (req.getCapture()) {
            return interpreter.executeCapture(req.getCommand());
        }
        return interpreter.execute(req.getCommand()).thenApply(__ -> "");
    }

    protected CompletableFuture<?> processExecute(int seqno, Gadp.ExecuteRequest req) {
        TargetInterpreter interpreter = (TargetInterpreter)this.getObjectChecked(req.getPath()).as(TargetInterpreter.class);
        return ((CompletableFuture)this.performExecute(req, interpreter).thenCompose(out -> this.model.flushEvents().thenApply(__ -> out))).thenCompose(out -> this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setExecuteReply(Gadp.ExecuteReply.newBuilder().setCaptured((String)out)).build()));
    }

    protected CompletableFuture<?> processActivation(int seqno, Gadp.ActivationRequest req) {
        TargetActiveScope scope = (TargetActiveScope)this.getObjectChecked(req.getPath()).as(TargetActiveScope.class);
        TargetObject active = this.getObjectChecked(req.getActive());
        return ((CompletableFuture)scope.requestActivation(active).thenCompose(__ -> this.model.flushEvents())).thenCompose(__ -> this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setActivationReply(Gadp.ActivationReply.getDefaultInstance()).build()));
    }

    protected CompletableFuture<?> processFocus(int seqno, Gadp.FocusRequest req) {
        TargetFocusScope scope = (TargetFocusScope)this.getObjectChecked(req.getPath()).as(TargetFocusScope.class);
        TargetObject focus = this.getObjectChecked(req.getFocus());
        return ((CompletableFuture)scope.requestFocus(focus).thenCompose(__ -> this.model.flushEvents())).thenCompose(__ -> this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setFocusReply(Gadp.FocusReply.getDefaultInstance()).build()));
    }

    protected CompletableFuture<?> processInterrupt(int seqno, Gadp.InterruptRequest req) {
        TargetInterruptible interruptible = (TargetInterruptible)this.getObjectChecked(req.getPath()).as(TargetInterruptible.class);
        return ((CompletableFuture)interruptible.interrupt().thenCompose(__ -> this.model.flushEvents())).thenCompose(__ -> this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setInterruptReply(Gadp.InterruptReply.getDefaultInstance()).build()));
    }

    protected CompletableFuture<?> processCacheInvalidate(int seqno, Gadp.CacheInvalidateRequest req) {
        ProtocolStringList path = req.getPath().getEList();
        TargetObject obj = this.getObjectChecked((List<String>)path);
        return ((CompletableFuture)obj.invalidateCaches().thenCompose(__ -> this.model.flushEvents())).thenCompose(__ -> this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setCacheInvalidateReply(Gadp.CacheInvalidateReply.getDefaultInstance()).build()));
    }

    protected CompletableFuture<?> processConfigure(int seqno, Gadp.ConfigureRequest req) {
        TargetConfigurable configurable = (TargetConfigurable)this.getObjectChecked(req.getPath()).as(TargetConfigurable.class);
        String key = req.getOption().getName();
        Object value = GadpValueUtils.getAttributeValue((TargetObject)configurable, req.getOption());
        return ((CompletableFuture)configurable.writeConfigurationOption(key, value).thenCompose(__ -> this.model.flushEvents())).thenCompose(__ -> this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setConfigureReply(Gadp.ConfigureReply.getDefaultInstance()).build()));
    }

    protected CompletableFuture<?> processKill(int seqno, Gadp.KillRequest req) {
        TargetKillable killable = (TargetKillable)this.getObjectChecked(req.getPath()).as(TargetKillable.class);
        return ((CompletableFuture)killable.kill().thenCompose(__ -> this.model.flushEvents())).thenCompose(__ -> this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setKillReply(Gadp.KillReply.getDefaultInstance()).build()));
    }

    protected CompletableFuture<?> processLaunch(int seqno, Gadp.LaunchRequest req) {
        TargetLauncher launcher = (TargetLauncher)this.getObjectChecked(req.getPath()).as(TargetLauncher.class);
        Map<String, ?> arguments = GadpValueUtils.getArguments(this.model, req.getArgumentList());
        return ((CompletableFuture)launcher.launch(arguments).thenCompose(__ -> {
            Msg.debug((Object)((Object)this), (Object)("Flushing events after launch: " + String.valueOf(Thread.currentThread())));
            return this.model.flushEvents();
        })).thenCompose(__ -> {
            Msg.debug((Object)((Object)this), (Object)("Responding after launch: " + String.valueOf(Thread.currentThread())));
            return this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setLaunchReply(Gadp.LaunchReply.getDefaultInstance()).build());
        });
    }

    protected CompletableFuture<?> processMemoryRead(int seqno, Gadp.MemoryReadRequest req) {
        TargetMemory memory = (TargetMemory)this.getObjectChecked(req.getPath()).as(TargetMemory.class);
        AddressRange range = GadpValueUtils.getAddressRange(memory.getModel(), req.getRange());
        CompletableFuture read = memory.readMemory(range.getMinAddress(), (int)range.getLength());
        return ((CompletableFuture)read.thenCompose(data -> this.model.flushEvents().thenApply(__ -> data))).thenCompose(data -> this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setMemoryReadReply(Gadp.MemoryReadReply.newBuilder().setContent(ByteString.copyFrom((byte[])data))).build()));
    }

    protected CompletableFuture<?> processMemoryWrite(int seqno, Gadp.MemoryWriteRequest req) {
        TargetMemory memory = (TargetMemory)this.getObjectChecked(req.getPath()).as(TargetMemory.class);
        Address start = GadpValueUtils.getAddress(memory.getModel(), req.getStart());
        return ((CompletableFuture)memory.writeMemory(start, req.getContent().toByteArray()).thenCompose(__ -> this.model.flushEvents())).thenCompose(__ -> this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setMemoryWriteReply(Gadp.MemoryWriteReply.getDefaultInstance()).build()));
    }

    protected CompletableFuture<?> processRegisterRead(int seqno, Gadp.RegisterReadRequest req) {
        TargetRegisterBank bank = (TargetRegisterBank)this.getObjectChecked(req.getPath()).as(TargetRegisterBank.class);
        return ((CompletableFuture)bank.readRegistersNamed((Collection)req.getNameList()).thenCompose(data -> this.model.flushEvents().thenApply(__ -> data))).thenCompose(data -> this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setRegisterReadReply(Gadp.RegisterReadReply.newBuilder().addAllValue(GadpValueUtils.makeRegisterValues(data))).build()));
    }

    protected CompletableFuture<?> processRegisterWrite(int seqno, Gadp.RegisterWriteRequest req) {
        TargetRegisterBank bank = (TargetRegisterBank)this.getObjectChecked(req.getPath()).as(TargetRegisterBank.class);
        LinkedHashMap<String, byte[]> values = new LinkedHashMap<String, byte[]>();
        for (Gadp.RegisterValue rv : req.getValueList()) {
            values.put(rv.getName(), rv.getContent().toByteArray());
        }
        return ((CompletableFuture)bank.writeRegistersNamed(values).thenCompose(__ -> this.model.flushEvents())).thenCompose(__ -> this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setRegisterWriteReply(Gadp.RegisterWriteReply.getDefaultInstance()).build()));
    }

    protected CompletableFuture<?> processResume(int seqno, Gadp.ResumeRequest req) {
        TargetResumable resumable = (TargetResumable)this.getObjectChecked(req.getPath()).as(TargetResumable.class);
        return ((CompletableFuture)resumable.resume().thenCompose(__ -> this.model.flushEvents())).thenCompose(__ -> this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setResumeReply(Gadp.ResumeReply.getDefaultInstance()).build()));
    }

    protected CompletableFuture<?> processStep(int seqno, Gadp.StepRequest req) {
        TargetSteppable steppable = (TargetSteppable)this.getObjectChecked(req.getPath()).as(TargetSteppable.class);
        return ((CompletableFuture)steppable.step(GadpValueUtils.getStepKind(req.getKind())).thenCompose(__ -> this.model.flushEvents())).thenCompose(__ -> this.channel.write(Gadp.RootMessage.newBuilder().setSequence(seqno).setStepReply(Gadp.StepReply.getDefaultInstance()).build()));
    }

    private static /* synthetic */ CompletionStage lambda$processResync$9(List path, Gadp.ResyncRequest req, TargetObject obj) {
        DebuggerObjectModel.requireNonNull((Object)obj, (List)path);
        DebuggerObjectModel.RefreshBehavior reqAttributes = req.getAttributes() ? DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS : DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER;
        DebuggerObjectModel.RefreshBehavior reqElements = req.getElements() ? DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS : DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER;
        return obj.resync(reqAttributes, reqElements);
    }

    protected class ListenerForEvents
    implements DebuggerModelListener {
        protected ListenerForEvents() {
        }

        public void created(TargetObject object) {
            if (!GadpClientHandler.this.sock.isOpen()) {
                return;
            }
            GadpClientHandler.this.channel.write(Gadp.RootMessage.newBuilder().setEventNotification(Gadp.EventNotification.newBuilder().setPath(GadpValueUtils.makePath(object.getPath())).setObjectCreatedEvent(Gadp.ObjectCreatedEvent.newBuilder().setTypeHint(object.getTypeHint()).addAllInterface(object.getInterfaceNames()))).build()).exceptionally(GadpClientHandler::errorSendNotify);
        }

        public void rootAdded(TargetObject root) {
            if (!GadpClientHandler.this.sock.isOpen()) {
                return;
            }
            GadpClientHandler.this.channel.write(Gadp.RootMessage.newBuilder().setEventNotification(Gadp.EventNotification.newBuilder().setRootAddedEvent(Gadp.RootAddedEvent.getDefaultInstance())).build()).exceptionally(GadpClientHandler::errorSendNotify);
        }

        public void attributesChanged(TargetObject parent, Collection<String> removed, Map<String, ?> added) {
            if (!GadpClientHandler.this.sock.isOpen()) {
                return;
            }
            if (removed.isEmpty() && added.isEmpty()) {
                return;
            }
            GadpClientHandler.this.sendDelta(parent.getPath(), CollectionUtils.Delta.empty(), CollectionUtils.Delta.create(removed, added)).exceptionally(GadpClientHandler::errorSendNotify);
        }

        public void elementsChanged(TargetObject parent, Collection<String> removed, Map<String, ? extends TargetObject> added) {
            if (!GadpClientHandler.this.sock.isOpen()) {
                return;
            }
            if (removed.isEmpty() && added.isEmpty()) {
                return;
            }
            GadpClientHandler.this.sendDelta(parent.getPath(), CollectionUtils.Delta.create(removed, added), CollectionUtils.Delta.empty()).exceptionally(GadpClientHandler::errorSendNotify);
        }

        public void invalidated(TargetObject object, TargetObject branch, String reason) {
            if (!GadpClientHandler.this.sock.isOpen()) {
                return;
            }
            if (object != branch) {
                return;
            }
            GadpClientHandler.this.channel.write(Gadp.RootMessage.newBuilder().setEventNotification(Gadp.EventNotification.newBuilder().setPath(GadpValueUtils.makePath(object.getPath())).setObjectInvalidateEvent(Gadp.ObjectInvalidateEvent.newBuilder().setReason(reason))).build()).exceptionally(GadpClientHandler::errorSendNotify);
        }

        public void consoleOutput(TargetObject console, TargetConsole.Channel c, byte[] data) {
            if (!GadpClientHandler.this.sock.isOpen()) {
                return;
            }
            if (c == null || console == null) {
                Msg.warn((Object)this, (Object)"Why is console or channel null in consoleOutput callback?");
                return;
            }
            GadpClientHandler.this.channel.write(Gadp.RootMessage.newBuilder().setEventNotification(Gadp.EventNotification.newBuilder().setPath(GadpValueUtils.makePath(console.getPath())).setConsoleOutputEvent(Gadp.ConsoleOutputEvent.newBuilder().setChannel(c.ordinal()).setData(ByteString.copyFrom((byte[])data)))).build()).exceptionally(GadpClientHandler::errorSendNotify);
        }

        public void consoleOutput(TargetObject console, TargetConsole.Channel c, String out) {
            if (!GadpClientHandler.this.sock.isOpen()) {
                return;
            }
            this.consoleOutput(console, c, out.getBytes(TargetConsole.CHARSET));
        }

        public void breakpointHit(TargetObject container, TargetObject trapped, TargetStackFrame frame, TargetBreakpointSpec spec, TargetBreakpointLocation breakpoint) {
            if (!GadpClientHandler.this.sock.isOpen()) {
                return;
            }
            Gadp.BreakHitEvent.Builder evt = Gadp.BreakHitEvent.newBuilder().setTrapped(GadpValueUtils.makePath(trapped.getPath())).setSpec(GadpValueUtils.makePath(spec.getPath())).setEffective(GadpValueUtils.makePath(breakpoint.getPath()));
            if (frame != null) {
                evt.setFrame(GadpValueUtils.makePath(frame.getPath()));
            }
            GadpClientHandler.this.channel.write(Gadp.RootMessage.newBuilder().setEventNotification(Gadp.EventNotification.newBuilder().setPath(GadpValueUtils.makePath(container.getPath())).setBreakHitEvent(evt)).build()).exceptionally(GadpClientHandler::errorSendNotify);
        }

        public void invalidateCacheRequested(TargetObject object) {
            if (!GadpClientHandler.this.sock.isOpen()) {
                return;
            }
            GadpClientHandler.this.channel.write(Gadp.RootMessage.newBuilder().setEventNotification(Gadp.EventNotification.newBuilder().setPath(GadpValueUtils.makePath(object.getPath())).setCacheInvalidateEvent(Gadp.CacheInvalidateEvent.getDefaultInstance())).build()).exceptionally(GadpClientHandler::errorSendNotify);
        }

        public void memoryReadError(TargetObject memory, AddressRange range, DebuggerMemoryAccessException e) {
            if (!GadpClientHandler.this.sock.isOpen()) {
                return;
            }
            GadpClientHandler.this.channel.write(Gadp.RootMessage.newBuilder().setEventNotification(Gadp.EventNotification.newBuilder().setPath(GadpValueUtils.makePath(memory.getPath())).setMemoryErrorEvent(Gadp.MemoryErrorEvent.newBuilder().setRange(GadpValueUtils.makeRange(range)).setMessage(e.getMessage()))).build()).exceptionally(GadpClientHandler::errorSendNotify);
        }

        public void memoryUpdated(TargetObject memory, Address address, byte[] data) {
            if (!GadpClientHandler.this.sock.isOpen()) {
                return;
            }
            GadpClientHandler.this.channel.write(Gadp.RootMessage.newBuilder().setEventNotification(Gadp.EventNotification.newBuilder().setPath(GadpValueUtils.makePath(memory.getPath())).setMemoryUpdateEvent(Gadp.MemoryUpdateEvent.newBuilder().setAddress(GadpValueUtils.makeAddress(address)).setContent(ByteString.copyFrom((byte[])data)))).build()).exceptionally(GadpClientHandler::errorSendNotify);
        }

        public void registersUpdated(TargetObject bank, Map<String, byte[]> updates) {
            if (!GadpClientHandler.this.sock.isOpen()) {
                return;
            }
            GadpClientHandler.this.channel.write(Gadp.RootMessage.newBuilder().setEventNotification(Gadp.EventNotification.newBuilder().setPath(GadpValueUtils.makePath(bank.getPath())).setRegisterUpdateEvent(Gadp.RegisterUpdateEvent.newBuilder().addAllValue(GadpValueUtils.makeRegisterValues(updates)))).build()).exceptionally(GadpClientHandler::errorSendNotify);
        }

        public void event(TargetObject object, TargetThread eventThread, TargetEventScope.TargetEventType type, String description, List<Object> parameters) {
            if (!GadpClientHandler.this.sock.isOpen()) {
                return;
            }
            Gadp.TargetEvent.Builder evt = Gadp.TargetEvent.newBuilder();
            if (eventThread != null) {
                evt.setEventThread(GadpValueUtils.makePath(eventThread.getPath()));
            }
            evt.setType(GadpValueUtils.makeTargetEventType(type));
            evt.setDescription(description);
            evt.addAllParameters(GadpValueUtils.makeValues(parameters));
            GadpClientHandler.this.channel.write(Gadp.RootMessage.newBuilder().setEventNotification(Gadp.EventNotification.newBuilder().setPath(GadpValueUtils.makePath(object.getPath())).setTargetEvent(evt)).build()).exceptionally(GadpClientHandler::errorSendNotify);
        }
    }

    protected static class UpdateSuppression {
        int attributesCount = 0;
        int elementsCount = 0;

        protected UpdateSuppression() {
        }

        boolean isEmpty() {
            return this.attributesCount == 0 && this.elementsCount == 0;
        }

        void incrementAttributes() {
            ++this.attributesCount;
        }

        void decrementAttributes() {
            assert (this.attributesCount > 0);
            --this.attributesCount;
        }

        void incrementElements() {
            ++this.elementsCount;
        }

        void decrementElements() {
            assert (this.elementsCount > 0);
            --this.elementsCount;
        }
    }
}

