/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift;

import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.swift.SwiftDemangledNodeKind;
import ghidra.app.util.demangler.swift.SwiftNativeDemangler;
import ghidra.app.util.demangler.swift.nodes.SwiftNode;
import ghidra.app.util.demangler.swift.nodes.SwiftUnsupportedNode;
import java.io.IOException;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SwiftDemangledTree {
    private static final Pattern KIND_PATTERN = Pattern.compile("kind=([^,]+)");
    private static final Pattern TEXT_PATTERN = Pattern.compile("text=\"(.+)\"");
    private static final Pattern INDEX_PATTERN = Pattern.compile("index=(.+)");
    private SwiftNode root;
    private String demangledString;

    public SwiftDemangledTree(SwiftNativeDemangler nativeDemangler, String mangled) throws DemangledException {
        SwiftNativeDemangler.SwiftNativeDemangledOutput demangledOutput;
        try {
            demangledOutput = nativeDemangler.demangle(mangled);
        }
        catch (IOException e) {
            throw new DemangledException((Exception)e);
        }
        this.demangledString = demangledOutput.demangled();
        Stack<SwiftNode> stack = new Stack<SwiftNode>();
        for (String line : demangledOutput.tree()) {
            SwiftNode node;
            int depth = this.depth(line);
            String kind = this.match(line, KIND_PATTERN);
            String text = this.match(line, TEXT_PATTERN);
            String index = this.match(line, INDEX_PATTERN);
            try {
                SwiftNode.NodeProperties properties = new SwiftNode.NodeProperties(SwiftDemangledNodeKind.valueOf(kind), text, index, depth, mangled, this.demangledString);
                node = SwiftNode.get(properties);
            }
            catch (IllegalArgumentException e) {
                SwiftNode.NodeProperties properties = new SwiftNode.NodeProperties(SwiftDemangledNodeKind.Unsupported, text, index, depth, mangled, this.demangledString);
                node = new SwiftUnsupportedNode(kind, properties);
            }
            if (node.getDepth() == 0) {
                this.root = node;
            } else {
                if (node.getDepth() <= ((SwiftNode)stack.peek()).getDepth()) {
                    while (((SwiftNode)stack.peek()).getDepth() > node.getDepth() - 1) {
                        stack.pop();
                    }
                }
                node.setParent((SwiftNode)stack.peek());
                ((SwiftNode)stack.peek()).getChildren().add(node);
            }
            stack.push(node);
        }
    }

    public SwiftNode getRoot() {
        return this.root;
    }

    public String getDemangledString() {
        return this.demangledString;
    }

    public String toString() {
        return SwiftNode.toString(this.root, true);
    }

    private int depth(String line) {
        int i;
        for (i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
        }
        return i / 2;
    }

    private String match(String line, Pattern pattern) {
        Matcher matcher = pattern.matcher(line);
        return matcher.find() ? matcher.group(1) : null;
    }
}

