/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.nodes;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.swift.SwiftDemangler;
import ghidra.app.util.demangler.swift.datatypes.SwiftArray;
import ghidra.app.util.demangler.swift.datatypes.SwiftCharacter;
import ghidra.app.util.demangler.swift.datatypes.SwiftDataTypeUtils;
import ghidra.app.util.demangler.swift.datatypes.SwiftPrimitive;
import ghidra.app.util.demangler.swift.datatypes.SwiftString;
import ghidra.app.util.demangler.swift.datatypes.SwiftStructure;
import ghidra.app.util.demangler.swift.nodes.SwiftNode;

public class SwiftStructureNode
extends SwiftNode {
    @Override
    public Demangled demangle(SwiftDemangler demangler) throws DemangledException {
        SwiftStructure struct;
        String name = null;
        Demangled namespace = null;
        Demangled privateDeclNamespace = null;
        block43: for (SwiftNode child : this.getChildren()) {
            switch (child.getKind()) {
                case Identifier: {
                    name = child.getText();
                    continue block43;
                }
                case PrivateDeclName: {
                    Demangled temp = child.demangle(demangler);
                    name = temp.getName();
                    privateDeclNamespace = temp.getNamespace();
                    continue block43;
                }
                case Class: 
                case Enum: 
                case Module: 
                case Structure: {
                    namespace = child.demangle(demangler);
                    continue block43;
                }
            }
            this.skip(child);
        }
        if (name == null) {
            return this.getUnknown();
        }
        String mangled = this.properties.mangled();
        String orig = this.properties.originalDemangled();
        if (SwiftDataTypeUtils.isSwiftNamespace(namespace)) {
            Object type;
            switch (name) {
                case "Bool": {
                    Object object = new SwiftPrimitive(mangled, orig, "bool");
                    break;
                }
                case "Int": {
                    Object object = new SwiftPrimitive(mangled, orig, "int");
                    break;
                }
                case "Int8": {
                    Object object = new SwiftPrimitive(mangled, orig, "__int8");
                    break;
                }
                case "Int16": {
                    Object object = new SwiftPrimitive(mangled, orig, "__int16");
                    break;
                }
                case "Int32": {
                    Object object = new SwiftPrimitive(mangled, orig, "__int32");
                    break;
                }
                case "Int64": {
                    Object object = new SwiftPrimitive(mangled, orig, "__int64");
                    break;
                }
                case "UInt": {
                    Object object = new SwiftPrimitive(mangled, orig, "int", true);
                    break;
                }
                case "UInt8": {
                    Object object = new SwiftPrimitive(mangled, orig, "__int8", true);
                    break;
                }
                case "UInt16": {
                    Object object = new SwiftPrimitive(mangled, orig, "__int16", true);
                    break;
                }
                case "UInt32": {
                    Object object = new SwiftPrimitive(mangled, orig, "__int32", true);
                    break;
                }
                case "UInt64": {
                    Object object = new SwiftPrimitive(mangled, orig, "__int64", true);
                    break;
                }
                case "Float": {
                    Object object = new SwiftPrimitive(mangled, orig, "float");
                    break;
                }
                case "Float16": {
                    Object object = new SwiftPrimitive(mangled, orig, "float2");
                    break;
                }
                case "Double": {
                    Object object = new SwiftPrimitive(mangled, orig, "double");
                    break;
                }
                case "Array": {
                    Object object = new SwiftArray(mangled, orig);
                    break;
                }
                case "Character": {
                    Object object = new SwiftCharacter(mangled, orig);
                    break;
                }
                case "String": {
                    Object object = new SwiftString(mangled, orig);
                    break;
                }
                default: {
                    Object object = type = null;
                }
            }
            if (type != null) {
                return type;
            }
        }
        if ((struct = new SwiftStructure(mangled, orig, name, SwiftNode.join(namespace, privateDeclNamespace), demangler)).getFields().isEmpty()) {
            DemangledDataType undefined = new DemangledDataType(mangled, orig, "undefined");
            undefined.incrementPointerLevels();
            struct.addField("unknown", null, undefined);
        }
        return struct;
    }
}

