/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt;

import ghidra.app.script.GhidraScript;
import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTProgramCorrelator;
import ghidra.feature.vt.api.main.VTProgramCorrelatorFactory;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.util.VTOptions;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.util.InvalidNameException;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractGhidraVersionTrackingScript
extends GhidraScript {
    private VTSession vtSession;
    private Program sourceProgram;
    private Program destinationProgram;
    private int transactionID;

    protected VTSession getVTSession() {
        return this.vtSession;
    }

    protected Program getSourceProgram() {
        return this.sourceProgram;
    }

    protected Program getDestinationProgram() {
        return this.destinationProgram;
    }

    public VTSession createVersionTrackingSession(String sourceProgramPath, String destinationProgramPath) throws VersionException, CancelledException, IOException {
        if (this.vtSession != null) {
            throw new RuntimeException("Attempted to open a new session with one already open!");
        }
        try {
            this.sourceProgram = this.openProgram(sourceProgramPath);
            this.destinationProgram = this.openProgram(destinationProgramPath);
            this.vtSession = new VTSessionDB("New Session", this.sourceProgram, this.destinationProgram, (Object)this);
            this.transactionID = this.vtSession.startTransaction("VT Script");
        }
        finally {
            if (this.vtSession == null) {
                this.closeVersionTrackingSession();
            }
        }
        return this.vtSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VTSession createVersionTrackingSession(String name, Program source, Program destination) throws IOException {
        if (this.vtSession != null) {
            throw new RuntimeException("Attempted to create a new session with one already open!");
        }
        try {
            this.sourceProgram = source;
            this.sourceProgram.addConsumer((Object)this);
            this.destinationProgram = destination;
            this.destinationProgram.addConsumer((Object)this);
            this.vtSession = new VTSessionDB(name, this.sourceProgram, this.destinationProgram, (Object)this);
            this.transactionID = this.vtSession.startTransaction("VT Script");
        }
        finally {
            if (this.vtSession == null) {
                this.closeVersionTrackingSession();
            }
        }
        return this.vtSession;
    }

    public VTSession openVersionTrackingSession(String path) throws VersionException, CancelledException, IOException {
        if (this.vtSession != null) {
            throw new RuntimeException("Attempted to open a session with one already open!");
        }
        if (this.state.getProject() == null) {
            throw new RuntimeException("No project open.");
        }
        DomainFile file = this.state.getProject().getProjectData().getFile(path);
        this.vtSession = (VTSessionDB)file.getDomainObject((Object)this, true, true, this.monitor);
        this.sourceProgram = this.vtSession.getSourceProgram();
        this.sourceProgram.addConsumer((Object)this);
        this.destinationProgram = this.vtSession.getDestinationProgram();
        this.destinationProgram.addConsumer((Object)this);
        this.transactionID = this.vtSession.startTransaction("VT Script");
        return this.vtSession;
    }

    public void saveVersionTrackingSession() throws IOException {
        if (this.vtSession != null) {
            throw new RuntimeException("Attempted to save a session when not open!");
        }
        this.vtSession.endTransaction(this.transactionID, true);
        try {
            this.vtSession.save();
        }
        finally {
            this.transactionID = this.vtSession.startTransaction("VT Script");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSessionAs(String path, String name) throws InvalidNameException, CancelledException, IOException {
        if (this.vtSession != null) {
            throw new RuntimeException("Attempted to save a session when not open!");
        }
        this.vtSession.endTransaction(this.transactionID, true);
        try {
            DomainFolder folder = this.state.getProject().getProjectData().getFolder(path);
            folder.createFile(name, (DomainObject)this.vtSession, this.monitor);
            this.vtSession.setName(name);
        }
        finally {
            this.transactionID = this.vtSession.startTransaction("VT Script");
        }
    }

    public void cleanup(boolean success) {
        this.closeVersionTrackingSession();
        super.cleanup(success);
    }

    public void closeVersionTrackingSession() {
        if (this.vtSession != null) {
            this.vtSession.endTransaction(this.transactionID, true);
            this.vtSession.release((Object)this);
            this.vtSession = null;
        }
        if (this.destinationProgram != null) {
            this.destinationProgram.release((Object)this);
            this.destinationProgram = null;
        }
        if (this.sourceProgram != null) {
            this.sourceProgram.release((Object)this);
            this.sourceProgram = null;
        }
    }

    private Program openProgram(String path) throws VersionException, CancelledException, IOException {
        if (this.state.getProject() == null) {
            throw new RuntimeException("No project open.");
        }
        DomainFile file = this.state.getProject().getProjectData().getFile(path);
        return (Program)file.getDomainObject((Object)this, true, true, this.monitor);
    }

    public Set<String> getSourceFunctions() {
        if (this.vtSession == null) {
            throw new RuntimeException("You must have an open vt session");
        }
        return this.getFunctionNames(this.vtSession.getSourceProgram());
    }

    public Set<String> getDestinationFunctions() {
        if (this.vtSession == null) {
            throw new RuntimeException("You must have an open vt session");
        }
        return this.getFunctionNames(this.vtSession.getSourceProgram());
    }

    private Set<String> getFunctionNames(Program program) {
        HashSet<String> functionNames = new HashSet<String>();
        FunctionIterator functions = program.getFunctionManager().getFunctions(true);
        for (Function function : functions) {
            functionNames.add(function.getName());
        }
        return functionNames;
    }

    public List<String> getProgramCorrelators() {
        ArrayList<String> correlators = new ArrayList<String>();
        List<VTProgramCorrelatorFactory> generateList = AbstractGhidraVersionTrackingScript.getVTProgramCorrelatorFactory();
        for (VTProgramCorrelatorFactory vtProgramCorrelatorFactory : generateList) {
            correlators.add(vtProgramCorrelatorFactory.getName());
        }
        return correlators;
    }

    public void runCorrelator(String name) throws CancelledException {
        if (this.vtSession == null) {
            throw new RuntimeException("You must have an open vt session to run a correlator");
        }
        VTProgramCorrelatorFactory correlatorFactory = this.getCorrelatorFactory(name);
        VTProgramCorrelator correlator = correlatorFactory.createCorrelator(this.sourceProgram, this.sourceProgram.getMemory().getLoadedAndInitializedAddressSet(), this.destinationProgram, this.destinationProgram.getMemory().getLoadedAndInitializedAddressSet(), new VTOptions("dummy"));
        correlator.correlate(this.vtSession, this.monitor);
    }

    public Collection<VTMatch> getMatchesFromLastRunCorrelator() {
        List<VTMatchSet> matchSets = this.vtSession.getMatchSets();
        VTMatchSet last = matchSets.get(matchSets.size() - 1);
        return last.getMatches();
    }

    public Function getSourceFunction(VTMatch vtMatch) {
        VTAssociation association = vtMatch.getAssociation();
        Program source = this.vtSession.getSourceProgram();
        FunctionManager functionManager = source.getFunctionManager();
        return functionManager.getFunctionAt(association.getSourceAddress());
    }

    public Function getDestinationFunction(VTMatch vtMatch) {
        VTAssociation association = vtMatch.getAssociation();
        Program destination = this.vtSession.getDestinationProgram();
        FunctionManager functionManager = destination.getFunctionManager();
        return functionManager.getFunctionAt(association.getDestinationAddress());
    }

    private VTProgramCorrelatorFactory getCorrelatorFactory(String name) {
        List<VTProgramCorrelatorFactory> generateList = AbstractGhidraVersionTrackingScript.getVTProgramCorrelatorFactory();
        for (VTProgramCorrelatorFactory vtProgramCorrelatorFactory : generateList) {
            if (!vtProgramCorrelatorFactory.getName().equals(name)) continue;
            return vtProgramCorrelatorFactory;
        }
        return null;
    }

    private static List<VTProgramCorrelatorFactory> getVTProgramCorrelatorFactory() {
        return ClassSearcher.getInstances(VTProgramCorrelatorFactory.class);
    }
}

