/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.markuptable;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.TableFilter;
import generic.theme.GColor;
import ghidra.app.util.SymbolInspector;
import ghidra.docking.settings.Settings;
import ghidra.feature.vt.api.impl.MarkupItemImpl;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemStatus;
import ghidra.feature.vt.api.util.Stringable;
import ghidra.feature.vt.gui.editors.DisplayableAddress;
import ghidra.feature.vt.gui.editors.EditableAddress;
import ghidra.feature.vt.gui.filters.Filter;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.provider.markuptable.DisplayableListingAddress;
import ghidra.feature.vt.gui.provider.markuptable.EditableListingAddress;
import ghidra.feature.vt.gui.provider.markuptable.MarkupItemStatusRenderer;
import ghidra.feature.vt.gui.provider.markuptable.MarkupItemValueRenderer;
import ghidra.feature.vt.gui.task.SetMarkupItemDestinationAddressTask;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.AbstractGhidraColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JLabel;

public class VTMarkupItemsTableModel
extends AddressBasedTableModel<VTMarkupItem> {
    private static final String TITLE = "VTMatchMarkupItem Table Model";
    private static final Color FG_ERROR = new GColor("color.fg.version.tracking.markup.items.table.error");
    private static final Color FG_USER_DEFINED = new GColor("color.fg.version.tracking.markup.items.table.user.defined.address");
    private static final Color FG_USER_DEFINED_SELECTED = new GColor("color.fg.version.tracking.markup.items.table.user.defined.address.selected");
    private List<Filter<VTMarkupItem>> allFilters = new ArrayList<Filter<VTMarkupItem>>();
    private final VTController controller;

    public VTMarkupItemsTableModel(VTController controller) {
        super(TITLE, controller.getServiceProvider(), controller.getSourceProgram(), null);
        this.controller = controller;
    }

    protected TableColumnDescriptor<VTMarkupItem> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new StatusTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new SourceAddressTableColumn(), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new AppliedDestinationAddressTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new RelativeDisplacementTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new MarkupTypeTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new SourceValueTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new DestinationValueTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new OriginalDestinationValueTableColumn(this));
        if (SystemUtilities.isInDevelopmentMode()) {
            descriptor.addHiddenColumn((DynamicTableColumn)new AppliedDestinationSourceTableColumn());
            descriptor.addHiddenColumn((DynamicTableColumn)new IsInDBTableColumn());
        }
        return descriptor;
    }

    public Address getAddress(int row) {
        VTMarkupItem markupItem = (VTMarkupItem)this.getRowObject(row);
        return markupItem.getSourceAddress();
    }

    public void reload() {
        this.reload(true);
    }

    void reload(boolean clearFirst) {
        if (clearFirst) {
            this.clearData();
        }
        super.reload();
    }

    protected void doLoad(Accumulator<VTMarkupItem> accumulator, TaskMonitor monitor) throws CancelledException {
        MatchInfo matchInfo = this.controller.getMatchInfo();
        if (matchInfo == null) {
            return;
        }
        Collection<VTMarkupItem> markupItems = matchInfo.getAppliableMarkupItems(monitor);
        if (markupItems == null) {
            return;
        }
        monitor.setMessage("Processing markup items");
        monitor.initialize((long)markupItems.size());
        for (VTMarkupItem markupItem : markupItems) {
            monitor.checkCancelled();
            accumulator.add((Object)markupItem);
            monitor.incrementProgress(1L);
        }
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        int appliedAddressIndex = this.getColumnIndex(AppliedDestinationAddressTableColumn.class);
        return columnIndex == appliedAddressIndex;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int appliedAddressIndex = this.getColumnIndex(AppliedDestinationAddressTableColumn.class);
        if (columnIndex != appliedAddressIndex) {
            return;
        }
        Address destinationAddress = (Address)aValue;
        VTMarkupItem appliableMarkupItem = (VTMarkupItem)this.getRowObject(rowIndex);
        ArrayList<VTMarkupItem> items = new ArrayList<VTMarkupItem>();
        items.add(appliableMarkupItem);
        SetMarkupItemDestinationAddressTask task = new SetMarkupItemDestinationAddressTask(this.controller.getSession(), items, destinationAddress);
        this.controller.runVTTask(task);
        this.reload(false);
    }

    public void updateFilter() {
        this.rebuildFilter();
    }

    void addFilter(Filter<VTMarkupItem> filter) {
        this.allFilters.add(filter);
        this.rebuildFilter();
    }

    private void rebuildFilter() {
        List<Filter<VTMarkupItem>> copiedFilters = this.allFilters.stream().map(f -> f.createCopy()).collect(Collectors.toList());
        MarkupTablePassthroughFilter passThroughFilter = new MarkupTablePassthroughFilter(copiedFilters);
        this.setTableFilter(passThroughFilter);
    }

    private static class StatusTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMarkupItem, VTMarkupItemStatus> {
        private MarkupItemStatusRenderer renderer = new MarkupItemStatusRenderer();

        private StatusTableColumn() {
        }

        public String getColumnName() {
            return "Status";
        }

        public VTMarkupItemStatus getValue(VTMarkupItem rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getStatus();
        }

        public GColumnRenderer<VTMarkupItemStatus> getColumnRenderer() {
            return this.renderer;
        }

        public int getColumnPreferredWidth() {
            return 30;
        }
    }

    private static class SourceAddressTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMarkupItem, DisplayableAddress> {
        private SymbolInspector symbolInspector;
        private AddressRenderer addressCellRenderer = new AddressRenderer();

        private SourceAddressTableColumn() {
        }

        public String getColumnName() {
            return "Source Address";
        }

        public DisplayableAddress getValue(VTMarkupItem rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            if (this.symbolInspector == null) {
                this.symbolInspector = new SymbolInspector(serviceProvider, null);
            }
            VTAssociation association = rowObject.getAssociation();
            Program sourceProgram = association.getSession().getSourceProgram();
            DisplayableListingAddress displayableAddress = new DisplayableListingAddress(sourceProgram, rowObject.getSourceAddress());
            return displayableAddress;
        }

        public GColumnRenderer<DisplayableAddress> getColumnRenderer() {
            return this.addressCellRenderer;
        }

        public int getColumnPreferredWidth() {
            return 75;
        }

        private class AddressRenderer
        extends AbstractGhidraColumnRenderer<DisplayableAddress> {
            private AddressRenderer() {
            }

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                Object value = data.getValue();
                DisplayableAddress editableAddress = (DisplayableAddress)value;
                String addressString = editableAddress.getDisplayString();
                GTableCellRenderingData renderData = data.copyWithNewValue((Object)addressString);
                JLabel renderer = (JLabel)super.getTableCellRendererComponent(renderData);
                Program program = editableAddress.getProgram();
                Address address = editableAddress.getAddress();
                Symbol s = null;
                if (address != null && address != Address.NO_ADDRESS && SourceAddressTableColumn.this.symbolInspector != null) {
                    s = program.getSymbolTable().getPrimarySymbol(address);
                }
                Color c = FG_ERROR;
                if (SourceAddressTableColumn.this.symbolInspector != null) {
                    SourceAddressTableColumn.this.symbolInspector.setProgram(program);
                    c = SourceAddressTableColumn.this.symbolInspector.getColor(s);
                }
                this.setForeground(c);
                renderer.setOpaque(true);
                return renderer;
            }

            public String getFilterString(DisplayableAddress t, Settings settings) {
                return t.getDisplayString();
            }
        }
    }

    static class AppliedDestinationAddressTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMarkupItem, EditableAddress> {
        private SymbolInspector symbolInspector;
        private AddressRenderer addressCellRenderer = new AddressRenderer();

        AppliedDestinationAddressTableColumn() {
        }

        public String getColumnName() {
            return "Dest Address";
        }

        public EditableAddress getValue(VTMarkupItem rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            VTAssociation association = rowObject.getAssociation();
            Program destinationProgram = association.getSession().getDestinationProgram();
            if (this.symbolInspector == null) {
                this.symbolInspector = new SymbolInspector(serviceProvider, null);
            }
            Address destinationAddress = rowObject.getDestinationAddress();
            EditableListingAddress editableAddress = new EditableListingAddress(destinationProgram, destinationAddress, rowObject);
            return editableAddress;
        }

        public GColumnRenderer<EditableAddress> getColumnRenderer() {
            return this.addressCellRenderer;
        }

        public int getColumnPreferredWidth() {
            return 75;
        }

        private class AddressRenderer
        extends AbstractGhidraColumnRenderer<EditableAddress> {
            private AddressRenderer() {
            }

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                Object value = data.getValue();
                EditableAddress editableAddress = (EditableAddress)value;
                String addressString = editableAddress.getDisplayString();
                GTableCellRenderingData renderData = data.copyWithNewValue((Object)addressString);
                JLabel renderer = (JLabel)super.getTableCellRendererComponent(renderData);
                Program program = editableAddress.getProgram();
                Address address = editableAddress.getAddress();
                Symbol s = null;
                if (address != null && address != Address.NO_ADDRESS && AppliedDestinationAddressTableColumn.this.symbolInspector != null) {
                    s = program.getSymbolTable().getPrimarySymbol(address);
                }
                Color c = FG_ERROR;
                if (AppliedDestinationAddressTableColumn.this.symbolInspector != null) {
                    AppliedDestinationAddressTableColumn.this.symbolInspector.setProgram(program);
                    c = AppliedDestinationAddressTableColumn.this.symbolInspector.getColor(s);
                }
                this.setForeground(c);
                renderer.setOpaque(true);
                return renderer;
            }

            public String getFilterString(EditableAddress t, Settings settings) {
                return t.getDisplayString();
            }
        }
    }

    private static class RelativeDisplacementTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMarkupItem, Long> {
        private RelativeDisplacementTableColumn() {
        }

        public String getColumnName() {
            return "Displacement";
        }

        public Long getValue(VTMarkupItem markupItem, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            Address sourceAddress = markupItem.getSourceAddress();
            Address destinationAddress = markupItem.getDestinationAddress();
            if (destinationAddress == null || destinationAddress == Address.NO_ADDRESS) {
                return null;
            }
            VTAssociation association = markupItem.getAssociation();
            Address sourceMatchAddress = association.getSourceAddress();
            Address destinationMatchAddress = association.getDestinationAddress();
            long relativeSourceOffset = sourceAddress.subtract(sourceMatchAddress);
            long relativeDestinationOffset = destinationAddress.subtract(destinationMatchAddress);
            return relativeDestinationOffset - relativeSourceOffset;
        }

        public int getColumnPreferredWidth() {
            return 50;
        }

        public String getColumnDescription() {
            return "Displays relative displacement of the destination address as compared to the source\n address.  Positive numbers indicated additions in the destination and\n negative numbers indicate subtractions.";
        }
    }

    private static class MarkupTypeTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMarkupItem, String> {
        private MarkupTypeTableColumn() {
        }

        public String getColumnName() {
            return "Markup Type";
        }

        public String getValue(VTMarkupItem rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getMarkupType().getDisplayName();
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    private class SourceValueTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMarkupItem, Stringable> {
        private MarkupItemValueRenderer renderer;

        private SourceValueTableColumn(VTMarkupItemsTableModel vTMarkupItemsTableModel) {
        }

        public String getColumnName() {
            return "Source Value";
        }

        public String getColumnDescription() {
            return "The current source value for the markup item.";
        }

        public Stringable getValue(VTMarkupItem rowObject, Settings settings, Program theProgram, ServiceProvider theServiceProvider) throws IllegalArgumentException {
            return rowObject.getSourceValue();
        }

        public GColumnRenderer<Stringable> getColumnRenderer() {
            if (this.renderer == null) {
                this.renderer = new MarkupItemValueRenderer();
            }
            return this.renderer;
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    private class DestinationValueTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMarkupItem, Stringable> {
        private MarkupItemValueRenderer renderer;

        private DestinationValueTableColumn(VTMarkupItemsTableModel vTMarkupItemsTableModel) {
        }

        public String getColumnName() {
            return "Current Dest Value";
        }

        public String getColumnDescription() {
            return "The current destination value for the markup item.";
        }

        public Stringable getValue(VTMarkupItem rowObject, Settings settings, Program theProgram, ServiceProvider theServiceProvider) throws IllegalArgumentException {
            return rowObject.getCurrentDestinationValue();
        }

        public GColumnRenderer<Stringable> getColumnRenderer() {
            if (this.renderer == null) {
                this.renderer = new MarkupItemValueRenderer();
            }
            return this.renderer;
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    private class OriginalDestinationValueTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMarkupItem, Stringable> {
        private MarkupItemValueRenderer renderer;

        private OriginalDestinationValueTableColumn(VTMarkupItemsTableModel vTMarkupItemsTableModel) {
        }

        public String getColumnName() {
            return "Original Dest Value";
        }

        public String getColumnDescription() {
            return "The original destination value for the markup item.";
        }

        public Stringable getValue(VTMarkupItem rowObject, Settings settings, Program theProgram, ServiceProvider theServiceProvider) throws IllegalArgumentException {
            return rowObject.getOriginalDestinationValue();
        }

        public GColumnRenderer<Stringable> getColumnRenderer() {
            if (this.renderer == null) {
                this.renderer = new MarkupItemValueRenderer();
            }
            return this.renderer;
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    static class AppliedDestinationSourceTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMarkupItem, String> {
        private static final String NO_SOURCE_TEXT = "None";
        private GColumnRenderer<String> sourceCellRenderer = new AbstractGColumnRenderer<String>(){

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                Object value = data.getValue();
                boolean isSelected = data.isSelected();
                String addressSource = value != null ? (String)value : AppliedDestinationSourceTableColumn.NO_SOURCE_TEXT;
                String sourceString = this.getText(value);
                GTableCellRenderingData renderData = data.copyWithNewValue((Object)sourceString);
                JLabel renderer = (JLabel)super.getTableCellRendererComponent(renderData);
                if (AppliedDestinationSourceTableColumn.NO_SOURCE_TEXT.equals(addressSource)) {
                    this.setForeground(FG_ERROR);
                } else if ("User Defined".equals(addressSource)) {
                    this.setForeground(isSelected ? FG_USER_DEFINED : FG_USER_DEFINED_SELECTED);
                }
                renderer.setOpaque(true);
                return renderer;
            }

            private String getText(String value) {
                String addressSource = value != null ? value : AppliedDestinationSourceTableColumn.NO_SOURCE_TEXT;
                String sourceString = "(" + addressSource + ")";
                return sourceString;
            }

            public String getFilterString(String t, Settings settings) {
                return this.getText(t);
            }
        };

        AppliedDestinationSourceTableColumn() {
        }

        public String getColumnName() {
            return "Dest Address Source";
        }

        public String getValue(VTMarkupItem rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            String destinationAddressSource = rowObject.getDestinationAddressSource();
            return destinationAddressSource;
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return this.sourceCellRenderer;
        }

        public int getColumnPreferredWidth() {
            return 75;
        }
    }

    static class IsInDBTableColumn
    extends AbstractProgramBasedDynamicTableColumn<VTMarkupItem, Boolean> {
        private GColumnRenderer<Boolean> isInDBCellRenderer = new AbstractGColumnRenderer<Boolean>(){

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                Object value = data.getValue();
                boolean isInDB = (Boolean)value;
                GTableCellRenderingData renderData = data.copyWithNewValue((Object)(isInDB ? "yes" : null));
                JLabel renderer = (JLabel)super.getTableCellRendererComponent(renderData);
                renderer.setOpaque(true);
                return renderer;
            }

            public String getFilterString(Boolean t, Settings settings) {
                boolean isInDB = t;
                return isInDB ? "yes" : "";
            }
        };

        IsInDBTableColumn() {
        }

        public String getColumnName() {
            return "In DB?";
        }

        public Boolean getValue(VTMarkupItem rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            if (!(rowObject instanceof MarkupItemImpl)) {
                return false;
            }
            MarkupItemImpl impl = (MarkupItemImpl)rowObject;
            return impl.isStoredInDB();
        }

        public GColumnRenderer<Boolean> getColumnRenderer() {
            return this.isInDBCellRenderer;
        }

        public int getColumnPreferredWidth() {
            return 25;
        }
    }

    private static class MarkupTablePassthroughFilter
    implements TableFilter<VTMarkupItem> {
        private List<Filter<VTMarkupItem>> appliedFilters;

        MarkupTablePassthroughFilter(List<Filter<VTMarkupItem>> appliedFilters) {
            this.appliedFilters = appliedFilters;
        }

        public boolean acceptsRow(VTMarkupItem markup) {
            if (this.appliedFilters == null) {
                return false;
            }
            if (this.appliedFilters.isEmpty()) {
                return true;
            }
            return this.rowMatchesFilters(this.appliedFilters, markup);
        }

        private boolean rowMatchesFilters(List<Filter<VTMarkupItem>> filters, VTMarkupItem VTMarkupItem2) {
            for (Filter<VTMarkupItem> filter : filters) {
                if (filter.passesFilter(VTMarkupItem2)) continue;
                return false;
            }
            return true;
        }

        public boolean isSubFilterOf(TableFilter<?> tableFilter) {
            if (!(tableFilter instanceof MarkupTablePassthroughFilter)) {
                return false;
            }
            MarkupTablePassthroughFilter otherMarkupFilter = (MarkupTablePassthroughFilter)tableFilter;
            if (this.appliedFilters.size() != otherMarkupFilter.appliedFilters.size()) {
                return false;
            }
            int n = this.appliedFilters.size();
            for (int i = 0; i < n; ++i) {
                Filter<VTMarkupItem> otherFilter;
                Filter<VTMarkupItem> myFilter = this.appliedFilters.get(i);
                if (myFilter.isSubFilterOf(otherFilter = otherMarkupFilter.appliedFilters.get(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    }
}

