/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard;

import docking.DialogComponentProvider;
import docking.widgets.label.GDLabel;
import ghidra.app.util.AddressInput;
import ghidra.feature.vt.gui.wizard.AddressRangeListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AddRemoveAddressRangeDialog
extends DialogComponentProvider {
    private Program program;
    private AddressFactory addressFactory;
    private AddressRangeListener listener;
    private JPanel addressRangePanel;
    private JLabel minLabel;
    private JLabel maxLabel;
    private AddressInput minAddressField;
    private AddressInput maxAddressField;

    protected AddRemoveAddressRangeDialog(String type, String programIndicator, Program program, AddressRangeListener listener) {
        super(programIndicator + " Address Range", true, true, true, false);
        this.program = program;
        this.addressFactory = program.getAddressFactory();
        this.listener = listener;
        this.setHelpLocation(new HelpLocation("LabelMgrPlugin", "AddEditDialog"));
        this.addWorkPanel(this.createAddressRangePanel());
        this.setFocusComponent((Component)this.minAddressField);
        this.addOKButton();
        this.addCancelButton();
        this.setOkButtonText(type);
        this.setDefaultButton(this.okButton);
    }

    private JPanel createAddressRangePanel() {
        this.addressRangePanel = new JPanel();
        this.addressRangePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
        this.addressRangePanel.setLayout((LayoutManager)new PairLayout(5, 5));
        this.minLabel = new GDLabel("Minimum:");
        this.minLabel.setToolTipText("Enter minimum address to add or remove");
        this.addressRangePanel.add(this.minLabel);
        this.minAddressField = new AddressInput();
        this.minAddressField.setAddressFactory(this.addressFactory);
        Dimension minPreferredSize = this.getPreferredSize();
        minPreferredSize.width = 200;
        this.minAddressField.setPreferredSize(minPreferredSize);
        this.addressRangePanel.add((Component)this.minAddressField);
        this.maxLabel = new GDLabel("Maximum:");
        this.maxLabel.setToolTipText("Enter maximum address to add or remove");
        this.addressRangePanel.add(this.maxLabel);
        this.maxAddressField = new AddressInput();
        this.maxAddressField.setAddressFactory(this.addressFactory);
        Dimension maxPreferredSize = this.getPreferredSize();
        maxPreferredSize.width = 200;
        this.minAddressField.setPreferredSize(maxPreferredSize);
        this.addressRangePanel.add((Component)this.maxAddressField);
        return this.addressRangePanel;
    }

    protected void dialogShown() {
        super.dialogShown();
        this.minAddressField.clear();
        this.maxAddressField.clear();
        this.minAddressField.requestFocus();
    }

    protected void okCallback() {
        if (this.isValidRange()) {
            if (this.listener != null) {
                this.listener.processAddressRange(this.getMinAddress(), this.getMaxAddress());
            }
            this.close();
        }
    }

    private boolean isValidRange() {
        Address minAddress = this.getMinAddress();
        if (minAddress == null) {
            this.setStatusText("Specify a minimum address.");
            return false;
        }
        Address maxAddress = this.getMaxAddress();
        if (maxAddress == null) {
            this.setStatusText("Specify a maximum address.");
            return false;
        }
        if (!minAddress.getAddressSpace().equals((Object)maxAddress.getAddressSpace())) {
            this.setStatusText("Min and Max must be in same address space.");
            return false;
        }
        if (minAddress.compareTo((Object)maxAddress) > 0) {
            this.setStatusText("Max address must be greater than Min address.");
            return false;
        }
        return true;
    }

    private Address getMinAddress() {
        return this.minAddressField.getAddress();
    }

    private Address getMaxAddress() {
        return this.maxAddressField.getAddress();
    }
}

