/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard;

import docking.wizard.WizardState;
import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.wizard.VTWizardStateKey;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Program;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class CreateNewSessionTask
extends Task {
    private final WizardState<VTWizardStateKey> state;
    private final VTController controller;

    public CreateNewSessionTask(VTController controller, WizardState<VTWizardStateKey> state) {
        super("Create New Version Tracking Session", true, true, true);
        this.controller = controller;
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) {
        VTSessionDB session = null;
        String name = null;
        try {
            Program sourceProgram = (Program)this.state.get((Object)VTWizardStateKey.SOURCE_PROGRAM);
            Program destinationProgram = (Program)this.state.get((Object)VTWizardStateKey.DESTINATION_PROGRAM);
            session = new VTSessionDB("New Session", sourceProgram, destinationProgram, (Object)this);
            sourceProgram.release((Object)this.controller.getTool());
            destinationProgram.release((Object)this.controller.getTool());
            name = (String)this.state.get((Object)VTWizardStateKey.SESSION_NAME);
            DomainFolder folder = (DomainFolder)this.state.get((Object)VTWizardStateKey.NEW_SESSION_FOLDER);
            try {
                folder.createFile(name, (DomainObject)session, monitor);
            }
            catch (InvalidNameException e) {
                Msg.showError((Object)((Object)this), null, (String)"Invalid Domain Object Name", (Object)"Please report this error; the name should have been checked already");
            }
            this.controller.openVersionTrackingSession(session);
        }
        catch (CancelledException sourceProgram) {
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, (String)"Failed to Create Session", (Object)("Failed to create db file: " + name), (Throwable)e);
        }
        finally {
            if (session != null) {
                session.release((Object)this);
            }
        }
    }
}

