/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.gui;

import docking.DialogComponentProvider;
import docking.widgets.list.ListPanel;
import generic.theme.GTheme;
import generic.theme.ThemeManager;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListModel;

public class ThemeChooserDialog
extends DialogComponentProvider {
    private ThemeManager themeManager;
    private ListPanel<GTheme> listPanel;

    public ThemeChooserDialog(ThemeManager themeManager) {
        super("Change Theme");
        this.themeManager = themeManager;
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setRememberSize(false);
        this.setHelpLocation(new HelpLocation("Theming", "Switch_Theme"));
        this.updateButtonEnablement();
    }

    private void updateButtonEnablement() {
        GTheme selectedValue = (GTheme)this.listPanel.getSelectedValue();
        GTheme currentTheme = this.themeManager.getActiveTheme();
        boolean canApplyTheme = selectedValue != null && !currentTheme.equals((Object)selectedValue);
        this.setOkEnabled(canApplyTheme);
    }

    protected void okCallback() {
        this.applyTheme();
        this.close();
    }

    private void applyTheme() {
        GTheme selectedValue = (GTheme)this.listPanel.getSelectedValue();
        GTheme activeTheme = this.themeManager.getActiveTheme();
        if (selectedValue != null && selectedValue != activeTheme) {
            Swing.runLater(() -> this.themeManager.setTheme(selectedValue));
        }
    }

    protected void cancelCallback() {
        this.close();
    }

    private JComponent buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        ThemeListModel model = new ThemeListModel();
        this.listPanel = new ListPanel();
        this.listPanel.setListModel((ListModel)model);
        this.listPanel.setSelectionMode(0);
        GTheme activeTheme = this.themeManager.getActiveTheme();
        this.listPanel.setSelectedValue((Object)activeTheme);
        this.listPanel.addListSelectionListener(e -> this.selectionChanged());
        panel.add((Component)this.listPanel);
        this.listPanel.setDoubleClickActionListener(e -> this.okCallback());
        return panel;
    }

    private void selectionChanged() {
        this.updateButtonEnablement();
    }

    private class ThemeListModel
    extends AbstractListModel<GTheme> {
        private List<GTheme> allThemes;

        ThemeListModel() {
            this.allThemes = new ArrayList<GTheme>(ThemeChooserDialog.this.themeManager.getSupportedThemes());
            Collections.sort(this.allThemes, (t1, t2) -> t1.getName().compareTo(t2.getName()));
        }

        @Override
        public int getSize() {
            return this.allThemes.size();
        }

        @Override
        public GTheme getElementAt(int index) {
            return this.allThemes.get(index);
        }
    }
}

