/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import db.DBChangeSet;
import db.DBHandle;
import db.Field;
import db.buffers.BufferFile;
import db.buffers.LocalManagedBufferFile;
import db.buffers.ManagedBufferFile;
import generic.theme.GIcon;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.data.CheckinHandler;
import ghidra.framework.data.ContentHandler;
import ghidra.framework.data.DBWithUserDataContentHandler;
import ghidra.framework.data.DefaultProjectData;
import ghidra.framework.data.DomainFileProxy;
import ghidra.framework.data.DomainObjectAdapter;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.data.DomainObjectMergeManager;
import ghidra.framework.data.GhidraFile;
import ghidra.framework.data.GhidraFolderData;
import ghidra.framework.data.LinkHandler;
import ghidra.framework.data.LockingTaskMonitor;
import ghidra.framework.data.VersionIcon;
import ghidra.framework.model.ChangeSet;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.store.CheckoutType;
import ghidra.framework.store.DataFileItem;
import ghidra.framework.store.DatabaseItem;
import ghidra.framework.store.FileIDFactory;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.FolderItem;
import ghidra.framework.store.ItemCheckoutStatus;
import ghidra.framework.store.Version;
import ghidra.framework.store.local.LocalDatabaseItem;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.framework.store.local.LocalFolderItem;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.ReadOnlyException;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.exception.FileInUseException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;
import resources.MultiIcon;
import resources.icons.TranslateIcon;

public class GhidraFileData {
    static final int ICON_WIDTH = 18;
    static final int ICON_HEIGHT = 17;
    private static final boolean ALWAYS_MERGE = System.getProperty("ForceMerge") != null;
    public static final Icon UNSUPPORTED_FILE_ICON = new GIcon("icon.project.data.file.ghidra.unsupported");
    public static final Icon CHECKED_OUT_ICON = new GIcon("icon.project.data.file.ghidra.checked.out");
    public static final Icon CHECKED_OUT_EXCLUSIVE_ICON = new GIcon("icon.project.data.file.ghidra.checked.out.exclusive");
    public static final Icon HIJACKED_ICON = new GIcon("icon.project.data.file.ghidra.hijacked");
    public static final Icon VERSION_ICON = new VersionIcon();
    public static final Icon READ_ONLY_ICON = new GIcon("icon.project.data.file.ghidra.read.only");
    public static final Icon NOT_LATEST_CHECKED_OUT_ICON = new GIcon("icon.project.data.file.ghidra.not.latest");
    private DefaultProjectData projectData;
    private LocalFileSystem fileSystem;
    private FileSystem versionedFileSystem;
    private DomainFolderChangeListener listener;
    private GhidraFolderData parent;
    private String name;
    private String fileID;
    private LocalFolderItem folderItem;
    private FolderItem versionedFolderItem;
    private Icon icon;
    private Icon disabledIcon;
    private AtomicBoolean busy = new AtomicBoolean();

    GhidraFileData(GhidraFolderData parent, String name) throws IOException {
        this.parent = parent;
        this.name = name;
        this.projectData = parent.getProjectData();
        this.fileSystem = parent.getLocalFileSystem();
        this.versionedFileSystem = parent.getVersionedFileSystem();
        this.listener = parent.getChangeListener();
        this.refresh();
    }

    GhidraFileData(GhidraFolderData parent, String name, LocalFolderItem folderItem, FolderItem versionedFolderItem) {
        this.parent = parent;
        this.name = name;
        this.folderItem = folderItem;
        this.versionedFolderItem = versionedFolderItem;
        this.projectData = parent.getProjectData();
        this.fileSystem = parent.getLocalFileSystem();
        this.versionedFileSystem = parent.getVersionedFileSystem();
        this.listener = parent.getChangeListener();
        this.validateCheckout();
        this.updateFileID();
    }

    void refresh(LocalFolderItem localFolderItem, FolderItem verFolderItem) {
        this.icon = null;
        this.disabledIcon = null;
        this.folderItem = localFolderItem;
        this.versionedFolderItem = verFolderItem;
        this.validateCheckout();
        boolean fileIDset = this.updateFileID();
        if (this.parent.visited()) {
            this.listener.domainFileStatusChanged(this.getDomainFile(), fileIDset);
        }
    }

    private boolean refresh() throws IOException {
        String parentPath = this.parent.getPathname();
        this.folderItem = this.folderItem == null ? this.fileSystem.getItem(parentPath, this.name) : this.folderItem.refresh();
        if (this.versionedFileSystem.isOnline()) {
            try {
                this.versionedFolderItem = this.versionedFolderItem == null ? this.versionedFileSystem.getItem(parentPath, this.name) : this.versionedFolderItem.refresh();
                this.validateCheckout();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.folderItem == null && this.versionedFolderItem == null) {
            throw new FileNotFoundException(this.name + " not found");
        }
        return this.updateFileID();
    }

    private boolean updateFileID() {
        boolean fileIdWasNull = this.fileID == null;
        this.fileID = this.folderItem != null ? this.folderItem.getFileID() : this.versionedFolderItem.getFileID();
        return fileIdWasNull && this.fileID != null;
    }

    void statusChanged() throws IOException {
        this.statusChanged(false);
    }

    private void statusChanged(boolean fileIDset) throws IOException {
        this.icon = null;
        this.disabledIcon = null;
        fileIDset |= this.refresh();
        if (this.parent.visited()) {
            this.listener.domainFileStatusChanged(this.getDomainFile(), fileIDset);
        }
    }

    private void validateCheckout() {
        if (this.fileSystem.isReadOnly() || !this.versionedFileSystem.isOnline()) {
            return;
        }
        try {
            if (this.folderItem != null && this.folderItem.isCheckedOut()) {
                if (this.versionedFolderItem != null) {
                    ItemCheckoutStatus coStatus = this.versionedFolderItem.getCheckout(this.folderItem.getCheckoutId());
                    if (coStatus == null) {
                        this.folderItem.clearCheckout();
                    }
                } else {
                    this.folderItem.clearCheckout();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkInUse() throws FileInUseException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.busy.get() || this.getOpenedDomainObject() != null) {
                throw new FileInUseException(this.name + " is in use");
            }
        }
    }

    boolean isBusy() {
        if (this.busy.get()) {
            return true;
        }
        DomainObjectAdapter dobj = this.getOpenedDomainObject();
        return dobj != null && !dobj.canLock();
    }

    void dispose() {
        this.projectData.removeFromIndex(this.fileID);
    }

    String getFileID() {
        return this.fileID;
    }

    String getPathname() {
        Object path = this.parent.getPathname();
        if (((String)path).length() != FileSystem.SEPARATOR.length()) {
            path = (String)path + FileSystem.SEPARATOR;
        }
        path = (String)path + this.name;
        return path;
    }

    String getName() {
        return this.name;
    }

    GhidraFolderData getParent() {
        return this.parent;
    }

    GhidraFile getDomainFile() {
        return new GhidraFile(this.parent.getDomainFolder(), this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    URL getSharedProjectURL(String ref) {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            RepositoryAdapter repository = this.projectData.getRepository();
            if (this.versionedFolderItem != null && repository != null) {
                URL folderURL = this.parent.getDomainFolder().getSharedProjectURL();
                try {
                    Object spec = this.name;
                    if (!StringUtils.isEmpty((CharSequence)ref)) {
                        spec = (String)spec + "#" + ref;
                    }
                    return new URL(folderURL, (String)spec);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    URL getLocalProjectURL(String ref) {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            ProjectLocator projectLocator = this.parent.getProjectLocator();
            if (!projectLocator.isTransient()) {
                return GhidraURL.makeURL(projectLocator, this.getPathname(), ref);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetFileID() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.versionedFolderItem != null || this.isCheckedOut()) {
                throw new IOException("File ID reset not permitted on versioned file");
            }
            if (this.folderItem != null) {
                this.fileID = this.folderItem.resetFileID();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    GhidraFile setName(String newName) throws InvalidNameException, IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.fileSystem.isReadOnly()) {
                throw new ReadOnlyException("setName permitted within writeable project only");
            }
            this.checkInUse();
            if (this.parent.containsFile(newName)) {
                throw new DuplicateFileException("File named " + newName + " already exists.");
            }
            String oldName = this.name;
            String folderPath = this.parent.getPathname();
            if (this.isHijacked()) {
                this.fileSystem.moveItem(folderPath, this.name, folderPath, newName);
                this.folderItem = null;
                this.parent.fileChanged(this.name);
                this.parent.fileChanged(newName);
                return this.parent.getDomainFile(newName);
            }
            if (this.versionedFolderItem == null) {
                if (this.isCheckedOut()) throw new FileInUseException(this.name + " is checked-out");
                this.fileSystem.moveItem(folderPath, this.name, folderPath, newName);
                this.folderItem = this.fileSystem.getItem(folderPath, newName);
            } else {
                this.versionedFileSystem.moveItem(folderPath, this.name, folderPath, newName);
                this.versionedFolderItem = this.versionedFileSystem.getItem(folderPath, newName);
            }
            this.name = newName;
            this.parent.fileRenamed(oldName, newName);
            return this.parent.getDomainFile(newName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getContentType() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            LocalFolderItem item;
            Object object = item = this.folderItem != null ? this.folderItem : this.versionedFolderItem;
            if (item == null) {
                return "Missing-File";
            }
            String contentType = item.getContentType();
            String string = contentType != null ? contentType : "Unknown-File";
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContentHandler<?> getContentHandler() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            LocalFolderItem item;
            Object object = item = this.folderItem != null ? this.folderItem : this.versionedFolderItem;
            if (item == null) {
                throw new FileNotFoundException(this.name + " not found");
            }
            return DomainObjectAdapter.getContentHandler(item.getContentType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class<? extends DomainObject> getDomainObjectClass() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                return this.getContentHandler().getDomainObjectClass();
            }
            catch (IOException iOException) {
                return DomainObject.class;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ChangeSet getChangesByOthersSinceCheckout() throws VersionException, IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.versionedFolderItem != null && this.folderItem != null && this.folderItem.isCheckedOut()) {
                return this.getContentHandler().getChangeSet(this.versionedFolderItem, this.folderItem.getCheckoutVersion(), this.versionedFolderItem.getCurrentVersion());
            }
            return null;
        }
    }

    private DomainObjectAdapter getOpenedDomainObject() {
        return this.projectData.getOpenedDomainObject(this.getPathname());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DomainObject getDomainObject(Object consumer, boolean okToUpgrade, boolean okToRecover, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        if (this.busy.get()) {
            throw new FileInUseException("Cannot open during versioning operation");
        }
        DomainObjectAdapter domainObj = null;
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.fileSystem.isReadOnly() || this.isLinkFile()) {
                return this.getReadOnlyDomainObject(consumer, -1, monitor);
            }
            domainObj = this.getOpenedDomainObject();
            if (domainObj != null) {
                if (!domainObj.addConsumer(consumer)) {
                    domainObj = null;
                    this.projectData.clearDomainObject(this.getPathname());
                } else {
                    return domainObj;
                }
            }
            ContentHandler<?> contentHandler = this.getContentHandler();
            if (this.folderItem == null) {
                Object doa = contentHandler.getReadOnlyObject(this.versionedFolderItem, -1, true, consumer, monitor);
                ((DomainObjectAdapter)doa).setChanged(false);
                DomainFileProxy proxy = new DomainFileProxy(this.name, this.parent.getPathname(), (DomainObjectAdapter)doa, -1, this.fileID, this.parent.getProjectLocator());
                proxy.setLastModified(this.getLastModifiedTime());
                return doa;
            }
            LocalFolderItem myFolderItem = this.folderItem;
            domainObj = contentHandler.getDomainObject((FolderItem)myFolderItem, (FileSystem)this.parent.getUserFileSystem(), -1L, okToUpgrade, okToRecover, consumer, monitor);
            this.projectData.setDomainObject(this.getPathname(), domainObj);
            if (!this.isLinkFile()) {
                this.projectData.trackDomainFileInUse(domainObj);
            }
        }
        try {
            domainObj.setDomainFile(this.getDomainFile());
        }
        catch (Exception e) {
            domainObj.release(consumer);
            this.projectData.clearDomainObject(this.getPathname());
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof VersionException) {
                throw (VersionException)((Object)cause);
            }
            throw new IOException(e.getMessage(), e);
        }
        this.listener.domainFileObjectOpenedForUpdate(domainObj.getDomainFile(), domainObj);
        return domainObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DomainObject getReadOnlyDomainObject(Object consumer, int version, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            FolderItem item = this.folderItem != null && version == -1 ? this.folderItem : this.versionedFolderItem;
            Object doa = this.getContentHandler().getReadOnlyObject(item, version, true, consumer, monitor);
            ((DomainObjectAdapter)doa).setChanged(false);
            if (!this.isLinkFile()) {
                this.projectData.trackDomainFileInUse((DomainObjectAdapter)doa);
            }
            DomainFileProxy proxy = new DomainFileProxy(this.name, this.getParent().getPathname(), (DomainObjectAdapter)doa, version, this.fileID, this.parent.getProjectLocator());
            proxy.setLastModified(this.getLastModifiedTime());
            return doa;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DomainObject getImmutableDomainObject(Object consumer, int version, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            DomainObjectAdapter obj = null;
            ContentHandler<?> contentHandler = this.getContentHandler();
            obj = this.versionedFolderItem == null || version == -1 && this.folderItem != null || this.isHijacked() ? (DomainObjectAdapter)contentHandler.getImmutableObject((FolderItem)this.folderItem, consumer, version, -1, monitor) : (DomainObjectAdapter)contentHandler.getImmutableObject(this.versionedFolderItem, consumer, version, -1, monitor);
            if (!this.isLinkFile()) {
                this.projectData.trackDomainFileInUse(obj);
            }
            DomainFileProxy proxy = new DomainFileProxy(this.name, this.getParent().getPathname(), obj, version, this.fileID, this.parent.getProjectLocator());
            proxy.setLastModified(this.getLastModifiedTime());
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canRecover() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            DomainObjectAdapter dobj = this.getOpenedDomainObject();
            if (!this.fileSystem.isReadOnly() && this.folderItem != null && dobj == null) {
                return this.folderItem.canRecover();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean takeRecoverySnapshot() throws IOException {
        if (this.fileSystem.isReadOnly()) {
            return true;
        }
        DomainObjectAdapter dobj = this.projectData.getOpenedDomainObject(this.getPathname());
        if (!(dobj instanceof DomainObjectAdapterDB) || !dobj.isChanged()) {
            return true;
        }
        LockingTaskMonitor monitor = null;
        DomainObjectAdapterDB dbObjDB = (DomainObjectAdapterDB)dobj;
        if (this.busy.getAndSet(true)) {
            return false;
        }
        try {
            monitor = dbObjDB.lockForSnapshot(true, "Recovery Snapshot Task");
            if (monitor == null) {
                boolean bl = true;
                return bl;
            }
            monitor.setMessage(this.getName());
            boolean bl = dbObjDB.getDBHandle().takeRecoverySnapshot((DBChangeSet)dbObjDB.getChangeSet(), (TaskMonitor)monitor);
            return bl;
        }
        catch (CancelledException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.busy.set(false);
            if (monitor != null) {
                monitor.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getLastModifiedTime() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.folderItem != null) {
                return this.folderItem.lastModified();
            }
            if (this.versionedFolderItem != null) {
                return this.versionedFolderItem.lastModified();
            }
            return 0L;
        }
    }

    Icon getIcon(boolean disabled) {
        if (disabled) {
            if (this.disabledIcon == null) {
                this.disabledIcon = this.generateIcon(true);
            }
            return this.disabledIcon;
        }
        if (this.icon == null) {
            this.icon = this.generateIcon(false);
        }
        return this.icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon generateIcon(boolean disabled) {
        if (this.parent == null) {
            return DomainFile.UNSUPPORTED_FILE_ICON;
        }
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            boolean isLink = this.isLinkFile();
            LocalFolderItem item = this.folderItem != null ? this.folderItem : this.versionedFolderItem;
            TranslateIcon baseIcon = new TranslateIcon(this.getBaseIcon((FolderItem)item), 1, 1);
            if (this.versionedFolderItem != null) {
                MultiIcon multiIcon = new MultiIcon(VERSION_ICON, disabled);
                multiIcon.addIcon((Icon)baseIcon);
                if (this.isHijacked()) {
                    multiIcon.addIcon(HIJACKED_ICON);
                } else if (this.isCheckedOut()) {
                    if (this.isCheckedOutExclusive()) {
                        multiIcon.addIcon(CHECKED_OUT_EXCLUSIVE_ICON);
                    } else if (this.getVersion() == this.getLatestVersion()) {
                        multiIcon.addIcon(CHECKED_OUT_ICON);
                    } else {
                        multiIcon.addIcon(NOT_LATEST_CHECKED_OUT_ICON);
                    }
                }
                if (isLink) {
                    multiIcon.addIcon((Icon)new TranslateIcon(LinkHandler.LINK_ICON, 0, 1));
                }
                return multiIcon;
            }
            if (this.folderItem != null) {
                MultiIcon multiIcon = new MultiIcon((Icon)baseIcon, disabled, 18, 17);
                if (this.isReadOnly() && !this.fileSystem.isReadOnly()) {
                    multiIcon.addIcon((Icon)new TranslateIcon(READ_ONLY_ICON, 8, 9));
                }
                if (this.isCheckedOut()) {
                    if (this.isCheckedOutExclusive()) {
                        multiIcon.addIcon(CHECKED_OUT_EXCLUSIVE_ICON);
                    } else {
                        multiIcon.addIcon(CHECKED_OUT_ICON);
                    }
                }
                if (isLink) {
                    multiIcon.addIcon((Icon)new TranslateIcon(LinkHandler.LINK_ICON, 0, 1));
                }
                return multiIcon;
            }
        }
        return DomainFile.UNSUPPORTED_FILE_ICON;
    }

    private Icon getBaseIcon(FolderItem item) {
        try {
            return this.getContentHandler().getIcon();
        }
        catch (IOException iOException) {
            return DomainFile.UNSUPPORTED_FILE_ICON;
        }
    }

    boolean isChanged() {
        DomainObjectAdapter dobj = this.getOpenedDomainObject();
        return dobj != null && dobj.isChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCheckedOut() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            return this.folderItem != null && this.folderItem.isCheckedOut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCheckedOutExclusive() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.folderItem == null) {
                return false;
            }
            if (this.folderItem.isCheckedOutExclusive()) {
                return true;
            }
            return !this.versionedFileSystem.isShared() && this.folderItem.isCheckedOut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean modifiedSinceCheckout() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            return this.isCheckedOut() && this.folderItem.getCurrentVersion() != this.folderItem.getLocalCheckoutVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReadOnly() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            return this.folderItem != null && this.folderItem.isReadOnly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isVersioned() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.versionedFolderItem == null) {
                return this.isCheckedOut();
            }
            return !this.isHijacked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isHijacked() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            return this.folderItem != null && this.versionedFolderItem != null && !this.folderItem.isCheckedOut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canCheckout() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                if (this.folderItem != null || this.fileSystem.isReadOnly() || this.versionedFileSystem.isReadOnly()) {
                    return false;
                }
                return !this.isLinkFile();
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canCheckin() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                return !this.fileSystem.isReadOnly() && !this.versionedFileSystem.isReadOnly() && this.modifiedSinceCheckout();
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getVersion() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                if (this.folderItem != null) {
                    if (this.folderItem.isCheckedOut()) {
                        return this.folderItem.getCheckoutVersion();
                    }
                    return this.folderItem.getCurrentVersion();
                }
                return this.versionedFolderItem.getCurrentVersion();
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)"IO error", (Throwable)e);
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getLatestVersion() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (!this.isHijacked() && this.versionedFolderItem != null) {
                return this.versionedFolderItem.getCurrentVersion();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canMerge() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                return !this.fileSystem.isReadOnly() && this.versionedFolderItem != null && this.folderItem != null && this.folderItem.isCheckedOut() && this.versionedFolderItem.getCurrentVersion() > this.folderItem.getCheckoutVersion();
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)"IO Error", (Throwable)e);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReadOnly(boolean state) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.fileSystem.isReadOnly()) {
                throw new ReadOnlyException("setReadOnly permitted in writeable project only");
            }
            if (this.isVersioned()) {
                throw new AssertException("Versioned files do not support read-only setting");
            }
            this.folderItem.setReadOnly(state);
            this.statusChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Version[] getVersionHistory() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.versionedFolderItem != null) {
                return this.versionedFolderItem.getVersions();
            }
            return null;
        }
    }

    void checkCanAddToRepository() throws IOException {
        if (!this.versionedFileSystem.isOnline()) {
            throw new NotConnectedException("Not connected to repository server");
        }
        if (this.fileSystem.isReadOnly() || this.versionedFileSystem.isReadOnly()) {
            throw new ReadOnlyException("versioning permitted within writeable project and repository only");
        }
        if (this.folderItem == null) {
            throw new FileNotFoundException("File not found");
        }
        if (this.folderItem.isCheckedOut() || this.versionedFolderItem != null) {
            throw new IOException("File already versioned");
        }
        ContentHandler<?> contentHandler = this.getContentHandler();
        if (contentHandler instanceof LinkHandler) {
            LinkHandler linkHandler = (LinkHandler)contentHandler;
            if (!GhidraURL.isServerRepositoryURL(LinkHandler.getURL((FolderItem)this.folderItem))) {
                throw new IOException("Local project link-file may not be versioned");
            }
        } else if (contentHandler.isPrivateContentType()) {
            throw new IOException("Content may not be versioned: " + this.getContentType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToVersionControl(String comment, boolean keepCheckedOut, TaskMonitor monitor) throws IOException, CancelledException {
        this.checkCanAddToRepository();
        if (this.busy.getAndSet(true)) {
            throw new FileInUseException(this.name + " is busy");
        }
        DomainObjectAdapterDB inUseDomainObj = null;
        this.projectData.mergeStarted();
        try {
            inUseDomainObj = this.getAndLockInUseDomainObjectForMergeUpdate("checkin");
            if (this.isLinkFile()) {
                keepCheckedOut = false;
            } else if (inUseDomainObj != null && !keepCheckedOut) {
                keepCheckedOut = true;
                Msg.warn((Object)this, (Object)("File currently open - must keep checked-out: " + this.name));
            }
            LocalFileSystem localFileSystem = this.fileSystem;
            synchronized (localFileSystem) {
                String user;
                block28: {
                    String parentPath = this.parent.getPathname();
                    user = ClientUtil.getUserName();
                    try {
                        if (this.folderItem instanceof DatabaseItem) {
                            DatabaseItem databaseItem = (DatabaseItem)this.folderItem;
                            ManagedBufferFile bufferFile = databaseItem.open();
                            try {
                                this.versionedFolderItem = this.versionedFileSystem.createDatabase(parentPath, this.name, this.folderItem.getFileID(), (BufferFile)bufferFile, comment, this.folderItem.getContentType(), false, monitor, user);
                                break block28;
                            }
                            finally {
                                bufferFile.dispose();
                            }
                        }
                        if (this.folderItem instanceof DataFileItem) {
                            DataFileItem dataFileItem = (DataFileItem)this.folderItem;
                            try (InputStream istream = dataFileItem.getInputStream();){
                                this.versionedFolderItem = this.versionedFileSystem.createDataFile(parentPath, this.name, istream, comment, this.folderItem.getContentType(), monitor);
                                break block28;
                            }
                        }
                        throw new AssertException("Unknown folder item type");
                    }
                    catch (InvalidNameException e) {
                        throw new AssertException("Unexpected error", (Throwable)e);
                    }
                }
                if (keepCheckedOut) {
                    CheckoutType checkoutType;
                    boolean exclusive = !this.versionedFileSystem.isShared() || inUseDomainObj != null;
                    ProjectLocator projectLocator = this.parent.getProjectLocator();
                    if (projectLocator.isTransient()) {
                        checkoutType = CheckoutType.TRANSIENT;
                        exclusive = true;
                    } else {
                        checkoutType = exclusive || !this.versionedFileSystem.isShared() ? CheckoutType.EXCLUSIVE : CheckoutType.NORMAL;
                    }
                    ItemCheckoutStatus checkout = this.versionedFolderItem.checkout(checkoutType, user, ItemCheckoutStatus.getProjectPath((String)projectLocator.toString(), (boolean)projectLocator.isTransient()));
                    this.folderItem.setCheckout(checkout.getCheckoutId(), exclusive, checkout.getCheckoutVersion(), this.folderItem.getCurrentVersion());
                    if (inUseDomainObj != null) {
                        this.getContentHandler().resetDBSourceFile((FolderItem)this.folderItem, inUseDomainObj);
                    }
                } else {
                    try {
                        this.folderItem.delete(-1, ClientUtil.getUserName());
                        this.folderItem = null;
                    }
                    catch (FileInUseException fileInUseException) {
                        // empty catch block
                    }
                }
            }
            if (inUseDomainObj != null) {
                inUseDomainObj.domainObjectRestored();
            }
        }
        finally {
            this.unlockDomainObject(inUseDomainObj);
            this.busy.set(false);
            this.projectData.mergeEnded();
            this.parent.deleteLocalFolderIfEmpty();
            this.parent.fileChanged(this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkout(boolean exclusive, TaskMonitor monitor) throws IOException, CancelledException {
        if (this.fileSystem.isReadOnly()) {
            throw new ReadOnlyException("checkout permitted in writeable project only");
        }
        if (this.versionedFileSystem.isReadOnly()) {
            throw new ReadOnlyException("Versioned repository is read-only and does not permit checkout");
        }
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            int checkoutVersion;
            boolean fileIDset;
            ItemCheckoutStatus checkout;
            block26: {
                CheckoutType checkoutType;
                if (this.folderItem != null) {
                    throw new AssertException("Cannot checkout, private file exists");
                }
                if (!this.versionedFileSystem.isOnline()) {
                    throw new NotConnectedException("Not connected to repository server");
                }
                if (this.isLinkFile()) {
                    return false;
                }
                String user = ClientUtil.getUserName();
                ProjectLocator projectLocator = this.parent.getProjectLocator();
                if (projectLocator.isTransient()) {
                    checkoutType = CheckoutType.TRANSIENT;
                    exclusive = true;
                } else {
                    checkoutType = exclusive || !this.versionedFileSystem.isShared() ? CheckoutType.EXCLUSIVE : CheckoutType.NORMAL;
                }
                checkout = this.versionedFolderItem.checkout(checkoutType, user, ItemCheckoutStatus.getProjectPath((String)projectLocator.toString(), (boolean)projectLocator.isTransient()));
                if (checkout == null) {
                    return false;
                }
                fileIDset = false;
                if (this.fileID == null) {
                    this.fileID = this.versionedFolderItem.getFileID();
                    fileIDset = this.fileID != null;
                }
                checkoutVersion = checkout.getCheckoutVersion();
                String parentPath = this.parent.getPathname();
                try {
                    if (this.versionedFolderItem instanceof DatabaseItem) {
                        DatabaseItem databaseItem = (DatabaseItem)this.versionedFolderItem;
                        ManagedBufferFile bufferFile = databaseItem.open(checkoutVersion);
                        try {
                            this.folderItem = this.fileSystem.createDatabase(parentPath, this.name, this.fileID, (BufferFile)bufferFile, null, databaseItem.getContentType(), false, monitor, user);
                            break block26;
                        }
                        finally {
                            bufferFile.dispose();
                        }
                    }
                    if (this.versionedFolderItem instanceof DataFileItem) {
                        DataFileItem dataFileItem = (DataFileItem)this.versionedFolderItem;
                        try (InputStream istream = dataFileItem.getInputStream(checkoutVersion);){
                            this.folderItem = this.fileSystem.createDataFile(parentPath, this.name, istream, null, dataFileItem.getContentType(), monitor);
                            break block26;
                        }
                    }
                    throw new AssertException("Can't checkout - unknown file type");
                }
                catch (InvalidNameException e) {
                    throw new AssertException("Unexpected error", (Throwable)e);
                }
                finally {
                    if (this.folderItem == null) {
                        this.versionedFolderItem.terminateCheckout(checkout.getCheckoutId(), false);
                    }
                }
            }
            this.folderItem.setCheckout(checkout.getCheckoutId(), exclusive, checkoutVersion, this.folderItem.getCurrentVersion());
            this.statusChanged(fileIDset);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean quickCheckin(CheckinHandler checkinHandler, TaskMonitor monitor) throws IOException, CancelledException {
        if (!(this.versionedFolderItem instanceof DatabaseItem)) {
            return false;
        }
        monitor.checkCancelled();
        monitor.setMessage("Initiating Check In for " + this.name);
        boolean success = false;
        LocalManagedBufferFile srcFile = null;
        ManagedBufferFile checkinFile = null;
        try {
            LocalFileSystem localFileSystem = this.fileSystem;
            synchronized (localFileSystem) {
                block20: {
                    checkinFile = ((DatabaseItem)this.versionedFolderItem).openForUpdate(this.folderItem.getCheckoutId());
                    if (this.versionedFolderItem.getCurrentVersion() == this.folderItem.getCheckoutVersion()) break block20;
                    boolean bl = false;
                    return bl;
                }
                srcFile = (LocalManagedBufferFile)((DatabaseItem)this.folderItem).open();
            }
            String comment = checkinHandler.getComment();
            if (checkinHandler.createKeepFile()) {
                DomainObject sourceObj = null;
                try {
                    sourceObj = (DomainObject)this.getContentHandler().getImmutableObject((FolderItem)this.folderItem, this, -1, -1, monitor);
                    this.createKeepFile(sourceObj, monitor);
                }
                catch (VersionException versionException) {
                }
                finally {
                    this.release(sourceObj);
                }
            }
            monitor.checkCancelled();
            LocalFileSystem localFileSystem2 = this.fileSystem;
            synchronized (localFileSystem2) {
                srcFile.createNewVersion(checkinFile, comment, monitor);
                success = true;
            }
        }
        finally {
            if (checkinFile != null) {
                checkinFile.close();
            }
            if (srcFile != null) {
                srcFile.close();
            }
        }
        return success;
    }

    private void verifyCheckout(String operationName) throws IOException {
        if (this.versionedFileSystem instanceof LocalFileSystem) {
            return;
        }
        String repoUserName = this.versionedFileSystem.getUserName();
        if (repoUserName == null) {
            throw new IOException("File " + operationName + " not permitted (not connected)");
        }
        ItemCheckoutStatus checkoutStatus = this.getCheckoutStatus();
        if (checkoutStatus == null) {
            throw new IOException("File not checked out");
        }
        String checkoutUserName = checkoutStatus.getUser();
        if (!repoUserName.equals(checkoutUserName)) {
            throw new IOException("File " + operationName + " not permitted - checkout user '" + checkoutUserName + "' differs from repository user '" + repoUserName + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void checkin(CheckinHandler checkinHandler, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        if (!this.versionedFileSystem.isOnline()) {
            throw new NotConnectedException("Not connected to repository server");
        }
        if (this.fileSystem.isReadOnly()) throw new ReadOnlyException("checkin permitted within writeable project and repository only");
        if (this.versionedFileSystem.isReadOnly()) {
            throw new ReadOnlyException("checkin permitted within writeable project and repository only");
        }
        if (!this.isCheckedOut()) {
            throw new IOException("File not checked out");
        }
        if (this.isChanged()) {
            throw new IOException("File has unsaved changes");
        }
        if (this.canRecover()) {
            throw new IOException("File recovery data exists");
        }
        if (!this.modifiedSinceCheckout()) {
            throw new IOException("File has not been modified since checkout");
        }
        this.verifyCheckout("checkin");
        if (monitor == null) {
            monitor = TaskMonitor.DUMMY;
        }
        if (this.busy.getAndSet(true)) {
            throw new FileInUseException(this.name + " is busy");
        }
        DomainObjectAdapterDB inUseDomainObj = null;
        this.projectData.mergeStarted();
        try {
            boolean quickCheckin;
            ContentHandler<?> contentHandler = this.getContentHandler();
            inUseDomainObj = this.getAndLockInUseDomainObjectForMergeUpdate("checkin");
            boolean keepCheckedOut = checkinHandler.keepCheckedOut();
            if (inUseDomainObj != null && !keepCheckedOut) {
                keepCheckedOut = true;
                Msg.warn((Object)this, (Object)("File currently open - must keep checked-out: " + this.name));
            }
            boolean bl = quickCheckin = ALWAYS_MERGE ? false : this.quickCheckin(checkinHandler, monitor);
            if (!quickCheckin) {
                if (SystemUtilities.isInHeadlessMode()) {
                    throw new IOException("Checkin failed, file requires merge which is not supported in headless mode");
                }
                Msg.info((Object)this, (Object)("Checkin with merge for " + this.name));
                Object checkinObj = contentHandler.getDomainObject(this.versionedFolderItem, null, this.folderItem.getCheckoutId(), false, false, this, monitor);
                ((DomainObjectAdapter)checkinObj).setDomainFile(new DomainFileProxy(this.name, this.getParent().getPathname(), (DomainObjectAdapter)checkinObj, this.versionedFolderItem.getCurrentVersion() + 1, this.fileID, this.parent.getProjectLocator()));
                DomainObject sourceObj = null;
                DomainObject originalObj = null;
                DomainObject latestObj = null;
                LocalFileSystem localFileSystem = this.fileSystem;
                // MONITORENTER : localFileSystem
                int coVer = this.folderItem.getCheckoutVersion();
                sourceObj = (DomainObject)contentHandler.getImmutableObject((FolderItem)this.folderItem, this, -1, -1, monitor);
                originalObj = (DomainObject)contentHandler.getImmutableObject(this.versionedFolderItem, this, coVer, -1, monitor);
                latestObj = (DomainObject)contentHandler.getImmutableObject(this.versionedFolderItem, this, -1, coVer, monitor);
                // MONITOREXIT : localFileSystem
                DomainObjectMergeManager mergeMgr = contentHandler.getMergeManager((DomainObject)checkinObj, sourceObj, originalObj, latestObj);
                if (!mergeMgr.merge(monitor)) {
                    Msg.info((Object)this, (Object)("Checkin with merge terminated for " + this.name));
                    ((DomainObjectAdapter)checkinObj).release(this);
                    this.release(sourceObj);
                    this.release(originalObj);
                    this.release(latestObj);
                    this.unlockDomainObject(inUseDomainObj);
                    this.busy.set(false);
                    this.projectData.mergeEnded();
                    this.parent.deleteLocalFolderIfEmpty();
                    this.parent.fileChanged(this.name);
                    return;
                }
                checkinObj.save(checkinHandler.getComment(), monitor);
                if (checkinHandler.createKeepFile()) {
                    if (monitor != null) {
                        monitor.setMessage("Generating local keep file...");
                    }
                    this.createKeepFile(sourceObj, monitor);
                }
            }
            LocalFileSystem localFileSystem = this.fileSystem;
            // MONITORENTER : localFileSystem
            this.versionedFolderItem = this.versionedFileSystem.getItem(this.parent.getPathname(), this.name);
            if (this.versionedFolderItem == null) {
                throw new IOException("Checkin failed, versioned item not found");
            }
            Msg.info((Object)this, (Object)("Checkin completed for " + this.name));
            if (keepCheckedOut) {
                boolean success = false;
                try {
                    if (monitor != null) {
                        monitor.setMessage("Updating local checkout file...");
                    }
                    this.folderItem.updateCheckout(this.versionedFolderItem, !quickCheckin, monitor);
                    success = true;
                }
                finally {
                    if (!success) {
                        try {
                            if (inUseDomainObj != null) {
                                this.projectData.clearDomainObject(this.getPathname());
                                inUseDomainObj.setDomainFile(new DomainFileProxy(this.name, this.parent.getPathname(), inUseDomainObj, -2, this.fileID, this.parent.getProjectLocator()));
                                inUseDomainObj.setTemporary(true);
                            }
                            this.undoCheckout(false, true);
                        }
                        catch (IOException e) {
                            Msg.error((Object)this, (Object)"Undo checkout error", (Throwable)e);
                        }
                    }
                }
                if (inUseDomainObj != null) {
                    contentHandler.resetDBSourceFile((FolderItem)this.folderItem, inUseDomainObj);
                }
            } else {
                this.undoCheckout(false, true);
            }
            // MONITOREXIT : localFileSystem
            if (inUseDomainObj != null) {
                inUseDomainObj.domainObjectRestored();
            }
            this.unlockDomainObject(inUseDomainObj);
            this.busy.set(false);
            this.projectData.mergeEnded();
            this.parent.deleteLocalFolderIfEmpty();
            this.parent.fileChanged(this.name);
            return;
        }
        catch (Throwable throwable) {
            this.unlockDomainObject(inUseDomainObj);
            this.busy.set(false);
            this.projectData.mergeEnded();
            this.parent.deleteLocalFolderIfEmpty();
            this.parent.fileChanged(this.name);
            throw throwable;
        }
    }

    private void release(DomainObject domainObj) {
        if (domainObj != null) {
            domainObj.release(this);
        }
    }

    private void unlockDomainObject(DomainObjectAdapterDB lockedDomainObject) {
        try {
            if (lockedDomainObject != null) {
                lockedDomainObject.unlock();
            }
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Unexpected " + this.getContentType() + " lock error: " + this.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DomainObjectAdapterDB getAndLockInUseDomainObjectForMergeUpdate(String operation) throws IOException {
        DomainObjectAdapterDB inUseDomainObj;
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            DomainObjectAdapter domainObj = this.getOpenedDomainObject();
            if (domainObj == null) {
                return null;
            }
            if (!(domainObj instanceof DomainObjectAdapterDB)) {
                throw new FileInUseException(this.name + " is in use");
            }
            inUseDomainObj = (DomainObjectAdapterDB)domainObj;
            if (inUseDomainObj.isChanged()) {
                throw new FileInUseException(this.name + " is in use w/ unsaved changes");
            }
        }
        ContentHandler<?> contentHandler = this.getContentHandler();
        if (!contentHandler.canResetDBSourceFile() || !inUseDomainObj.lock(operation) || inUseDomainObj.getDBHandle().hasUncommittedChanges()) {
            throw new FileInUseException(this.name + " is in use");
        }
        return inUseDomainObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ItemCheckoutStatus getCheckoutStatus() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            long checkoutId;
            if (!this.versionedFileSystem.isOnline()) {
                throw new NotConnectedException("Not connected to repository server");
            }
            if (this.versionedFolderItem == null) {
                throw new IOException("File is not versioned");
            }
            ItemCheckoutStatus status = null;
            if (this.folderItem != null && (checkoutId = this.folderItem.getCheckoutId()) >= 0L) {
                status = this.versionedFolderItem.getCheckout(checkoutId);
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ItemCheckoutStatus[] getCheckouts() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (!this.versionedFileSystem.isOnline()) {
                throw new NotConnectedException("Not connected to repository server");
            }
            if (this.versionedFolderItem == null) {
                throw new IOException("File is not versioned");
            }
            return this.versionedFolderItem.getCheckouts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminateCheckout(long checkoutId) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (!this.versionedFileSystem.isOnline()) {
                throw new NotConnectedException("Not connected to repository server");
            }
            if (this.versionedFolderItem == null) {
                throw new IOException("File is not versioned");
            }
            this.versionedFolderItem.terminateCheckout(checkoutId, true);
        }
    }

    void undoCheckout(boolean keep, boolean inUseOK) throws IOException {
        this.undoCheckout(keep, false, inUseOK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void undoCheckout(boolean keep, boolean force, boolean inUseOK) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.fileSystem.isReadOnly()) {
                throw new ReadOnlyException("undoCheckout permitted within writeable project only");
            }
            if (!inUseOK) {
                this.checkInUse();
            }
            boolean doForce = false;
            boolean isOnline = this.versionedFileSystem.isOnline();
            if (!isOnline) {
                if (!force) {
                    throw new NotConnectedException("Not connected to repository server");
                }
                doForce = true;
            }
            if (!this.isCheckedOut()) {
                throw new IOException("File not checked out");
            }
            if (!doForce) {
                this.verifyCheckout("undo-checkout");
                long checkoutId = this.folderItem.getCheckoutId();
                this.versionedFolderItem.terminateCheckout(checkoutId, true);
            }
            String keepName = this.getKeepName();
            if (keep) {
                this.folderItem.clearCheckout();
                try {
                    String folderPath = this.parent.getPathname();
                    this.fileSystem.moveItem(folderPath, this.name, folderPath, keepName);
                    this.parent.fileChanged(keepName);
                }
                catch (InvalidNameException e) {
                    throw new AssertException("Unexpected error", (Throwable)e);
                }
            } else {
                this.folderItem.delete(-1, ClientUtil.getUserName());
                this.parent.deleteLocalFolderIfEmpty();
            }
            this.folderItem = null;
            this.parent.fileChanged(this.name);
        }
    }

    private String getKeepName() {
        String tempName;
        String keep = tempName = this.name + ".keep";
        int cnt = 0;
        while (this.fileSystem.fileExists(this.parent.getPathname(), keep) || this.versionedFileExists(keep)) {
            keep = tempName + "." + ++cnt;
        }
        return keep;
    }

    private boolean versionedFileExists(String fileName) {
        try {
            return this.versionedFileSystem.isOnline() && this.versionedFileSystem.getItem(this.parent.getPathname(), fileName) != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private void createKeepFile(DomainObject sourceObj, TaskMonitor monitor) {
        Object keepName = this.name + ".keep";
        try {
            GhidraFileData keepFileData = this.parent.getFileData((String)keepName, false);
            if (keepFileData != null) {
                try {
                    keepFileData.delete();
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)("Failed to create keep file: failed to remove old keep file: " + (String)keepName), (Throwable)e);
                    return;
                }
            }
            keepName = this.getKeepName();
            Msg.info((Object)this, (Object)("Creating old version keep file: " + (String)keepName));
            this.parent.createFile((String)keepName, sourceObj, monitor);
        }
        catch (InvalidNameException e) {
            throw new AssertException("Unexpected error", (Throwable)e);
        }
        catch (CancelledException e) {
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Failed to create keep file: " + (String)keepName), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.fileSystem.isReadOnly()) {
                throw new ReadOnlyException("delete permitted within writeable project only");
            }
            this.checkInUse();
            if (this.folderItem != null && this.folderItem.isCheckedOut()) {
                throw new FileInUseException("Can not delete file while it is checked-out");
            }
            if (this.isHijacked()) {
                this.folderItem.delete(-1, ClientUtil.getUserName());
                this.parent.deleteLocalFolderIfEmpty();
                Msg.info((Object)this, (Object)("Deleted local file, revealing hijacked file " + this.name));
            } else if (this.versionedFolderItem == null) {
                this.folderItem.delete(-1, ClientUtil.getUserName());
                Msg.info((Object)this, (Object)("Deleted local file " + this.name));
            } else {
                this.versionedFolderItem.delete(-1, ClientUtil.getUserName());
                Msg.info((Object)this, (Object)("Deleted versioned file " + this.name));
            }
            if (!(this.fileID == null || this.folderItem != null && this.versionedFolderItem != null && this.fileID.equals(this.versionedFolderItem.getFileID()))) {
                this.removeAssociatedUserDataFile();
            }
            this.parent.fileChanged(this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(int version) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.fileSystem.isReadOnly()) {
                throw new ReadOnlyException("delete(version) permitted within writeable project only");
            }
            if (this.versionedFolderItem == null) {
                throw new IOException(this.name + " is not versioned");
            }
            if (this.folderItem != null && this.folderItem.getCheckoutVersion() == version) {
                throw new FileInUseException(this.name + " version " + version + " is checked-out");
            }
            this.versionedFolderItem.delete(version, ClientUtil.getUserName());
        }
    }

    private void removeAssociatedUserDataFile() {
        try {
            ContentHandler<?> contentHandler = this.getContentHandler();
            if (contentHandler instanceof DBWithUserDataContentHandler) {
                LocalFolderItem item = this.folderItem != null ? this.folderItem : this.versionedFolderItem;
                ((DBWithUserDataContentHandler)contentHandler).removeUserDataFile((FolderItem)item, (FileSystem)this.parent.getUserFileSystem());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void merge(boolean okToUpgrade, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        if (this.fileSystem.isReadOnly()) {
            throw new ReadOnlyException("merge permitted within writeable project only");
        }
        if (this.parent.getProjectLocator().isTransient()) {
            throw new IOException("Merge not permitted for transient project");
        }
        if (!this.versionedFileSystem.isOnline()) {
            throw new NotConnectedException("Not connected to repository server");
        }
        if (!this.isCheckedOut()) {
            throw new IOException("File not checked out");
        }
        if (!(this.versionedFolderItem instanceof DatabaseItem)) {
            throw new IOException("unsupported operation");
        }
        if (this.folderItem.getCheckoutVersion() == this.versionedFolderItem.getCurrentVersion()) {
            throw new IOException("Versioned file has not been updated since checkout");
        }
        if (this.isChanged()) {
            throw new IOException("File has unsaved changes");
        }
        if (this.canRecover()) {
            throw new IOException("File recovery data exists");
        }
        this.verifyCheckout("merge");
        if (monitor == null) {
            monitor = TaskMonitor.DUMMY;
        }
        if (this.busy.getAndSet(true)) {
            throw new FileInUseException(this.name + " is busy");
        }
        LocalDatabaseItem tmpItem = null;
        DomainObjectAdapterDB inUseDomainObj = null;
        this.projectData.mergeStarted();
        try {
            inUseDomainObj = this.getAndLockInUseDomainObjectForMergeUpdate("merge");
            ContentHandler<?> contentHandler = this.getContentHandler();
            if (!this.modifiedSinceCheckout()) {
                this.folderItem.updateCheckout(this.versionedFolderItem, true, monitor);
            } else {
                if (SystemUtilities.isInHeadlessMode()) {
                    throw new IOException("Merge failed, merge is not supported in headless mode");
                }
                int mergeVer = this.versionedFolderItem.getCurrentVersion();
                if (!okToUpgrade) {
                    Object testObj = contentHandler.getReadOnlyObject(this.versionedFolderItem, mergeVer, false, this, monitor);
                    testObj.release(this);
                }
                Msg.info((Object)this, (Object)("Merging version " + mergeVer + " for " + this.name));
                DatabaseItem databaseItem = (DatabaseItem)this.versionedFolderItem;
                ManagedBufferFile bufferFile = databaseItem.open(mergeVer);
                try {
                    String tmpName = this.name + ".merge";
                    tmpItem = this.fileSystem.createTemporaryDatabase(this.parent.getPathname(), tmpName, databaseItem.getFileID(), (BufferFile)bufferFile, databaseItem.getContentType(), false, monitor);
                }
                catch (InvalidNameException e) {
                    throw new AssertException("Unexpected error", (Throwable)e);
                }
                finally {
                    bufferFile.dispose();
                }
                int coVer = this.folderItem.getCheckoutVersion();
                long checkoutId = this.folderItem.getCheckoutId();
                tmpItem.setCheckout(checkoutId, this.folderItem.isCheckedOutExclusive(), mergeVer, 0);
                Object mergeObj = contentHandler.getDomainObject((FolderItem)tmpItem, null, -1L, okToUpgrade, false, this, monitor);
                DomainObject sourceObj = null;
                DomainObject originalObj = null;
                DomainObject latestObj = null;
                try {
                    sourceObj = (DomainObject)contentHandler.getImmutableObject((FolderItem)this.folderItem, this, -1, -1, monitor);
                    originalObj = (DomainObject)contentHandler.getImmutableObject(this.versionedFolderItem, this, coVer, -1, monitor);
                    latestObj = (DomainObject)contentHandler.getImmutableObject(this.versionedFolderItem, this, mergeVer, coVer, monitor);
                    DomainObjectMergeManager mergeMgr = contentHandler.getMergeManager((DomainObject)mergeObj, sourceObj, originalObj, latestObj);
                    if (!mergeMgr.merge(monitor)) {
                        Msg.info((Object)this, (Object)("Merge terminated for " + this.name));
                        return;
                    }
                    mergeObj.save("Merge with version " + mergeVer, monitor);
                    this.createKeepFile(sourceObj, monitor);
                }
                finally {
                    this.release((DomainObject)mergeObj);
                    this.release(sourceObj);
                    this.release(originalObj);
                    this.release(latestObj);
                }
                this.folderItem.updateCheckout((FolderItem)tmpItem, mergeVer);
                this.versionedFolderItem.updateCheckoutVersion(checkoutId, mergeVer, ClientUtil.getUserName());
                tmpItem = null;
            }
            Msg.info((Object)this, (Object)("Updated checkout completed for " + this.name));
            if (inUseDomainObj != null) {
                contentHandler.resetDBSourceFile((FolderItem)this.folderItem, inUseDomainObj);
                inUseDomainObj.domainObjectRestored();
            }
        }
        finally {
            this.unlockDomainObject(inUseDomainObj);
            this.busy.set(false);
            try {
                if (tmpItem != null) {
                    try {
                        tmpItem.delete(-1, ClientUtil.getUserName());
                    }
                    catch (IOException e) {
                        Msg.error((Object)this, (Object)"IO error", (Throwable)e);
                    }
                }
                this.parent.fileChanged(this.name);
                if (this.parent.visited()) {
                    this.parent.refresh(false, true, null);
                }
            }
            finally {
                this.projectData.mergeEnded();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    GhidraFile moveTo(GhidraFolderData newParent) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (newParent.getLocalFileSystem() != this.fileSystem) {
                throw new IllegalArgumentException("moveTo permitted within same project only");
            }
            if (this.fileSystem.isReadOnly()) {
                throw new ReadOnlyException("moveTo permitted within writeable project only");
            }
            if (this.getParent().getPathname().equals(newParent.getPathname())) {
                throw new IllegalArgumentException("newParent must differ from current parent");
            }
            this.checkInUse();
            GhidraFolderData oldParent = this.parent;
            String oldName = this.name;
            String newName = newParent.getTargetName(this.name);
            try {
                if (this.isHijacked()) {
                    this.fileSystem.moveItem(this.parent.getPathname(), this.name, newParent.getPathname(), newName);
                    this.parent.fileChanged(this.name);
                    newParent.fileChanged(newName);
                    return newParent.getDomainFile(newName);
                }
                if (this.versionedFolderItem == null) {
                    if (this.isCheckedOut()) throw new FileInUseException(this.name + " is checked-out");
                    this.fileSystem.moveItem(this.parent.getPathname(), this.name, newParent.getPathname(), newName);
                    this.folderItem = this.fileSystem.getItem(newParent.getPathname(), newName);
                } else {
                    this.versionedFileSystem.moveItem(this.parent.getPathname(), this.name, newParent.getPathname(), newName);
                    this.versionedFolderItem = this.versionedFileSystem.getItem(newParent.getPathname(), newName);
                }
            }
            catch (InvalidNameException e) {
                throw new AssertException("Unexpected error", (Throwable)e);
            }
            this.parent = newParent;
            this.name = newName;
            oldParent.fileMoved(newParent, oldName, newName);
            return newParent.getDomainFile(newName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLinkFile() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                return LinkHandler.class.isAssignableFrom(this.getContentHandler().getClass());
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    URL getLinkFileURL() throws IOException {
        if (!this.isLinkFile()) {
            return null;
        }
        LocalFolderItem item = this.folderItem != null ? this.folderItem : this.versionedFolderItem;
        return LinkHandler.getURL((FolderItem)item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLinkingSupported() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                return this.getContentHandler().getLinkHandler() != null;
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DomainFile copyToAsLink(GhidraFolderData newParent) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            LinkHandler<?> lh = this.getContentHandler().getLinkHandler();
            if (lh == null) {
                return null;
            }
            return newParent.copyAsLink(this.projectData, this.getPathname(), this.name, lh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GhidraFile copyTo(GhidraFolderData newParent, TaskMonitor monitor) throws IOException, CancelledException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            String targetName;
            block14: {
                if (newParent.getLocalFileSystem().isReadOnly()) {
                    throw new ReadOnlyException("copyVersionTo permitted to writeable project only");
                }
                LocalFolderItem item = this.folderItem != null ? this.folderItem : this.versionedFolderItem;
                String pathname = newParent.getPathname();
                String contentType = item.getContentType();
                targetName = newParent.getTargetName(this.name);
                String user = ClientUtil.getUserName();
                try {
                    if (item instanceof DatabaseItem) {
                        ManagedBufferFile bufferFile = ((DatabaseItem)item).open();
                        try {
                            newParent.getLocalFileSystem().createDatabase(pathname, targetName, FileIDFactory.createFileID(), (BufferFile)bufferFile, null, contentType, true, monitor, user);
                            break block14;
                        }
                        finally {
                            bufferFile.dispose();
                        }
                    }
                    if (item instanceof DataFileItem) {
                        try (InputStream istream = ((DataFileItem)item).getInputStream();){
                            newParent.getLocalFileSystem().createDataFile(pathname, targetName, istream, null, contentType, monitor);
                            break block14;
                        }
                    }
                    throw new AssertException("Unknown Item in copyTo");
                }
                catch (InvalidNameException e) {
                    throw new AssertException("Unexpected error", (Throwable)e);
                }
            }
            newParent.fileChanged(targetName);
            return newParent.getDomainFile(targetName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GhidraFile copyVersionTo(int version, GhidraFolderData destFolder, TaskMonitor monitor) throws IOException, CancelledException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (destFolder.getLocalFileSystem().isReadOnly()) {
                throw new ReadOnlyException("copyVersionTo permitted to writeable project");
            }
            if (this.versionedFolderItem == null) {
                return null;
            }
            if (!(this.versionedFolderItem instanceof DatabaseItem)) {
                throw new IOException("unsupported operation");
            }
            String pathname = destFolder.getPathname();
            String contentType = this.versionedFolderItem.getContentType();
            String targetName = destFolder.getTargetName(this.name + "_v" + version);
            String user = ClientUtil.getUserName();
            try {
                ManagedBufferFile bufferFile = ((DatabaseItem)this.versionedFolderItem).open(version);
                if (bufferFile == null) {
                    return null;
                }
                try {
                    destFolder.getLocalFileSystem().createDatabase(pathname, targetName, FileIDFactory.createFileID(), (BufferFile)bufferFile, null, contentType, true, monitor, user);
                }
                finally {
                    bufferFile.dispose();
                }
            }
            catch (InvalidNameException e) {
                throw new AssertException("Unexpected error", (Throwable)e);
            }
            destFolder.fileChanged(targetName);
            return destFolder.getDomainFile(targetName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void convertToPrivateFile(TaskMonitor monitor) throws IOException, CancelledException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (!(this.versionedFileSystem instanceof LocalFileSystem)) {
                throw new UnsupportedOperationException("not supported for project");
            }
            if (!this.isVersioned()) {
                return;
            }
            GhidraFolderData oldParent = this.getParent();
            if (this.isCheckedOut()) {
                this.folderItem.clearCheckout();
                oldParent.fileChanged(this.name);
            } else {
                GhidraFile df = this.copyTo(oldParent, monitor);
                this.versionedFolderItem.delete(-1, ClientUtil.getUserName());
                oldParent.fileChanged(this.name);
                try {
                    df.setName(this.name);
                }
                catch (InvalidNameException e) {
                    throw new AssertException("Unexpected error", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void packFile(File file, TaskMonitor monitor) throws IOException, CancelledException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            LocalFolderItem item = this.folderItem != null ? this.folderItem : this.versionedFolderItem;
            item.output(file, -1, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long length() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.folderItem != null) {
                return this.folderItem.length();
            }
            if (this.versionedFolderItem != null) {
                return this.versionedFolderItem.length();
            }
            return 0L;
        }
    }

    Map<String, String> getMetadata() {
        LocalFolderItem item = this.folderItem != null ? this.folderItem : this.versionedFolderItem;
        return GhidraFileData.getMetadata((FolderItem)item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, String> getMetadata(FolderItem item) {
        if (!(item instanceof DatabaseItem)) {
            return new HashMap<String, String>();
        }
        DatabaseItem databaseItem = (DatabaseItem)item;
        ManagedBufferFile bf = null;
        DBHandle dbh = null;
        GenericDomainObjectDB genericDomainObj = null;
        try {
            bf = databaseItem.open();
            dbh = new DBHandle((BufferFile)bf);
            genericDomainObj = new GenericDomainObjectDB(dbh);
            Map<String, String> map = genericDomainObj.getMetadata();
            return map;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Field.UnsupportedFieldException unsupportedFieldException) {
        }
        catch (IOException e) {
            Msg.error(GhidraFileData.class, (Object)"Read meta-data error", (Throwable)e);
        }
        finally {
            if (genericDomainObj != null) {
                genericDomainObj.release();
            }
            if (dbh != null) {
                dbh.close();
            }
            if (bf != null) {
                bf.dispose();
            }
        }
        return new HashMap<String, String>();
    }

    public String toString() {
        if (this.projectData == null) {
            return this.name + "(disposed)";
        }
        ProjectLocator projectLocator = this.projectData.getProjectLocator();
        if (projectLocator.isTransient()) {
            return this.projectData.getProjectLocator().getName() + this.getPathname();
        }
        return this.projectData.getProjectLocator().getName() + ":" + this.getPathname();
    }

    private static class GenericDomainObjectDB
    extends DomainObjectAdapterDB {
        protected GenericDomainObjectDB(DBHandle dbh) throws IOException {
            super(dbh, "Generic", 500, dbh);
            this.loadMetadata();
        }

        @Override
        public String getDescription() {
            return "Generic Database Domain Object";
        }

        @Override
        public boolean isChangeable() {
            return false;
        }

        public void release() {
            this.release(this.dbh);
        }
    }
}

