/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.widgets.tree.GTreeLazyNode;
import docking.widgets.tree.GTreeNode;
import ghidra.framework.main.datatree.Cuttable;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.LinkedDomainFolder;
import ghidra.util.HTMLUtilities;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import resources.ResourceManager;

public class DomainFolderNode
extends GTreeLazyNode
implements Cuttable {
    private static final Icon ENABLED_OPEN_FOLDER = DomainFolder.OPEN_FOLDER_ICON;
    private static final Icon ENABLED_CLOSED_FOLDER = DomainFolder.CLOSED_FOLDER_ICON;
    private static final Icon DISABLED_OPEN_FOLDER = ResourceManager.getDisabledIcon((Icon)ENABLED_OPEN_FOLDER);
    private static final Icon DISABLED_CLOSED_FOLDER = ResourceManager.getDisabledIcon((Icon)ENABLED_CLOSED_FOLDER);
    private DomainFolder domainFolder;
    private boolean isCut;
    private DomainFileFilter filter;
    private String toolTipText;
    private boolean isEditable;

    DomainFolderNode(DomainFolder domainFolder, DomainFileFilter filter) {
        this.domainFolder = domainFolder;
        this.filter = filter;
        if (domainFolder != null) {
            this.toolTipText = StringUtilities.trimMiddle((String)domainFolder.getPathname(), (int)120);
            this.toolTipText = HTMLUtilities.toLiteralHTML((String)this.toolTipText, (int)0);
            this.isEditable = domainFolder.isInWritableProject();
        }
    }

    public boolean isAutoExpandPermitted() {
        return !this.domainFolder.isLinked();
    }

    public DomainFolder getDomainFolder() {
        return this.domainFolder;
    }

    public boolean isLeaf() {
        return false;
    }

    @Override
    public void setIsCut(boolean isCut) {
        this.isCut = isCut;
        this.fireNodeChanged();
    }

    @Override
    public boolean isCut() {
        return this.isCut;
    }

    public Icon getIcon(boolean expanded) {
        if (this.domainFolder instanceof LinkedDomainFolder) {
            return ((LinkedDomainFolder)this.domainFolder).getIcon(expanded);
        }
        if (expanded) {
            return this.isCut ? DISABLED_OPEN_FOLDER : ENABLED_OPEN_FOLDER;
        }
        return this.isCut ? DISABLED_CLOSED_FOLDER : ENABLED_CLOSED_FOLDER;
    }

    public String getName() {
        return this.domainFolder.getName();
    }

    public String toString() {
        return this.getName();
    }

    public String getToolTip() {
        return this.toolTipText;
    }

    protected List<GTreeNode> generateChildren() {
        ArrayList<GTreeNode> children = new ArrayList<GTreeNode>();
        if (this.domainFolder != null && !this.domainFolder.isEmpty()) {
            DomainFile[] files;
            DomainFolder[] folders;
            for (DomainFolder folder : folders = this.domainFolder.getFolders()) {
                children.add((GTreeNode)new DomainFolderNode(folder, this.filter));
            }
            for (DomainFile domainFile : files = this.domainFolder.getFiles()) {
                DomainFolder folder;
                if (domainFile.isLinkFile() && this.filter != null && this.filter.followLinkedFolders() && (folder = domainFile.followLink()) != null) {
                    children.add((GTreeNode)new DomainFolderNode(folder, this.filter));
                    continue;
                }
                if (this.filter != null && !this.filter.accept(domainFile)) continue;
                children.add(new DomainFileNode(domainFile));
            }
        }
        Collections.sort(children);
        return children;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DomainFolderNode node = (DomainFolderNode)obj;
        return this.domainFolder.equals(node.domainFolder);
    }

    public int hashCode() {
        return System.identityHashCode(this.domainFolder);
    }

    public DomainFileFilter getDomainFileFilter() {
        return this.filter;
    }

    public int compareTo(GTreeNode node) {
        if (node instanceof DomainFileNode) {
            return -((DomainFileNode)node).compareTo((GTreeNode)this);
        }
        return super.compareTo(node);
    }

    public void valueChanged(Object newValue) {
        if (newValue.equals(this.getName())) {
            return;
        }
        if (newValue instanceof String) {
            try {
                this.domainFolder.setName((String)newValue);
            }
            catch (InvalidNameException e) {
                Msg.showError((Object)this, (Component)this.getTree(), (String)"Rename Failed", (Object)("Invalid name: " + String.valueOf(newValue)));
            }
            catch (IOException e) {
                Msg.showError((Object)this, (Component)this.getTree(), (String)"Rename Failed", (Object)e.getMessage());
            }
        }
    }
}

