/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.model;

import db.Transaction;
import ghidra.framework.data.DomainObjectFileListener;
import ghidra.framework.model.AbortedTransactionListener;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObjectClosedListener;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventQueueID;
import ghidra.framework.model.EventType;
import ghidra.framework.model.TransactionInfo;
import ghidra.framework.model.TransactionListener;
import ghidra.framework.options.Options;
import ghidra.framework.store.LockException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import utility.function.ExceptionalCallback;
import utility.function.ExceptionalSupplier;

public interface DomainObject {
    @Deprecated
    public static final EventType DO_OBJECT_SAVED = DomainObjectEvent.SAVED;
    @Deprecated
    public static final EventType DO_DOMAIN_FILE_CHANGED = DomainObjectEvent.FILE_CHANGED;
    @Deprecated
    public static final EventType DO_OBJECT_RENAMED = DomainObjectEvent.RENAMED;
    @Deprecated
    public static final EventType DO_OBJECT_RESTORED = DomainObjectEvent.RESTORED;
    @Deprecated
    public static final EventType DO_PROPERTY_CHANGED = DomainObjectEvent.PROPERTY_CHANGED;
    @Deprecated
    public static final EventType DO_OBJECT_CLOSED = DomainObjectEvent.CLOSED;
    @Deprecated
    public static final EventType DO_OBJECT_ERROR = DomainObjectEvent.ERROR;
    public static final Object undoLock = new Object();

    public boolean isChanged();

    public void setTemporary(boolean var1);

    public boolean isTemporary();

    public boolean isChangeable();

    public boolean canSave();

    public void save(String var1, TaskMonitor var2) throws IOException, CancelledException;

    public void saveToPackedFile(File var1, TaskMonitor var2) throws IOException, CancelledException;

    public void release(Object var1);

    public void addListener(DomainObjectListener var1);

    public void removeListener(DomainObjectListener var1);

    public void addCloseListener(DomainObjectClosedListener var1);

    public void removeCloseListener(DomainObjectClosedListener var1);

    public void addDomainFileListener(DomainObjectFileListener var1);

    public void removeDomainFileListener(DomainObjectFileListener var1);

    public EventQueueID createPrivateEventQueue(DomainObjectListener var1, int var2);

    public boolean removePrivateEventQueue(EventQueueID var1);

    public String getDescription();

    public String getName();

    public void setName(String var1);

    public DomainFile getDomainFile();

    public boolean addConsumer(Object var1);

    public List<Object> getConsumerList();

    public boolean isUsedBy(Object var1);

    public void setEventsEnabled(boolean var1);

    public boolean isSendingEvents();

    public void flushEvents();

    public void flushPrivateEventQueue(EventQueueID var1);

    public boolean canLock();

    public boolean isLocked();

    public boolean lock(String var1);

    public void forceLock(boolean var1, String var2);

    public void unlock();

    public List<String> getOptionsNames();

    public Options getOptions(String var1);

    public boolean isClosed();

    public boolean hasExclusiveAccess();

    public Map<String, String> getMetadata();

    public long getModificationNumber();

    public Transaction openTransaction(String var1) throws IllegalStateException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <E extends Exception> void withTransaction(String description, ExceptionalCallback<E> callback) throws E {
        int id = this.startTransaction(description);
        try {
            callback.call();
        }
        finally {
            this.endTransaction(id, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <E extends Exception, T> T withTransaction(String description, ExceptionalSupplier<T, E> supplier) throws E {
        Object t = null;
        boolean success = false;
        int id = this.startTransaction(description);
        try {
            t = supplier.get();
            success = true;
        }
        finally {
            this.endTransaction(id, success);
        }
        return (T)t;
    }

    public int startTransaction(String var1);

    public int startTransaction(String var1, AbortedTransactionListener var2);

    public void endTransaction(int var1, boolean var2);

    public TransactionInfo getCurrentTransactionInfo();

    public boolean hasTerminatedTransaction();

    public DomainObject[] getSynchronizedDomainObjects();

    public void addSynchronizedDomainObject(DomainObject var1) throws LockException;

    public void releaseSynchronizedDomainObject() throws LockException;

    public boolean canUndo();

    public boolean canRedo();

    public void clearUndo();

    public void undo() throws IOException;

    public void redo() throws IOException;

    public String getUndoName();

    public String getRedoName();

    public List<String> getAllUndoNames();

    public List<String> getAllRedoNames();

    public void addTransactionListener(TransactionListener var1);

    public void removeTransactionListener(TransactionListener var1);
}

