/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.model;

import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.store.FileSystem;

public class DomainObjectDisplayUtils {
    private static final String VERSION_SEP = "@";
    private static final String CHANGE_INDICATOR = "*";
    private static final String READ_ONLY = " [Read-Only]";
    private static final String PROJECT_SEP_ELLIPSES = ":" + FileSystem.SEPARATOR + "..." + FileSystem.SEPARATOR;

    private DomainObjectDisplayUtils() {
    }

    public static String getShortPath(DomainFile df) {
        Object pathString = df.toString();
        int length = ((String)pathString).length();
        if (length < 100) {
            return pathString;
        }
        String[] pathParts = ((String)pathString).split(FileSystem.SEPARATOR);
        if (pathParts.length == 2) {
            return pathString;
        }
        String projectName = df.getProjectLocator().getName();
        int parentFolderIndex = pathParts.length - 2;
        String parentName = pathParts[parentFolderIndex];
        String filename = df.getName();
        pathString = projectName + PROJECT_SEP_ELLIPSES + parentName + FileSystem.SEPARATOR + filename;
        return pathString;
    }

    public static String getToolTip(DomainObject object) {
        DomainFile df = object.getDomainFile();
        String changeIndicator = object.isChanged() ? CHANGE_INDICATOR : "";
        String pathString = DomainObjectDisplayUtils.getShortPath(df);
        if (!df.isInWritableProject()) {
            return pathString + READ_ONLY + changeIndicator;
        }
        return pathString + changeIndicator;
    }

    public static String getTabText(DomainFile df) {
        Object tabName = df.getName();
        if (df.isReadOnly()) {
            int version = df.getVersion();
            if (!df.canSave() && version != -1) {
                tabName = (String)tabName + VERSION_SEP + version;
            }
            tabName = (String)tabName + READ_ONLY;
        }
        return tabName;
    }

    public static String getTabText(DomainObject object) {
        if (object.isChanged()) {
            return CHANGE_INDICATOR + DomainObjectDisplayUtils.getTabText(object.getDomainFile());
        }
        return DomainObjectDisplayUtils.getTabText(object.getDomainFile());
    }
}

