/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.mgr;

import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.MergeableBackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectException;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.mgr.BackgroundCommandTask;
import ghidra.framework.plugintool.mgr.ToolTaskMonitor;
import ghidra.util.DateUtils;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.PriorityQueue;
import ghidra.util.exception.RollbackException;
import ghidra.util.task.TaskDialog;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.rmi.ConnectException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import javax.swing.JComponent;

public class ToolTaskManager
implements Runnable {
    private static final String TIME_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private volatile PluginTool tool;
    private volatile boolean isExecuting;
    private LinkedList<BackgroundCommandTask<?>> tasks = new LinkedList();
    private Map<DomainObject, PriorityQueue<BackgroundCommand<?>>> queuedCommandsMap = new HashMap();
    private long startQueueTime = 0L;
    private long startTaskTime = 0L;
    private Thread taskThread;
    private ThreadGroup taskThreadGroup;
    private ToolTaskMonitor toolTaskMonitor;
    private BackgroundCommandTask<?> currentTask;
    private TaskDialog modalTaskDialog;

    public ToolTaskManager(PluginTool tool) {
        this.tool = tool;
        this.toolTaskMonitor = new ToolTaskMonitor(tool);
        this.toolTaskMonitor.setName("Progress Monitor");
        this.taskThreadGroup = new ThreadGroup(Thread.currentThread().getThreadGroup(), "Background-Task-Group-" + tool.getName());
    }

    public ThreadGroup getTaskThreadGroup() {
        return this.taskThreadGroup;
    }

    public JComponent getMonitorComponent() {
        return this.toolTaskMonitor;
    }

    public synchronized boolean isBusy() {
        return this.isExecuting || this.taskThread != null && this.taskThread.isAlive();
    }

    public <T extends DomainObject> boolean execute(String commandName, T domainObject, Function<T, Boolean> f) {
        return this.execute(new SimpleCommand<T>(commandName, f), domainObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends DomainObject> boolean execute(Command<T> cmd, T obj) {
        if (this.tool == null) {
            return false;
        }
        this.tool.clearStatusInfo();
        boolean success = false;
        this.isExecuting = true;
        try {
            success = this.applyCommand(cmd, obj);
        }
        finally {
            this.isExecuting = false;
        }
        if (!success) {
            String statusMessage = cmd.getName() + " failed";
            String cmdMessage = cmd.getStatusMsg();
            if (cmdMessage != null) {
                statusMessage = statusMessage + ": " + cmdMessage;
            }
            this.tool.setStatusInfo(statusMessage);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private <T extends DomainObject> boolean applyCommand(Command<T> cmd, T domainObject) {
        boolean success;
        block9: {
            success = false;
            boolean error = false;
            String cmdName = cmd.getName();
            int txId = domainObject.startTransaction(cmdName);
            try {
                success = cmd.applyTo(domainObject);
                this.executeCommand(new EmptyBackgroundCommand(cmdName), domainObject);
            }
            catch (Throwable t) {
                block8: {
                    error = true;
                    this.clearQueuedCommands(domainObject);
                    if (t instanceof DomainObjectException) {
                        t = t.getCause();
                    }
                    if (t instanceof ConnectException) {
                        boolean bl = false;
                        domainObject.endTransaction(txId, !error);
                        return bl;
                    }
                    if (!(t instanceof RollbackException)) break block8;
                    boolean bl = false;
                    domainObject.endTransaction(txId, !error);
                    return bl;
                }
                Msg.showError((Object)this, null, (String)"Command Failure", (Object)("An unexpected error occurred running command: " + cmd.getName()), (Throwable)t);
            }
            domainObject.endTransaction(txId, !error);
            break block9;
            {
                catch (Throwable throwable) {
                    domainObject.endTransaction(txId, !error);
                    throw throwable;
                }
            }
        }
        return success;
    }

    public synchronized <T extends DomainObject> void executeCommand(BackgroundCommand<T> cmd, T obj) {
        if (this.tool == null) {
            return;
        }
        BackgroundCommandTask<T> task = new BackgroundCommandTask<T>(this, obj, cmd);
        this.tasks.addLast(task);
        if (this.taskThread != null && this.taskThread.isAlive()) {
            return;
        }
        this.taskThread = new Thread(this.taskThreadGroup, this, "Background-Task-" + this.tool.getName());
        this.taskThread.setPriority(2);
        this.taskThread.start();
        try {
            this.wait(1000L);
        }
        catch (InterruptedException e) {
            Msg.error((Object)this, (Object)"Interrupted waiting for the Background Command to start a transaction");
        }
    }

    public synchronized <T extends DomainObject> void scheduleFollowOnCommand(BackgroundCommand<T> cmd, T obj) {
        if (this.isProcessingDomainObject(obj)) {
            PriorityQueue queue = this.queuedCommandsMap.get(obj);
            if (queue == null) {
                queue = new PriorityQueue();
                this.queuedCommandsMap.put(obj, queue);
            }
            if (!this.mergeMergeableBackgroundCommands(cmd, queue)) {
                queue.add(cmd, 1);
            }
        } else {
            this.executeCommand(cmd, obj);
        }
    }

    private boolean isProcessingDomainObject(DomainObject obj) {
        if (this.taskThread == null) {
            return false;
        }
        if (this.hasQueuedTasksForDomainObject(obj)) {
            return true;
        }
        return this.currentTask != null && !this.currentTask.isDoneQueueProcessing();
    }

    private <T extends DomainObject> boolean mergeMergeableBackgroundCommands(BackgroundCommand<T> newCommand, PriorityQueue<BackgroundCommand<?>> queue) {
        BackgroundCommand lastCommand = (BackgroundCommand)queue.getLast();
        if (!(lastCommand instanceof MergeableBackgroundCommand) || !(newCommand instanceof MergeableBackgroundCommand)) {
            return false;
        }
        MergeableBackgroundCommand mergeableBackgroundCommand = (MergeableBackgroundCommand)lastCommand;
        MergeableBackgroundCommand newMergeableBackgroundCommand = (MergeableBackgroundCommand)newCommand;
        mergeableBackgroundCommand.mergeCommands(newMergeableBackgroundCommand);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(TaskMonitor monitor) {
        ToolTaskManager toolTaskManager = this;
        synchronized (toolTaskManager) {
            if (this.isBusy()) {
                this.toolTaskMonitor.cancel();
            }
            if (this.currentTask != null) {
                this.clearQueuedCommands((DomainObject)this.currentTask.getDomainObject());
            }
        }
        while (this.taskThread != null && !monitor.isCancelled()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private String time() {
        if (!SystemUtilities.isInDevelopmentMode()) {
            return "";
        }
        LocalDateTime localDate = DateUtils.toLocalDate((Date)new Date());
        return TIME_FORMATTER.format(localDate) + " ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Msg.debug((Object)this, (Object)(this.time() + "Background processing started..."));
            this.startQueueTime = System.currentTimeMillis();
            BackgroundCommandTask<?> task = this.getNextTask();
            while (task != null) {
                Msg.debug((Object)this, (Object)(this.time() + "Task Start: " + task.getTaskTitle()));
                this.startTaskTime = System.currentTimeMillis();
                ToolTaskManager toolTaskManager = this;
                synchronized (toolTaskManager) {
                    this.currentTask = task;
                }
                if (task.isModal()) {
                    this.modalTaskDialog = new TaskDialog(task);
                    this.modalTaskDialog.show(0);
                    task.run((TaskMonitor)this.modalTaskDialog);
                } else {
                    this.toolTaskMonitor.initialize(task);
                    task.run((TaskMonitor)this.toolTaskMonitor);
                }
                task = this.getNextTask();
            }
            double totalTime = (double)(System.currentTimeMillis() - this.startQueueTime) / 1000.0;
            Msg.debug((Object)this, (Object)(this.time() + "Background processing complete (" + totalTime + " secs)"));
        }
        finally {
            ToolTaskManager toolTaskManager = this;
            synchronized (toolTaskManager) {
                this.currentTask = null;
            }
        }
    }

    private synchronized BackgroundCommandTask<?> getNextTask() {
        if (this.tasks.isEmpty()) {
            this.taskThread = null;
            return null;
        }
        return this.tasks.removeFirst();
    }

    private synchronized <T extends DomainObject> BackgroundCommand<T> getNextCommand(T obj) {
        PriorityQueue<BackgroundCommand<?>> queue = this.queuedCommandsMap.get(obj);
        if (queue == null) {
            return null;
        }
        BackgroundCommand cmd = (BackgroundCommand)queue.removeFirst();
        if (queue.isEmpty()) {
            this.queuedCommandsMap.remove(obj);
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends DomainObject> void taskCompleted(T obj, BackgroundCommandTask<T> task, TaskMonitor monitor) {
        obj.flushEvents();
        try {
            while (!monitor.isCancelled()) {
                BackgroundCommand<T> cmd;
                ToolTaskManager toolTaskManager = this;
                synchronized (toolTaskManager) {
                    cmd = this.getNextCommand(obj);
                    if (cmd == null) {
                        task.setDoneQueueProcessing();
                        break;
                    }
                }
                Msg.debug((Object)this, (Object)(this.time() + "Start: " + cmd.getName()));
                this.toolTaskMonitor.updateTaskCmd(cmd);
                long localStart = System.currentTimeMillis();
                cmd.applyTo(obj, monitor);
                cmd.taskCompleted();
                double totalTime = (double)(System.currentTimeMillis() - localStart) / 1000.0;
                Msg.debug((Object)this, (Object)(this.time() + "Completed: " + cmd.getName() + " (" + totalTime + " secs)"));
                obj.flushEvents();
            }
        }
        finally {
            try {
                if (monitor.isCancelled()) {
                    this.clearQueuedCommands(obj);
                    if (this.tool != null) {
                        this.tool.setStatusInfo(task.getCommand().getName() + " cancelled");
                    }
                }
            }
            finally {
                if (this.currentTask.isModal()) {
                    this.modalTaskDialog.taskProcessed();
                    this.modalTaskDialog = null;
                } else {
                    this.toolTaskMonitor.taskCompleted(this.currentTask);
                }
            }
        }
        task.getCommand().taskCompleted();
        double totalTime = (double)(System.currentTimeMillis() - this.startTaskTime) / 1000.0;
        Msg.debug((Object)this, (Object)(this.time() + "Task Completed: " + task.getTaskTitle() + " (" + totalTime + " secs)"));
    }

    public synchronized void clearQueuedCommands(DomainObject obj) {
        PriorityQueue<BackgroundCommand<?>> queue = this.queuedCommandsMap.get(obj);
        if (queue == null) {
            return;
        }
        while (!queue.isEmpty()) {
            BackgroundCommand cmd = (BackgroundCommand)queue.removeFirst();
            cmd.dispose();
        }
        this.queuedCommandsMap.remove(obj);
    }

    public synchronized void clearTasks(DomainObject obj) {
        Iterator iter = this.tasks.iterator();
        while (iter.hasNext()) {
            BackgroundCommandTask task = (BackgroundCommandTask)iter.next();
            if (task.getDomainObject() != obj) continue;
            iter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends DomainObject> void taskFailed(T obj, BackgroundCommand<T> taskCmd, TaskMonitor monitor) {
        try {
            obj.flushEvents();
            this.clearQueuedCommands(obj);
            if (this.tool != null) {
                if (!monitor.isCancelled()) {
                    monitor.cancel();
                    String msg = taskCmd.getStatusMsg();
                    if (msg == null || msg.length() == 0) {
                        msg = "Unspecified error occurred.";
                    }
                    Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)(taskCmd.getName() + " Failed"), (Object)msg);
                } else {
                    this.tool.setStatusInfo(taskCmd.getName() + " cancelled");
                }
            }
        }
        finally {
            if (this.currentTask.isModal()) {
                this.modalTaskDialog.taskProcessed();
                this.modalTaskDialog = null;
            } else {
                this.toolTaskMonitor.taskCompleted(this.currentTask);
            }
        }
    }

    public synchronized void dispose() {
        this.clearTasks();
        ArrayList<DomainObject> list = new ArrayList<DomainObject>(this.queuedCommandsMap.keySet());
        for (DomainObject obj : list) {
            this.clearQueuedCommands(obj);
        }
        this.queuedCommandsMap = new HashMap();
        this.toolTaskMonitor.dispose();
        if (this.modalTaskDialog != null) {
            this.modalTaskDialog.dispose();
        }
        this.tool = null;
    }

    public synchronized void clearTasks() {
        this.tasks.clear();
    }

    public void cancelCurrentTask() {
        this.toolTaskMonitor.cancel();
    }

    public synchronized boolean hasTasksForDomainObject(DomainObject domainObject) {
        if (!this.isBusy()) {
            return false;
        }
        if (this.currentTask != null && this.currentTask.getDomainObject() == domainObject) {
            return true;
        }
        return this.hasQueuedTasksForDomainObject(domainObject);
    }

    private synchronized boolean hasQueuedTasksForDomainObject(DomainObject domainObject) {
        for (BackgroundCommandTask backgroundCommandTask : this.tasks) {
            if (backgroundCommandTask.getDomainObject() != domainObject) continue;
            return true;
        }
        return false;
    }

    private static class SimpleCommand<T extends DomainObject>
    implements Command<T> {
        private String commandName;
        private Function<T, Boolean> f;

        SimpleCommand(String commandName, Function<T, Boolean> f) {
            this.commandName = commandName;
            this.f = f;
        }

        @Override
        public boolean applyTo(T domainObject) {
            return this.f.apply(domainObject);
        }

        @Override
        public String getStatusMsg() {
            return null;
        }

        @Override
        public String getName() {
            return this.commandName;
        }
    }

    private static class EmptyBackgroundCommand<T extends DomainObject>
    extends BackgroundCommand<T> {
        public EmptyBackgroundCommand(String name) {
            super(name, false, true, false);
        }

        @Override
        public boolean applyTo(T obj, TaskMonitor monitor) {
            return true;
        }
    }
}

