/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project.extensions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.project.extensions.ExtensionDetailsPanel;
import ghidra.framework.project.extensions.ExtensionInstaller;
import ghidra.framework.project.extensions.ExtensionTablePanel;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.extensions.ExtensionUtils;
import ghidra.util.filechooser.GhidraFileChooserModel;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import resources.Icons;

public class ExtensionTableProvider
extends DialogComponentProvider {
    private static final String LAST_IMPORT_DIRECTORY_KEY = "LastExtensionImportDirectory";
    private ExtensionTablePanel extensionTablePanel;
    private boolean requireRestart = false;

    public ExtensionTableProvider(PluginTool tool) {
        super("Install Extensions");
        this.addWorkPanel(this.createMainPanel(tool));
        this.setHelpLocation(new HelpLocation("FrontEndPlugin", "Extensions"));
    }

    private JComponent createMainPanel(PluginTool tool) {
        JPanel panel = new JPanel(new BorderLayout());
        this.extensionTablePanel = new ExtensionTablePanel(tool);
        ExtensionDetailsPanel extensionDetailsPanel = new ExtensionDetailsPanel(this.extensionTablePanel);
        JSplitPane splitPane = new JSplitPane(0, this.extensionTablePanel, extensionDetailsPanel);
        splitPane.setResizeWeight(0.75);
        panel.add((Component)splitPane, "Center");
        splitPane.setDividerLocation(0.75);
        this.createAddAction(this.extensionTablePanel);
        this.createRefreshAction(this.extensionTablePanel, extensionDetailsPanel);
        this.addOKButton();
        return panel;
    }

    protected void okCallback() {
        this.close();
    }

    public void close() {
        super.close();
        this.extensionTablePanel.dispose();
    }

    protected void dialogClosed() {
        super.dialogClosed();
        if (this.extensionTablePanel.getTableModel().hasModelChanged() || this.requireRestart) {
            Msg.showInfo((Object)((Object)this), null, (String)"Extensions Changed!", (Object)"Please restart Ghidra for extension changes to take effect.");
        }
    }

    private void createAddAction(final ExtensionTablePanel panel) {
        Icon addIcon = Icons.ADD_ICON;
        DockingAction addAction = new DockingAction("ExtensionTools", "AddExtension"){

            public void actionPerformed(ActionContext context) {
                ResourceFile installDir = (ResourceFile)Application.getApplicationLayout().getExtensionInstallationDirs().get(0);
                if (!installDir.exists() && !installDir.mkdir()) {
                    Msg.showError((Object)((Object)this), null, (String)"Directory Error", (Object)("Cannot install/uninstall extensions: Failed to create extension installation directory: " + String.valueOf(installDir)));
                }
                if (!installDir.canWrite()) {
                    Msg.showError((Object)((Object)this), null, (String)"Permissions Error", (Object)("Cannot install/uninstall extensions: Invalid write permissions on installation directory: " + String.valueOf(installDir)));
                    return;
                }
                GhidraFileChooser chooser = new GhidraFileChooser((Component)ExtensionTableProvider.this.getComponent());
                chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_AND_DIRECTORIES);
                chooser.setLastDirectoryPreference(ExtensionTableProvider.LAST_IMPORT_DIRECTORY_KEY);
                chooser.setTitle("Select Extension");
                chooser.addFileFilter((GhidraFileFilter)new ExtensionFileFilter(ExtensionTableProvider.this));
                List files = chooser.getSelectedFiles();
                chooser.dispose();
                if (ExtensionTableProvider.this.installExtensions(files)) {
                    panel.refreshTable();
                    ExtensionTableProvider.this.requireRestart = true;
                }
            }
        };
        String group = "extensionTools";
        addAction.setMenuBarData(new MenuData(new String[]{"Add Extension"}, addIcon, group));
        addAction.setToolBarData(new ToolBarData(addIcon, group));
        addAction.setHelpLocation(new HelpLocation("FrontEndPlugin", "ExtensionTools"));
        addAction.setDescription("Add extension");
        addAction.setEnabled(!Application.inSingleJarMode());
        this.addAction((DockingActionIf)addAction);
    }

    private boolean installExtensions(List<File> files) {
        boolean didInstall = false;
        for (File file : files) {
            if (new File(file, "build.gradle").isFile()) {
                Msg.showWarn((Object)((Object)this), null, (String)"Invalid Extension", (Object)"The selected extension contains a 'build.gradle' file.\nGhidra does not support installing extensions in source form.\nPlease build the extension and try again.");
                continue;
            }
            boolean success = ExtensionInstaller.install(file);
            didInstall |= success;
        }
        return didInstall;
    }

    private void createRefreshAction(final ExtensionTablePanel tablePanel, ExtensionDetailsPanel detailsPanel) {
        Icon refreshIcon = Icons.REFRESH_ICON;
        DockingAction refreshAction = new DockingAction(this, "ExtensionTools", "RefreshExtensions"){

            public void actionPerformed(ActionContext context) {
                tablePanel.refreshTable();
            }
        };
        String group = "extensionTools";
        refreshAction.setMenuBarData(new MenuData(new String[]{"Refresh"}, refreshIcon, group));
        refreshAction.setToolBarData(new ToolBarData(refreshIcon, group));
        refreshAction.setHelpLocation(new HelpLocation("FrontEndPlugin", "ExtensionTools"));
        refreshAction.setDescription("Refresh extension list");
        this.addAction((DockingActionIf)refreshAction);
    }

    private class ExtensionFileFilter
    implements GhidraFileFilter {
        private ExtensionFileFilter(ExtensionTableProvider extensionTableProvider) {
        }

        public String getDescription() {
            return "Ghidra Extension";
        }

        public boolean accept(File f, GhidraFileChooserModel model) {
            return f.isDirectory() || ExtensionUtils.isExtension((File)f);
        }
    }
}

