/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import docking.widgets.OptionDialog;
import ghidra.framework.model.DomainFile;
import ghidra.util.Msg;
import ghidra.util.exception.VersionException;
import java.awt.Component;

public class VersionExceptionHandler {
    public static boolean isUpgradeOK(Component parent, DomainFile domainFile, String actionName, VersionException ve) {
        String contentType = domainFile.getContentType();
        if (domainFile.isReadOnly() || ve.getVersionIndicator() != 1 || !ve.isUpgradable()) {
            VersionExceptionHandler.showVersionError(parent, domainFile.getName(), contentType, actionName, ve);
            return false;
        }
        String filename = domainFile.getName();
        if (domainFile.isVersioned() && !domainFile.isCheckedOutExclusive()) {
            VersionExceptionHandler.showNeedExclusiveCheckoutDialog(parent, filename, contentType, actionName);
            return false;
        }
        int userChoice = VersionExceptionHandler.showUpgradeDialog(parent, ve, filename, contentType, actionName);
        if (userChoice != 1) {
            return false;
        }
        return !domainFile.isCheckedOut() || (userChoice = VersionExceptionHandler.showWarningDialog(parent, filename, contentType, actionName)) == 1;
    }

    private static void showNeedExclusiveCheckoutDialog(Component parent, String filename, String contentType, String actionName) {
        Msg.showError(VersionExceptionHandler.class, (Component)parent, (String)(actionName + " Failed!"), (Object)("Unable to " + actionName + " " + contentType + ": " + filename + "\n \nAn upgrade of the " + contentType + " data is required, however, you must have an exclusive checkout\nto upgrade a shared file!\n \nNOTE: If you are unable to obtain an exclusive checkout, you may be able to " + actionName + "\nthe file with an older version of Ghidra."));
    }

    private static int showUpgradeDialog(Component parent, VersionException ve, String filename, String contentType, String actionName) {
        String detailMessage = ve.getDetailMessage() == null ? "" : "\n" + ve.getDetailMessage();
        String title = "Upgrade " + contentType + " Data? " + filename;
        String message = "The " + contentType + " file you are attempting to " + actionName + " is an older version." + detailMessage + "\n \nWould you like to Upgrade it now?";
        return OptionDialog.showOptionDialog((Component)parent, (String)title, (String)message, (String)"Upgrade", (int)3);
    }

    private static int showWarningDialog(Component parent, String filename, String contentType, String actionName) {
        String title = "Upgrade Shared " + contentType + " Data? " + filename;
        String message = "This " + contentType + " file is shared with other users.  If you upgrade this file,\nother users will not be able to read the new version until they upgrade to \na compatible version of Ghidra. Do you want to continue?";
        return OptionDialog.showOptionDialog((Component)parent, (String)title, (String)message, (String)"Upgrade", (int)2);
    }

    public static void showVersionError(Component parent, String filename, String contentType, String actionName, VersionException ve) {
        int versionIndicator = ve.getVersionIndicator();
        String versionType = versionIndicator == 2 ? " newer" : (versionIndicator == 1 ? "n older" : "n unknown");
        String upgradeMsg = "";
        if (ve.isUpgradable()) {
            upgradeMsg = " (data upgrade is possible)";
        }
        Msg.showError(VersionExceptionHandler.class, (Component)parent, (String)(actionName + " Failed!"), (Object)("Unable to " + actionName + " " + contentType + ": " + filename + "\n \nFile was created with a" + versionType + " version of Ghidra" + upgradeMsg));
    }
}

