/*
 * Decompiled with CFR 0.152.
 */
package generic.test;

import ghidra.framework.TestApplicationUtils;
import ghidra.util.SystemUtilities;
import ghidra.util.UniversalIdGenerator;
import ghidra.util.exception.AssertException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TestName;
import utility.application.ApplicationUtilities;

public abstract class AbstractGTest {
    public static final boolean BATCH_MODE;
    protected static final boolean PARALLEL_MODE;
    public static final int DEFAULT_WAIT_DELAY;
    public static final int DEFAULT_WAIT_TIMEOUT;
    public static final int DEFAULT_WINDOW_TIMEOUT;
    protected static final int PRIVATE_LONG_WAIT_TIMEOUT;
    private static String testDirectoryPath;
    @Rule
    public TestName testName = new TestName();

    private static String createTestDirectoryPath() {
        File testDir;
        if (testDirectoryPath == null) {
            testDirectoryPath = BATCH_MODE ? AbstractGTest.buildBatchDirectoryPath() : AbstractGTest.buildDevelopmentDirectoryPath();
        }
        if (!(testDir = new File(testDirectoryPath)).exists()) {
            if (!testDir.mkdirs()) {
                throw new AssertException("Failed to create temp directory: " + String.valueOf(testDir));
            }
            System.out.println("Created test directory: " + String.valueOf(testDir));
        }
        return testDirectoryPath;
    }

    private static String buildBatchDirectoryPath() {
        try {
            return new File(ApplicationUtilities.getDefaultUserTempDir((String)"ghidra"), "test_" + String.valueOf(UUID.randomUUID()) + File.separator + "temp.data").getPath();
        }
        catch (IOException e) {
            throw new AssertException((Throwable)e);
        }
    }

    private static String buildDevelopmentDirectoryPath() {
        File tempDir = TestApplicationUtils.getUniqueTempDir();
        return tempDir.getPath();
    }

    public static String getTestDirectoryPath() {
        return testDirectoryPath;
    }

    public static int getRandomInt() {
        return AbstractGTest.getRandomInt(0, Integer.MAX_VALUE);
    }

    public static int getRandomInt(int min, int max) {
        int distributionLength = max - min + 1;
        double randomValueInRange = Math.random() * (double)distributionLength;
        int randomInt = (int)randomValueInRange;
        int valueInRangeWithOffset = min + randomInt;
        return Math.min(valueInRangeWithOffset, max);
    }

    public static String getRandomString() {
        return "STR_" + AbstractGTest.getRandomString(0, 20);
    }

    public static String getRandomString(int min, int max) {
        int stringLength = AbstractGTest.getRandomInt(min, max);
        StringBuilder buffy = new StringBuilder();
        for (int i = 0; i < stringLength; ++i) {
            buffy.append((char)AbstractGTest.getRandomInt(65, 127));
        }
        return buffy.toString();
    }

    public static void assertArraysEqualOrdered(String message, Object[] expected, Object[] actual) {
        if (expected == null) {
            Assert.assertNull((Object)actual);
            return;
        }
        AbstractGTest.assertListEqualOrdered(message, Arrays.asList(expected), Arrays.asList(actual));
    }

    public static void assertArraysEqualUnordered(String message, Object[] expected, Object[] actual) {
        if (expected == null) {
            Assert.assertNull((Object)actual);
            return;
        }
        AbstractGTest.assertListEqualUnordered(null, Arrays.asList(expected), Arrays.asList(actual));
    }

    public static void assertListEqualOrdered(List<?> expected, List<?> actual) {
        AbstractGTest.assertListEqualOrdered(null, expected, actual);
    }

    public static void assertListEqualOrdered(String message, List<?> expected, List<?> actual) {
        if (expected == null) {
            Assert.assertNull(actual);
            return;
        }
        Assert.assertEquals((String)AbstractGTest.printListFailureMessage(message, expected, actual), (long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            if (actual.get(i).equals(expected.get(i))) continue;
            Assert.fail((String)AbstractGTest.printListFailureMessage(message, expected, actual));
        }
    }

    public static void assertListEqualUnordered(String message, List<?> expected, List<?> actual) {
        if (expected == null) {
            Assert.assertNull(actual);
            return;
        }
        ArrayList expectedCopy = new ArrayList(expected);
        ArrayList actualCopy = new ArrayList(actual);
        actualCopy.removeAll(expected);
        expectedCopy.removeAll(actual);
        if (actualCopy.isEmpty() && expectedCopy.isEmpty()) {
            return;
        }
        if (message == null) {
            message = "\tExpected collections to be the same; one or both collections had extra items - difference:\n\n\n\t'Expected' unique values: " + String.valueOf(expectedCopy) + ";\n\t'Actual' unique values:      " + String.valueOf(actualCopy) + "\n\n";
        }
        Assert.fail((String)message);
    }

    @SafeVarargs
    public static <T> void assertListEqualsArrayOrdered(List<T> actual, T ... expected) {
        AbstractGTest.assertListEqualOrdered(null, Arrays.asList(expected), actual);
    }

    public static void assertListEqualsArrayUnordered(List<?> actual, Object ... expected) {
        AbstractGTest.assertListEqualUnordered(null, Arrays.asList(expected), actual);
    }

    public static void assertArraysEqualUnordered(String[] expected, String[] actual) {
        AbstractGTest.assertArraysEqualUnordered(null, expected, actual);
    }

    @SafeVarargs
    public static <T> void assertContainsExactly(Collection<T> collection, T ... expected) {
        List<T> asList = Arrays.asList(expected);
        HashSet<T> expectedSet = new HashSet<T>(collection);
        HashSet<T> actualSet = new HashSet<T>(asList);
        expectedSet.removeAll(asList);
        actualSet.removeAll(collection);
        if (!actualSet.isEmpty()) {
            Assert.fail((String)("Collection did not contain expected results.\nExpected: " + String.valueOf(asList) + "\nFound: " + String.valueOf(collection)));
        }
        if (!expectedSet.isEmpty()) {
            Assert.fail((String)("collection also contained extra results: " + String.valueOf(expectedSet)));
        }
    }

    public static <T> void assertContainsExactly(Collection<T> expected, Collection<T> actual) {
        HashSet<T> expectedSet = new HashSet<T>(expected);
        HashSet<T> actualSet = new HashSet<T>(actual);
        expectedSet.removeAll(actual);
        actualSet.removeAll(expected);
        if (!actualSet.isEmpty()) {
            Assert.fail((String)("Actual collection had more entries than expected.\nExpected: " + String.valueOf(expected) + "\nFound:      " + String.valueOf(actual)));
        }
        if (!expectedSet.isEmpty()) {
            Assert.fail((String)("Expected collection had these entries not found in the actual collection: " + String.valueOf(expectedSet)));
        }
    }

    public static <T> void assertContainsString(String expected, String actual) {
        Assert.assertTrue((String)("String not contained.  Found: '" + actual + "'\n\tExpected to contain: '" + expected + "'"), (boolean)actual.contains(expected));
    }

    public static <T> void assertContainsStringIgnoringCase(String expected, String actual) {
        Assert.assertTrue((String)("String not contained.  Found: '" + actual + "'\n\tExpected to contain: '" + expected + "'"), (boolean)actual.toLowerCase().contains(expected.toLowerCase()));
    }

    private static String printListFailureMessage(String message, List<?> expected, List<?> actual) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Expected: ").append(expected.toString());
        buffer.append(" Found: ").append(actual.toString());
        buffer.toString();
        if (message == null) {
            return buffer.toString();
        }
        return message + "\n\n" + String.valueOf(buffer);
    }

    public static void failWithException(String message, Throwable e) {
        AssertionError error = new AssertionError((Object)message);
        ((Throwable)((Object)error)).initCause(e);
        throw error;
    }

    public String getName() {
        return this.testName.getMethodName();
    }

    public static byte[] bytes(int ... unsignedBytes) {
        byte[] result = new byte[unsignedBytes.length];
        for (int i = 0; i < unsignedBytes.length; ++i) {
            result[i] = (byte)unsignedBytes[i];
        }
        return result;
    }

    public static long sleep(long timeMs) {
        long start = System.currentTimeMillis();
        try {
            Thread.sleep(timeMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long end = System.currentTimeMillis();
        return end - start;
    }

    public static void waitFor(CountDownLatch latch) {
        try {
            if (!latch.await(DEFAULT_WAIT_TIMEOUT, TimeUnit.MILLISECONDS)) {
                throw new AssertionFailedError("Timed-out waiting for CountDownLatch");
            }
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Interrupted waiting for CountDownLatch");
        }
    }

    public static void waitFor(AtomicBoolean ab) throws AssertionFailedError {
        AbstractGTest.waitForCondition(() -> ab.get());
    }

    public static void waitFor(BooleanSupplier condition) throws AssertionFailedError {
        AbstractGTest.waitForCondition(condition);
    }

    public static void waitForCondition(BooleanSupplier condition) throws AssertionFailedError {
        AbstractGTest.waitForCondition(condition, "Timed-out waiting for condition");
    }

    public static void waitForCondition(BooleanSupplier condition, String failureMessage) throws AssertionFailedError {
        AbstractGTest.waitForCondition(condition, true, failureMessage);
    }

    public static void waitForCondition(BooleanSupplier condition, Supplier<String> failureMessageSupplier) throws AssertionFailedError {
        AbstractGTest.waitForCondition(condition, true, failureMessageSupplier);
    }

    public static void waitForConditionWithoutFailing(BooleanSupplier supplier) {
        AbstractGTest.waitForCondition(supplier, false, () -> null);
    }

    private static void waitForCondition(BooleanSupplier condition, boolean failOnTimeout, String failureMessage) throws AssertionFailedError {
        AbstractGTest.waitForCondition(condition, failOnTimeout, () -> failureMessage);
    }

    private static void waitForCondition(BooleanSupplier condition, boolean failOnTimeout, Supplier<String> failureMessageSupplier) throws AssertionFailedError {
        int totalTime = 0;
        while (totalTime <= DEFAULT_WAIT_TIMEOUT) {
            if (condition.getAsBoolean()) {
                return;
            }
            totalTime = (int)((long)totalTime + AbstractGTest.sleep(DEFAULT_WAIT_DELAY));
        }
        if (!failOnTimeout) {
            return;
        }
        String failureMessage = "Timed-out waiting for condition";
        if (failureMessageSupplier != null) {
            failureMessage = failureMessageSupplier.get();
        }
        throw new AssertionFailedError(failureMessage);
    }

    public static <T> T waitFor(Supplier<T> supplier, String failureMessage) {
        return AbstractGTest.waitForValue(supplier, failureMessage, true);
    }

    public static <T> T waitFor(Supplier<T> supplier) {
        return AbstractGTest.waitForValue(supplier);
    }

    public static <T> T waitForValue(Supplier<T> supplier) {
        return AbstractGTest.waitForValue(supplier, null, true);
    }

    public static <T> T waitForValueWithoutFailing(Supplier<T> supplier) {
        return AbstractGTest.waitForValue(supplier, null, false);
    }

    private static <T> T waitForValue(Supplier<T> supplier, String failureMessage, boolean failOnTimeout) {
        int totalTime = 0;
        while (totalTime <= DEFAULT_WAIT_TIMEOUT) {
            T t = supplier.get();
            if (t != null) {
                return t;
            }
            totalTime = (int)((long)totalTime + AbstractGTest.sleep(DEFAULT_WAIT_DELAY));
        }
        if (!failOnTimeout) {
            return null;
        }
        String error = failureMessage != null ? failureMessage : "Timed-out waiting for non-null value";
        throw new AssertionFailedError(error);
    }

    static {
        UniversalIdGenerator.initialize();
        BATCH_MODE = SystemUtilities.isInTestingBatchMode();
        PARALLEL_MODE = Boolean.parseBoolean(System.getProperty("ghidra.test.property.parallel.mode", Boolean.FALSE.toString()));
        DEFAULT_WAIT_DELAY = 10 * (PARALLEL_MODE ? 20 : 1);
        DEFAULT_WINDOW_TIMEOUT = DEFAULT_WAIT_TIMEOUT = 2000 * (PARALLEL_MODE ? 10 : 1);
        PRIVATE_LONG_WAIT_TIMEOUT = DEFAULT_WAIT_TIMEOUT * 5;
        testDirectoryPath = AbstractGTest.createTestDirectoryPath();
    }
}

