/*
 * Decompiled with CFR 0.152.
 */
package generic.test;

import generic.jar.ResourceFile;
import generic.test.AbstractGTest;
import generic.test.ConcurrentTestExceptionHandler;
import generic.test.ConcurrentTestExceptionStatement;
import generic.test.TestUtils;
import generic.test.rule.RepeatedTestRule;
import generic.util.WindowUtilities;
import ghidra.GhidraTestApplicationLayout;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.LoggingInitialization;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.TypeVariable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import utilities.util.FileUtilities;
import utilities.util.reflection.ReflectionUtilities;
import utility.application.ApplicationLayout;

public abstract class AbstractGenericTest
extends AbstractGTest {
    private static final String GHIDRA_TEST_PROPERTY_REPORT_DIR = "ghidra.test.property.report.dir";
    private static File debugDirectory;
    public static final String TESTDATA_DIRECTORY_NAME = "testdata";
    public static final String DEFAULT_TOOL_NAME = "CodeBrowser";
    public static final String DEFAULT_TEST_TOOL_NAME = "TestCodeBrowser";
    private static boolean initialized;
    private static boolean printedApplicationConflictWaring;
    private static ApplicationLayout loadedApplicationLayout;
    private static ApplicationConfiguration loadedApplicationConfiguration;
    private volatile boolean hasFailed;
    private boolean logSettingsChanged;
    public TestWatcher watchman = new TestWatcher(){

        protected void starting(Description description) {
            AbstractGenericTest.this.hasFailed = false;
            AbstractGenericTest.this.debugBatch(String.valueOf(new Date()) + "\n***** STARTING Test: " + AbstractGenericTest.this.getClass().getSimpleName() + " - " + AbstractGenericTest.this.testName.getMethodName() + " *****");
        }

        protected void failed(Throwable e, Description description) {
            AbstractGenericTest.this.hasFailed = true;
            AbstractGenericTest.this.testFailed(e);
            AbstractGenericTest.this.debugBatch("\t\u2716 FAILED Test: " + AbstractGenericTest.this.getClass().getSimpleName() + " - " + AbstractGenericTest.this.testName.getMethodName() + " \u2716\t");
        }

        protected void succeeded(Description description) {
            AbstractGenericTest.this.debugBatch("\t\u2713 PASSED Test: " + AbstractGenericTest.this.getClass().getSimpleName() + " - " + AbstractGenericTest.this.testName.getMethodName() + " \u2713\t");
        }
    };
    @Rule
    public TestRule concurrentTestExceptionRule = (base, description) -> new ConcurrentTestExceptionStatement(base);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testName).around((TestRule)this.watchman);
    @Rule
    public TestRule repeatedRule = new RepeatedTestRule();

    @After
    public void resetLogging() {
        if (this.logSettingsChanged) {
            LoggingInitialization.reinitialize();
        }
    }

    private void debugBatch(String message) {
        if (BATCH_MODE) {
            Msg.debug(AbstractGenericTest.class, (Object)message);
        }
    }

    private synchronized void initialize(AbstractGenericTest test) {
        ApplicationLayout layout;
        this.initializeSystemProperties();
        try {
            layout = test.createApplicationLayout();
        }
        catch (Exception e) {
            throw new AssertException((Throwable)e);
        }
        this.initializeLayout(layout);
        ApplicationConfiguration configuration = test.createApplicationConfiguration();
        if (initialized) {
            this.printWarningIfConflictingInitializationConfigs(layout, configuration);
            return;
        }
        if (configuration == null) {
            return;
        }
        initialized = true;
        loadedApplicationLayout = layout;
        loadedApplicationConfiguration = configuration;
        try {
            Application.initializeApplication(layout, configuration);
        }
        catch (Exception e) {
            throw new AssertException((Throwable)e);
        }
    }

    protected void initializeSystemProperties() {
        System.setProperty("SystemUtilities.isTesting", "true");
    }

    protected void initializeLayout(ApplicationLayout layout) {
        File testDir = new File(AbstractGenericTest.getTestDirectoryPath());
        AbstractGenericTest.setInstanceField("userCacheDir", layout, testDir);
    }

    private void printWarningIfConflictingInitializationConfigs(ApplicationLayout layout, ApplicationConfiguration configuration) {
        if (loadedApplicationLayout.getClass().equals(layout.getClass()) && loadedApplicationConfiguration.getClass().equals(configuration.getClass())) {
            return;
        }
        if (printedApplicationConflictWaring) {
            return;
        }
        printedApplicationConflictWaring = true;
        Msg.error((Object)this, (Object)("\n\n\n\n\t\t\tWARNING!!\n\nAttempted to run multiple tests with different configurations.\nThis prevents the proper initialization of tests\nLoaded configurations, in order: " + loadedApplicationConfiguration.getClass().getSimpleName() + " and " + configuration.getClass().getSimpleName() + "\n"), (Throwable)ReflectionUtilities.createJavaFilteredThrowable());
    }

    public AbstractGenericTest() {
        this.initialize(this);
    }

    protected ApplicationLayout createApplicationLayout() throws IOException {
        return new GhidraTestApplicationLayout(new File(AbstractGenericTest.getTestDirectoryPath()));
    }

    protected ApplicationConfiguration createApplicationConfiguration() {
        ApplicationConfiguration configuration = new ApplicationConfiguration();
        return configuration;
    }

    protected boolean hasTestFailed() {
        return this.hasFailed;
    }

    protected void testFailed(Throwable e) {
    }

    protected void setLogLevel(Class<?> loggerClazz, Level newLevel) {
        this.setLogLevel(loggerClazz.getName(), newLevel);
    }

    protected void setLogLevel(String loggerName, Level newLevel) {
        this.logSettingsChanged = true;
        Configurator.setLevel((String)loggerName, (Level)newLevel);
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = loggerContext.getConfiguration();
        LoggerConfig rootLoggerConfiguration = (LoggerConfig)configuration.getLoggers().get("");
        AppenderRef consoleAppender = this.getConsoleAppender(configuration, rootLoggerConfiguration);
        Level currentLevel = consoleAppender.getLevel();
        if (currentLevel.compareTo(newLevel) > 0) {
            return;
        }
        String consoleAppenderName = "console";
        rootLoggerConfiguration.removeAppender(consoleAppenderName);
        Appender appender = configuration.getAppender(consoleAppenderName);
        rootLoggerConfiguration.addAppender(appender, newLevel, null);
        loggerContext.updateLoggers();
    }

    private AppenderRef getConsoleAppender(Configuration configuration, LoggerConfig rootLoggerConfigiguration) {
        String consoleAppenderName = "console";
        List appenders = rootLoggerConfigiguration.getAppenderRefs();
        for (AppenderRef ref : appenders) {
            String refName = ref.getRef();
            if (!refName.equals(consoleAppenderName)) continue;
            return ref;
        }
        Assert.fail((String)"Unable to find the logging console appender");
        return null;
    }

    public static Window windowForComponent(Component c) {
        return WindowUtilities.windowForComponent(c);
    }

    public static List<String> loadTextResource(Class<?> cls, String name) throws IOException {
        InputStream is = cls.getResourceAsStream(name);
        if (is == null) {
            throw new IOException("Could not find resource: " + name);
        }
        Msg.debug(AbstractGenericTest.class, (Object)("Loading classpath resource: " + name));
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        List<String> text = AbstractGenericTest.readText(br);
        br.close();
        return text;
    }

    private static List<String> readText(BufferedReader br) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        String line = "";
        while (line != null) {
            line = br.readLine();
            if (line == null) continue;
            list.add(line);
        }
        return list;
    }

    public static List<String> loadTextResource(String name) throws IOException {
        File file = AbstractGenericTest.getTestDataFile(name);
        Msg.debug(AbstractGenericTest.class, (Object)("Loading text file: " + String.valueOf(file)));
        BufferedReader reader = new BufferedReader(new FileReader(file));
        List<String> text = AbstractGenericTest.readText(reader);
        reader.close();
        return text;
    }

    public static File getTestDataFile(String path) throws FileNotFoundException {
        ResourceFile resourceFile = Application.getModuleDataFile("TestResources", path);
        Msg.debug(AbstractGenericTest.class, (Object)("Loading test data file: " + String.valueOf(resourceFile)));
        return resourceFile.getFile(false);
    }

    public static File getTestDataDir(String relativePath) throws FileNotFoundException, IOException {
        ResourceFile resourceFile = Application.getModuleDataSubDirectory("TestResources", relativePath);
        return resourceFile.getFile(false);
    }

    public static File findTestDataFile(String path) {
        try {
            ResourceFile resourceFile = Application.getModuleDataFile("TestResources", path);
            Msg.debug(AbstractGenericTest.class, (Object)("Loading test data file: " + String.valueOf(resourceFile)));
            return resourceFile.getFile(false);
        }
        catch (FileNotFoundException e) {
            Msg.warn(AbstractGenericTest.class, (Object)("Test data file not found: " + path));
            return null;
        }
    }

    public static File getTestDataDirectory() {
        try {
            return Application.getModuleSubDirectory("TestResources", "data").getFile(false);
        }
        catch (IOException e) {
            throw new AssertException("Unable to find test resources directory 'data' directory");
        }
    }

    public static <T> T getInstanceFieldByClassType(Class<T> classType, Object ownerInstance) {
        return TestUtils.getInstanceFieldByClassType(classType, ownerInstance);
    }

    public static void setInstanceField(String fieldName, Object ownerInstance, Object value) throws RuntimeException {
        TestUtils.setInstanceField(fieldName, ownerInstance, value);
    }

    public static Object getInstanceField(String fieldName, Object ownerInstance) throws RuntimeException {
        return TestUtils.getInstanceField(fieldName, ownerInstance);
    }

    public static Object invokeConstructor(Class<?> containingClass, Class<?>[] parameterTypes, Object[] args) throws RuntimeException {
        return TestUtils.invokeConstructor(containingClass, parameterTypes, args);
    }

    public static Object invokeInstanceMethod(String methodName, Object ownerInstance, Class<?>[] parameterTypes, Object[] args) throws RuntimeException {
        return TestUtils.invokeInstanceMethod(methodName, ownerInstance, parameterTypes, args);
    }

    public static Object invokeInstanceMethod(String methodName, Object ownerInstance) throws RuntimeException {
        return AbstractGenericTest.invokeInstanceMethod(methodName, ownerInstance, null, null);
    }

    public static String createStackTraceForAllThreads() {
        return TestUtils.createStackTraceForAllThreads();
    }

    public static String toString(Collection<?> collection) {
        StringBuffer buffer = new StringBuffer();
        TypeVariable<Class<?>>[] typeParameters = collection.getClass().getTypeParameters();
        buffer.append("Collection<");
        for (TypeVariable<Class<?>> typeVariable : typeParameters) {
            buffer.append(typeVariable.getName()).append(", ");
        }
        if (typeParameters.length > 0) {
            int length = buffer.length();
            buffer.delete(length - 2, length);
        }
        buffer.append(">: ");
        for (Object object : collection) {
            buffer.append(object).append(", ");
        }
        return buffer.toString();
    }

    public static FontMetrics getFontMetrics(Font font) {
        BufferedImage image = new BufferedImage(1, 1, 3);
        Graphics g = image.getGraphics();
        FontMetrics fm = g.getFontMetrics(font);
        g.dispose();
        return fm;
    }

    public static void setErrorsExpected(boolean expected) {
        if (expected) {
            Msg.error(AbstractGenericTest.class, (Object)">>>>>>>>>>>>>>>> Expected Errors");
            ConcurrentTestExceptionHandler.disable();
        } else {
            Msg.error(AbstractGenericTest.class, (Object)"<<<<<<<<<<<<<<<< End Expected Errors");
            ConcurrentTestExceptionHandler.enable();
        }
    }

    public static File getDebugFileDirectory() {
        if (debugDirectory != null) {
            return debugDirectory;
        }
        String debugDirName = "debug";
        String dirPath = System.getProperty(GHIDRA_TEST_PROPERTY_REPORT_DIR);
        if (dirPath != null) {
            debugDirectory = new File(dirPath, debugDirName);
        } else {
            ResourceFile moduleDir = Application.getMyModuleRootDirectory();
            ResourceFile binDir = new ResourceFile(moduleDir, "bin");
            debugDirectory = new File(binDir.getFile(false), debugDirName);
        }
        return debugDirectory;
    }

    public static File createTempDirectory(String name) throws IOException {
        String tempTestRootDirname = "generic.test.temp.dir";
        AbstractGenericTest.deleteSimilarTempFiles(tempTestRootDirname);
        String testTempDir = AbstractGenericTest.getTestDirectoryPath();
        Path tempDirPath = Paths.get(testTempDir, new String[0]);
        Path tempRootDirPath = Files.createTempDirectory(tempDirPath, tempTestRootDirname, new FileAttribute[0]);
        File tempRootDir = tempRootDirPath.toFile();
        tempRootDir.deleteOnExit();
        FileUtilities.deleteDir((File)tempRootDir);
        Path userDir = tempRootDirPath.resolve(name);
        Files.createDirectories(userDir, new FileAttribute[0]);
        File file = userDir.toFile();
        file.deleteOnExit();
        return file;
    }

    public String createTempFilePath(String name) throws IOException {
        String path = this.createTempFilePath(name, ".tmp");
        return path;
    }

    public String createTempFilePath(String name, String extension) throws IOException {
        File file = this.createTempFile(name, extension);
        file.delete();
        return file.getAbsolutePath();
    }

    public File createTempFileForTest() throws IOException {
        return this.createTempFile(this.getName());
    }

    public File createTempFileForTest(String suffix) throws IOException {
        return this.createTempFile(this.getName(), suffix);
    }

    public File createTempFile(String name) throws IOException {
        File file = this.createTempFile(name, ".tmp");
        return file;
    }

    public File createTempFile(String name, String suffix) throws IOException {
        String testMethodName = this.testName.getMethodName();
        String prefixName = name != null ? name : "null";
        String suffixName = suffix != null ? suffix : ".tmp";
        AbstractGenericTest.deleteMatchingTempFiles(prefixName + ".*" + suffixName);
        String testTempDir = AbstractGenericTest.getTestDirectoryPath();
        File dir = new File(testTempDir);
        String filename = prefixName + "." + testMethodName + ".";
        File tempFile = File.createTempFile(filename, suffixName, dir);
        tempFile.deleteOnExit();
        return tempFile;
    }

    public static void deleteSimilarTempFiles(String nameText) {
        String literalNamePattern = Pattern.quote(nameText);
        String contains = ".*" + literalNamePattern + ".*";
        AbstractGenericTest.deleteMatchingTempFiles(contains);
    }

    public static void deleteMatchingTempFiles(String namePattern) {
        File[] oldFiles;
        Pattern pattern = Pattern.compile(namePattern);
        String tempPath = AbstractGenericTest.getTestDirectoryPath();
        File testTempDir = new File(tempPath);
        for (File file : oldFiles = testTempDir.listFiles((dir, filename) -> {
            boolean matches = pattern.matcher(filename).matches();
            return matches;
        })) {
            FileUtilities.deleteDir((File)file);
        }
    }

    static {
        initialized = false;
        printedApplicationConflictWaring = false;
    }
}

