/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework;

import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.framework.ApplicationIdentifier;
import ghidra.framework.ApplicationProperties;
import ghidra.framework.preferences.Preferences;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import util.CollectionUtils;
import utility.application.ApplicationLayout;
import utility.application.ApplicationUtilities;

public class GenericRunInfo {
    public static final String TEST_DIRECTORY_SUFFIX = "-Test";
    private static final Logger LOG = LogManager.getLogger(GenericRunInfo.class);

    private static List<File> getUserSettingsDirsByTime() {
        ApplicationLayout layout = Application.getApplicationLayout();
        File userSettingsDirectory = Application.getUserSettingsDirectory();
        List<File> appDirs = GenericRunInfo.collectAllApplicationDirectories(userSettingsDirectory.getParentFile());
        try {
            File legacyUserSettingsDirectory = ApplicationUtilities.getLegacyUserSettingsDir((ApplicationProperties)layout.getApplicationProperties(), (ResourceFile)layout.getApplicationInstallationDir());
            appDirs.addAll(GenericRunInfo.collectAllApplicationDirectories(legacyUserSettingsDirectory.getParentFile()));
        }
        catch (FileNotFoundException legacyUserSettingsDirectory) {
            // empty catch block
        }
        Comparator modifyTimeComparator = (f1, f2) -> {
            long modify2;
            File prefs1 = new File((File)f1, "preferences");
            File prefs2 = new File((File)f2, "preferences");
            if (!prefs1.exists() || !prefs2.exists()) {
                if (!prefs1.exists()) {
                    if (!prefs2.exists()) {
                        return 0;
                    }
                    return 1;
                }
                return -1;
            }
            long modify1 = prefs1.lastModified();
            if (modify1 == (modify2 = prefs2.lastModified())) {
                return f1.getName().compareTo(f2.getName());
            }
            return modify1 < modify2 ? 1 : -1;
        };
        Collections.sort(appDirs, modifyTimeComparator);
        return appDirs;
    }

    private static List<File> collectAllApplicationDirectories(File dataDirectoryParentDir) {
        String settingsDirPrefix = "." + Application.getName().replaceAll("\\s", "").toLowerCase();
        FileFilter userDirFilter = f -> {
            String name = f.getName();
            return f.isDirectory() && name.startsWith(settingsDirPrefix) && !name.endsWith(TEST_DIRECTORY_SUFFIX);
        };
        File[] userDirs = dataDirectoryParentDir.listFiles(userDirFilter);
        return CollectionUtils.asList(userDirs);
    }

    public static File getPreviousApplicationSettingsFile(String filename) {
        List<File> settingsDirs = GenericRunInfo.getPreviousApplicationSettingsDirsByTime();
        for (File dir : settingsDirs) {
            String altFilePath;
            File file;
            String dirPath = dir.getPath();
            if (dirPath.endsWith("Test") || !(file = new File(altFilePath = dirPath + File.separatorChar + filename)).exists()) continue;
            return file;
        }
        return null;
    }

    public static File getPreviousApplicationSettingsDir(String dirName, FileFilter filter) {
        List<File> settingsDirs = GenericRunInfo.getPreviousApplicationSettingsDirsByTime();
        for (File dir : settingsDirs) {
            File[] listFiles;
            String altFilePath;
            File altSettingsDir;
            String dirPath = dir.getPath();
            if (dirPath.endsWith("Test") || !(altSettingsDir = new File(altFilePath = dirPath + File.separatorChar + dirName)).exists() || !altSettingsDir.isDirectory() || (listFiles = altSettingsDir.listFiles(filter)) == null || listFiles.length <= 0) continue;
            return altSettingsDir;
        }
        return null;
    }

    public static List<File> getPreviousApplicationSettingsDirsByTime() {
        ArrayList<File> settingsDirs = new ArrayList<File>();
        ApplicationIdentifier myIdentifier = new ApplicationIdentifier(Application.getApplicationLayout().getApplicationProperties());
        String myRelease = myIdentifier.getApplicationReleaseName();
        String myDirName = Application.getUserSettingsDirectory().getName();
        LOG.trace("Finding previous application settings directories for " + String.valueOf(myIdentifier));
        for (File dir : GenericRunInfo.getUserSettingsDirsByTime()) {
            String dirName = dir.getName();
            if (dirName.equals(myDirName)) continue;
            LOG.trace("\tchecking " + dirName);
            if (dirName.startsWith(".")) {
                dirName = dirName.substring(1);
            }
            try {
                ApplicationIdentifier identifier = new ApplicationIdentifier(dirName);
                String release = identifier.getApplicationReleaseName();
                if (release.equals(myRelease)) {
                    LOG.trace("\t\tkeeping");
                    settingsDirs.add(dir);
                    continue;
                }
                LOG.trace("\t\tskipping");
            }
            catch (IllegalArgumentException e) {
                LOG.trace("\tdir does not have an application identifier - skipping");
            }
        }
        return settingsDirs;
    }

    public static String getProjectsDirPath() {
        String path = Preferences.getProperty("ProjectDirectory", null, true);
        if (path != null && new File(path).isDirectory()) {
            return path;
        }
        return System.getProperty("user.home");
    }

    public static void setProjectsDirPath(String path) {
        if (path != null && new File(path).isDirectory()) {
            Preferences.setProperty("ProjectDirectory", path);
        }
    }
}

