/*
 * Decompiled with CFR 0.152.
 */
package functioncalls.graph.layout;

import edu.uci.ics.jung.graph.Graph;
import functioncalls.graph.FcgEdge;
import functioncalls.graph.FcgVertex;
import functioncalls.graph.FunctionCallGraph;
import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.layout.AbstractVisualGraphLayout;
import ghidra.graph.viewer.layout.Column;
import ghidra.graph.viewer.layout.GridLocationMap;
import ghidra.graph.viewer.layout.LayoutPositions;
import ghidra.graph.viewer.layout.Row;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class BowTieLayout
extends AbstractVisualGraphLayout<FcgVertex, FcgEdge> {
    protected BowTieLayout(FunctionCallGraph graph, String name) {
        super((Graph)graph, name);
    }

    public AbstractVisualGraphLayout<FcgVertex, FcgEdge> createClonedLayout(VisualGraph<FcgVertex, FcgEdge> newGraph) {
        if (!(newGraph instanceof FunctionCallGraph)) {
            throw new IllegalArgumentException("Must pass a " + FunctionCallGraph.class.getSimpleName() + "to clone the " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        BowTieLayout newLayout = new BowTieLayout((FunctionCallGraph)newGraph, this.getLayoutName());
        return newLayout;
    }

    protected Point2D getVertexLocation(FcgVertex v, Column col, Row<FcgVertex> row, Rectangle bounds) {
        return this.getCenteredVertexLocation((VisualVertex)v, col, row, bounds);
    }

    public boolean isCondensedLayout() {
        return true;
    }

    public FunctionCallGraph getVisualGraph() {
        return (FunctionCallGraph)this.getGraph();
    }

    protected GridLocationMap<FcgVertex, FcgEdge> performInitialGridLayout(VisualGraph<FcgVertex, FcgEdge> g) throws CancelledException {
        if (!(g instanceof FunctionCallGraph)) {
            throw new IllegalArgumentException("This layout can only be used with the " + String.valueOf(FunctionCallGraph.class));
        }
        return this.layoutFunctionCallGraph((FunctionCallGraph)g);
    }

    public LayoutPositions<FcgVertex, FcgEdge> calculateLocations(VisualGraph<FcgVertex, FcgEdge> g, TaskMonitor taskMonitor) {
        LayoutPositions locs = super.calculateLocations(g, taskMonitor);
        return locs;
    }

    private GridLocationMap<FcgVertex, FcgEdge> layoutFunctionCallGraph(FunctionCallGraph g) {
        GridLocationMap grid = new GridLocationMap();
        FcgVertex source = Objects.requireNonNull(g.getSource());
        ArrayList inEdges = new ArrayList(g.getInEdges((Object)source));
        List inVertices = inEdges.stream().map(e -> (FcgVertex)e.getStart()).collect(Collectors.toList());
        inVertices.sort((v1, v2) -> v1.getAddress().compareTo((Object)v2.getAddress()));
        int row = 0;
        for (int col = 0; col < inVertices.size(); ++col) {
            FcgVertex v = (FcgVertex)((Object)inVertices.get(col));
            grid.set((Object)v, row, col);
        }
        row = 1;
        grid.set((Object)source, row, 0);
        ArrayList outEdges = new ArrayList(g.getOutEdges((Object)source));
        List outVertices = outEdges.stream().map(e -> (FcgVertex)e.getEnd()).collect(Collectors.toList());
        outVertices.removeAll(inVertices);
        outVertices.sort((v1, v2) -> v1.getAddress().compareTo((Object)v2.getAddress()));
        row = 2;
        for (int col = 0; col < outVertices.size(); ++col) {
            FcgVertex v = (FcgVertex)((Object)outVertices.get(col));
            grid.set((Object)v, row, col);
        }
        grid.centerRows();
        return grid;
    }
}

